unit CommonIB;

interface

uses
  Windows, Classes, SysUtils, FIBQuery;


const
  ibftSmallInt  = 7;
  ibftInteger   = 8;
  ibftQuad      = 9;
  ibftFloat     = 10;
  ibftD_Float   = 11;
  ibftDate      = 12;  // IB 6.0
  ibftTime      = 13;  // IB 6.0
  ibftChar      = 14;
  ibftInt64     = 16;  // IB 6.0
  ibftDouble    = 27;
  ibftDateTime  = 35;
  ibftTimeStamp = 35;
  ibftVarChar   = 37;
  ibftCString   = 40;
  ibftBlob      = 261;

{----      BLOB   ------}
function IBBlobToStr(BlobField : TFIBXSQLVAR) : string;
{----       ------}
function FieldTypeToStr(FieldType, FieldSubType, FieldLen, FieldScale, FieldSegmentLen, FieldCharacterLen : integer;
                        SQLDialect : integer = 1; FullInfo : boolean = FALSE) : string;

implementation


function IBBlobToStr(BlobField : TFIBXSQLVAR) : string;
var
  Strm : TMemoryStream;
begin
  Result := '';
  if BlobField.IsNull then
    Exit;
  Strm := TMemoryStream.Create;
  try
    BlobField.SaveToStream(Strm);
    Strm.Position := 0;
    SetLength(Result,Strm.Size);
    Strm.Read(Result[1],Strm.Size);
  finally
    Strm.Free;
  end;
end;

function FieldTypeToStr(FieldType, FieldSubType, FieldLen, FieldScale, FieldSegmentLen, FieldCharacterLen : integer;
                        SQLDialect : integer = 1; FullInfo : boolean = FALSE) : string;

  function LengthInChars : string;
  begin
    if FieldLen < FieldCharacterLen then
      Result := IntToStr(FieldCharacterLen)
    else
      Result := IntToStr(FieldLen);
  end;

begin
  Result := '';
  case FieldType of
    ibftBlob     : begin
                     Result := 'BLOB';
                     if FullInfo then
                       Result := Result + ' sub_type '+ IntToStr(FieldSubType)+ ' segment size '+IntToStr(FieldSegmentLen);
                   end;
    ibftChar     : begin
                     Result := 'CHAR';
                     if FullInfo then
                       Result := Result + '('+ LengthInChars +')';
                   end;
    ibftVarChar  : begin
                     Result := 'VARCHAR';
                     if FullInfo then
                       Result := Result + '('+ LengthInChars +')';
                   end;
    ibftCString  : begin
                     Result := 'CSTRING';
                     if FullInfo then
                       Result := Result + '('+IntToStr(FieldLen)+')';
                   end;
    ibftDate     : Result := 'DATE';
    ibftTime     : Result := 'TIME';
    ibftDateTime : if SQLDialect = 3 then
                     Result := 'TIMESTAMP'
                   else
                     Result := 'DATE';
    ibftSmallInt : Result := 'SMALLINT';
    ibftInteger  : if FieldScale < 0 then
                   begin
                     Result := 'NUMERIC';
                     if FullInfo then
                       Result := Result + '(9,' + IntToStr(-1 * FieldScale) + ')';
                   end
                   else
                     Result := 'INTEGER';
    ibftInt64    : begin
                     Result := 'NUMERIC';
                     if FullInfo then
                       Result :=  Result + '(18,' + IntToStr(-1 * FieldScale) + ')';
                   end;
    ibftDouble   : if FieldScale < 0 then
                   begin
                     Result := 'NUMERIC';
                     if FullInfo then
                       Result := Result + '(15,' + IntToStr(-1 * FieldScale) + ')';
                   end
                   else
                     Result := 'DOUBLE PRECISION';
     ibftFloat    : Result := 'FLOAT';
  end;
end;

end.
