{************************************************************************}
{ FIBPlus - component library  for direct access  to Interbase  databases}
{    FIBPlus is based in part on the product                             }
{    Free IB Components, written by Gregory H. Deatz for                 }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.                     }
{                                         Contact:       gdeatz@hlmdd.com}
{    Copyright (c) 1998-2001 Serge Buzadzhy                              }
{                                         Contact: serge_buzadzhy@mail.ru}
{  Please see the file FIBLicense.txt for full license information.      }
{************************************************************************}

{Special thanks to Vadim Yegorov <zg@matrica.apollo.lv>}

unit pFIBStoredProc;

interface
uses
  pFIBQuery, FIBQuery,Classes;

type
  TpFIBStoredProc = class(TpFIBQuery)
  private
    FStoredProc: string;
    procedure SetStoredProc(Value: string);
  protected
  public
    constructor Create(AOwner: TComponent); override;
  published
    property StoredProcName: string read FStoredProc write SetStoredProc;
  end;

implementation

uses
   pFIBDatabase, StrUtil, SysUtils,pFIBDataInfo;

procedure TpFIBStoredProc.SetStoredProc(Value: string);
begin
  if (Value <> FStoredProc) then
  begin
   FStoredProc := Value;
   if not (csReading in ComponentState) then begin
     FBase.CheckDatabase;
     if Trim(Value)='' then
      SQL.Clear
     else
      SQL.Text :=
       ListSPInfo.GetExecProcTxt(Database,
        FormatIdentifier(Database.SQLDialect, FStoredProc)
        ,csDesigning in ComponentState
       );
   end;
  end;
end;

constructor TpFIBStoredProc.Create(AOwner: TComponent);
begin
  inherited;
  FStoredProc := '';
end;


end.
