{************************************************************************}
{ FIBPlus - component library  for direct access  to Interbase  databases}
{    FIBPlus is based in part on the product                             }
{    Free IB Components, written by Gregory H. Deatz for                 }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.                     }
{                                         Contact:       gdeatz@hlmdd.com}
{    Copyright (c) 1998-2001 Serge Buzadzhy                              }
{                                         Contact: serge_buzadzhy@mail.ru}
{  Please see the file FIBLicense.txt for full license information.      }
{************************************************************************}

unit pFIBProps;

interface

 uses Classes,SysUtils;

type
  TpPrepareOption=
   (pfSetRequiredFields,pfSetReadOnlyFields,pfImportDefaultValues,
    psUseBooleanField,psApplyRepositary,psGetOrderInfo,psAskRecordCount
   );
  TpPrepareOptions=set of TpPrepareOption;


  TFormatFields = class(TPersistent)
  private
     FDisplayFormatDateTime:string;
     FDisplayFormatDate:string;
     FDisplayFormatTime:string;
     FDisplayFormatNumeric :string;
     FEditFormatNumeric    :string;
    function StoreDfDt:boolean;
    function StoreDfN:boolean;
    function StoreEfN:boolean;
    function StoreDfD:boolean;
    function StoreDfT:boolean;        
  public
   constructor Create;
  published
    property DateTimeDisplayFormat:string read FDisplayFormatDateTime
                                   write FDisplayFormatDateTime  stored  StoreDfDt ;
    property NumericDisplayFormat :string read FDisplayFormatNumeric
                                   write FDisplayFormatNumeric   stored  StoreDfN ;
    property NumericEditFormat    :string read FEditFormatNumeric
                                   write FEditFormatNumeric     stored  StoreEfN ;
    property DisplayFormatDate:string read FDisplayFormatDate
                               write FDisplayFormatDate  stored StoreDfD;
    property DisplayFormatTime:string read FDisplayFormatTime
                               write FDisplayFormatTime stored StoreDfT;

  end;

  TAutoUpdateOptions= class (TPersistent)
  private
   FOwner     :Tcomponent;
   FUpdateTableName:string;
   FKeyFields      :string; //  
   FAutoReWriteSqls:boolean; // UpdateSQL?
   FCanChangeSQLs:boolean;
   FGeneratorName :string; // 
   FSelectGenID:boolean;//  
   FGenBeforePost:boolean;//   Post,  OnNewRecord
   procedure SetUpdateTableName(Value:string);
  protected

  public
   constructor Create(Owner:TComponent);
   property    Owner:Tcomponent  read    FOwner     ;
  published
   property    UpdateTableName:string  read  FUpdateTableName write SetUpdateTableName;
   property    KeyFields  :string read  FKeyFields write FKeyFields;
   property    AutoReWriteSqls:boolean read  FAutoReWriteSqls write FAutoReWriteSqls default false;
   property    CanChangeSQLs:boolean read  FCanChangeSQLs write FCanChangeSQLs default false;
   property    GeneratorName :string read FGeneratorName write FGeneratorName;
   property    SelectGenID:boolean read FSelectGenID write FSelectGenID default false;
   property    GenBeforePost:boolean read FGenBeforePost write FGenBeforePost default true;

  end;

  TConnectParams=class(TPersistent)
  private
    FOwner:TComponent;
    function  GetUserName: string;
    procedure SetUserName(const Value:string);
    function  GetRoleName: string;
    procedure SetRoleName(const Value:string);
    function  GetPassword: string;
    procedure SetPassword(const Value:string);
    function  GetCharSet: string;
    procedure SetCharSet(const Value:string);

  public
   constructor Create(Owner:TComponent);
  published
    property UserName : string read GetUserName write SetUserName stored false;
    property RoleName : string read GetRoleName write SetRoleName stored false;
    property Password : string read GetPassword write SetPassword stored false;
    property CharSet  : string read GetCharSet  write SetCharSet  stored false;
  end;

implementation
 uses FIBDataBase,FIB,ibase;

constructor TAutoUpdateOptions.Create;
begin
 inherited Create;
 FOwner:=Owner;
 FGeneratorName :='';
 FSelectGenID:=false;
 FGenBeforePost:=true;
 FCanChangeSQLs:=false;
end;

procedure TAutoUpdateOptions.SetUpdateTableName(Value:string);
begin
// FUpdateTableName:=AnsiUpperCase(Value);
 FUpdateTableName:=Value;
 if FGeneratorName='' then
  FGeneratorName:='GEN_'+FUpdateTableName
end;



// TFormatFields
constructor TFormatFields.Create;
begin
 FDisplayFormatDateTime:='dd.mm.yyyy';
 FDisplayFormatNumeric :='#,###0.' ;
 FEditFormatNumeric    :='0.';
 FDisplayFormatDate:=ShortDateFormat;
 FDisplayFormatTime:=ShortTimeFormat;
end;

function TFormatFields.StoreDfT:boolean;
begin
 Result:= FDisplayFormatTime<>ShortTimeFormat;
end;

function TFormatFields.StoreDfD:boolean;
begin
 Result:= FDisplayFormatDate<>ShortDateFormat;
end;

function TFormatFields.StoreDfDt:boolean;
begin
 Result:= FDisplayFormatDateTime<>ShortDateFormat;
end;

function TFormatFields.StoreDfN:boolean;
begin
 Result:= FDisplayFormatNumeric <>'#,###0.' ;
end;

function TFormatFields.StoreEfN:boolean;
begin
 Result:= FEditFormatNumeric<>'0.';
end;
///TConnectParams

constructor TConnectParams.Create(Owner:TComponent);
begin
 inherited Create;
 FOwner:=Owner
end;

function  TConnectParams.GetUserName: string;
begin
 Result:='';
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
 with TFIBDataBase(FOwner) do begin
  Result:=DBParamByDPB[isc_dpb_user_name];
 end;
end;

procedure TConnectParams.SetUserName(const Value:string);
begin
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
  with TFIBDataBase(FOwner) do
   DBParamByDPB[isc_dpb_user_name]:= Value
end;

function  TConnectParams.GetRoleName: string;
begin
 Result:='';
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
 with TFIBDataBase(FOwner) do begin
  Result:=DBParamByDPB[isc_dpb_sql_role_name];
 end;
end;

procedure TConnectParams.SetRoleName(const Value:string);
begin
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
  with TFIBDataBase(FOwner) do
   DBParamByDPB[isc_dpb_sql_role_name]:= Value
end;

function  TConnectParams.GetPassword: string;
begin
 Result:='';
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
 with TFIBDataBase(FOwner) do begin
  Result:=DBParamByDPB[isc_dpb_password];
 end;
end;

procedure TConnectParams.SetPassword(const Value:string);
begin
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
  with TFIBDataBase(FOwner) do
   DBParamByDPB[isc_dpb_password]:= Value
end;

function  TConnectParams.GetCharSet: string;
begin
 Result:='';
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
 with TFIBDataBase(FOwner) do begin
  Result:=DBParamByDPB[isc_dpb_lc_ctype];
 end;
end;

procedure TConnectParams.SetCharSet(const Value:string);
begin
 if Assigned(FOwner) and (FOwner is TFIBDataBase) then
  with TFIBDataBase(FOwner) do
   DBParamByDPB[isc_dpb_lc_ctype]:= Value
end;

end.


