{********************************************************}
{                                                        }
{       Borland Deplphi                                  }
{       InterBase EventAlerter components                }
{       Copyright (c) 1995,98 Inprise Corporation        }
{                                                        }
{       Written by:                                      }
{         James Thorpe                                   }
{         CSA Australasia                                }
{         Compuserve: 100035,2064                        }
{         Internet:   csa@csaa.com.au                    }
{                                                        }
{       Adapted for FreeIBComponents                     }
{         12 Nov 1998 by Belokon Andre                   }
{         SoftHouseLabs@usa.net                          }
{                                                        }
{********************************************************}

unit pFIBEvedt;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Grids, DsgnIntf, pFIBEvent;

type
  TFIBEAEventsEditor = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    cEvents: TStringGrid;
    RequestedEvents: TLabel;
    bOK: TButton;
    bCancel: TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TEventsProperty = class(TPropertyEditor)
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

implementation

{$R *.DFM}

function EditAlerterEvents( Events: TStrings): Boolean;
var
  i: integer;
begin
  result := false;
  with TFIBEAEventsEditor.Create(Application) do
  begin
    try
      for i := 0 to Events.Count-1 do
        cEvents.Cells[1, i] := Events[i];
      if ShowModal = idOk then
      begin
        result := true;
        Events.Clear;
        for i := 0 to MaxEvents-1 do
          if length( cEvents.Cells[1, i]) <> 0 then
            Events.Add( cEvents.Cells[1, i]);
      end;
    finally
      Free;
    end;
  end;
end;

procedure TFIBEAEventsEditor.FormCreate(Sender: TObject);
var
  i: integer;
begin
  for i := 1 to MaxEvents do
    cEvents.Cells[0, i-1] := IntToStr( i);
end;


function TEventsProperty.GetValue: string;
begin
  Result := '(Events)';
end;

function TEventsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TEventsProperty.Edit;
begin
  EditAlerterEvents(TpFIBEventer(GetComponent(0)).Events);
end;


end.
