{************************************************************************}
{ FIBPlus - component library  for direct access  to Interbase  databases}
{    FIBPlus is based in part on the product                             }
{    Free IB Components, written by Gregory H. Deatz for                 }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.                     }
{                                         Contact:       gdeatz@hlmdd.com}
{    Copyright (c) 1998-2001 Serge Buzadzhy                              }
{                                         Contact: serge_buzadzhy@mail.ru}
{  Please see the file FIBLicense.txt for full license information.      }
{************************************************************************}

unit pFIBDataInfo;

interface
 uses SysUtils,classes,DB,pFIBDataSet,FIBDataSet,FIBDataBase,FIBQuery,
  pFIBQuery,pFIBDataBase

  ,Dialogs //GUI

 ;

 type   TpFIBFieldInfo=class
        private
         FIsComputed  :boolean;
         FDefaultValue:string;
         FCanIncToWhereClause:boolean;
         FDomainName:string;
         FDefaulValueEmptyString: boolean;          
// Info from FIB$FIELDS_INFO
         FWithAdditionalInfo:boolean;
         FDisplayLabel:string;
         FVisible     :boolean;
         FEditFormat  :string;
         FDisplayFormat:string;
         FIsTriggered :boolean;
         FOtherInfo   :TStrings;
        public
         constructor Create;
         destructor  Destroy;override;
         property IsComputed:boolean read FIsComputed ;
         property DefaultValue:string read FDefaultValue ;
         property DomainName:string read FDomainName;
         property CanIncToWhereClause:boolean read FCanIncToWhereClause;
// Info from FIB$FIELDS_INFO
         property WithAdditionalInfo:boolean read FWithAdditionalInfo;
         property DisplayLabel:string  read FDisplayLabel;
         property Visible     :boolean read FVisible   ;
         property EditFormat  :string  read FEditFormat ;
         property DisplayFormat:string read FDisplayFormat;
         property IsTriggered:boolean  read FIsTriggered;
         property OtherInfo:TStrings   read FOtherInfo;
         property DefaulValueEmptyString:boolean read FDefaulValueEmptyString;          
        end;

        TpFIBTableInfo=class
        private
         FDBName:string;
         FTableName:string;
         FPrimaryKeyFields:string;
         FFieldList :TStringList;
         procedure GetInfoFields(const TableName:string;aTransaction:TFIBTransaction);
         procedure ClearFieldList;
         procedure GetAdditionalInfo(FromQuery:TpFIBDataset;
          const FieldName:string;ToFieldInfo:TpFIBFieldInfo );

        public
         constructor Create
          (aDataBase:TFIBDataBase;const ATableName:string);
         destructor Destroy;override;
         function    FieldInfo(const FieldName:string):TpFIBFieldInfo;
         property    TableName:string read FTableName ;
         property    PrimaryKeyFields:string read FPrimaryKeyFields;
         property    FieldList :TStringList read FFieldList;
        end;

       TpFIBTableInfoCollect= class(TComponent)
       private
        FListTabInfo:TStringList;
       protected
         procedure Notification(AComponent: TComponent; Operation: TOperation); override;
       public
        constructor Create(AOwner:TComponent); override;
        destructor  Destroy;override;

        function    FindTableInfo(const ADBName,ATableName:string):TpFIBTableInfo;
        function    GetTableInfo(aDataBase:TFIBDataBase;const ATableName:string):TpFIBTableInfo;
        function    GetFieldInfo(aDataBase:TFIBDataBase;
                       const ATableName,AFieldName:string
                    ):TpFIBFieldInfo;

        procedure   Clear;
        procedure   ClearForDataBase(aDatabase:TFIBDataBase);
        procedure   ClearForTable(TableName:string)	;
       end;

       TpDataSetInfo= class
       private
         FDBName:string;
         FSelectSQL:TStrings;
         FInsertSQL:TStrings;
         FUpdateSQL:TStrings;
         FDeleteSQL:TStrings;
         FRefreshSQL:TStrings;
         FKeyField:string;
         FGeneratorName:string;
       public
        constructor Create(DataSet:TpFIBDataSet);
        destructor  Destroy;override;
       end;

       TpDataSetInfoCollect= class
       private
        FListDataSetInfo:TStringList;
       public
        constructor Create;//(AOwner:TComponent);// override;
        destructor  Destroy;override;
        function    FindDataSetInfo(DataSet:TpFIBDataSet):TpDataSetInfo;
        function    GetDataSetInfo(DataSet:TpFIBDataSet):TpDataSetInfo;
        function    LoadDataSetInfo(DataSet:TpFIBDataSet):boolean;
        procedure   ClearDSInfo(DataSet:TpFIBDataSet);
       end;

       TpStoredProcCollect= class
       private
        FStoredProcNames:TStringList;
        FSPParamTxt:TStringList;
        function  IndexOfSP(DB:TFIBDatabase;const SPName:string;
         ForceReQuery:boolean):integer;
        function  GetParamsText(DB:TFIBDatabase;const SPName:string):string;
       public
        constructor Create;
        destructor  Destroy;override;
        function    GetExecProcTxt(DB:TFIBDatabase;
         const SPName:string;   ForceReQuery:boolean
        ):string;
        procedure   ClearSPInfo(DB:TFIBDatabase);
       end;


var
     ListTableInfo  :TpFIBTableInfoCollect;
     ListDataSetInfo:TpDataSetInfoCollect;
     ListSPInfo     :TpStoredProcCollect;
// Manage Developer Info tables
function    ExistFRepositaryTable(DB:TFIBDatabase):boolean;
procedure   CreateFRepositaryTable(DB:TFIBDatabase);
procedure   CreateDRepositaryTable(DB:TFIBDatabase);
function    ExistDRepositaryTable(DB:TFIBDatabase):boolean;
function    SaveFIBDataSetInfo(DataSet:TpFibDataSet):boolean;
// Routine function

function  GetFieldInfos(Field:TField):TpFIBFieldInfo;
function  GetOtherFieldInfo(Field:TField;const InfoName:string):string;

implementation

uses StrUtil,FIBConsts;

var ListOfDataBases:TStringList;

function ExistRepositaryTable(DB:TFIBDatabase;Kind:byte):boolean;
var aTransaction:TFibTransaction;
    qry:TFIBQuery;
    Index:integer;

function RepositaryIsRegistered:boolean;
begin
 Index:=ListOfDataBases.IndexOfObject(DB);
 if Index>-1 then begin
   Result:=Pos(IntToStr(Kind),ListOfDataBases[Index])>0;
 end
 else
   Result:=false;
end;

begin
 Result:=RepositaryIsRegistered;
 if Result or (Index>-1) then Exit;

 aTransaction:=TFibTransaction.Create(nil);
 aTransaction.DefaultDatabase:=DB;
 qry:=TFIBQuery.Create(nil);
 with qry do
 try
  Database:=DB;  Transaction:=aTransaction;
  SQL.Text:='select COUNT(RDB$RELATION_NAME) '+
                    'from RDB$RELATIONS where RDB$FLAGS = 1 '+
                    'and RDB$RELATION_NAME=?RT';
  aTransaction.StartTransaction;
  Params[0].asString:='FIB$FIELDS_INFO';
  ExecQuery;
  with ListOfDataBases do
   if Fields[0].asInteger>0 then
    Index:=AddObject('1',DB)
   else
    Index:=AddObject('0',DB);

  Close;
  Params[0].asString:='FIB$DATASETS_INFO';
  ExecQuery;
  if Fields[0].asInteger>0 then
   ListOfDataBases[Index]:=ListOfDataBases[Index]+'2';
  Result:=RepositaryIsRegistered;
 finally
  aTransaction.Free;
  Free;
 end;
end;

function ExistDRepositaryTable(DB:TFIBDatabase):boolean;
begin
 Result:=ExistRepositaryTable(DB,2)
end;

function ExistFRepositaryTable(DB:TFIBDatabase):boolean;
begin
 Result:=ExistRepositaryTable(DB,1)
end;

procedure   DoCreateRepositaryTable(DB:TFIBDatabase;Kind:byte);
var Index:integer;
    Transaction:TFibTransaction;
    qry:TFIBQuery;
begin
 qry:=TFIBQuery.Create(nil);
 Transaction:=TFibTransaction.Create(nil);
 try
  Transaction.DefaultDatabase:=DB;
  qry.Database:=DB;  qry.Transaction:=Transaction;
  qry.ParamCheck:=false;
  Transaction.StartTransaction;
  with qry,qry.SQL do
  case Kind of
  1: begin
      Text:=
      'CREATE DOMAIN FIB$BOOLEAN AS SMALLINT DEFAULT 1 NOT NULL CHECK (VALUE IN (0,1))';
      ExecQuery;
      Text:=
       'CREATE TABLE FIB$FIELDS_INFO (TABLE_NAME VARCHAR(25) NOT NULL, '+
       'FIELD_NAME VARCHAR(25) NOT NULL, '+
       'DISPLAY_LABEL VARCHAR(25),'+
       'VISIBLE FIB$BOOLEAN DEFAULT 1 NOT NULL,'+
       'DISPLAY_FORMAT VARCHAR(15),'+
       'EDIT_FORMAT VARCHAR(15),'+
       'TRIGGERED FIB$BOOLEAN DEFAULT 0 NOT NULL,'+
       'CONSTRAINT PK_FIB$FIELDS_INFO PRIMARY KEY (TABLE_NAME, FIELD_NAME))';
      ExecQuery;
      Text:=
      'GRANT SELECT ON TABLE FIB$FIELDS_INFO TO PUBLIC';
      ExecQuery;
     end;
  2: begin
      Text:=
       'CREATE TABLE FIB$DATASETS_INFO (DS_ID INTEGER NOT NULL, '+
       'DESCRIPTION VARCHAR(40),'+
       'SELECT_SQL BLOB sub_type 1 segment size 80,'+
       'UPDATE_SQL BLOB sub_type 1 segment size 80,'+
       'INSERT_SQL BLOB sub_type 1 segment size 80,'+
       'DELETE_SQL BLOB sub_type 1 segment size 80,'+
       'REFRESH_SQL BLOB sub_type 1 segment size 80,'+
       'NAME_GENERATOR VARCHAR(30), '+
       'KEY_FIELD VARCHAR(30),'+
       'CONSTRAINT PK_FIB$DATASETS_INFO PRIMARY KEY (DS_ID))';
      ExecQuery;
      Text:=
       'GRANT SELECT ON TABLE FIB$DATASETS_INFO TO PUBLIC';
      ExecQuery;
     end;
  end; //case
  Transaction.Commit;
 finally
  Transaction.Free;
  qry.Free;
 end;
 with ListOfDataBases do begin
  Index:=IndexOfObject(DB);
  if Index=-1 then
   AddObject(IntToStr(Kind),DB)
  else
   ListOfDataBases[Index]:=ListOfDataBases[Index]+IntToStr(Kind);
 end;
end;

procedure   CreateDRepositaryTable(DB:TFIBDatabase);
begin
 DoCreateRepositaryTable(DB,2)
end;

procedure   CreateFRepositaryTable(DB:TFIBDatabase);
begin
 DoCreateRepositaryTable(DB,1)
end;


function   ExchangeDataSetInfo(DataSet:TpFibDataSet;DS_Info:TpDataSetInfo):boolean;
var
    vTransaction:TFibTransaction;
    DI:TFIBDataset;
    Description:string;
begin
 Result:=true;
 with DataSet do begin
   if DataSet_ID= 0 then
    raise Exception.Create(Name+'.DataSet_ID must be greater 0');
   if DataBase=nil then  raise Exception.Create(SDataBaseNotAssigned);
   if not ExistDRepositaryTable(DataSet.Database) then
     raise Exception.Create('Table FIB$DATASETS_INFO not exist.');

   DI:=TFIBDataset.Create(nil);
   vTransaction:=TFibTransaction.Create(nil);
   try
    vTransaction.DefaultDatabase:=DataSet.DataBase;
    DI.Database:=DataSet.DataBase;  DI.Transaction:=vTransaction;
    vTransaction.StartTransaction;
    DI.SelectSQL.Text:=
     'SELECT * FROM FIB$DATASETS_INFO WHERE DS_ID='+IntToStr(DataSet_ID);

    if DS_Info<>nil then begin
     DI.Open;
     if DI.RecordCount=0 then Exit;
     with DS_Info,DI do begin
      FSelectSQL.Text :=FieldByName('SELECT_SQL').asString;
      FUpdateSQL.Text :=FieldByName('UPDATE_SQL').asString;
      FInsertSQL.Text :=FieldByName('INSERT_SQL').asString;
      FDeleteSQL.Text :=FieldByName('DELETE_SQL').asString;
      FRefreshSQL.Text:=FieldByName('REFRESH_SQL').asString;
      FKeyField       :=FieldByName('KEY_FIELD').asString;
      FGeneratorName  :=FieldByName('NAME_GENERATOR').asString;
     end;
    end
    else begin
     DI.InsertSQL.Text:=
      'INSERT INTO FIB$DATASETS_INFO (DS_ID) VALUES('+IntToStr(DataSet_ID)+')';
     DI.UpdateSQL.Text:=
      'UPDATE FIB$DATASETS_INFO SET SELECT_SQL=?SELECT_SQL,'+
     'DESCRIPTION=?DESCRIPTION,'+
     'UPDATE_SQL=?UPDATE_SQL,'+
     'INSERT_SQL=?INSERT_SQL,'+
     'DELETE_SQL=?DELETE_SQL,'+
     'REFRESH_SQL=?REFRESH_SQL,'+
     'NAME_GENERATOR=?NAME_GENERATOR,'+
     'KEY_FIELD=?KEY_FIELD '+
     'WHERE DS_ID='+IntToStr(DataSet_ID)
     ;
     DI.Open;

      if DI.RecordCount=0  then begin
       DI.QInsert.ExecQuery;
       DI.Close;DI.Open;
       if DI.RecordCount=0  then raise Exception.Create('Can''t insert new info record');
      end;
      Description:=DI.FieldByName('DESCRIPTION')   .asString;
      Result:=false;
      if not InputQuery('Save FIBDataSet properties',
       'Enter dataset description',Description
      ) then Exit;
      DI.Edit;
      DI.FieldByName('SELECT_SQL') .asString :=SelectSQL.Text;
      DI.FieldByName('INSERT_SQL') .asString :=InsertSQL.Text;
      DI.FieldByName('DELETE_SQL') .asString :=DeleteSQL.Text;
      DI.FieldByName('UPDATE_SQL') .asString :=UpdateSQL.Text;
      DI.FieldByName('REFRESH_SQL').asString :=RefreshSQL.Text;
      DI.FieldByName('KEY_FIELD')  .asString :=AutoUpdateOptions.KeyFields;
      DI.FieldByName('NAME_GENERATOR').asString  :=AutoUpdateOptions.GeneratorName;
      DI.FieldByName('DESCRIPTION')   .asString  :=Description;
      DI.Post;
    end;
    vTransaction.Commit;
    Result:=true;
   finally
    vTransaction.Free;
    DI.Free;
   end;
 end;
end;

function   SaveFIBDataSetInfo(DataSet:TpFibDataSet):boolean;
begin
 Result:=ExchangeDataSetInfo(DataSet,nil);
end;

 function DBPrimaryKeyFields(const TableName:string;
  aDatabase:TFIBDataBase;aTransaction:TFIBTransaction
 ):string;
 var q:TpFIBQuery;
 begin
  q:=TpFIBQuery.Create(nil);
  Result:='';
  with q do  try
  SQL.Text:=
   'select i.rdb$field_name '+
   'from    rdb$relation_constraints r, rdb$index_segments i '+
   'where   r.rdb$relation_name='''+TableName+''' and '+
   'r.rdb$constraint_type=''PRIMARY KEY'' and '+
   'r.rdb$index_name=i.rdb$index_name ' +
   'order by i.rdb$field_position';
   DataBase:=aDatabase;
   Transaction:=aTransaction;
   if not Transaction.InTransaction then Transaction.StartTransaction;
   ExecQuery;
   Result:=Trim(Fields[0].asString); Next;
   while not eof do begin
    Result:=Result+';'+Trim(Fields[0].asString);
    Next
   end;
  finally
   q.Free
  end
 end;


constructor TpFIBFieldInfo.Create;
begin
  inherited Create;
  FWithAdditionalInfo:=false;
  FIsTriggered       :=false;
  FOtherInfo         :=TStringList.Create;
  FDefaulValueEmptyString := false;
end;

destructor  TpFIBFieldInfo.Destroy;
begin
 FOtherInfo.Free;       
 inherited Destroy;
end;

constructor TpFIBTableInfo.Create
                 (aDataBase:TFIBDataBase;const ATableName:string);
var InternalTransaction:TpFIBTransaction;
begin
 inherited Create;
 FTableName:=ATableName;
 FDBName   :=aDataBase.DBName;
 FFieldList:=TStringList.Create;
 InternalTransaction:=TpFIBTransaction.Create(nil);
 InternalTransaction.DefaultDatabase:=aDatabase;
 try
  FPrimaryKeyFields:=  DBPrimaryKeyFields(FTableName,
                       aDatabase,InternalTransaction
                      );
  GetInfoFields(FTableName,InternalTransaction);
 finally
  InternalTransaction.Free
 end;
end;



destructor TpFIBTableInfo.Destroy;//override;
begin
 ClearFieldList;
 FFieldList.Free;
 inherited Destroy;
end;

function TpFIBTableInfo.FieldInfo(const FieldName:string):TpFIBFieldInfo;
var Index:integer;
begin
 Result:=nil;
 Index:=FFieldList.IndexOf(Trim(ReplaceCIStr(FieldName,'"','')));
 if Index>-1 then Result:=TpFIBFieldInfo(FFieldList.Objects[Index]);
end;

procedure TpFIBTableInfo.ClearFieldList;
var i:integer;
begin
 for i:=Pred(FFieldList.Count) downto 0 do
  FFieldList.Objects[i].Free;
 FFieldList.Clear;
end;

procedure TpFIBTableInfo.GetAdditionalInfo(FromQuery:TpFIBDataset;
          const FieldName:string;ToFieldInfo:TpFIBFieldInfo);
var i:integer;
begin
 try
  with FromQuery,ToFieldInfo do       //
    if (FN('FIELD_NAME').asString=FieldName) or
     Locate('FIELD_NAME',FieldName,[]) then
    begin
     FWithAdditionalInfo:=true;
     for i:=0 to Pred(FieldCount) do
     begin
      if Fields[i].FieldName='DISPLAY_LABEL' then
         FDisplayLabel:=Fields[i].asString
      else
      if Fields[i].FieldName='VISIBLE' then
         FVisible     :=Fields[i].asInteger=1
      else
      if Fields[i].FieldName='EDIT_FORMAT' then
         FEditFormat  :=Fields[i].asString
      else
      if Fields[i].FieldName='DISPLAY_FORMAT' then
         FDisplayFormat:=Fields[i].asString
      else
      if Fields[i].FieldName='TRIGGERED' then
         FIsTriggered :=Fields[i].asInteger=1
      else
        FOtherInfo.Values[Fields[i].FieldName]:=Fields[i].asString;
     end;// end for
    end
  except
  end
end;

procedure TpFIBTableInfo.GetInfoFields(const TableName:string;
  aTransaction:TFIBTransaction
);
var q:TpFIBQuery;
    fi:TpFIBFieldInfo;
    ExistAdInfo:boolean;
    d:TpFIBDataSet;
begin
  d:=nil;
  ExistAdInfo:=ExistFRepositaryTable(aTransaction.DefaultDatabase);
  if ExistAdInfo then try
    d:=TpFIBDataSet.Create(nil);
    d.DataBase:=aTransaction.DefaultDatabase;
    d.Transaction:=aTransaction;
    d.SelectSQL.Text:='Select * from FIB$FIELDS_INFO where TABLE_NAME='''+
                    TableName+''' ORDER BY FIELD_NAME';
    d.PrepareOptions:=[];
    d.Open;
  except
   d.Free;
   d:=nil;
   ExistAdInfo:=false;
  end;
  if TableName='ALIAS' then begin
   if not ExistAdInfo then Exit;
   with d do try
    while not eof do
    begin
     fi:=TpFIBFieldInfo.Create;
     GetAdditionalInfo(d,Fields[1].asString,fi);
     FFieldList.AddObject(Trim(Fields[1].asString),fi);
     Next
    end;
    finally
     Free;
    end 
  end
  else begin
    q:=TpFIBQuery.Create(nil);
    with q do  try
    SQL.Text:=
     'Select R.RDB$FIELD_NAME,R.RDB$FIELD_SOURCE,F.RDB$COMPUTED_BLR, '+
     'R.RDB$DEFAULT_SOURCE DS,F.RDB$DEFAULT_SOURCE DS1, '+
     'F.RDB$FIELD_TYPE, F.RDB$DIMENSIONS '+
     'from  RDB$RELATION_FIELDS R '+
     'JOIN RDB$FIELDS F ON (R.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME) '+
     'where  R.RDB$RELATION_NAME='''+TableName+''' '+
     'order by R.RDB$FIELD_POSITION';
     DataBase:=aTransaction.DefaultDatabase;
     Transaction:=aTransaction;
     if not Transaction.InTransaction then Transaction.StartTransaction;
     ExecQuery;
     if q.eof then begin
      Close;
      SQL.Text:=
       'Select RDB$PARAMETER_NAME,0,0,0,0, '+
       'RDB$PARAMETER_TYPE,0 '+
       'from RDB$PROCEDURE_PARAMETERS '+
       'WHERE RDB$PROCEDURE_NAME='''+TableName+''' '+
       'AND RDB$PARAMETER_TYPE=1 ';
      ExecQuery;
     end;
     ClearFieldList;
     while not eof do begin
      fi:=TpFIBFieldInfo.Create;
      with fi do begin
       FDomainName:=Trim(Fields[1].asString);
       FIsComputed:=not Fields[2].IsNull;
       FDefaultValue:=Trim(BlobAsString('DS'));
       if FDefaultValue='' then
        FDefaultValue:=Trim(BlobAsString('DS1'));
       if FDefaultValue<>'' then begin
        FDefaultValue:=Trim(Copy(FDefaultValue,8,MaxInt)); //Cut "DEFAULT"
        if FDefaultValue[1]in['''','"'] then
         FDefaultValue:=Copy(FDefaultValue,2,Length(FDefaultValue)-2);
         if FDefaultValue='' then
            FDefaulValueEmptyString := true; 
         //Cut Leading Quote
       end;
       FCanIncToWhereClause:=
        (Fields[5].asInteger<>261)and(Fields[5].asInteger<>9)
        and(Fields[6].asInteger=0);
       if ExistAdInfo then
        GetAdditionalInfo(d,Fields[0].asString,fi);
      end;
      FFieldList.AddObject(Trim(Fields[0].asString),fi);
      Next
     end;
    finally
     if ExistAdInfo then d.Free;
     q.Free
    end
  end;
end;

//TpFIBTableInfoCollect
constructor TpFIBTableInfoCollect.Create(AOwner:TComponent);
begin
 inherited Create(AOwner);
 FListTabInfo:=TStringList.Create;
 FListTabInfo.Sorted:=true;
 FListTabInfo.Duplicates:=dupAccept
end;

destructor  TpFIBTableInfoCollect.Destroy;//override;
begin
 Clear;
 FListTabInfo.Free;
 inherited Destroy;
end;

procedure TpFIBTableInfoCollect.Notification(AComponent: TComponent; Operation: TOperation);
var Index:integer;
begin
 if Operation=opRemove then
  if AComponent is TFIBDataBase then begin
    ClearForDataBase(TFIBDataBase(AComponent));
    Index:=ListOfDataBases.IndexOfObject(AComponent);
    if Index<>-1 then ListOfDataBases.Delete(Index)
  end;
 inherited Notification(AComponent,Operation);
end;

function    TpFIBTableInfoCollect.FindTableInfo
 (const ADBName,ATableName:string):TpFIBTableInfo;
var Index: Integer;
    i:integer;
begin
 Result:=nil;
 with FListTabInfo do
  if Find(ATableName, Index) then
   if aDBName=TpFIBTableInfo(Objects[Index]).FDBName then
    Result:=TpFIBTableInfo(Objects[Index])
   else // other Database
    for i:=Index+1 to Pred(Count) do
     if (ATableName=Strings[i]) and
        (aDBName=TpFIBTableInfo(Objects[Index]).FDBName)
     then begin
      Result:=TpFIBTableInfo(Objects[i]);
      Break;
     end
     else
     if (ATableName<>Strings[i]) then Exit;
end;

function    TpFIBTableInfoCollect.GetTableInfo(aDataBase:TFIBDataBase;
 const ATableName:string
):TpFIBTableInfo;
begin
 Result:=FindTableInfo(aDataBase.DBName,ATableName);
 if Result=nil then begin
  Result:=TpFIBTableInfo.Create(aDataBase,ATableName);
  FListTabInfo.AddObject(ATableName,Result);
  aDatabase.FreeNotification(Self)
 end;
end;

function  TpFIBTableInfoCollect.GetFieldInfo(aDataBase:TFIBDataBase;
                       const ATableName,AFieldName:string
                    ):TpFIBFieldInfo;
var ti:TpFIBTableInfo;
begin
  Result:=nil;
  ti:=GetTableInfo(aDataBase,ATableName);
  if ti=nil then Exit;
  Result:=ti.FieldInfo(AFieldName);
end;


procedure   TpFIBTableInfoCollect.Clear;
var i:integer;
begin
 for i:=0 to Pred(FListTabInfo.Count) do
  FListTabInfo.Objects[i].Free;
 FListTabInfo.Clear;
end;

procedure   TpFIBTableInfoCollect.ClearForDataBase(aDatabase:TFIBDataBase);
var i:integer;
begin
 if aDatabase=nil then Exit;
 with FListTabInfo do
 for i:=Pred(Count) downto 0 do
  if (TpFIBTableInfo(Objects[i]).FDBName=aDatabase.DBName)
  then begin
   Objects[i].Free;
   Delete(i)
  end;
end;

procedure   TpFIBTableInfoCollect.ClearForTable(TableName:string);
var Index: Integer;
begin
 TableName:=TableName;
 with FListTabInfo do
  if Find(TableName, Index) then begin
   while (Index<Count) and
    (TpFIBTableInfo(Objects[Index]).FTableName=TableName)
   do begin
    Objects[Index].Free;    Delete(Index)
   end;
  end;
end;

// DataSets info

constructor TpDataSetInfo.
 Create(DataSet:TpFIBDataSet);
begin
 if (DataSet=nil) or (DataSet.DataBase=nil)
 or (DataSet.DataBase.DBName='')
 then
  Raise Exception.Create(SCantGetInfo+IntToStr(DataSet.DataSet_ID)+#13#10+
   SDataBaseNotAssigned
  );
 inherited Create;
 FDBName:=DataSet.DataBase.DBName;
 FSelectSQL:=TStringList.Create;
 FInsertSQL:=TStringList.Create;
 FUpdateSQL:=TStringList.Create;
 FDeleteSQL:=TStringList.Create;
 FRefreshSQL:=TStringList.Create;
 FKeyField:='';
 FGeneratorName:='';
end;

destructor  TpDataSetInfo.Destroy;
begin
 FSelectSQL.Free;
 FInsertSQL.Free;
 FUpdateSQL.Free;
 FDeleteSQL.Free;
 FRefreshSQL.Free;
 inherited Destroy;
end;

constructor TpDataSetInfoCollect.Create;//(AOwner:TComponent);
begin
 inherited Create;
 FListDataSetInfo:=TStringList.Create;
 FListDataSetInfo.Sorted:=true;
 FListDataSetInfo.Duplicates:=dupAccept
end;

destructor  TpDataSetInfoCollect.Destroy;
var i:integer;
begin
 with FListDataSetInfo do begin
  for i:=0 to Pred(Count) do Objects[i].Free;
  Free
 end;
 inherited;
end;


function    TpDataSetInfoCollect.FindDataSetInfo(DataSet:TpFIBDataSet):TpDataSetInfo;
var ID_Str:string;
    i,Index:integer;
begin
  Result:=nil;
  if (DataSet=nil) or (DataSet.DataSet_ID=0) then Exit;
  ID_Str:=IntToStr(DataSet.DataSet_ID);
 Result:=nil;
 with FListDataSetInfo do
  if Find(ID_Str, Index) then
   if DataSet.Database.DBName=TpDataSetInfo(Objects[Index]).FDBName then
    Result:=TpDataSetInfo(Objects[Index])
   else
    for i:=Index+1 to Pred(Count) do
     if (ID_Str=Strings[i]) and
        (DataSet.Database.DBName=TpDataSetInfo(Objects[Index]).FDBName)
     then begin
      Result:=TpDataSetInfo(Objects[i]);
      Break;
     end
     else
     if (ID_Str<>Strings[i]) then Exit;
end;

function TpDataSetInfoCollect.GetDataSetInfo(DataSet:TpFIBDataSet):TpDataSetInfo;
begin
 Result:=nil;
 if (DataSet=nil) or (DataSet.DataBase=nil) or (DataSet.DataSet_ID=0)
 then Exit;
 Result:=FindDataSetInfo(DataSet);
 if Result=nil then begin
  Result:=TpDataSetInfo.Create(DataSet);
  ExchangeDataSetInfo(DataSet,Result);
  FListDataSetInfo.AddObject(IntToStr(DataSet.DataSet_ID),Result);
 end;
end;

function TpDataSetInfoCollect.LoadDataSetInfo(DataSet:TpFIBDataSet):boolean;
var   DSI:TpDataSetInfo;
begin
  Result:=false;
  DSI:=GetDataSetInfo(DataSet);
  if DSI=nil then Exit;
  with DataSet do begin
   if (DSI.FSelectSQL.Text<>'') and
    (SelectSQL.Text<>DSI.FSelectSQL.Text)
   then
    SelectSQL.Text:=DSI.FSelectSQL.Text;
   if (DSI.FInsertSQL.Text<>'')
   and (InsertSQL.Text<>DSI.FInsertSQL.Text)
   then
    InsertSQL.Text:=DSI.FInsertSQL.Text;
   if (DSI.FUpdateSQL.Text<>'')
   and
    (UpdateSQL.Text<>DSI.FUpdateSQL.Text)
   then
    UpdateSQL.Text:=DSI.FUpdateSQL.Text;
   if (DSI.FDeleteSQL.Text<>'')
   and
    (DeleteSQL.Text<>DSI.FDeleteSQL.Text)
   then
    DeleteSQL.Text:=DSI.FDeleteSQL.Text;
   if (DSI.FRefreshSQL.Text<>'')
   and
    (RefreshSQL.Text<>DSI.FRefreshSQL.Text)
   then
    RefreshSQL.Text:=DSI.FRefreshSQL.Text;
   with AutoUpdateOptions do begin
    SelectGenID:=(DSI.FKeyField<>'') and (DSI.FGeneratorName<>'');
    KeyFields :=DSI.FKeyField;
    GeneratorName:=DSI.FGeneratorName;
   end;
  end;
end;

procedure TpDataSetInfoCollect.ClearDSInfo(DataSet:TpFIBDataSet);
var ID_Str:string;
    Index:integer;
begin
 if (DataSet=nil) or (DataSet.DataSet_ID=0) then Exit;
 ID_Str:=IntToStr(DataSet.DataSet_ID);
 with FListDataSetInfo do
  if Find(ID_Str, Index) then
   if DataSet.Database.DBName=TpDataSetInfo(Objects[Index]).FDBName then begin
        Objects[Index].Free;
        Delete(Index);
   end;
end;
//

constructor TpStoredProcCollect.Create;
begin
 inherited Create;
 FStoredProcNames:=TStringList.Create;
 FStoredProcNames.Sorted:=true;
 FStoredProcNames.Duplicates:=dupIgnore;
 FSPParamTxt    :=TStringList.Create;
end;

destructor  TpStoredProcCollect.Destroy;//override;
begin
 FStoredProcNames.Free;
 FSPParamTxt  .Free;
 inherited Destroy;
end;

function  TpStoredProcCollect.GetParamsText(DB:TFIBDatabase;
           const SPName:string
          ):string;
var
  Qry: TpFIBQuery;
  Trans: TpFIBTransaction;
  lSQLDA: TFIBXSQLDA;
begin
    begin
      Result := '';
      Qry := TpFIBQuery.Create(nil);
      Trans := TpFIBTransaction.Create(nil);
      with Qry,Trans do
      try
        Database := DB;
        DefaultDatabase := Database;
        Transaction := Trans;
        SQL.Text :=
         'SELECT RDB$PARAMETER_NAME, RDB$PARAMETER_TYPE FROM '+
         'RDB$PROCEDURE_PARAMETERS WHERE RDB$PROCEDURE_NAME = ' +
         '''' + FormatIdentifierValue(Database.SQLDialect, SPName) + '''' +
         'ORDER BY RDB$PARAMETER_NUMBER';
        StartTransaction;
        try
          ExecQuery;
          lSQLDA := Current;
          while not Qry.Eof do
          begin
            if (lSQLDA.ByName['RDB$PARAMETER_TYPE'].AsInteger = 0) then
            begin
              if (Result <> '') then
                Result := Result + ', ';
              Result := Result + '?' + FormatIdentifier(Database.SQLDialect,
Trim(lSQLDA.ByName['RDB$PARAMETER_NAME'].AsString));
            end;
            lSQLDA := Next;
          end;
          Close;
        finally
          Commit;
        end;
      finally
        Qry.Free;
        Trans.Free;
      end;
    end;
    if Result<>'' then Result:='('+Result+')'
end;

function TpStoredProcCollect.IndexOfSP(DB:TFIBDatabase;const SPName:string;
 ForceReQuery:boolean
):integer;
var RegSPName:string;
begin
 RegSPName:=DB.DBName+'||'+SPName;
 with FStoredProcNames do begin
   if ForceReQuery or not Find(RegSPName,Result) then begin
    Result:=Add(RegSPName);
    FSPParamTxt.Insert(Result,GetParamsText(DB,SPName))
   end;
 end;
end;

function TpStoredProcCollect.GetExecProcTxt(DB:TFIBDatabase;
         const SPName:string;   ForceReQuery:boolean
        ):string;

begin
  Result:='EXECUTE PROCEDURE ' + SPName+' '+
   FSPParamTxt[IndexOfSP(DB,SPName,ForceReQuery)]
end;


procedure   TpStoredProcCollect.ClearSPInfo(DB:TFIBDatabase);
var i,c:integer;
begin
   c:=Pred(FStoredProcNames.Count);
   for i:=c downto 0 do
    if Pos(DB.DBName,FStoredProcNames[i])=1 then
    begin
      FStoredProcNames.Delete(i);
      FSPParamTxt.Delete(i);
    end;
end;

// Routine function

function GetFieldInfos(Field:TField):TpFIBFieldInfo;
var d:TpFIBDataSet;
    RelTable,RelField:string;
begin
 Result:=nil;
 if not (Field.DataSet is TpFIBDataSet) then Exit;
 d:=TpFIBDataSet(Field.DataSet);
 with d do begin
  RelTable:=GetRelationTableName(Field);
  RelField:=GetRelationFieldName(Field);
  Result:=
   ListTableInfo.GetFieldInfo(DataBase,
       RelTable,RelField
   );
 end;
 if Result<>nil then Exit;
 
 RelTable:='ALIAS';
 RelField:=Field.FieldName;
 with d do
 Result:=
   ListTableInfo.GetFieldInfo(DataBase,
       RelTable,RelField
   );
end;

function  GetOtherFieldInfo(Field:TField;const InfoName:string):string;
var vFI:TpFIBFieldInfo;
begin
 Result:='';
 vFI   :=GetFieldInfos(Field);
 if vFI=nil then Exit;
 Result:=vFI.FOtherInfo.Values[InfoName]
end;

initialization
 ListTableInfo:=TpFIBTableInfoCollect.Create(nil);
 ListDataSetInfo:=TpDataSetInfoCollect.Create;
 ListOfDataBases:=TStringList.Create;
 ListSPInfo     :=TpStoredProcCollect.Create;
finalization
 ListTableInfo.Free;
 ListOfDataBases.Free;
 ListDataSetInfo.Free;
 ListSPInfo.Free
end.
