{************************************************************************}
{ FIBPlus - component library  for direct access  to Interbase  databases}
{    FIBPlus is based in part on the product                             }
{    Free IB Components, written by Gregory H. Deatz for                 }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.                     }
{                                         Contact:       gdeatz@hlmdd.com}
{    Copyright (c) 1998-2001 Serge Buzadzhy                              }
{                                         Contact: serge_buzadzhy@mail.ru}
{  Please see the file FIBLicense.txt for full license information.      }
{************************************************************************}


unit RegFIBPlusEditors;

interface
{$I FIBPlus.INC}
uses Classes, Sysutils, DB, Dialogs, Controls,
  pFIBDataSet, pFIBDatabase, pFIBStoredProc,FIBSqlEd,
  pFIBQuery, DSContainer, FIBSQLMonitor, pFIBErrorHandler,
  DsgnIntf, pFIBDBEdit,pFIBTrEdit
{$IFDEF INSTALL_EVENTALERT}
  ,pFIBEvent, pFIBEvedt
{$ENDIF}
{$IFDEF FOR_ALL},pFIBProps{$ELSE},sbFIBProps{$ENDIF}

  // Added by Serg Vostrikov
{$IFDEF CAN_DYN_ARRAY}
{$IFDEF  INC_SERVICE_SUPPORT}
  , IB_Services
{$ENDIF}
{$ENDIF}
  ;

type
  TpFIBTransactionEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;


  TpFIBDatabaseEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TFIBGenSQlEd = class(TComponentEditor)
    DefaultEditor: TComponentEditor;
  public
{$IFDEF VER100}
    constructor Create(AComponent: TComponent; ADesigner: TFormDesigner); override;
{$ELSE}
    constructor Create(AComponent: TComponent; ADesigner: IFormDesigner); override;
{$ENDIF}
    destructor Destroy; override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure SaveDataSetInfo;
  end;

procedure Register;

implementation

uses RegUtils, FIBDataSet, FIBQuery, FIBDatabase, SqlTxtRtns, StrUtil,
     EdFieldInfo, pFIBDataInfo, EdDataSetInfo;

const FIBPalette = 'FIBPlus';

type
 TFIBAliasEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
 end;

function TFIBAliasEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TFIBAliasEdit.GetValues(Proc: TGetStrProc);
var i: integer;
  Keys: Variant;
begin
  if PropCount > 1 then Exit;
  Keys := DefAllSubKey(['Software', RegFIBRoot, 'Aliases']);
  if VarType(Keys) = varBoolean then Exit;
  for i := VarArrayLowBound(Keys, 1) to VarArrayHighBound(Keys, 1) do Proc(Keys[i])
end;
//
type
 TFIBTrKindEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
 end;

function TFIBTrKindEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TFIBTrKindEdit.GetValues(Proc: TGetStrProc);
var i: integer;
    Keys,v: Variant;
begin
  if PropCount > 1 then Exit;
  Keys := DefAllSubKey(['Software', RegFIBRoot, RegFIBTrKinds]);
  Proc('NoUserKind');
  if VarType(Keys) = varBoolean then Exit;
  for i := VarArrayLowBound(Keys, 1) to VarArrayHighBound(Keys, 1) do begin
   v:=DefReadFromRegistry(['Software', RegFIBRoot, RegFIBTrKinds,
    Keys[i]
   ],['Name']);
   if VarType(v) <> varBoolean then
    Proc(v[0,0])
  end;
end;


type
  TDataSet_ID_Edit = class(TIntegerProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

function TDataSet_ID_Edit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

procedure TDataSet_ID_Edit.Edit;
var OldID: integer;
begin
  OldID := TpFIBDataSet(GetComponent(0)).DataSet_ID;
  if not ExistDRepositaryTable(TpFibDataSet(GetComponent(0)).DataBase) then begin
    if
      MessageDlg('Table FIB$DATASETS_INFO not exist.' + #13#10 +
      'Create it?', mtConfirmation, [mbOK, mbCancel], 0
      ) <> mrOk
      then Exit;
    CreateDRepositaryTable(TpFibDataSet(GetComponent(0)).DataBase);
  end;

  ChooseDSInfo(TpFIBDataSet(GetComponent(0)));
  if OldID <> TpFIBDataSet(GetComponent(0)).DataSet_ID then
    Modified
end;
//
type TTableNameEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TTableNameEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TTableNameEdit.GetValues(Proc: TGetStrProc);
var i: integer;
  Tables: TStrings;
begin
  if PropCount > 1 then Exit;
  if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then Exit;
  Tables := TStringList.Create;
  with TpFIBDataSet(TAutoUpdateOptions(GetComponent(0)).Owner) do try
    AllTables(SelectSQL.Text, Tables);
    for i := 0 to Pred(Tables.Count) do Proc(ExtractWord(1, Tables[i], [' ']));
  finally
    Tables.Free
  end
end;
//

type TKeyFieldNameEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TKeyFieldNameEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TKeyFieldNameEdit.GetValues(Proc: TGetStrProc);
var i: integer;
  Tables: TStrings;
begin
  if PropCount > 1 then Exit;
  if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then Exit;
  Tables := TStringList.Create;
  with TpFIBDataSet(TAutoUpdateOptions(GetComponent(0)).Owner),
    TAutoUpdateOptions(GetComponent(0))
    do try
    if Trim(UpdateTableName) = '' then Exit;
    FieldDefs.Update;
    for i := 0 to Pred(FieldCount) do begin
      if (Fields[i] is TIntegerField) and
        (ExtractWord(1, GetFieldOrigin(Fields[i]), ['.']) = UpperCase(UpdateTableName)) then
        Proc(Fields[i].FieldName);
    end;
  finally
    Tables.Free
  end
end;
//===========
{  TpFIBTransactionEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;}

function TpFIBTransactionEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TpFIBTransactionEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := 'Edit Transaction params';
  end;
end;

procedure TpFIBTransactionEditor.ExecuteVerb(Index: Integer);
begin
 case Index of
  0:  if EditFIBTrParams(TpFIBTransaction(Component)) then
       Designer.Modified 
 end;
end;
//===========
procedure TpFIBDatabaseEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: begin
        if not ExistFRepositaryTable(TFIBDataBase(Component)) then begin
          if MessageDlg('Table FIB$FIELDS_INFO not exist.' + #13#10 +
            'Create it?', mtConfirmation, [mbOK, mbCancel], 0) <> mrOk
            then Exit;
          CreateFRepositaryTable(TFIBDataBase(Component));
        end;
        ShowFieldInfo(TFIBDataBase(Component))
      end;
  else if EditFIBDatabase(TFIBDataBase(Component)) then
    Designer.Modified;
  end;
end;

function TpFIBDatabaseEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := 'Edit Field info table';
  else Result := 'Database Editor';
  end;
end;

function TpFIBDatabaseEditor.GetVerbCount: Integer;
begin
  Result := 2;
end;


type TGeneratorNameEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGeneratorNameEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TGeneratorNameEdit.GetValues(Proc: TGetStrProc);
var
  Qry: TpFIBQuery;
  Trans: TpFIBTransaction;
  Dset: TpFIBDataset;
  lSQLDA: TFIBXSQLDA;

begin
  if PropCount > 1 then Exit;
  if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then
Exit;
  Dset:= (TAutoUpdateOptions(GetComponent(0)).Owner as TpFIBDataSet);
  Qry := nil; Trans := nil;
  try
  Trans := TpFIBTransaction.Create(nil);
  Qry := TpFIBQuery.Create(nil);
  Qry.Database := Dset.Database;
  Trans.DefaultDatabase := Dset.Database;
  Qry.Transaction := Trans;
  Qry.SQL.Text := 'select RDB$GENERATOR_NAME '+
                  'from RDB$GENERATORS '+
  'where (RDB$SYSTEM_FLAG is NULL) or (RDB$SYSTEM_FLAG = 0)'+
                  'order by RDB$GENERATOR_NAME';
  try
   Trans.StartTransaction;
   Qry.ExecQuery;
   lSQLDA := Qry.Current;
     while not Qry.Eof do
     begin
       Proc(Trim(lSQLDA.ByName['RDB$GENERATOR_NAME'].AsString));
       lSQLDA := Qry.Next;
     end;
   Qry.Close;
  finally
   Trans.Commit;
  end;

  finally
    Qry.Free;
    Trans.Free;
  end
end;

// DataSet component editors

type
  PClass = ^TClass;

{$IFDEF VER100}

constructor TFIBGenSQlEd.Create(AComponent: TComponent; ADesigner: TFormDesigner);
{$ELSE}

constructor TFIBGenSQlEd.Create(AComponent: TComponent; ADesigner: IFormDesigner);
{$ENDIF}
var CompClass: TClass;
begin
  inherited Create(AComponent, ADesigner);
  CompClass := PClass(Acomponent)^;
  try
    PClass(AComponent)^ := TDataSet;
    DefaultEditor := GetComponentEditor(AComponent, ADesigner);
  finally
    PClass(AComponent)^ := CompClass;
  end;
end;

destructor TFIBGenSQlEd.Destroy;
begin
  DefaultEditor.Free;
  inherited Destroy
end;

function TFIBGenSQlEd.GetVerbCount: Integer;
begin
  if (Component is TpFIBDataSet) then
    Result := DefaultEditor.GetVerbCount + 2
  else
    Result := DefaultEditor.GetVerbCount + 1;
end;

function TFIBGenSQlEd.GetVerb(Index: Integer): string;
begin
  if Index < DefaultEditor.GetVerbCount then
    Result := DefaultEditor.GetVerb(Index)
  else
    case Index - DefaultEditor.GetVerbCount of
      0: Result := 'Generator SQls';
      1: Result := 'Edit DataSets info table';
    end;
end;

procedure TFIBGenSQlEd.ExecuteVerb(Index: Integer);
var SText:string;
begin
  if Index < DefaultEditor.GetVerbCount then
    DefaultEditor.ExecuteVerb(Index)
  else begin
   SText:=TFIBDataSet(Component).SelectSQL.Text;
   case Index - DefaultEditor.GetVerbCount of
      0: if ShowGenSQL(TFIBDataSet(Component)) then Designer.Modified;
      1: SaveDataSetInfo
   end;
   if SText<>TFIBDataSet(Component).SelectSQL.Text then
    Designer.Modified;
  end;
end;

procedure TFIBGenSQlEd.SaveDataSetInfo;
begin
  with Component as TpFibDataSet do
    if DataSet_ID = 0 then ShowMessage(Name + '.DataSet_ID must be greater 0')
    else
      if DataBase = nil then ShowMessage('DataBase not assigned')
      else begin
        if not ExistDRepositaryTable(TFIBDataset(Component).DataBase) then begin
          if
            MessageDlg('Table FIB$DATASETS_INFO not exist.' + #13#10 +
            'Create it?', mtConfirmation, [mbOK, mbCancel], 0
            ) <> mrOk
            then Exit;
          CreateDRepositaryTable(TFibDataSet(Component).DataBase);
        end;
        SaveFIBDataSetInfo(TpFibDataSet(Component));
      end;
end;

type
  TpFIBStoredProcProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TpFIBStoredProcProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

procedure TpFIBStoredProcProperty.GetValues(Proc: TGetStrProc);
var
  StoredProc: TpFIBStoredProc;
  Qry: TpFIBQuery;
  Trans: TpFIBTransaction;
  lSQLDA: TFIBXSQLDA;
begin
  StoredProc := GetComponent(0) as TpFIBStoredProc;
  Qry := nil; Trans := nil;
  try
    Qry := TpFIBQuery.Create(nil);
    Qry.Database := StoredProc.Database;
    Trans := TpFIBTransaction.Create(nil);
    Trans.DefaultDatabase := StoredProc.Database;
    Qry.Transaction := Trans;
    Qry.SQL.Text := 'SELECT RDB$PROCEDURE_NAME FROM RDB$PROCEDURES';
    Trans.StartTransaction;
    try
    Qry.ExecQuery;
      lSQLDA := Qry.Current;
      while not Qry.Eof do
      begin
        Proc(Trim(lSQLDA.ByName['RDB$PROCEDURE_NAME'].AsString));
        lSQLDA := Qry.Next;
      end;
      Qry.Close;
    finally
      Trans.Commit;
    end;
  finally
    Qry.Free;
    Trans.Free;
  end;
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string), TpFIBDatabase, 'AliasName', TFIBAliasEdit);
{$IFDEF INSTALL_EVENTALERT}
  RegisterPropertyEditor(TypeInfo(TStrings), TpFIBEventer, 'Events', TEventsProperty);
{$ENDIF}
  RegisterPropertyEditor(TypeInfo(string),TpFIBTransaction,
   'UserKindTransaction',
   TFIBTrKindEdit
  );

  RegisterPropertyEditor(TypeInfo(string), TAutoUpdateOptions,
    'UpdateTableName', TTableNameEdit
    );
  RegisterPropertyEditor(TypeInfo(string), TAutoUpdateOptions,
    'KeyFields', TKeyFieldNameEdit
    );
  RegisterPropertyEditor(TypeInfo(integer), TpFIBDataSet,
    'DataSet_ID', TDataSet_ID_Edit
    );
  RegisterPropertyEditor(TypeInfo(string), TpFIBStoredProc, 'StoredProcName',
   TpFIBStoredProcProperty
  );
  RegisterPropertyEditor(TypeInfo(boolean),TFIBDataSet,'WaitEndMasterScroll',nil);
  RegisterComponentEditor(TpFIBTransaction, TpFIBTransactionEditor);
  RegisterComponentEditor(TpFIBDatabase, TpFIBDatabaseEditor);
  RegisterComponentEditor(TFIBDataSet, TFIBGenSQlEd);
  RegisterPropertyEditor(TypeInfo(string), TAutoUpdateOptions,
    'GeneratorName', TGeneratorNameEdit
    );

end;

end.
