{************************************************************************}
{ FIBPlus - component library  for direct access  to Interbase  databases}
{    FIBPlus is based in part on the product                             }
{    Free IB Components, written by Gregory H. Deatz for                 }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.                     }
{                                         Contact:       gdeatz@hlmdd.com}
{    Copyright (c) 1998-2001 Serge Buzadzhy                              }
{                                         Contact: serge_buzadzhy@mail.ru}
{  Please see the file FIBLicense.txt for full license information.      }
{************************************************************************}

unit RegFIBPlus;

interface
{$I FIBPlus.INC}
 uses Classes,Sysutils,DB,
  pFIBDataSet,pFIBDatabase,
  pFIBQuery, DSContainer,FIBSQLMonitor,pFIBErrorHandler,
  pFIBStoredProc,

  {$IFDEF INSTALL_EVENTALERT}
   pFIBEvent,
  {$ENDIF}
  {$IFDEF FOR_ALL} pFIBProps {$ELSE}sbFIBProps {$ENDIF}

  // Added by Serg Vostrikov

   {$IFDEF  INC_SERVICE_SUPPORT}
  ,IB_Services, IB_Install
   {$ENDIF}

  ;


procedure Register;

implementation

uses DsgnIntf,RegUtils,FIBDataSet,FIBQuery,FIBDatabase,SqlTxtRtns,StrUtil,
 pFIBDataInfo
;

const FIBPalette='FIBPlus';

{$R FIBPLUS.DCR}

procedure Register;
begin
 {$IFNDEF ONLY_PLUS}
  RegisterComponents(FIBPalette, [TFIBDataSet]);
  RegisterComponents(FIBPalette, [TFIBQuery]);
  RegisterComponents(FIBPalette, [TFIBDatabase, TFIBTransaction]);
 {$ENDIF}
 {$IFDEF INSTALL_EVENTALERT}
  RegisterComponents(FIBPalette, [TpFIBEventer]);
 {$ENDIF}
  RegisterComponents(FIBPalette, [TpFIBStoredProc]);
  RegisterComponents(FIBPalette, [TFIBSQLMonitor]);
  RegisterComponents(FIBPalette,
   [TpFIBDatabase,TpFIBDataSet,TpFIBTransaction,TpFIBQuery,
    TpFIBUpdateObject,    TDataSetsContainer,
    TpFibErrorHandler
   ]
  );
  //Added by Serg Vostrikov

  {$IFDEF  INC_SERVICE_SUPPORT}
  RegisterComponents(FIBPalette, [
       TpFIBServerProperties,
       TpFIBConfigService,
       TpFIBLicensingService,
       TpFIBLogService,
       TpFIBStatisticalService,
       TpFIBBackupService,
       TpFIBRestoreService,
       TpFIBValidationService,
       TpFIBSecurityService,
       TpFIBInstall,
       TpFIBUnInstall

    ]);
   {$ENDIF}

end;

end.
