unit BDE2FIBPlus;

interface
uses Classes, Forms, DB, DbTables, pFIBDataSet, FIBDataSet,
     FIBDatabase, pFIBQuery, pFIBMigrator, pFIBDatabase, SysUtils;

type
  TBDE2FIBPlus = class(TCustomFIBPlusMigrator)
  private
    FFIBTransaction: TpFIBTransaction;
    function GetTransaction: TpFIBTransaction;
    procedure SetTransaction(Value: TpFIBTransaction);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;

    { Overrided methods }

    procedure MigrateTransactions; override;
    function ReplaceField(aDataSet: TpFIBDataSet; aField: TField): boolean; override;
    procedure CheckDataSet(MustDie: TDataSet); override;
    procedure CheckQuery(aComponent: TComponent); override;
    function CheckForFree(aComponent: TComponent): boolean; override;
    function IsDataSetNeeded(MustDie: TDataSet): boolean; override;

    procedure SetStoredProcedure(vQuery: TpFIBQuery; MustDie: TDataSet); override;
    function GetNeededTransaction(MustDie: TDataSet): TpFIBTransaction; override;
    procedure GetNeededSQLs(aDataSet: TpFIBDataSet; MustDie: TDataSet); override;
    procedure GetCachedUpdates(aDataSet: TpFIBDataSet; MustDie: TDataSet); override;
    procedure GetNeededUpdateObject(aDataSet: TpFIBDataSet; MustDie: TDataSet); override;
  public
    procedure Migrate; override;
  published
    property FIBTransaction: TpFIBTransaction read GetTransaction write SetTransaction;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('FIBPlus', [TBDE2FIBPlus]);
end;

{ TBDE2FIBPlus }
function  TBDE2FIBPlus.GetTransaction: TpFIBTransaction;
begin
  Result := FFIBTransaction;
end;

procedure TBDE2FIBPlus.SetTransaction(Value: TpFIBTransaction);
begin
  FFIBTransaction := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

procedure TBDE2FIBPlus.Notification(AComponent: TComponent;  Operation: TOperation);
begin
  inherited;
  if (Operation = opRemove) and (AComponent = FFIBTransaction) then
      FFIBTransaction := nil;
end;

procedure  TBDE2FIBPlus.Migrate;
begin
  if not Assigned(FIBTransaction) then
    raise Exception.Create('Transaction is not assigned!');
  inherited;
end;

procedure TBDE2FIBPlus.CheckDataSet(MustDie: TDataSet);
var aDataSet: TpFIBDataSet;
begin
  if (MustDie is TBDEDataSet) then begin
    // Add dataset pair to list
    aDataSet := TpFIBDataSet.Create(MustDie.Owner);
    NewDataSetPair(aDataSet, MustDie);
  end;
end;

function TBDE2FIBPlus.CheckForFree(aComponent: TComponent): boolean;
begin
  Result := (aComponent is TBDEDataSet);
end;

procedure TBDE2FIBPlus.CheckQuery(aComponent: TComponent);
begin
  // nothing to do
end;

procedure TBDE2FIBPlus.GetCachedUpdates(aDataSet: TpFIBDataSet;
  MustDie: TDataSet);
begin
  aDataSet.CachedUpdates := TBDEDataSet(MustDie).CachedUpdates;
end;

procedure TBDE2FIBPlus.GetNeededSQLs(aDataSet: TpFIBDataSet;
  MustDie: TDataSet);
var SpPars: string;
    LineIndex, L: Integer;
begin
  if MustDie is TQuery then begin
    aDataSet.SelectSQL.Assign((MustDie as TQuery).SQL);
    with aDataSet.SelectSQL do
      for LineIndex := 0 to Pred(Count) do begin
        SpPars := Strings[LineIndex];
        repeat
         L := Pos(':', SpPars);
         if L = 0 then Break;
         SpPars[L] := '?';
        until False;
        Strings[LineIndex] := SpPars;
      end;
  end
  else begin
    aDataSet.SelectSQL.Text := 'select * from ' +
       TTable(MustDie).TableName;
    with aDataSet.AutoUpdateOptions do begin
      AutoReWriteSqls := True;
      UpdateTableName := TTable(MustDie).TableName;
      KeyFields := TTable(MustDie).IndexFieldNames;
    end;
  end;
end;

function TBDE2FIBPlus.GetNeededTransaction(
  MustDie: TDataSet): TpFIBTransaction;
begin
  Result := FFIBTransaction;
end;

procedure TBDE2FIBPlus.GetNeededUpdateObject(aDataSet: TpFIBDataSet;
  MustDie: TDataSet);
begin
  with (MustDie as TBDEDataSet) do
    if Assigned(UpdateObject) and (UpdateObject is TUpdateSQL) then
      with (UpdateObject as TUpdateSQL) do begin
        aDataSet.UpdateSQL := ModifySQL;
        aDataSet.InsertSQL := InsertSQL;
        aDataSet.DeleteSQL := DeleteSQL;
      end;
end;

function TBDE2FIBPlus.IsDataSetNeeded(MustDie: TDataSet): boolean;
begin
  Result := not (MustDie is TStoredProc);
end;

function TBDE2FIBPlus.ReplaceField(aDataSet: TpFIBDataSet;
  aField: TField): boolean;
begin
  Result := false;
end;

procedure TBDE2FIBPlus.SetStoredProcedure(vQuery: TpFIBQuery;
  MustDie: TDataSet);
var SpPars: string;
    ParamIndex: Integer;
begin
  with (MustDie as TStoredProc) do begin
    vQuery.SQL.Text := 'EXECUTE PROCEDURE ' + StoredProcName;
    if ParamCount = 0 then Prepare;
    if ParamCount > 0 then begin
      SpPars := '';
      for ParamIndex := 0 to Pred(ParamCount) do
        if Params[ParamIndex].ParamType = ptInput then
           SpPars := SpPars + '?' + Params[ParamIndex].Name + ',';
      if SpPars <> '' then SpPars := '(' +
          Copy(SpPars, 1, Length(SpPars) - 1) + ')';
      vQuery.SQL.Text := vQuery.SQL.Text + SpPars;
    end;
    MustDie.Name := 'Die_' + MustDie.Name;
    vQuery.Name := Copy(MustDie.Name, 5, length(MustDie.Name));
  end;
end;

procedure TBDE2FIBPlus.MigrateTransactions;
begin
  // nothing to do
end;

end.


