unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FIBDatabase, pFIBDatabase, Db, FIBDataSet, pFIBDataSet, ExtCtrls,
  StdCtrls, Grids, DBGrids, ComCtrls, Mask, FIBQuery, pFIBQuery;

type
  TForm1 = class(TForm)
    pFIBDatabase1: TpFIBDatabase;
    dsShablon: TpFIBDataSet;
    pFIBTransaction1: TpFIBTransaction;
    DataSource1: TDataSource;
    Panel1: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Button1: TButton;
    edFileName: TEdit;
    Button2: TButton;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    TabSheet3: TTabSheet;
    Memo1: TMemo;
    DBGrid1: TDBGrid;
    SQLText: TMemo;
    Panel2: TPanel;
    Button4: TButton;
    btnChange: TButton;
    Panel3: TPanel;
    Button6: TButton;
    qryDDL: TpFIBQuery;
    Label2: TLabel;
    EdName: TEdit;
    Button3: TButton;
    btnCreateSP: TButton;
    CheckBox1: TCheckBox;
    Button5: TButton;
    memRSQL: TMemo;
    Splitter1: TSplitter;
    procedure btnChangeClick(Sender: TObject);
    procedure btnCreateSPClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure pFIBDatabase1Connect(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    function SP_Text(DataSet:TpFibDataSet;asVariable:boolean):string;
    function View_Text(DataSet:TpFibDataSet):string;    
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses FIBSQLed,ibase,StrUtil,SqlTxtRtns;

function LastChar(const Text: string): char;
begin
  if Length(Text) = 0 then Result := #0
  else Result := Text[Length(Text)];
end;

procedure TForm1.btnChangeClick(Sender: TObject);
begin
 if not  pFIBTransaction1.Active then pFIBTransaction1.StartTransaction;
 dsShablon.Close;
 if ShowGenSQL(dsShablon) then
   SQLText.Text:=dsShablon.SelectSQL.Text

end;



type  THackFibDataSet =class (TpFibDataSet);

function GetNameSQLType(Field:TField):string;
var vSQLType:integer;
    vScale,vSize  :integer;
    floatSize     :integer;
begin
 with TpFibDataSet(Field.DataSet).QSelect.FieldByName[Field.FieldName],
  THackFibDataSet(Field.DataSet)
  do begin
  vSQLType:=SQLType;
  vSize    :=Size;
  if (vSQLType =SQL_DOUBLE) or (vSQLType =SQL_FLOAT) then begin
   vScale   :=-GetFieldScale(TNumericField(Field)) ;
   case vSize of
    4:floatSize:=9;
    8:floatSize:=15;
   else
    floatSize:=4
   end;
  end;
 end;
 case vSQLType of
  SQL_VARYING :Result:='VARCHAR('+IntToStr(vSize)+')';
  SQL_TEXT    :Result:='CHAR('+IntToStr(vSize)+')';
  SQL_DOUBLE ,  SQL_FLOAT   :
  Result:='NUMERIC('+IntToStr(floatSize)+','+IntToStr(vScale)+')';
  SQL_LONG    :Result:='INTEGER';
  SQL_SHORT   :Result:='SMALLINT';
  SQL_DATE    :
     if Form1.pFIBDatabase1.SQLDialect = 3 then Result := 'TIMESTAMP'
     else Result := 'DATE';
  SQL_BLOB    :Result:='BLOB';
  SQL_TYPE_TIME:Result:='TIME';
  SQL_TYPE_DATE:Result:='DATE';
  SQL_INT64:Result:='NUMERIC(18, 0)';
 else
  Result:='UNKNOWN';
 end;
end;

function TForm1.SP_Text(DataSet:TpFibDataSet;asVariable:boolean):string;
var i:integer;
    bufStr:string;
    declareStr:string;
    ts:TStrings;
begin  
 ts:=TStringList.Create;
 Result:='';
 with ts,DataSet do try
   Clear;
   Add('CREATE PROCEDURE ' + FormatIdentifier(pFIBDatabase1.SQLDialect, EdName.Text));
   Add('RETURNS (');
   if not asVariable then begin
    declareStr:=' '
   end
   else begin
    declareStr:=' declare variable ';
    Add(')');
    Add('AS');
   end;
   for i:=0 to Pred(FieldCount) do begin
    bufStr:=declareStr+
     FormatIdentifier(pFIBDatabase1.SQLDialect, Fields[i].FieldName) + ' ' +
         GetNameSQLType(Fields[i]);
    if i<>Pred(FieldCount) then bufStr:=bufStr+iifStr(asVariable,';',',');
    Add(bufStr)
   end;
   if not asVariable then begin
    Add(')');
    Add('AS');
   end;
   Add('BEGIN');
   Add('FOR');
   for i:=0 to Pred(SelectSQL.Count) do
      Add('   '+SelectSQL[i]);
   Add(' INTO ' );
   for i:=0 to Pred(FieldCount) do begin
    bufStr:='        :'+FormatIdentifier(pFIBDatabase1.SQLDialect, Fields[i].FieldName);
    if i<>Pred(FieldCount) then bufStr:=bufStr+', ';
    Add(bufStr)
   end;
   Add('DO') ;
   Add('BEGIN');
   Add('  Suspend;');
   Add('END');
   Add('END');
   Result:=ts.Text;
 finally
  ts.Free
 end;
end;


procedure TForm1.btnCreateSPClick(Sender: TObject);
begin
 if not dsShablon.Active then dsShablon.Open;
 Memo1.Lines.Text:=SP_Text(dsShablon,CheckBox1.Checked);
 PageControl1.ActivePage:=TabSheet3;
 Memo1.SetFocus;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 pFIBDatabase1.Connected:=false;
 if Trim(edFileName.Text)<>'' then
   pFIBDatabase1.DBName:=edFileName.Text;
 pFIBDatabase1.Connected:=true;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 with pFIBDatabase1 do begin
  ReadParamsFromAlias;
  edFileName.Text:=DBName;
  if ParamCount>0 then begin
   DBName:=ParamStr(1);
   UseLoginPrompt:=ParamCount<3;
   if not UseLoginPrompt then begin
     DBParams.Values['user_name']:=ParamStr(2);
     DBParams.Values['password'] :=ParamStr(3);
     Connected:=True;
     Button1.Enabled:=false
   end;
  end;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if OpenDialog1.Execute then begin
   edFileName.Text:=OpenDialog1.FileName;
 end;
end;


function TForm1.View_Text(DataSet:TpFibDataSet):string;
var i:integer;
    bufStr:string;
    declareStr:string;
    ts:TStrings;
begin
 ts:=TStringList.Create;
 Result:='';
 with ts,DataSet do try
   Clear;
   Add('CREATE VIEW '+FormatIdentifier(pFIBDatabase1.SQLDialect, EdName.Text)+' (');

   for i:=0 to Pred(FieldCount) do begin
    bufStr:=declareStr+ FormatIdentifier(pFIBDatabase1.SQLDialect, Fields[i].FieldName);
    if i<>Pred(FieldCount) then bufStr:=bufStr+',';
    Add(bufStr)
   end;
   Add(')');
   Add('AS');
   AddStrings(SelectSQL);
   Result:=ts.Text;
 finally
  ts.Free
 end;
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
 if not dsShablon.Active then dsShablon.Open;
 Memo1.Lines.Text:=View_Text(dsShablon);
 PageControl1.ActivePage:=TabSheet3;
 Memo1.SetFocus;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 dsShablon.Close;
 dsShablon.SelectSQL.Text:=SQLText.Text;
 dsShablon.Open;
 PageControl1.ActivePage:=TabSheet2;
end;

procedure TForm1.pFIBDatabase1Connect(Sender: TObject);
begin
  if Trim(edFileName.Text)='' then
   edFileName.Text:=pFIBDatabase1.DBName
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
 with  qryDDL do begin
  SQL.Text:=Memo1.Text;
  ExecQuery;
  pFIBTransaction1.CommitRetaining
 end;
end;

procedure TForm1.Button5Click(Sender: TObject);
var i,j,p:integer;
    s,s1:string;
    Alias,RelTable:string;
begin
 s1:=SQLText.Text;s:='';
 p:=Pos('*',s1);
 while p<>0 do begin
  j:=p-1;
  while (j>0) and (s1[j] in [' ',#9,#13,#10]) do Dec(j);
  RelTable:='';Alias:='';
  if (j>0) and (s1[j]='.') then begin
   while (j>0) and (s1[j] in [' ',#9,#13,#10,'.']) do
    Dec(j);
   while (j>0) and not (s1[j] in [' ',#9,#13,#10,'.']) do begin
    Alias:=s1[j]+Alias;
    Dec(j);
   end;
   RelTable:=TableByAlias(SQLText.Text,Alias);
  end;
  s:=s+Copy(s1,1,j);
  if LastChar(s)<>#10 then s:=s+#13#10#9;
  with  dsShablon do begin
   Close; SelectSQL.Text:=SQLText.Text;
   Open;
   for i :=0  to Pred(FieldCount) do
   begin
     if (RelTable='') or
      (GetRelationTableName(Fields[i])=UpperCase(RelTable))
     then begin
      if Alias<>'' then
       s:=s+Alias+'.'+GetRelationFieldName(Fields[i])
      else
       s:=s+GetFieldOrigin(Fields[i]);
      if i<FieldCount-1 then s:=s+','+#13#10#9;
     end;
   end;
  end;
  s1:=Copy(s1,p+1,100000);
  p:=Pos('*',s1);
 end;
 j:=1; p:=Length(s1);
 while (j<=p) and  (s1[j]in [' ',#13,#9,#10]) do Inc(j);
 s1:=Copy(s1,j,100000);
 if (LastChar(s)<>#10) then s:=s+#13#10;
 s:=s+s1;
 memRSQL.Text:=s;
end;

end.
