unit frmUserDS;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, StdCtrls, ExtCtrls;

type
  TfrmDsgnSQLs = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    DBGrid2: TDBGrid;
    Splitter1: TSplitter;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    procedure CheckRepTable;
  public
    { Public declarations }
  end;

var
  frmDsgnSQLs: TfrmDsgnSQLs;

implementation

uses DmCSDemo,FIBSQLEd,pFIBDataInfo,CommonIB;

{$R *.DFM}

procedure TfrmDsgnSQLs.CheckRepTable;
begin
  if not ExistDRepositaryTable(DmEmployee.UserDS.DataBase) then
   if
      MessageDlg('Table FIB$DATASETS_INFO not exist.' + #13#10 +
      'Create it?', mtConfirmation, [mbOK, mbCancel], 0
      ) <> mrOk
    then Abort
   else
    CreateDRepositaryTable(DmEmployee.UserDS.DataBase);

end;

procedure TfrmDsgnSQLs.FormCreate(Sender: TObject);
begin
 try
  DmEmployee.DSInfos.Close;
  if ExistDRepositaryTable(DmEmployee.UserDS.DataBase) then begin
   DmEmployee.DSInfos.Open;
   DBGrid2.Visible:=True;
  end
  else
   DBGrid2.Visible:=false
 except
  if not DmEmployee.DSInfos.Active then  DBGrid2.Visible:=false ;
  raise
 end;
end;

procedure TfrmDsgnSQLs.Button3Click(Sender: TObject);
var str,str1:string;
    b:boolean;
begin
  CheckRepTable;
  str :=IntToStr(DmEmployee.UserDS.DataSet_ID);
  str1:=str;
  b:=InputQuery('Input DataSet number ','New DataSet number',
    str
  );
  if not b then Exit;
  with DmEmployee,DmEmployee.UserDS do
  try
   Close;
   if (Sender=Button1) and (str1<>str) then begin
    SelectSQL.Clear; UpdateSQL.Clear;
    InsertSQL.Clear; RefreshSQL.Clear;
   end; 
   DataSet_ID:=0;
   b :=ShowGenSQL(UserDS);
   DataSet_ID:=StrToInt(str);
   if b then
    ListDataSetInfo.ClearDSInfo(UserDS)
   else
    Exit;
   SaveFIBDataSetInfo(UserDS);
   DmEmployee.DSInfos.Close;
   DmEmployee.DSInfos.Open;
   DBGrid2.Visible:=True;
  except
   on EConvertError do
     MessageDlg('You must input number ' , mtError, [mbOK], 0)
   else
    raise
  end;
end;

end.
