unit Frmviews;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,Dialogs,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Buttons, Grids, ExtCtrls,
  FIBDataSet, pFIBDataSet, Menus, ComCtrls;

type
  TFrmViewDemo = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    VaryingTableSource: TDataSource;
    Panel2: TPanel;
    VaryingTable: TpFIBDataSet;
    cmbTables: TComboBox;
    qryAllTables: TpFIBDataSet;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Panel3: TPanel;
    DBNavigator: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    BitBtn1: TBitBtn;
    PopupMenu1: TPopupMenu;
    Sortbycurrentcolumn1: TMenuItem;
    StatusBar1: TStatusBar;
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure VaryingTableSourceDataChange(Sender: TObject; Field: TField);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure Sortbycurrentcolumn1Click(Sender: TObject);
  private
    { private declarations }
    procedure GetAllTables;
    procedure ShowTable(ATable: string);
    procedure ShowStatusForms;
  public
    { public declarations }
  end;

var
  FrmViewDemo: TFrmViewDemo;

implementation

{$R *.DFM}
uses FIBSQLEd,StrUtil;

procedure TFrmViewDemo.ShowTable( ATable: string );
begin
  Screen.Cursor := crHourglass;      { show user something's happening }
  VaryingTable.DisableControls;      { hide data changes from user }
  VaryingTable.Active := FALSE;      { close the table }
  (* Old BDE source
  VaryingTable.TableName := ATable;  { update the name }
  *)

  with VaryingTable, AutoUpdateOptions do begin
    UpdateTableName := ATable;  { update the name }
    AutoReWriteSqls := true;
    GenBeforePost := false;
    SelectSQL.Text := 'select * from ' + ATable;
    DeleteSQL.Clear;  UpdateSQL.Clear; InsertSQL.Clear;
    RefreshSQL.Clear; KeyFields:=''
  end;
  VaryingTable.Open;                 { open the table }
  VaryingTable.EnableControls;       { paint the changes }
  Screen.Cursor := crDefault;        { reset the pointer }
  ShowStatusForms
end;

procedure TFrmViewDemo.FormShow(Sender: TObject);
begin
  VaryingTable.Open;
end;

procedure TFrmViewDemo.GetAllTables;
begin
 with qryAllTables,cmbTables do begin
  if not Active then  Open;
  Items.Clear;
  First;
  while not eof do begin
   Items.Add(FN('RDB$RELATION_NAME').asString);
   Next
  end
 end;
end;

procedure TFrmViewDemo.BitBtn2Click(Sender: TObject);
begin
  with VaryingTable do
  if HasUncommitedChanges then
    if (MessageDlg('Do commit unsaved changes?', mtConfirmation,
          [mbYes, mbCancel], 0) = mrYes) then
    Transaction.Commit
  else
    Transaction.Rollback;
  ShowTable(cmbTables.Text);
end;

procedure TFrmViewDemo.FormCreate(Sender: TObject);
begin
 GetAllTables;
 if cmbTables.Items.Count>0 then
  cmbTables.ItemIndex:=0;
end;

procedure TFrmViewDemo.ShowStatusForms;
begin
 with VaryingTable,StatusBar1 do begin
  Button1.Enabled:=  HasUncommitedChanges;
  Button2.Enabled:=  HasUncommitedChanges;
  if not Sorted then
   Panels[0].Text:='Haven''t sort fields'
  else with SortFieldInfo(1) do begin
   Panels[0].Text:='Sorted on "'+FieldName+'" by '+iifStr(Asc,'ascending','descending')
  end;
 end;
end;

procedure TFrmViewDemo.Button1Click(Sender: TObject);
begin
 VaryingTable.Transaction.CommitRetaining;
 ShowStatusForms;
end;

procedure TFrmViewDemo.Button2Click(Sender: TObject);
begin
   VaryingTable.Transaction.RollBack;
   ShowTable(cmbTables.Text);
end;

procedure TFrmViewDemo.VaryingTableSourceDataChange(Sender: TObject;
  Field: TField);
begin
 ShowStatusForms;
end;

procedure TFrmViewDemo.DBGrid1TitleClick(Column: TColumn);
var FieldSortOrder:TSortFieldInfo;
begin
 with VaryingTable do
  if Active then
   if not IsSortedField(Column.Field,FieldSortOrder) then
    DoSort([Column.FieldName],[true])
   else
    DoSort([Column.FieldName],[not FieldSortOrder.Asc]);
 ShowStatusForms;
end;

procedure TFrmViewDemo.Sortbycurrentcolumn1Click(Sender: TObject);
begin
 DBGrid1TitleClick(DBGrid1.Columns[DBGrid1.SelectedIndex])
end;

end.
