unit Frmtrans;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Buttons, Grids, ExtCtrls,
  Dialogs;

type
  TFrmTransDemo = class(TForm)
    DBGrid1: TDBGrid;
    DBNavigator: TDBNavigator;
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BtnUndoEdits: TSpeedButton;
    BtnCommitEdits: TSpeedButton;
    procedure BtnCommitEditsClick(Sender: TObject);
    procedure BtnUndoEditsClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FrmTransDemo: TFrmTransDemo;

implementation

uses DmCSDemo;

{$R *.DFM}

procedure TFrmTransDemo.FormShow(Sender: TObject);
begin
  (* Old BDE source
  DmEmployee.EmployeeDatabase.StartTransaction;
  *)
  DmEmployee.Transaction.StartTransaction;
  DmEmployee.EmployeeTable.Open;
end;

procedure TFrmTransDemo.FormHide(Sender: TObject);
begin
  (* Old BDE source
  DmEmployee.EmployeeDatabase.Commit;
  *)
  DmEmployee.Transaction.CommitRetaining;
end;

procedure TFrmTransDemo.BtnCommitEditsClick(Sender: TObject);
begin
  (* Old BDE source
  if DmEmployee.EmployeeDatabase.InTransaction and
  *)
  if DmEmployee.Transaction.InTransaction and
     (MessageDlg('Are you sure you want to commit your changes?',
        mtConfirmation, [mbYes, mbNo], 0) = mrYes) then
  begin
    (* Old BDE source
    DmEmployee.EmployeeDatabase.Commit;
    DmEmployee.EmployeeDatabase.StartTransaction;
    *)
    DmEmployee.Transaction.CommitRetaining;
    DmEmployee.Transaction.StartTransaction;
    DmEmployee.EmployeeTable.Refresh;
  end else
    MessageDlg('Can''t Commit Changes: No Transaction Active', mtError, [mbOk], 0);
end;

procedure TFrmTransDemo.BtnUndoEditsClick(Sender: TObject);
begin
  (* Old BDE source
  if DmEmployee.EmployeeDatabase.InTransaction and
  *)
  if DmEmployee.Transaction.InTransaction and
    (MessageDlg('Are you sure you want to undo all changes made during the ' +
       'current transaction?', mtConfirmation, [mbYes, mbNo], 0) = mrYes) then
   begin
     (* Old BDE source
     DmEmployee.EmployeeDatabase.Rollback;
     DmEmployee.EmployeeDatabase.StartTransaction;
     *)
     DmEmployee.Transaction.RollbackRetaining;
     DmEmployee.Transaction.StartTransaction;
     DmEmployee.EmployeeTable.Refresh;
   end else
     MessageDlg('Can''t Undo Edits: No Transaction Active', mtError, [mbOk], 0);
end;

end.
