unit MainF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, FIBDataSet, pFIBDataSet, FIBDatabase, pFIBDatabase, Grids, DBGrids,
  FIB, pFIBErrorHandler, StdCtrls;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Database: TpFIBDatabase;
    Transaction: TpFIBTransaction;
    CompaniesDataSet: TpFIBDataSet;
    pFibErrorHandler1: TpFibErrorHandler;
    Label1: TLabel;
    cmbKindOnLost: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    procedure DatabaseLostConnect(Database: TFIBDatabase; E: EFIBError;
      var Actions: TOnLostConnectActions);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure pFibErrorHandler1FIBErrorEvent(Sender: TObject;
      ErrorValue: EFIBError; KindIBError: TKindIBError;
      var DoRaise: Boolean);
    procedure DatabaseErrorRestoreConnect(Database: TFIBDatabase;
      E: EFIBError; var Actions: TOnLostConnectActions);
    procedure DatabaseAfterRestoreConnect;
    procedure Button1Click(Sender: TObject);
    procedure DatabaseConnect(Sender: TObject);
  private
    AttemptRest:integer;
  public
    { Public declarations }
    Restoring: boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DatabaseLostConnect(Database: TFIBDatabase; E: EFIBError;
  var Actions: TOnLostConnectActions);

begin
  case cmbKindOnLost.ItemIndex of
   0: begin
       Actions := laCloseConnect;
       MessageDlg('Connection lost. TpFIBDatabase will be closed!',
        mtInformation, [mbOk], 0
       );
      end;
   1:begin
      Actions := laTerminateApp;
      MessageDlg('Connection lost. Application will be closed!',
       mtInformation, [mbOk], 0
      );
     end;
   2:begin
     Restoring := true;
     Actions := laWaitRestore;
     TpFIBDataBase(Database).OnLostConnect := nil;
   end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Restoring := false;
  Database.Open;
  Transaction.StartTransaction;
  CompaniesDataSet.AutoUpdateOptions.UpdateTableName := 'Companies';
  CompaniesDataSet.Open;
  cmbKindOnLost.ItemIndex:=0;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Transaction.InTransaction then Transaction.Commit;
  Database.Close;
end;

procedure TForm1.pFibErrorHandler1FIBErrorEvent(Sender: TObject;
  ErrorValue: EFIBError; KindIBError: TKindIBError; var DoRaise: Boolean);
begin
  Label4.Visible:=true;
  Label3.Visible:=true;
  if Restoring then exit;
  if KindIBError = keLostConnect then begin
    DoRaise := false;
    Abort;
  end;
end;

procedure TForm1.DatabaseErrorRestoreConnect(Database: TFIBDatabase;
  E: EFIBError; var Actions: TOnLostConnectActions);
begin
 Inc(AttemptRest);
 Label4.Caption:=IntToStr(AttemptRest);
 Label4.Refresh
end;

procedure TForm1.DatabaseAfterRestoreConnect;
begin
  MessageDlg('Connection restored. You can apply cached updates',
       mtInformation, [mbOk], 0
  );
  Restoring := false;
  Database.OnLostConnect := DatabaseLostConnect;
  Label4.Visible:=false;
  Label3.Visible:=false;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 with CompaniesDataSet do try
  if not DataBase.Connected then begin
   try
    DataBase.Connected:=true
   except
    MessageDlg('Can''t restore connect',
       mtInformation, [mbOk], 0
    );
    Exit
   end
  end;
  if not Transaction.Active then Transaction.StartTransaction;
  ApplyUpdToBase;
  Transaction.CommitRetaining;
  CommitUpdToCach
 except
  if Transaction.Active then Transaction.RollBack
 end;
end;

procedure TForm1.DatabaseConnect(Sender: TObject);
begin
   DataBase.UseLoginPrompt:=false;
end;

end.
