{************************************************************************}
{ FIBPlus - component library  for direct access  to Interbase  databases}
{    FIBPlus is based in part on the product                             }
{    Free IB Components, written by Gregory H. Deatz for                 }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.                     }
{                                         Contact:       gdeatz@hlmdd.com}
{    Copyright (c) 1998-2001 Serge Buzadzhy                              }
{                                         Contact: serge_buzadzhy@mail.ru}
{  Please see the file FIBLicense.txt for full license information.      }
{************************************************************************}
unit MainF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    AliasesLB: TListBox;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    AliasNameE: TEdit;
    PathE: TEdit;
    UserE: TEdit;
    RoleE: TEdit;
    CharSetC: TComboBox;
    DialectC: TComboBox;
    DeleteB: TButton;
    AddB: TButton;
    UpdateB: TButton;
    CloseB: TButton;
    BrowseB: TButton;
    OpenD: TOpenDialog;
    TestB: TButton;
    procedure CloseBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AliasesLBClick(Sender: TObject);
    procedure UpdateBClick(Sender: TObject);
    procedure DeleteBClick(Sender: TObject);
    procedure AddBClick(Sender: TObject);
    procedure BrowseBClick(Sender: TObject);
    procedure TestBClick(Sender: TObject);
  private
    { Private declarations }
    procedure ReadAliasInfo(const AliasName: string);
    procedure WriteAliasInfo(const AliasName: string);
    procedure DeleteAliasInfo(const AliasName: string);
    function  CurrentAlias: string;
    procedure ClearAliasInfo;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
uses RegUtils, Registry, FIB, ibase,DB,FIBDatabase,ib_intf;

{$R *.DFM}

const RegFIBRoot = 'FIBC_Software';

procedure TMainForm.CloseBClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var RegObj: TRegistry;
begin
  RegObj := TRegistry.Create;
  with RegObj do
  try
   RootKey := HKEY_CURRENT_USER;
   OpenKey('Software', true);
   OpenKey(RegFIBRoot, true);
   OpenKey('Aliases', true);
   GetKeyNames(AliasesLB.Items);
   if not IsIBClient6 then
   begin
    DialectC.Items.Clear;
    DialectC.Items.Add('1');
   end;
    DialectC.ItemIndex:=0
  finally
   Free;
  end;
end;

procedure TMainForm.AliasesLBClick(Sender: TObject);
begin
  if AliasesLB.ItemIndex = -1 then exit;
  ClearAliasInfo;
  ReadAliasInfo(CurrentAlias);
end;

procedure TMainForm.ReadAliasInfo(const AliasName: string);
var Values: Variant;
    Index: integer;
begin
  AliasNameE.Text := AliasName;
  Values :=
   DefReadFromRegistry(['Software', RegFIBRoot, 'Aliases', AliasName],
     ['Database Name',
      DPBConstantNames[isc_dpb_user_name],
      DPBConstantNames[isc_dpb_lc_ctype],
      DPBConstantNames[isc_dpb_sql_role_name],
      'SQL_DIALECT'
     ]
   );
  if VarType(Values) = varBoolean then Exit;
  for Index := 0 to 4 do begin
   if Values[1, Index] then
    case Index of
     0: PathE.Text := Values[0, Index];
     1: UserE.Text := Values[0, Index];
     2: CharSetC.Text := Values[0, Index];
     3: RoleE.Text := Values[0, Index];
     4: DialectC.Text:=Values[0, Index]
//     ItemIndex := StrToIntDef(Values[0, Index], 1) - 1;
    end;
  end;
end;

procedure TMainForm.WriteAliasInfo(const AliasName: string);
begin
  DefWriteToRegistry(['Software', RegFIBRoot, 'Aliases', AliasName],
    ['Database Name'
    ,
     DPBConstantNames[isc_dpb_user_name],
     DPBConstantNames[isc_dpb_lc_ctype],
     DPBConstantNames[isc_dpb_sql_role_name],
     'SQL_DIALECT'
    ],
    [PathE.Text
    ,
     UserE.Text,
     CharSetC.Text,
     RoleE.Text,
     IntToStr(DialectC.ItemIndex + 1)
    ]
  );
end;

procedure TMainForm.UpdateBClick(Sender: TObject);
var Res: TModalResult;
begin
  if AliasesLB.ItemIndex = -1 then exit;
  if CurrentAlias = AliasNameE.Text then WriteAliasInfo(CurrentAlias)
  else begin
    Res := MessageDlg('Alias has been renamed. Update?', mtConfirmation,
     [mbYes, mbNo, mbCancel], 0);
    case Res of
      mrCancel: exit;
      mrYes: begin
        DeleteAliasInfo(CurrentAlias);
        WriteAliasInfo(AliasNameE.Text);
        AliasesLB.Items[AliasesLB.ItemIndex] := AliasNameE.Text;
      end;
      else WriteAliasInfo(CurrentAlias);
    end;
  end;
end;

procedure TMainForm.DeleteAliasInfo(const AliasName: string);
var RegObj: TRegistry;
    Index: Integer;
    SubKeys: TStringList;
begin
  RegObj := TRegistry.Create;
  with RegObj do
  try
   RootKey := HKEY_CURRENT_USER;
   OpenKey('Software', true);
   OpenKey(RegFIBRoot, true);
   OpenKey('Aliases', true);
   if OpenKey(AliasName, false) then begin
     SubKeys := TStringList.Create;
     GetValueNames(SubKeys);
     for Index := 0 to pred(SubKeys.Count) do
       DeleteValue(SubKeys[Index]);
     SubKeys.Free;
     CloseKey;
     RootKey := HKEY_CURRENT_USER;
     OpenKey('Software\' + RegFIBRoot + '\Aliases', true);
     DeleteKey(AliasName);
   end;
  finally
   Free;
  end;
end;

procedure TMainForm.DeleteBClick(Sender: TObject);
begin
  if AliasesLB.ItemIndex = -1 then exit;
  if MessageDlg('Are you sure you want to delete alias: "' +
    CurrentAlias + '"?"', mtConfirmation, [mbYes, mbNo], 0) <> mrYes then exit;
  DeleteAliasInfo(CurrentAlias);
  AliasesLB.Items.Delete(AliasesLB.ItemIndex);
end;

function TMainForm.CurrentAlias: string;
begin
  Result := AliasesLB.Items[AliasesLB.ItemIndex];
end;

procedure TMainForm.AddBClick(Sender: TObject);
var NewAlias: string;
    Index: Integer;
begin
  if not InputQuery('Add new Alias', 'Alias name', NewAlias) then exit;
  NewAlias := trim(NewAlias);
  Index := AliasesLB.Items.IndexOf(NewAlias);
  if Index <> -1 then begin
    MessageDlg('This Alias already exists.', mtError, [mbOk], 0);
    exit;
  end;
  AliasesLB.Items.Add(NewAlias);
  AliasesLB.ItemIndex := AliasesLB.Items.Count - 1;
  AliasNameE.Text := NewAlias;
  ClearAliasInfo;
  WriteAliasInfo(CurrentAlias);
end;

procedure TMainForm.ClearAliasInfo;
begin
  PathE.Text := '';
  UserE.Text := 'SYSDBA';
  CharSetC.Text := 'WIN1251';
  RoleE.Text := '';
  DialectC.ItemIndex := 2;
end;

procedure TMainForm.BrowseBClick(Sender: TObject);
begin
  if not OpenD.Execute then exit;
  PathE.Text := OpenD.FileName;
end;

procedure TMainForm.TestBClick(Sender: TObject);
var TempDB : TFIBDatabase;
begin
  TestB.Enabled := false;
  TempDB := TFIBDatabase.Create(nil);
  try
    TempDB.DBName:=PathE.Text;
    with TempDB.DBParams do begin
     Values['user_name']    :=UserE.Text;
     Values['sql_role_name']:=RoleE.Text;
     Values['lc_ctype']     :=CharSetC.Text;
    end;
    TempDB.UseLoginPrompt := true;
    TempDB.SQLDialect :=  DialectC.ItemIndex + 1;
    TempDB.Connected := True;
    ShowMessage('Successful Connection');
  finally
    TempDB.Free;
    TestB.Enabled := true;
  end;
end;

end.
