{***************************************************************
 *
 * Unit Name : FProgress
 * Purpose   : Progress Dialog
 * Author    : Eugen Mihailescu
 * Company   : EM Quicksoft Romania SRL
 * Copyright : 1998,2002  All rights reserved.
 * Web Site  : http://www.em-quicksoft.com
 * Support   : support@em-quicksoft.com
 * History   : 03/19/2000
 *
 * Disclaimer: The objectives of this program is only educational.
 *             You MUST NOT use it without getting any material benefit on it
 *             You have the right to share this code with others without removing
 *             the copyright and/or disclaimer notice.
 *             You are allowed to include its code in your application
 *             only if it was designed for non commercial purpose,
 *             otherwise we claim $10 for each copy of your
 *             application which contains this code inside.
 ****************************************************************}

Unit fProgress;

Interface

Uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ComCtrls;

Type
  TProgressForm = Class(TForm)
    ProgressBar: TProgressBar;
    StatusLabel: TLabel;
    CancelButton: TButton;
  private

  protected
    Procedure SetMinValue(Value: Integer);
    Procedure SetMaxValue(Value: Integer);
    Procedure SetStatusMessage(Value: String);
    Procedure SetPosition(Value: Integer);
    Procedure SetCancel(Value: Boolean);

  public
    Procedure ProgressBy(Value: Integer);

    Property StatusMessage: String write SetStatusMessage;
    Property MinValue: Integer write SetMinValue;
    Property MaxValue: Integer write SetMaxValue;
    Property Position: Integer write SetPosition;
    Property CanCancel: Boolean write SetCancel;
  End;

Implementation

{$R *.DFM}

Const
  NOBUTTONHEIGHT    : Smallint = 112;
  WITHBUTTONHEIGHT  : Smallint = 147;
  //******************* TProgressForm.SetCancel *************************

Procedure TProgressForm.SetCancel;
Begin
  CancelButton.Visible := Value;
  If Value Then
    Self.Height := WITHBUTTONHEIGHT
  Else
    Self.Height := NOBUTTONHEIGHT;
End;
//******************* TProgressForm.ProgressBy *************************

Procedure TProgressForm.ProgressBy;
Begin
  ProgressBar.StepBy(Value);
End;
//******************* TProgressForm.SetMinValue *************************

Procedure TProgressForm.SetMinValue;
Begin
  ProgressBar.Min := Value;
End;
//******************* TProgressForm.SetMaxValue *************************

Procedure TProgressForm.SetMaxValue;
Begin
  ProgressBar.Max := Value;
End;
//******************* TProgressForm.SetPosition *************************

Procedure TProgressForm.SetPosition(Value: Integer);
Begin
  ProgressBar.Position := Value;
End;
//******************* TProgressForm.SetStatusMessage *************************

Procedure TProgressForm.SetStatusMessage(Value: String);
Begin
  StatusLabel.Caption := Value;
  StatusLabel.Refresh;
End;

End.

