{***************************************************************
 *
 * Unit Name : ExportAs
 * Purpose   : Export Dialog Box
 * Author    : Eugen Mihailescu
 * Company   : EM Quicksoft Romania SRL
 * Copyright : 1998,2002  All rights reserved.
 * Web Site  : http://www.em-quicksoft.com
 * Support   : support@em-quicksoft.com
 * History   : 03/19/2000
 *
 * Disclaimer: The objectives of this program is only educational.
 *             You MUST NOT use it without getting any material benefit on it
 *             You have the right to share this code with others without removing
 *             the copyright and/or disclaimer notice.
 *             You are allowed to include its code in your application
 *             only if it was designed for non commercial purpose,
 *             otherwise we claim $10 for each copy of your
 *             application which contains this code inside.
 ****************************************************************}

Unit ExportAs;

Interface

Uses
  ExportData,
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  ExtCtrls,
  StdCtrls,
  DBTables,
  Db;

Type
  TExportFrm = Class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    Image1: TImage;
    Button2: TButton;
    Button3: TButton;
    SaveDialog1: TSaveDialog;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Procedure Button1Click(Sender: TObject);
    Procedure Button2Click(Sender: TObject);
    Procedure FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
    Procedure Button3Click(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure RadioGroup2Click(Sender: TObject);
  private
    btnClose: Boolean;
    { Private declarations }
  public
    TableName: String;
    Function ExportDataAs(FileName: String): TExportFile;
  End;

Var
  ExportFrm         : TExportFrm;
  defaultname       : String;

Implementation
{$R *.DFM}
//******************* TExportFrm.Button1Click *************************

Procedure TExportFrm.Button1Click(Sender: TObject);
Const
  extension         : Array[0..6] Of String[3] = ('db', 'dbf',
    'dbf', 'xls', 'txt', 'txt', '');
Begin
  SaveDialog1.FileName := Copy(ExtractFileName(defaultname), 1,
    Length(ExtractFileName(defaultname)) - 4);
  SaveDialog1.FilterIndex := ComboBox1.ItemIndex + 1;
  If SaveDialog1.Execute Then
    Begin
      ComboBox1.ItemIndex := SaveDialog1.FilterIndex - 1;
      Edit1.Text := SaveDialog1.FileName; //+ '.' +extension[savedialog1.FilterIndex];
      If ComboBox1.ItemIndex In [4, 5] Then
        Height := 373
      Else
        Height := 299;
    End;
  Top := (Screen.Height - Height) Div 2;
End;
//******************* TExportFrm.ExportDataAs *************************

Function TExportFrm.ExportDataAs(FileName: String): TExportFile;
Var
  R, R1             : TExportFile;
Begin
  defaultname := FileName;
  R1.FileName := '';
  R1.Pages := -1;
  R1.Selection := -1;
  R1.txtFormat := -1;
  R1.FormatType := dfNone;

  If ShowModal = mrOK Then
    Begin
      R.FileName := Edit1.Text;
      R.Selection := RadioGroup1.ItemIndex;
      R.Pages := RadioGroup2.ItemIndex;
      R.txtFormat := RadioGroup3.ItemIndex;
      Case ComboBox1.ItemIndex Of
        0: R.FormatType := dfParadox;
        1: R.FormatType := dfDBase;
        2: R.FormatType := dfFoxPro;
        3: R.FormatType := dfExcel;
        4: R.FormatType := dfCSV;
        5: R.FormatType := dfASCII;
        Else
          R.FormatType := dfNone;
      End;
      Result := R;
    End
  Else
    Begin
      R1.FileName := '';
      Result := R1;
    End;
End;
//******************* TExportFrm.Button2Click *************************

Procedure TExportFrm.Button2Click(Sender: TObject);
Begin
  If Trim(Edit1.Text) <> '' Then
    Begin
      TableName := Edit1.Text;
    End
  Else
    MessageBox(0, 'Invalid filename. Please enter again.', 'Invalid filename', mb_OK Or mb_iconerror);
End;
//******************* TExportFrm.FormCloseQuery *************************

Procedure TExportFrm.FormCloseQuery(Sender: TObject;
  Var CanClose: Boolean);
Begin
  CanClose := (Trim(Edit1.Text) <> '') Or (btnClose);
End;
//******************* TExportFrm.Button3Click *************************

Procedure TExportFrm.Button3Click(Sender: TObject);
Begin
  btnClose := True;
End;
//******************* TExportFrm.FormCreate *************************

Procedure TExportFrm.FormCreate(Sender: TObject);
Begin
  Height := 299;
  btnClose := False;
End;
//******************* TExportFrm.RadioGroup2Click *************************

Procedure TExportFrm.RadioGroup2Click(Sender: TObject);
Begin
  If radiogroup1.ItemIndex = 1 Then
    Begin
      radiogroup1.ItemIndex := 1;
      radiogroup1.Enabled := False;
    End
  Else
    radiogroup1.Enabled := True;
End;

End.

