{***************************************************************
 *
 * Unit Name : EMLinkLabel
 * Purpose   : Link Label
 * Author    : Eugen Mihailescu
 * Company   : EM Quicksoft Romania SRL
 * Copyright : 1998,2002  All rights reserved.
 * Web Site  : http://www.em-quicksoft.com
 * Support   : support@em-quicksoft.com
 * History   : 03/19/2000
 *
 * Disclaimer: The objectives of this program is only educational.
 *             You MUST NOT use it without getting any material benefit on it
 *             You have the right to share this code with others without removing
 *             the copyright and/or disclaimer notice.
 *             You are allowed to include its code in your application
 *             only if it was designed for non commercial purpose,
 *             otherwise we claim $10 for each copy of your
 *             application which contains this code inside.
 ****************************************************************}

Unit EMLinkLabel;

Interface

Uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Shellapi,
  MMSystem;

Type
  TLinkType = (ltHTTP, ltMAILTO, ltFTP, ltHTTPS, ltNews, ltTELNET, ltWAIS,
    ltGOPHER, ltFILE, ltCUSTOM, ltNone);
Const
  LinkProtocols     : Array[TLinkType] Of String =
    ('http://', 'mailto:', 'ftp://', 'https://', 'news:', 'telnet:', 'wais:',
    'gopher:', 'file://', '', '');
Type
  TLinkLabel = Class(TLabel)
  private
    FLinkType: TLinkType;
    FLinkProtocol: String;
    FLinkDestination: String;
    FLinkColor: TColor;
    FLinkColorMouseMove: TColor;
    FLinkMagnet: Boolean;
    FLinkSound: Boolean;
    Function GetLinkType(p: String): TLinkType;
  protected
    Procedure SetLinkType(Value: TLinkType);
    Procedure SetLinkProtocol(Value: String);
    Procedure SetLinkDestination(Value: String);
    Procedure Click; override;
    Procedure CMMouseEnter(Var Msg: TMessage); message CM_MOUSEENTER;
    Procedure CMMouseLeave(Var Msg: TMessage); message CM_MOUSELEAVE;
    Procedure CMFontChanged(Var Msg: TMessage); message CM_FONTCHANGED;
    Procedure SetLinkColor(Value: TColor);
  public
    Constructor Create(AOwner: TComponent); override;
  published
    Property LinkType: TLinkType read FLinkType write SetLinkType;
    Property LinkProtocol: String read FLinkProtocol write SetLinkProtocol;
    Property LinkDestination: String read FLinkDestination write
      SetLinkDestination;
    Property LinkColor: TColor read FLinkColor write SetLinkColor;
    Property LinkColorMouseMove: TColor read FLinkColorMouseMove write FLinkColorMouseMove;
    Property LinkMagnet: Boolean read FLinkMagnet write FLinkMagnet;
    Property LinkSound: Boolean read FLinkSound write FLinkSound;
  End;

Procedure Register;

Implementation
//******************* TLinkLabel.Create *************************

Constructor TLinkLabel.Create(AOwner: TComponent);
Begin
  Inherited Create(AOwner);
  Font.Color := clBlue;
  Font.Style := Font.Style + [fsUnderline];
  LinkDestination := 'mailto:support@em-quicksoft.com';
  FLinkColor := Font.Color;
  FLinkColorMouseMove := clRed;
  LinkMagnet := True;
  LinkSound := True;
  Caption := 'Send a mail to EM Quicksoft Romania';
  Cursor := crHandPoint;
End;
//******************* TLinkLabel.SetLinkType *************************

Procedure TLinkLabel.SetLinkType(Value: TLinkType);
Begin
  If FLinkType <> Value Then
    Begin
      FLinkType := Value;
      If FLinkType < ltCUSTOM Then
        FLinkProtocol := LinkProtocols[FLinkType]
      Else
        If FLinkType = ltNone Then
        Begin
          FLinkProtocol := '';
          FLinkDestination := '';
        End;
    End;
End;
//******************* TLinkLabel.SetLinkProtocol *************************

Procedure TLinkLabel.SetLinkProtocol(Value: String);
Begin
  If FLinkProtocol <> Value Then
    Begin
      FLinkProtocol := AnsiLowerCase(Value);
      FLinkType := GetLinkType(FLinkProtocol);
    End;
End;
//******************* TLinkLabel.GetLinkType *************************

Function TLinkLabel.GetLinkType(p: String): TLinkType;
Var
  I                 : TLinkType;
Begin
  For I := ltHTTP To ltFILE Do
    If LinkProtocols[I] = p Then
      Begin
        Result := I;
        Exit;
      End;
  If p = '' Then
    Result := ltNone
  Else
    Result := ltCUSTOM;
End;
//******************* TLinkLabel.SetLinkDestination *************************

Procedure TLinkLabel.SetLinkDestination(Value: String);
Var
  I                 : TLinkType;
  p                 : Integer;
Begin
  If Value <> FLinkDestination Then
    Begin
      FLinkDestination := AnsiLowerCase(Value);
      For I := ltHTTP To ltFILE Do
        Begin
          p := Pos(LinkProtocols[I], FLinkDestination);
          If p = 1 Then
            Begin
              FLinkDestination := Copy(FLinkDestination,
                Length(LinkProtocols[I]) + 1,
                Length(FLinkDestination) -
                Length(LinkProtocols[I]));
              FLinkType := I;
              FLinkProtocol := LinkProtocols[I];
              Exit;
            End;
        End;

      If FLinkDestination = '' Then
        Begin
          FLinkType := ltNone;
          FLinkProtocol := '';
        End
    End;
End;
//******************* TLinkLabel.Click *************************

Procedure TLinkLabel.Click;
Begin
  If LinkSound Then
    sndPlaySound('MenuPopup', snd_Async + snd_NoDefault);
  If FLinkType < ltNone Then
    ShellExecute(TWinControl(Owner).Handle, 'open', PChar(LinkProtocol + LinkDestination), Nil, Nil, SW_SHOW);
  Inherited Click;
End;
//******************* TLinkLabel.CMMouseEnter *************************

Procedure TLinkLabel.CMMouseEnter(Var Msg: TMessage);
Begin
  Font.Color := FLinkColorMouseMove;
  If LinkMagnet Then
    Begin
      Width := Width + 1;
      Height := Height + 1;
      Top := Top - 1;
      Left := Left - 1;
    End;
  If LinkSound Then
    sndPlaySound('MenuCommand', snd_Async + snd_NoDefault);
  Refresh;
End;
//******************* TLinkLabel.CMMouseLeave *************************

Procedure TLinkLabel.CMMouseLeave(Var Msg: TMessage);
Begin
  Font.Color := FLinkColor;
  If LinkMagnet Then
    Begin
      Width := Width - 1;
      Height := Height - 1;
      Top := Top + 1;
      Left := Left + 1;
    End;
  Refresh;
End;
//******************* TLinkLabel.SetLinkColor *************************

Procedure TLinkLabel.SetLinkColor(Value: TColor);
Begin
  If Value <> FLinkColor Then
    Begin
      FLinkColor := Value;
      Font.Color := FLinkColor;
      Refresh;
    End;
End;
//******************* TLinkLabel.CMFontChanged *************************

Procedure TLinkLabel.CMFontChanged(Var Msg: TMessage);
Begin
  If csDesigning In ComponentState Then
    Begin
      FLinkColor := Font.Color;
      Refresh;
    End;
End;

Procedure Register;
Begin
  RegisterComponents('EM-Quicksoft', [TLinkLabel]);
End;

End.

