{ Copyright 2002 Dirk Graf                                     Version 1.0   }
{ this utility functions are public domain. 				     }	 
{ contact dirk@d-graf.de                      				     }	 

unit UhndlPlugin;

interface

uses sysutils,windows,forms,Menus,shellapi,classes;

Type
  tGetPluginname  =Procedure (aname:PChar;Size:Integer); stdcall;
  tStartPlugin    =Procedure (stammdaten:PChar); stdcall;
  tPluginVersion  =Procedure (aVersion:PChar;Size:Integer); stdcall;
  tPluginHint     =Procedure (aVersion:PChar;Size:Integer); stdcall;

  tDllEntry=Class(TObject)
    dllHandle  : THandle;
    ProcAdress : tStartPlugin;
  end;

  tPluginProcs=Class(TList)
  private
    FPluginparam: string;
    procedure SetPluginparam(const Value: string);
    
  public
    Procedure Clear;override;
    Constructor Create;virtual;
    Procedure ExeClick(sender:TObject);
    Procedure DllClick(sender:TObject);
    Function AddDll(afile:String;aMenuItem:TMenuItem):TMenuItem;
    Function AddEXE(afile:String;aMenuItem:TMenuItem):TMenuItem;
    Property Pluginparam:string read FPluginparam write SetPluginparam;
  end;


Procedure addPlugIns(Item:tMenuItem);

implementation
uses grsys;

var PlugInProcs:tPluginProcs;

Procedure addPlugIns(Item:tMenuItem);
var
  sr:TSearchRec;
  I:Integer;
  TM:TMenuItem;
  s:String;
Begin
  s:=slashPath(extractfiledir(paramstr(0)))+'plugin\';
  I:=findfirst(s+'*.*',faAnyFile,sr);
  while I=0 do
  Begin
    If Uppercase(extractFileExt(sr.name))='.DLL' Then
       PlugInProcs.addDll(s+sr.name,Item) else
    If Uppercase(extractFileExt(sr.name))='.EXE' Then
       PlugInProcs.addexe(s+sr.name,Item);
    i:=findnext(sr);
  end;
  sysutils.findclose(sr);
end;

{ tPluginProcs }

function tPluginProcs.AddDll(afile: String;
  aMenuItem: TMenuItem): TMenuItem;
var
  TM:TMenuItem;
  entry: tDllEntry;
  a:array[0..64] Of Char;
  P:tGetPluginname;
  sp:tStartPlugin;
begin
  entry:=tDllEntry.Create;

  entry.dllHandle:=LoadLibrary(PChar(aFile));
  if entry.dllHandle <>0 Then
  Begin
    P:=tGetPluginname(GetProcAddress(entry.dllHandle,'GETPLUGINNAME'));
    If assigned(P) Then
    Begin
      P(a,sizeOf(a));
      TM:=TMenuItem.Create(aMenuItem);
      TM.Caption:=String(a);
      TM.OnClick:=DLLClick;
      entry.ProcAdress:=tStartPlugin(GetProcAddress(entry.dllHandle,'STARTPLUGIN'));
      tm.Tag:=Integer(entry);
      P:=tGetPluginname(GetProcAddress(entry.dllHandle,'PLUGINHINT'));
      If assigned(P) Then
         P(a,sizeOf(a));
      TM.Hint:=String(a);
      aMenuItem.add(tm);
      add(entry);
    end else
    Begin
      freeLibrary(entry.dllHandle);
      entry.Free;
    end;
  end else entry.Free;
end;

function tPluginProcs.AddEXE(afile: String;
  aMenuItem: TMenuItem): TMenuItem;
var
  TM:TMenuItem;
  s:String;
begin
  TM:=TMenuItem.Create(aMenuItem);
  s:=extractFilename(afile);
  TM.Caption:=copy(s,1,Pos('.',s)-1);
  TM.OnClick:=ExeClick;
  aMenuItem.add(tm);
end;

procedure tPluginProcs.Clear;
Var I:Integer;
begin
  For I:=0 to Count-1 do
  Begin
    FreeLibrary( tDllentry(Items[i]).dllHandle );
    tDllentry(Items[i]).ProcAdress:=NIL;
    tDllentry(Items[i]).free;
  end;
  inherited;
end;

constructor tPluginProcs.Create;
begin
  inherited;
  FPluginparam:='';
end;

procedure tPluginProcs.DllClick(sender: TObject);
begin
  tDllEntry(TmenuItem(sender).Tag).ProcAdress( PChar(FPluginparam));
end;

procedure tPluginProcs.ExeClick(sender: TObject);
var s,st:String;
begin
  s:=slashPath(extractfiledir(paramstr(0)))+'plugin\'+TmenuItem(sender).Caption+'.EXE';
  if Pos('&',s)>0 Then system.Delete(s,Pos('&',s),1);
  shellexecute(application.handle, 'open', Pchar(s), PChar(FPluginparam), '', sw_shownormal);
end;

procedure tPluginProcs.SetPluginparam(const Value: string);
begin
  FPluginparam := Value;
end;

initialization
  PlugInProcs:=tPluginProcs.create;
finalization
  PlugInProcs.Free;
end.
