{ ****************************************************************** }
{                                                                    }
{   Copyright  2002 by Jon Stagg                                    }
{                                                                    }
{  N.B. call FORMATCODE after paste or open                          }
{                                                                    }
{ ****************************************************************** }

unit MyCodeEditor;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Comctrls,StdCtrls;

type
  TCodeEditor = class(TRichEdit)
    private
      { Private fields of TCodeEditor }
        { Storage for property ColorASP }
        FColorASP : TColor;
        { Storage for property ColorHTML }
        FColorHTML : TColor;
        { Storage for property ColorSTD }
        FColorSTD : TColor;

      { Private methods of TCodeEditor }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TCodeEditor }

      { Protected methods of TCodeEditor }

        procedure KeyDown(var Key: Word; Shift: TShiftState); override;
        procedure KeyPress(var Key : Char); override;
        procedure KeyUp(var Key: Word; Shift: TShiftState); override;
        procedure Loaded; override;

    public
      { Public fields and properties of TCodeEditor }

      { Public methods of TCodeEditor }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure FormatCode;

    published
      { Published properties of TCodeEditor }
        property OnKeyDown;
        property OnKeyPress;
        property OnKeyUp;
        property ColorASP : TColor
             read FColorASP write FColorASP
             default clRed;
        property ColorHTML : TColor
             read FColorHTML write FColorHTML
             default clBlack;
        property ColorSTD : TColor
             read FColorSTD write FColorSTD
             default clNavy;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TCodeEditor with Win32 as its
       default page on the Delphi component palette }
     RegisterComponents('Win32', [TCodeEditor]);
end;

{ Method to set variable and property values and create objects }
procedure TCodeEditor.AutoInitialize;
begin
     FColorASP := clRed;
     FColorHTML := clNavy ;
     FColorSTD := clBlack;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TCodeEditor.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

procedure TCodeEditor.KeyDown(var Key: Word; Shift: TShiftState);
begin
     case Key of
     VK_BACK, VK_DELETE :   { Backspace, DEL keys }
               begin
               { Response to backspace/delete, if different
                 from or additional to response of parent class }

               end; 

     VK_PRIOR,              { PAGE UP key }
     VK_NEXT,               { PAGE DOWN key } 
     VK_END,                { END key }
     VK_HOME :              { HOME key }
               begin
               end;

     VK_LEFT,               { LEFT ARROW key }
     VK_UP,                 { UP ARROW key }
     VK_RIGHT,              { RIGHT ARROW key }
     VK_DOWN :              { DOWN ARROW key }
               begin
               end;
               
     VK_TAB :               { TAB key }
               begin
               end;

     VK_INSERT :            { INS key }
               begin
               end;

     VK_ESCAPE :            { ESC key }
               begin
               end;

     end; { case }

     { Obtain the default response of the parent class to this keydown event }
     inherited KeyDown(Key, Shift);
     //if not (ssShift in Shift) then exit;
    if (ord(key) = 188) and (Shift = [ssShift]) then selattributes.Color := ColorHTML;

end;

procedure TCodeEditor.KeyPress(var Key : Char);
const
     TabKey = Char(VK_TAB);
     EnterKey = Char(VK_RETURN);
begin
     inherited KeyPress(Key);
end;

procedure TCodeEditor.KeyUp(var Key: Word; Shift: TShiftState);
var
    s:integer;
begin
    //if not (ssShift in Shift) then exit;
    s:=selstart;
    if (ord(key) = 190) and (Shift = [ssShift]) then selattributes.Color := ColorSTD;
    if (ord(key) = 53) and (Shift = [ssShift]) then
        if s > 0 then
            if Text[s-1] = '<' then
                begin
                    selstart := s-2;
                    sellength := 2;
                    selattributes.color := ColorASP;
                end;
    selstart := s;
    sellength := 0;
    inherited KeyUp(Key, Shift);
     
end;

constructor TCodeEditor.Create(AOwner: TComponent);
const
  ScrollBarA: array[0..3] of TScrollStyle = (

    ssBoth,
    ssHorizontal,
    ssNone,
    ssVertical);
begin
     inherited Create(AOwner);
     if csDesigning in ComponentState then
        begin
            Font.Name := 'Courier New';
            Font.Size := 12;
            Align := alClient;
            WantTabs := true;
            WordWrap := False;
            ScrollBars := ScrollBarA[0];
        end;
     AutoInitialize;
end;

destructor TCodeEditor.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TCodeEditor.FormatCode;
var
  FoundAt: LongInt;
  s,StartPos, ToEnd,ss,se: Integer;
  label StartLoop1;
  label StartLoop2;
  label Start1;
  label Start2;
begin
Start1:
    s := selstart;
    StartPos := 0;
    selstart := 1;
    sellength :=  Length(Text);
    selattributes.Color := ColorSTD;

StartLoop1:
    ToEnd := Length(Text) - StartPos;
    FoundAt := FindText('<', StartPos, ToEnd, []);
    if FoundAt <> -1 then
        begin
            ss := FoundAt;
            FoundAt := FindText('>', ss+1, ToEnd, []);
            if FoundAt = -1 then
                se := length(text)
            else
                se := FoundAt + 1;
            SetFocus;
            SelStart := ss;
            SelLength := (se-ss);
            selattributes.Color := colorHTML;
            SelStart := se;
            SelLength := 0;
            if se = length(text) then exit;
        end
    else
        begin
            SelStart := length(text);
            SelLength := 0;
            goto Start2;
        end;
    StartPos := se;
    goto StartLoop1;
Start2:
    StartPos := 0;
StartLoop2:
    ToEnd := Length(Text) - StartPos;
    FoundAt := FindText('<%', StartPos, ToEnd, []);
    if FoundAt <> -1 then
        begin
            ss := FoundAt;
            FoundAt := FindText('%>', ss, ToEnd, []);
            if FoundAt = -1 then
                se := length(text)
            else
                se := FoundAt + 2;
            SetFocus;
            SelStart := ss;
            SelLength := (se-ss);
            selattributes.Color := ColorASP;
            SelStart := se;
            SelLength := 0;
            if se = length(text) then exit;
        end
    else
        begin
            SelStart := length(text);
            SelLength := 0;
            selstart := s;
            exit;
        end;
    StartPos := se;
    goto StartLoop2;
end;

procedure TCodeEditor.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;


end.

