unit Main;

interface

uses
  Windows, Classes, Controls, Forms, Buttons, TeeProcs, TeEngine, Chart,
  ChartView, Series, StdCtrls, ShellAPI, Dialogs, ExtCtrls;

type
  TMainForm = class(TForm)
    Chart1: TChart;
    Panel1: TPanel;
    AddBtn: TSpeedButton;
    RemoveBtn: TSpeedButton;
    ChartViewBtn: TSpeedButton;
    Series1: TLineSeries;
    Series2: TAreaSeries;
    ChartView: TChartView;
    Label1: TLabel;
    Label2: TLabel;
    procedure ChartViewBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure RemoveBtnClick(Sender: TObject);
    procedure Label2Click(Sender: TObject);
  private
    CurrentSeries: TChartSeries;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ChartViewBtnClick(Sender: TObject);
begin
  ChartView.Execute;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  Series1.FillSampleValues(20);
  Series2.FillSampleValues(20);
end;

procedure TMainForm.AddBtnClick(Sender: TObject);
begin
  CurrentSeries := TLineSeries.Create(Chart1);
  CurrentSeries.FillSampleValues(20);
  Chart1.AddSeries(CurrentSeries);
end;

procedure TMainForm.RemoveBtnClick(Sender: TObject);
begin
  CurrentSeries := Chart1.Series[Chart1.SeriesCount - 1];
  Chart1.RemoveSeries(CurrentSeries);
end;

procedure TMainForm.Label2Click(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', 'http://www.utilmind.com', nil, nil, SW_SHOWNORMAL);
end;
  
end.
