{*************************************************************}
{            ChartView Components for Delphi 32               }
{ Version:   1.00                                             }
{ Author:    Aleksey Kuznetsov                                }
{ E-Mail:    info@utilmind.com                                }
{ Homepage:  http://www.utilmind.com                          }
{ Created:   January, 28, 1999                                }
{ Modified:  February, 15, 1999                               }
{ Legal:     Copyright (c) 1999, UtilMind Solutions           }
{*************************************************************}
{   ChartView (English):                                      }
{ This component (dialogue window) is intended for visual     }
{ set-up of appearance of the diagrams TChart. With help of   }
{ dialogue TChartView the user can change style, colour and   }
{ headings of chart series, and also to change their          }
{ arrangement in Z-order.                                     }
{*************************************************************}
{   ChartView (Russian):                                      }
{   ( )         }
{      TChart.        }
{   TChartView         }
{ ,     ,   }
{     Z.  -  Execute.      }
{*************************************************************}
{ Thanks for using ChartView components.                      }
{ If at occurrence of any questions concerning these          }
{ components, please visit our website: www.utilmind.com      }
{*************************************************************}

unit ChartView;

interface

uses
  Windows, Classes, Forms, Chart, Dialogs,
  TeEngine, GraphView;

type
  TChartView = class(TCommonDialog)
  private
    FMasterChart: TChart;
    FLanguage: TLanguage;

    procedure SetMasterChart(Value: TChart);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(aOwner: TComponent); override;

    function Execute: Boolean; override;
  published
    property MasterChart: TChart read FMasterChart write SetMasterChart;
    property Language: TLanguage read FLanguage write FLanguage;
  end;

procedure Register;

implementation

constructor TChartView.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FMasterChart := nil;
end;

function TChartView.Execute;
var
  i: Integer;
  CurrentSerie: TChartSeries;
  SeriesStyle: TGraphStyle;
begin
  GraphViewDialog := TGraphViewDialog.Create(Application);
  GraphViewDialog.HelpContext := HelpContext;
  with GraphViewDialog do
   begin
    i := FMasterChart.SeriesCount;
    if i <> 0 then
     for i := 0 to i - 1 do
      begin
       CurrentSerie := FMasterChart.Series[i];
       if CurrentSerie.ClassName = 'TBarSeries' then SeriesStyle := gsBar else
       if CurrentSerie.ClassName = 'TAreaSeries' then SeriesStyle := gsArea else
       if CurrentSerie.ClassName = 'TPointSeries' then SeriesStyle := gsPoint
       else SeriesStyle := gsLine;
       Add(CurrentSerie.Title, SeriesStyle, CurrentSerie.Active, CurrentSerie.SeriesColor);
      end;
    MasterChart := FMasterChart;
    case FLanguage of
      lEnglish: begin
                 Caption := 'Chart View';
                 Label1.Caption := 'Series title:';
                 StyleBtn.Caption := '&Style...';
                 ColorBtn.Caption := '&Color...';
                 TitleBtn.Caption := '&Title...';
                 CloseBtn.Caption := '&Close';
                 UpBtn.Hint := 'Move up';
                 DownBtn.Hint := 'Move down';
                end;
      lRussian: begin
                 Caption := ' ';
                 Label1.Caption := ' ';
                 StyleBtn.Caption := '&...';
                 ColorBtn.Caption := '&...';
                 TitleBtn.Caption := '&...';
                 CloseBtn.Caption := '&';
                 UpBtn.Hint := '';
                 DownBtn.Hint := '';
                end;
      lUkrainian: begin
                   Caption := ' i';
                   Label1.Caption := '& i';
                   StyleBtn.Caption := '&...';
                   ColorBtn.Caption := '&...';
                   TitleBtn.Caption := '&...';
                   CloseBtn.Caption := '&';
                   UpBtn.Hint := '';
                   DownBtn.Hint := '';
                  end;
     end;
    Language := FLanguage;
    Result := ShowModal = id_Ok;
   end;
  GraphViewDialog.Free;
end;

procedure TChartView.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (AComponent = FMasterChart) and
     (Operation = opRemove) then
   FMasterChart := nil;
end;

procedure TChartView.SetMasterChart(Value: TChart);
begin
  if FMasterChart <> Value then
   begin
    FMasterChart := Value;
    if Value <> nil then
     Value.FreeNotification(Self);
   end;
end;

procedure Register;
begin
  RegisterComponents('UtilMind', [TChartView]);
end;

end.
