{***************************************************************
 *
 * Unit Name : AboutFrm
 * Purpose   : AboutBox Dialog
 * Author    : Eugen Mihailescu
 * Company   : EM Quicksoft Romania SRL
 * Copyright : 1998,2002  All rights reserved.
 * Web Site  : http://www.em-quicksoft.com
 * Support   : support@em-quicksoft.com
 * History   : 03/18/2000
 *
 * Disclaimer: The objectives of this program is only educational.
 *             You MUST NOT use it without getting any material benefit on it
 *             You have the right to share this code with others without removing
 *             the copyright and/or disclaimer notice.
 *             You are allowed to include its code in your application
 *             only if it was designed for non commercial purpose,
 *             otherwise we claim $10 for each copy of your
 *             application which contains this code inside.
 ****************************************************************}

Unit AboutFrm;

Interface

Uses Windows,
  Classes,
  Graphics,
  Forms,
  Controls,
  StdCtrls,
  Shellapi,
  Buttons,
  ExtCtrls,
  SysUtils;

Type
  TmyAboutBox = Class(TForm)
    OKButton: TButton;
    Image1: TImage;
    Label3: TLabel;
    Label4: TLabel;
    Label1: TLabel;
    Panel1: TPanel;
    Label2: TLabel;
    Bevel1: TBevel;
    Label5: TLabel;
    Label6: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Procedure Button1Click(Sender: TObject);
    Procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    Function GetWinDir: ShortString;
    { Public declarations }
  End;

Var
  myAboutBox        : TmyAboutBox;

Implementation
{$R *.DFM}
//******************* AddBackSlash *************************

Function AddBackSlash(Const S: ShortString): ShortString;
Begin
  If (Length(S) < 255) And (S[Length(S)] <> '\') Then
    Result := S + '\'
  Else
    Result := S;
End;
//******************* TmyAboutBox.GetWinDir *************************

Function TmyAboutBox.GetWinDir: ShortString;
Var
  WindowsDir        : ShortString;
Begin

  GetWindowsDirectory(@WindowsDir[1], SizeOf(WindowsDir) - 1);
  WindowsDir[0] := Chr(StrLen(@WindowsDir[1]));
  WindowsDir := AddBackSlash(WindowsDir);
  Result := UpperCase(WindowsDir);
End;
//******************* TmyAboutBox.Button1Click *************************

Procedure TmyAboutBox.Button1Click(Sender: TObject);
Var
  FileName          : String;
Begin
  FileName := Copy(GetWinDir, 1, 3) + 'Program Files\Common Files\Microsoft Shared\MSInfo\MSINFO32.EXE';
  ShellExecute(Application.Handle, Nil, PChar(FileName), Nil, Nil, SW_SHOW);
End;
//******************* TmyAboutBox.Button2Click *************************

Procedure TmyAboutBox.Button2Click(Sender: TObject);
Begin
  Application.HelpCommand(HELP_CONTENTS, 0);
End;

End.

