{***************************************************************
 *
 * Unit Name : AboutBox
 * Purpose   : Easy About Box Dialog
 * Author    : Eugen Mihailescu
 * Company   : EM Quicksoft Romania SRL
 * Copyright : 1998,2002  All rights reserved.
 * Web Site  : http://www.em-quicksoft.com
 * Support   : support@em-quicksoft.com
 * History   : 03/18/2000
 *
 * Disclaimer: The objectives of this program is only educational.
 *             You MUST NOT use it without getting any material benefit on it
 *             You have the right to share this code with others without removing
 *             the copyright and/or disclaimer notice.
 *             You are allowed to include its code in your application
 *             only if it was designed for non commercial purpose,
 *             otherwise we claim $10 for each copy of your
 *             application which contains this code inside.
 ****************************************************************}

Unit AboutBox;

Interface

Uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs;

Type
  TAboutBox = Class(TComponent)
  private
    fBmpLogo: TPicture;
    fProductName: String;
    fisRegistred: Boolean;
    fYourCompanyName: String;
    fOtherSoftwareCompany: String;
    fOtherSoftware: String;
    fOtherTM: Boolean;
    fRegUser: String;
    fRegCompany: String;
    fProductID: String;
    FCaption: String;
    fRegFrom: Word;
    fRegUpto: Word;
    fLegalNotice: String;
    fisShowing: Boolean;
  protected
    Procedure SetBmpLogo(Value: TPicture);
  public
    Constructor Create(AOwner: TComponent); override;
    Destructor Destroy; override;
    Procedure SetShowModal(Value: Boolean);
    Procedure myCloseEvent(Sender: TObject; Var Action: TCloseAction);
  published
    Property LogoPicture: TPicture read fBmpLogo write SetBmpLogo;
    Property ProductName: String read fProductName write fProductName;
    Property isRegistred: Boolean read fisRegistred write fisRegistred;
    Property YourCompanyName: String read fYourCompanyName write fYourCompanyName;
    Property OtherSoftwareCompany: String read fOtherSoftwareCompany write fOtherSoftwareCompany;
    Property OtherSoftwareName: String read fOtherSoftware write fOtherSoftware;
    Property OtherTM: Boolean read fOtherTM write fOtherTM;
    Property RegistredUser: String read fRegUser write fRegUser;
    Property RegistredCompany: String read fRegCompany write fRegCompany;
    Property ProductID: String read fProductID write fProductID;
    Property FormCaption: String read FCaption write FCaption;
    Property RegistredFrom: Word read fRegFrom write fRegFrom default 1999;
    Property RegistredUpto: Word read fRegUpto write fRegUpto default 2000;
    Property LegalNotice: String read fLegalNotice write fLegalNotice;
    Property ShowModal: Boolean read fisShowing write SetShowModal;
  End;

Procedure Register;

Implementation
Uses AboutFrm;
//******************* TAboutBox.Create *************************

Constructor TAboutBox.Create(AOwner: TComponent);
Begin
  myAboutBox := TmyAboutBox.Create(Application);
  myAboutBox.OnClose := myCloseEvent;
  Inherited Create(AOwner);
  fBmpLogo := TPicture.Create;
  fRegFrom := 1999;
  fRegUpto := 2000;
  FCaption := 'About...';
  fProductName := 'YourProductName';
  fRegCompany := 'YourCompanyName';
  fRegUser := 'UserName';
  fYourCompanyName := 'YourCompanyName';
  fOtherTM := True;
  fOtherSoftwareCompany := 'Inprise Co';
  fOtherSoftware := 'Delphi';
  If fBmpLogo.Graphic = Nil Then
    fBmpLogo.Icon := Application.Icon;
End;
//******************* TAboutBox.Destroy *************************

Destructor TAboutBox.Destroy;
Begin
  //  fBmpLogo.Free;
  //  myAboutBox.Free;
  Inherited Destroy;
End;
//******************* TAboutBox.SetShowModal *************************

Procedure TAboutBox.SetShowModal(Value: Boolean);
Begin
  myAboutBox.Label11.Visible := Not fisRegistred;
  myAboutBox.Label1.Caption := Format('%-s   by %-s. All rights reserved.', [fOtherSoftware, fOtherSoftwareCompany]);
  myAboutBox.Label1.Visible := fOtherTM;
  myAboutBox.Label4.Caption := Format('Copyright  %-d - %-d %-s. All rights reserved.', [fRegFrom, fRegUpto, fYourCompanyName]);
  If Trim(fProductName) <> '' Then
    myAboutBox.Label3.Caption := fProductName;
  myAboutBox.Label7.Caption := fRegUser;
  myAboutBox.Label8.Caption := fRegCompany;
  myAboutBox.Label10.Caption := fProductID;
  myAboutBox.Image1.Picture := fBmpLogo;
  myAboutBox.Caption := FCaption;
  fisShowing := Not Value;
  If Not Value Then
    myAboutBox.Close
  Else
    myAboutBox.ShowModal;
End;
//******************* TAboutBox.SetBmpLogo *************************

Procedure TAboutBox.SetBmpLogo(Value: TPicture);
Begin
  fBmpLogo.Assign(Value);
End;
//******************* TAboutBox.myCloseEvent *************************

Procedure TAboutBox.myCloseEvent(Sender: TObject; Var Action: TCloseAction);
Begin
  fisShowing := False;
  Action := caHide;
End;

Procedure Register;
Begin
  RegisterComponents('EM-Quicksoft', [TAboutBox]);
End;

End.

