
//////////////////////////////////////////////
//                                          //
//   Qmm 2.01                               //
//                                          //
//   Shared quick memory manager unit       //
//                                          //
//   Copyright (c) 2001, Andrew Driazgov    //
//   e-mail: andrey@asp.tstu.ru             //
//                                          //
//   Last updated: January 24, 2001         //
//                                          //
//////////////////////////////////////////////

library Qmm;

uses Windows;

{$R *.RES}

type
  PEntryPoint = ^TEntryPoint;
  TEntryPoint = packed record
    Address: LongWord;
    Space: LongWord;
    AdrLeft: PEntryPoint;
    AdrRight: PEntryPoint;
    SpLeft: PEntryPoint;
    SpRight: PEntryPoint;
  end;

  PEFreeArr = ^TEFreeArr;
  TEFreeArr = array[0..$7FFFFF] of PEntryPoint;

  TQMemHeapStatus = record
    TotalAddrSpace: Cardinal;
    TotalCommitted: Cardinal;
    TotalUncommitted: Cardinal;
    TotalAllocated: Cardinal;
    TotalFree: Cardinal;
    MaxFreeBlock: Cardinal;
    CountOfFreeBlocks: Cardinal;
    Overhead: Cardinal;
  end;

const
  MaxECount = $10000;  // MaxECount := (Value+$3FFF) and $FFFFC000;

var
  lpCriticalSection:_RTL_CRITICAL_SECTION;

  ListLeft: PEntryPoint;
  ListRight: PEntryPoint;

  EFreeCount: Integer;
  EFreeArr: PEFreeArr;

  SizeTable: array[0..30] of PEntryPoint;

  StartAddr: LongWord;
  SpaceBegin: LongWord;

  IntQMemIsInstalled: Boolean = False;

function GetNormalSize(Size: Integer): Integer;
asm
        ADD     EAX,3
        TEST    EAX,$FFFFFFE0
        JE      @@sm
        BSR     ECX,EAX
        MOV     EAX,2
        SHL     EAX,CL
        RET
@@sm:   MOV     EAX,32
end;

function GetRegionOfSize(Size: Integer): Pointer;
asm
        BSF     ECX,EAX
        LEA     EDX,[ECX*4+SizeTable]
        MOV     ECX,[EDX]
        TEST    ECX,ECX
        JE      @@nx
        MOV     EAX,ECX
        MOV     ECX,[ECX].TEntryPoint.SpRight
        MOV     [EDX],ECX
        TEST    ECX,ECX
        JE      @@qm
        XOR     EDX,EDX
        MOV     [ECX].TEntryPoint.SpLeft,EDX
@@qm:   RET
@@nx:   MOV     EDX,EAX
        MOV     EAX,ListLeft
        TEST    EAX,EAX
        JE      @@qt
@@lp:   CMP     EDX,[EAX].TEntryPoint.Space
        JLE     @@qt
        MOV     EAX,[EAX].TEntryPoint.AdrRight
        TEST    EAX,EAX
        JNE     @@lp
@@qt:
end;

function IntBitTest(P: Pointer; Index: Integer): Boolean;
asm
        BT      [EAX],EDX
        SETC    AL
end;

procedure IntBitSet(P: Pointer; Index: Integer);
asm
        BTS     [EAX],EDX
end;

function IntFreeBitScanForward(P: Pointer; FirstBit, LastBit: Integer): Integer;
asm
        PUSH    EBX
        PUSH    ESI
        PUSH    EDI
        LEA     ESI,[EDX+8]
        CMP     ECX,ESI
        JL      @@ut
        MOV     EBX,$FFFFFFFF
        MOV     ESI,ECX
        MOV     EDI,$0000001F
        AND     ECX,EDI
        AND     ESI,$FFFFFFE0
        SUB     EDI,ECX
        SHR     ESI,5
        MOV     ECX,EDI
        MOV     EDI,EBX
        SHR     EDI,CL
        MOV     ECX,EDX
        AND     EDX,$FFFFFFE0
        AND     ECX,$0000001F
        SHR     EDX,5
        SHL     EBX,CL
        MOV     ECX,[EAX+EDX*4]
        NOT     ECX
        AND     EBX,ECX
        SUB     ESI,EDX
        JE      @@nq
        TEST    EBX,EBX
        JNE     @@ne
        INC     EDX
        DEC     ESI
        JE      @@xx
@@lp:   MOV     EBX,[EAX+EDX*4]
        NOT     EBX
        TEST    EBX,EBX
        JNE     @@ne
        INC     EDX
        DEC     ESI
        JNE     @@lp
@@xx:   MOV     EBX,[EAX+EDX*4]
        NOT     EBX
@@nq:   AND     EBX,EDI
        JE      @@zq
@@ne:   BSF     ECX,EBX
@@qt:   SHL     EDX,5
        LEA     EAX,[ECX+EDX]
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@ut:   SUB     ECX,EDX
        JS      @@zq
@@uk:   BT      [EAX],EDX
        JNC     @@iq
        INC     EDX
        DEC     ECX
        JNS     @@uk
@@zq:   MOV     EAX,$FFFFFFFF
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@iq:   MOV     EAX,EDX
        POP     EDI
        POP     ESI
        POP     EBX
end;

function IntFreeBitScanReverse(P: Pointer; FirstBit, LastBit: Integer): Integer;
asm
        PUSH    EBX
        PUSH    ESI
        PUSH    EDI
        LEA     ESI,[EDX+8]
        CMP     ECX,ESI
        JL      @@ut
        MOV     EBX,$FFFFFFFF
        MOV     ESI,ECX
        MOV     EDI,$0000001F
        AND     ECX,EDI
        AND     ESI,$FFFFFFE0
        SUB     EDI,ECX
        SHR     ESI,5
        MOV     ECX,EDI
        MOV     EDI,EBX
        SHR     EDI,CL
        MOV     ECX,EDX
        AND     EDX,$FFFFFFE0
        AND     ECX,$0000001F
        SHR     EDX,5
        SHL     EBX,CL
        MOV     ECX,[EAX+ESI*4]
        NOT     ECX
        AND     EDI,ECX
        SUB     EDX,ESI
        JE      @@nq
        TEST    EDI,EDI
        JNE     @@ne
        NEG     EDX
        DEC     ESI
        DEC     EDX
        JE      @@xx
@@lp:   MOV     EDI,[EAX+ESI*4]
        NOT     EDI
        TEST    EDI,EDI
        JNE     @@ne
        DEC     ESI
        DEC     EDX
        JNE     @@lp
@@xx:   MOV     EDI,[EAX+ESI*4]
        NOT     EDI
@@nq:   AND     EDI,EBX
        JE      @@zq
@@ne:   BSR     ECX,EDI
@@qt:   SHL     ESI,5
        LEA     EAX,[ECX+ESI]
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@ut:   SUB     EDX,ECX
        JG      @@zq
@@uk:   BT      [EAX],ECX
        JNC     @@iq
        DEC     ECX
        INC     EDX
        JNG     @@uk
@@zq:   MOV     EAX,$FFFFFFFF
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@iq:   MOV     EAX,ECX
        POP     EDI
        POP     ESI
        POP     EBX
end;

procedure IntSetBits(P: Pointer; FirstBit, LastBit: Integer);
asm
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        LEA     ESI,[EDX+8]
        CMP     ECX,ESI
        JL      @@ut
        MOV     EBX,$FFFFFFFF
        MOV     ESI,ECX
        MOV     EDI,$0000001F
        AND     ECX,EDI
        AND     ESI,$FFFFFFE0
        SUB     EDI,ECX
        SHR     ESI,5
        MOV     ECX,EDI
        MOV     EDI,EBX
        SHR     EDI,CL
        MOV     ECX,EDX
        AND     EDX,$FFFFFFE0
        AND     ECX,$0000001F
        SHR     EDX,5
        SHL     EBX,CL
        SUB     ESI,EDX
        JE      @@xx
        OR      [EAX+EDX*4],EBX
        INC     EDX
        DEC     ESI
        JE      @@ne
        MOV     EBX,$FFFFFFFF
@@lp:   MOV     [EAX+EDX*4],EBX
        INC     EDX
        DEC     ESI
        JNE     @@lp
@@xx:   AND     EDI,EBX
@@ne:   OR      [EAX+EDX*4],EDI
        POP     EBX
        POP     ESI
        POP     EDI
        RET
@@ut:   SUB     ECX,EDX
        JS      @@qt
@@uk:   BTS     [EAX],EDX
        INC     EDX
        DEC     ECX
        JNS     @@uk
@@qt:   POP     EBX
        POP     ESI
        POP     EDI
end;

procedure DelFromSizeTable(E: PEntryPoint);
asm
        MOV     EDX,[EAX].TEntryPoint.SpLeft
        TEST    EDX,EDX
        JNE     @@nx
        MOV     EDX,[EAX].TEntryPoint.Space
        BSF     ECX,EDX
        LEA     EDX,[ECX*4+SizeTable]
        CMP     EAX,[EDX]
        JNE     @@qt
        MOV     ECX,[EAX].TEntryPoint.SpRight
        MOV     [EDX],ECX
        TEST    ECX,ECX
        JE      @@qt
        XOR     EDX,EDX
        MOV     [ECX].TEntryPoint.SpLeft,EDX
@@qt:   RET
@@nx:   MOV     ECX,[EAX].TEntryPoint.SpRight
        MOV     [EDX].TEntryPoint.SpRight,ECX
        TEST    ECX,ECX
        JE      @@qx
        MOV     [ECX].TEntryPoint.SpLeft,EDX
@@qx:
end;

function ExtGetMem(Size: Integer): Pointer;
label
  99;
var
  E: PEntryPoint;
  I,J: Integer;
begin
  try
    EnterCriticalSection(lpCriticalSection);
    Size := GetNormalSize(Size);
    E := GetRegionOfSize(Size);
    if E <> nil then
    begin
      J := E^.Address-StartAddr;
      I := J;
      Inc(J,Size);
      I := LongWord(I) shr 16;
      Dec(J);
      J := LongWord(J) shr 16;
      if I = J then
      begin
        if not IntBitTest(Pointer(StartAddr),I) then
        begin
          if VirtualAlloc(Pointer(StartAddr+LongWord(I) shl 16), $10000,
            MEM_COMMIT, PAGE_READWRITE) = nil then
          begin
            Result := nil;
            goto 99;
          end;
          IntBitSet(Pointer(StartAddr),I);
        end;
      end else
      begin
        I := IntFreeBitScanForward(Pointer(StartAddr),I,J);
        if I >= 0 then
        begin
          J := IntFreeBitScanReverse(Pointer(StartAddr),I,J);
          if VirtualAlloc(Pointer(StartAddr+LongWord(I) shl 16),
            LongWord(J-I+1) shl 16, MEM_COMMIT, PAGE_READWRITE) = nil then
          begin
            Result := nil;
            goto 99;
          end;
          IntSetBits(Pointer(StartAddr),I,J);
        end;
      end;
      with E^ do
      begin
        Result := Pointer(Address+4);
        PInteger(Address)^ := Size;
        I := Integer(Space)-Size;
        if I = 0 then
        begin
          EFreeArr^[EFreeCount] := E;
          Inc(EFreeCount);
          if AdrLeft <> nil then
            AdrLeft^.AdrRight := AdrRight
          else
            ListLeft := AdrRight;
          if AdrRight <> nil then
            AdrRight^.AdrLeft := AdrLeft
          else
            ListRight := AdrLeft;
        end else
        begin
          DelFromSizeTable(E);
          Space := I;
          Inc(Address,Size);
          SpLeft := nil;
        end;
      end;
    end else
      Result := nil;
  99:
  finally
    LeaveCriticalSection(lpCriticalSection);
  end;
end;

function SearchPointerPlace(P: Pointer): PEntryPoint;
asm
        MOV     EDX,EAX
        MOV     EAX,ListRight
        TEST    EAX,EAX
        JE      @@qt
@@lp:   CMP     EDX,[EAX].TEntryPoint.Address
        JAE     @@qt
        MOV     EAX,[EAX].TEntryPoint.AdrLeft
        TEST    EAX,EAX
        JNE     @@lp
@@qt:
end;

procedure SetInSizeTable(E: PEntryPoint; L: LongWord);
asm
        BSF     ECX,EDX
        LEA     EDX,[ECX*4+SizeTable]
        MOV     ECX,[EDX]
        MOV     [EDX],EAX
        MOV     [EAX].TEntryPoint.SpRight,ECX
        TEST    ECX,ECX
        JE      @@qt
        MOV     [ECX].TEntryPoint.SpLeft,EAX
@@qt:
end;

function ExtFreeMem(P: Pointer): Integer;
label
  99;
var
  E,E1: PEntryPoint;
  J: LongWord;
begin
  Dec(LongWord(P),4);
  if (LongWord(P)<SpaceBegin) or
    (PLongWord(P)^+LongWord(P)>LongWord(EFreeArr)) then
  begin
    Result := 1;
    Exit;
  end;
  try
    EnterCriticalSection(lpCriticalSection);
    E := SearchPointerPlace(P);
    if E <> nil then
    begin
      J := E^.Address+E^.Space;
      if LongWord(P) <= J then
      begin
        if LongWord(P) = J then
        begin
          J := PLongWord(P)^;
          if E <> ListRight then
          begin
            Inc(LongWord(P),J);
            E1 := E^.AdrRight;
            if LongWord(P) >= E1.Address then
            begin
              if LongWord(P) = E1.Address then
              begin
                DelFromSizeTable(E1);
                Inc(J,E^.Space);
                EFreeArr^[EFreeCount] := E;
                Inc(EFreeCount);
                DelFromSizeTable(E);
                with E1^ do
                begin
                  Dec(Address,J);
                  Inc(Space,J);
                  AdrLeft := E^.AdrLeft;
                  if AdrLeft <> nil then
                    AdrLeft^.AdrRight := E1
                  else
                    ListLeft := E1;
                  SpLeft := nil;
                end;
                Result := 0;
              end else
                Result := -1;
              goto 99;
            end;
          end;
          DelFromSizeTable(E);
          Inc(E^.Space,J);
          E^.SpLeft := nil;
          Result := 0;
        end else
          Result := -1;
        goto 99;
      end;
      E := E^.AdrRight;
    end else
      E := ListLeft;
    if E <> nil then
    begin
      J := PLongWord(P)^;
      Inc(J,LongWord(P));
      with E^ do
        if J >= Address then
        begin
          if J = Address then
          begin
            DelFromSizeTable(E);
            Address := LongWord(P);
            Inc(Space,PLongWord(P)^);
            SpLeft := nil;
            Result := 0;
          end else
            Result := -1;
          goto 99;
        end;
    end;
    if EFreeCount > 0 then
    begin
      Dec(EFreeCount);
      E1 := EFreeArr^[EFreeCount];
      with E1^ do
      begin
        Address := LongWord(P);
        Space := PLongWord(P)^;
        AdrRight := E;
        if E <> nil then
        begin
          AdrLeft := E^.AdrLeft;
          E^.AdrLeft := E1;
        end else
        begin
          AdrLeft := ListRight;
          ListRight := E1;
        end;
        if AdrLeft <> nil then
          AdrLeft^.AdrRight := E1
        else
          ListLeft := E1;
        SetInSizeTable(E1,Space);
        SpLeft := nil;
      end;
      Result := 0;
    end else
      Result := -1;
  99:
  finally
    LeaveCriticalSection(lpCriticalSection);
  end;
end;

procedure IntCopyMem(Source, Dest: Pointer; L: Cardinal);
asm
        PUSH    EBX
        SUB     EDX,4
        SHR     ECX,5
        JMP     @@fs
@@lp:   MOV     EBX,[EAX]
        MOV     [EDX],EBX
@@fs:   MOV     EBX,[EAX+4]
        MOV     [EDX+4],EBX
        MOV     EBX,[EAX+8]
        MOV     [EDX+8],EBX
        MOV     EBX,[EAX+12]
        MOV     [EDX+12],EBX
        MOV     EBX,[EAX+16]
        MOV     [EDX+16],EBX
        MOV     EBX,[EAX+20]
        MOV     [EDX+20],EBX
        MOV     EBX,[EAX+24]
        MOV     [EDX+24],EBX
        MOV     EBX,[EAX+28]
        MOV     [EDX+28],EBX
        ADD     EAX,32
        ADD     EDX,32
        DEC     ECX
        JNE     @@lp
@@qt:   POP     EBX
end;

function ExtReallocMem(P: Pointer; Size: Integer): Pointer;
label
  99;
var
  E,E1: PEntryPoint;
  J,K: Integer;
begin
  Dec(LongWord(P),4);
  if (LongWord(P)<SpaceBegin) or
    (PLongWord(P)^+LongWord(P)>LongWord(EFreeArr)) then
  begin
    LongWord(Result) := $FFFFFFFF;
    Exit;
  end;
  Size := GetNormalSize(Size);
  J := PInteger(P)^;
  if Size = J then
  begin
    Result := Pointer(LongWord(P)+4);
    Exit;
  end;
  try
    EnterCriticalSection(lpCriticalSection);
    E := SearchPointerPlace(P);
    if E <> nil then
    begin
      if LongWord(P) < E^.Address+E^.Space then
      begin
        Result := nil;
        goto 99;
      end;
      E := E^.AdrRight;
    end else
      E := ListLeft;
    if E <> nil then
      with E^ do
        if LongWord(J)+LongWord(P) >= Address then
        begin
          if LongWord(J)+LongWord(P) = Address then
          begin
            if Size <= J+Integer(Space) then
            begin
              if Size > J then
              begin
                J := (Address-StartAddr) shr 16;
                K := (LongWord(P)+LongWord(Size)-StartAddr-1) shr 16;
                if J = K then
                begin
                  if not IntBitTest(Pointer(StartAddr),J) then
                  begin
                    if VirtualAlloc(Pointer(StartAddr+LongWord(J) shl 16), $10000,
                      MEM_COMMIT, PAGE_READWRITE) = nil then
                    begin
                      Result := nil;
                      goto 99;
                    end;
                    IntBitSet(Pointer(StartAddr),J);
                  end;
                end else
                begin
                  J := IntFreeBitScanForward(Pointer(StartAddr),J,K);
                  if J >= 0 then
                  begin
                    K := IntFreeBitScanReverse(Pointer(StartAddr),J,K);
                    if VirtualAlloc(Pointer(StartAddr+LongWord(J) shl 16),
                      LongWord(K-J+1) shl 16, MEM_COMMIT, PAGE_READWRITE) = nil then
                    begin
                      Result := nil;
                      goto 99;
                    end;
                    IntSetBits(Pointer(StartAddr),J,K);
                  end;
                end;
              end;
              DelFromSizeTable(E);
              Inc(Space,PLongWord(P)^-LongWord(Size));
              PInteger(P)^ := Size;
              if Space <> 0 then
              begin
                Address := LongWord(P)+LongWord(Size);
                SpLeft := nil;
              end else
              begin
                EFreeArr^[EFreeCount] := E;
                Inc(EFreeCount);
                if AdrLeft <> nil then
                  AdrLeft^.AdrRight := AdrRight
                else
                  ListLeft := AdrRight;
                if AdrRight <> nil then
                  AdrRight^.AdrLeft := AdrLeft
                else
                  ListRight := AdrLeft;
              end;
              Result := Pointer(LongWord(P)+4);
            end else
            begin
              Result := ExtGetMem(Size-4);
              if Result <> nil then
              begin
                IntCopyMem(P,Result,PLongWord(P)^);
                Inc(LongWord(P),4);
                ExtFreeMem(P);
              end;
            end;
          end else
            Result := nil;
          goto 99;
        end;
    if Size > J then
    begin
      Result := ExtGetMem(Size-4);
      if Result <> nil then
      begin
        IntCopyMem(P,Result,J);
        Inc(LongWord(P),4);
        ExtFreeMem(P);
      end;
    end
    else if EFreeCount > 0 then
    begin
      Dec(EFreeCount);
      E1 := EFreeArr^[EFreeCount];
      with E1^ do
      begin
        Address := LongWord(P)+LongWord(Size);
        Space := PLongWord(P)^-LongWord(Size);
        AdrRight := E;
        if E <> nil then
        begin
          AdrLeft := E^.AdrLeft;
          E^.AdrLeft := E1;
        end else
        begin
          AdrLeft := ListRight;
          ListRight := E1;
        end;
        if AdrLeft <> nil then
          AdrLeft^.AdrRight := E1
        else
          ListLeft := E1;
        SpLeft := nil;
      end;
      PInteger(P)^ := Size;
      Result := Pointer(LongWord(P)+4);
    end else
      Result := nil;
  99:
  finally
    LeaveCriticalSection(lpCriticalSection);
  end;
end;

function IntSetBitScanForward(P: Pointer; FirstBit, LastBit: Integer): Integer;
asm
        PUSH    EBX
        PUSH    ESI
        PUSH    EDI
        LEA     ESI,[EDX+8]
        CMP     ECX,ESI
        JL      @@ut
        MOV     EBX,$FFFFFFFF
        MOV     ESI,ECX
        MOV     EDI,$0000001F
        AND     ECX,EDI
        AND     ESI,$FFFFFFE0
        SUB     EDI,ECX
        SHR     ESI,5
        MOV     ECX,EDI
        MOV     EDI,EBX
        SHR     EDI,CL
        MOV     ECX,EDX
        AND     EDX,$FFFFFFE0
        AND     ECX,$0000001F
        SHR     EDX,5
        SHL     EBX,CL
        AND     EBX,[EAX+EDX*4]
        SUB     ESI,EDX
        JE      @@nq
        TEST    EBX,EBX
        JNE     @@ne
        INC     EDX
        DEC     ESI
        JE      @@xx
@@lp:   OR      EBX,[EAX+EDX*4]
        JNE     @@ne
        INC     EDX
        DEC     ESI
        JNE     @@lp
@@xx:   MOV     EBX,[EAX+EDX*4]
@@nq:   AND     EBX,EDI
        JE      @@zq
@@ne:   BSF     ECX,EBX
@@qt:   SHL     EDX,5
        LEA     EAX,[ECX+EDX]
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@ut:   SUB     ECX,EDX
        JS      @@zq
@@uk:   BT      [EAX],EDX
        JC      @@iq
        INC     EDX
        DEC     ECX
        JNS     @@uk
@@zq:   MOV     EAX,$FFFFFFFF
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@iq:   MOV     EAX,EDX
        POP     EDI
        POP     ESI
        POP     EBX
end;

function IntSetBitScanReverse(P: Pointer; FirstBit, LastBit: Integer): Integer;
asm
        PUSH    EBX
        PUSH    ESI
        PUSH    EDI
        LEA     ESI,[EDX+8]
        CMP     ECX,ESI
        JL      @@ut
        MOV     EBX,$FFFFFFFF
        MOV     ESI,ECX
        MOV     EDI,$0000001F
        AND     ECX,EDI
        AND     ESI,$FFFFFFE0
        SUB     EDI,ECX
        SHR     ESI,5
        MOV     ECX,EDI
        MOV     EDI,EBX
        SHR     EDI,CL
        MOV     ECX,EDX
        AND     EDX,$FFFFFFE0
        AND     ECX,$0000001F
        SHR     EDX,5
        SHL     EBX,CL
        AND     EDI,[EAX+ESI*4]
        SUB     EDX,ESI
        JE      @@nq
        TEST    EDI,EDI
        JNE     @@ne
        NEG     EDX
        DEC     ESI
        DEC     EDX
        JE      @@xx
@@lp:   OR      EDI,[EAX+ESI*4]
        JNE     @@ne
        DEC     ESI
        DEC     EDX
        JNE     @@lp
@@xx:   MOV     EDI,[EAX+ESI*4]
@@nq:   AND     EDI,EBX
        JE      @@zq
@@ne:   BSR     ECX,EDI
@@qt:   SHL     ESI,5
        LEA     EAX,[ECX+ESI]
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@ut:   SUB     EDX,ECX
        JG      @@zq
@@uk:   BT      [EAX],ECX
        JC      @@iq
        DEC     ECX
        INC     EDX
        JNG     @@uk
@@zq:   MOV     EAX,$FFFFFFFF
        POP     EDI
        POP     ESI
        POP     EBX
        RET
@@iq:   MOV     EAX,ECX
        POP     EDI
        POP     ESI
        POP     EBX
end;

procedure IntResetBits(P: Pointer; FirstBit, LastBit: Integer);
asm
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        LEA     ESI,[EDX+8]
        CMP     ECX,ESI
        JL      @@ut
        MOV     EBX,$FFFFFFFF
        MOV     ESI,ECX
        MOV     EDI,$0000001F
        AND     ECX,EDI
        AND     ESI,$FFFFFFE0
        SUB     EDI,ECX
        SHR     ESI,5
        MOV     ECX,EDI
        MOV     EDI,EBX
        SHR     EDI,CL
        MOV     ECX,EDX
        AND     EDX,$FFFFFFE0
        AND     ECX,$0000001F
        SHR     EDX,5
        SHL     EBX,CL
        NOT     EDI
        NOT     EBX
        SUB     ESI,EDX
        JE      @@xx
        AND     [EAX+EDX*4],EBX
        INC     EDX
        DEC     ESI
        JE      @@ne
        XOR     EBX,EBX
@@lp:   MOV     [EAX+EDX*4],EBX
        INC     EDX
        DEC     ESI
        JNE     @@lp
@@xx:   OR      EDI,EBX
@@ne:   AND     [EAX+EDX*4],EDI
        POP     EBX
        POP     ESI
        POP     EDI
        RET
@@ut:   SUB     ECX,EDX
        JS      @@qt
@@uk:   BTR     [EAX],EDX
        INC     EDX
        DEC     ECX
        JNS     @@uk
@@qt:   POP     EBX
        POP     ESI
        POP     EDI
end;

function QMemDecommitOverstock: Integer;
label
  99;
var
  E: PEntryPoint;
  L,R: Integer;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      E := ListLeft;
      while E <> nil do
      begin
        if E^.Space shr 17 > 0 then
        begin
          L := (E^.Address+$FFFF-StartAddr) shr 16;
          R := (E^.Address+E^.Space-$10000-StartAddr) shr 16;
          L := IntSetBitScanForward(Pointer(StartAddr),L,R);
          if L >= 0 then
          begin
            R := IntSetBitScanReverse(Pointer(StartAddr),L,R);
            if not VirtualFree(Pointer(StartAddr+LongWord(L) shl 16),
              LongWord(R-L+1) shl 16, MEM_DECOMMIT) then
            begin
              Result := -1;
              goto 99;
            end;
            IntResetBits(Pointer(StartAddr),L,R);
          end;
        end;
        E := E^.AdrRight;
      end;
      Result := 0;
    99:
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemSize(P: Pointer): Integer;
begin
  Dec(LongWord(P),4);
  if (LongWord(P)>=SpaceBegin) and
      (PLongWord(P)^+LongWord(P)<=LongWord(EFreeArr)) then
    Result := PInteger(P)^-4
  else
    Result := -1;
end;

function QMemTotalAddrSpace: Integer;
begin
  if IntQMemIsInstalled then
    Result := LongWord(EFreeArr)-StartAddr
  else
    Result := -1;
end;

const
  BitTable: array[0..255] of Byte =
    (0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
     1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
     1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
     2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
     1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
     2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
     2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
     3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8);

function IntCountOfSetBits(P: Pointer; L: Cardinal): Cardinal;
asm
        PUSH    EBX
        PUSH    ESI
        MOV     EBX,EAX
        XOR     EAX,EAX
        SUB     EDX,2
        JS      @@nx
@@lp:   MOVZX   ECX,BYTE PTR [EBX+EDX]
        MOVZX   ESI,BYTE PTR [EBX+EDX+1]
        MOVZX   ECX,BYTE PTR [ECX+BitTable]
        ADD     EAX,ECX
        MOVZX   ESI,BYTE PTR [ESI+BitTable]
        ADD     EAX,ESI
        SUB     EDX,2
        JNS     @@lp
@@nx:   INC     EDX
        JZ      @@qt2
        POP     ESI
        POP     EBX
        RET
@@qt2:  MOVZX   ECX,BYTE PTR [EBX]
        MOVZX   ECX,BYTE PTR [ECX+BitTable]
        ADD     EAX,ECX
        POP     ESI
        POP     EBX
end;

function IntCountOfFreeBits(P: Pointer; L: Cardinal): Cardinal;
asm
        PUSH    EDX
        CALL    IntCountOfSetBits
        NEG     EAX
        POP     EDX
        LEA     EAX,[EAX+EDX*8]
end;

function QMemTotalCommitted: Integer;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      Result := IntCountOfSetBits(Pointer(StartAddr),
        (LongWord(EFreeArr)-StartAddr) shr 19) shl 16;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemTotalUncommitted: Integer;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      Result := IntCountOfFreeBits(Pointer(StartAddr),
        (LongWord(EFreeArr)-StartAddr) shr 19) shl 16;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemTotalAllocated: Integer;
var
  E: PEntryPoint;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      Result := LongWord(EFreeArr)-SpaceBegin;
      E := ListLeft;
      while E <> nil do
      begin
        Dec(Result,E^.Space);
        E := E^.AdrRight;
      end;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemTotalFree: Integer;
var
  E: PEntryPoint;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      Result := 0;
      E := ListLeft;
      while E <> nil do
      begin
        Inc(Result,E^.Space);
        E := E^.AdrRight;
      end;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemMaxFreeBlock: Integer;
var
  E: PEntryPoint;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      Result := 0;
      E := ListLeft;
      while E <> nil do
      begin
        if E^.Space > LongWord(Result) then
          Result := E^.Space;
        E := E^.AdrRight;
      end;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemCountOfFreeBlocks: Integer;
begin
  if IntQMemIsInstalled then
  begin
    try
      EnterCriticalSection(lpCriticalSection);
      Result := MaxECount-EFreeCount;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end;
  end else
    Result := -1;
end;

function QMemOverhead: Integer;
begin
  if IntQMemIsInstalled then
    Result := MaxECount*28
  else
    Result := -1;
end;

function QMemGetHeapStatus: TQMemHeapStatus;
var
  E: PEntryPoint;
  X1,X2: LongWord;
begin
  if IntQMemIsInstalled then
    try
      EnterCriticalSection(lpCriticalSection);
      with Result do
      begin
        TotalAddrSpace := LongWord(EFreeArr)-StartAddr;
        TotalCommitted := IntCountOfSetBits(Pointer(StartAddr),
          TotalAddrSpace shr 19) shl 16;
        TotalUncommitted := TotalAddrSpace - TotalCommitted;
        X1 := 0;
        X2 := 0;
        E := ListLeft;
        while E <> nil do
        begin
          Inc(X1,E^.Space);
          if E^.Space > X2 then
            X2 := E^.Space;
          E := E^.AdrRight;
        end;
        TotalFree := X1;
        TotalAllocated := LongWord(EFreeArr)-SpaceBegin-X1;
        MaxFreeBlock := X2;
        CountOfFreeBlocks := MaxECount-EFreeCount;
        Overhead := MaxECount*28;;
      end;
    finally
      LeaveCriticalSection(lpCriticalSection);
    end
  else
    with Result do
    begin
      TotalAddrSpace := 0;
      TotalCommitted := 0;
      TotalUncommitted := 0;
      TotalAllocated := 0;
      TotalFree := 0;
      MaxFreeBlock := 0;
      CountOfFreeBlocks := 0;
      Overhead := 0;
    end;
end;

function QMemIsInstalled: Boolean;
begin
  Result := IntQMemIsInstalled;
end;

exports
  ExtGetMem,
  ExtFreeMem,
  ExtReallocMem,
  QMemDecommitOverstock,
  QMemSize,
  QMemTotalAddrSpace,
  QMemTotalCommitted,
  QMemTotalUncommitted,
  QMemTotalAllocated,
  QMemTotalFree,
  QMemMaxFreeBlock,
  QMemCountOfFreeBlocks,
  QMemOverhead,
  QMemGetHeapStatus,
  QMemIsInstalled;

procedure IntFillLong(Value: LongWord; P: Pointer; Count: Cardinal);
asm
        XCHG    EDI,EDX
        REP     STOSD
        MOV     EDI,EDX
end;

procedure QMemInstall(InitialSize, MaximumSize: Integer);
var
  L: LongWord;
  E: PEntryPoint;
  P: PLongWord;
begin
  if (not IntQMemIsInstalled) and (MaximumSize>0) then
  begin
    Inc(MaximumSize,$7FFFF);
    MaximumSize := MaximumSize and $FFF80000;
    L := MaxECount*28;
    StartAddr := LongWord(VirtualAlloc(nil, L+LongWord(MaximumSize),
      MEM_RESERVE or MEM_TOP_DOWN, PAGE_READWRITE));
    if StartAddr = 0 then
      Exit;
    EFreeArr := Pointer(StartAddr+LongWord(MaximumSize));
    if VirtualAlloc(EFreeArr, L, MEM_COMMIT, PAGE_READWRITE) = nil then
    begin
      VirtualFree(Pointer(StartAddr),0,MEM_RELEASE);
      Exit;
    end;
    EFreeCount := MaxECount;
    E := Pointer(LongWord(EFreeArr)+LongWord(MaxECount) shl 2);
    P := @EFreeArr^[EFreeCount];
    for L := 1 to EFreeCount do
    begin
      P^ := LongWord(E);
      Inc(E);
      Dec(P);
    end;
    if InitialSize < $10000 then
      InitialSize := $10000
    else if InitialSize > MaximumSize then
      InitialSize := MaximumSize
    else
    begin
      Inc(InitialSize,$FFFF);
      InitialSize := InitialSize and $FFFF0000;
    end;
    if VirtualAlloc(Pointer(StartAddr), InitialSize, MEM_COMMIT,
      PAGE_READWRITE) = nil then
    begin
      VirtualFree(Pointer(StartAddr),0,MEM_RELEASE);
      Exit;
    end;
    L := LongWord(MaximumSize) shr 19;
    IntFillLong(0,Pointer(StartAddr),(L+3) shr 2);
    IntSetBits(Pointer(StartAddr),0,InitialSize shr 16 - 1);
    SpaceBegin := (L+35) and $FFFFFFE0 - 4;
    Inc(SpaceBegin,StartAddr);
    Dec(EFreeCount);
    E := EFreeArr^[EFreeCount];
    ListLeft := E;
    ListRight := E;
    with E^ do
    begin
      Address := SpaceBegin;
      Space := LongWord(EFreeArr)-SpaceBegin;
      AdrLeft := nil;
      AdrRight := nil;
      SpLeft := nil;
      SpRight := nil;
    end;
    InitializeCriticalSection(lpCriticalSection);
    IntFillLong(0,@SizeTable,31);
    IntQMemIsInstalled := True;
  end;
end;

procedure DLLMain(dwReason: LongWord);
begin
  if (dwReason=DLL_PROCESS_DETACH) and IntQMemIsInstalled then
  begin
    IntQMemIsInstalled := False;
    DeleteCriticalSection(lpCriticalSection);
    VirtualFree(Pointer(StartAddr), 0, MEM_RELEASE);
  end;
end;

begin
  IntQMemIsInstalled := False;
  QMemInstall(65536,268435456);
  DLLProc := @DLLMain;
end.

