unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileSplitter, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    btnSplit: TButton;
    FileSplitter: TFileSplitter;
    btnUnSplit: TButton;
    edtSize: TEdit;
    Bevel1: TBevel;
    Label1: TLabel;
    edtFileName: TEdit;
    Label2: TLabel;
    OpenDialog: TOpenDialog;
    btnSelectFile: TButton;
    Label3: TLabel;
    procedure btnSplitClick(Sender: TObject);
    procedure btnUnSplitClick(Sender: TObject);
    procedure btnSelectFileClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnSplitClick(Sender: TObject);
begin
  if FileExists(edtFileName.Text) then
  begin
    FileSplitter.FileName := edtFileName.Text;
    try
      FileSplitter.Size := StrToInt(edtSize.Text);
    except
      on EConvertError do
      begin
        ShowMessage('''' + edtSize.Text + ''' is not valid integer number. Default value is being used.');
        FileSplitter.Size := 1457664;
      end;
    end;
    FileSplitter.Split;
    ShowMessage('Done splitting!');
  end
  else
  begin
    ShowMessage('File doesn''t exist!');
    edtFileName.SetFocus;
  end;
end;

procedure TForm1.btnUnSplitClick(Sender: TObject);
begin
  FileSplitter.UnSplit;
  ShowMessage('Done unsplitting!');
end;

procedure TForm1.btnSelectFileClick(Sender: TObject);
var
  lOK: Boolean;

begin
  lOK := OpenDialog.Execute;
  if lOK then
    edtFileName.Text := OpenDialog.FileName;
end;

end.
