unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, Restructure, TypInfo, StdCtrls, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Restructure1: TRestructure;
    Label1: TLabel;
    edtMin: TEdit;
    edtMax: TEdit;
    Label2: TLabel;
    edtDef: TEdit;
    Label3: TLabel;
    cbReq: TCheckBox;
    edtPic: TEdit;
    Label4: TLabel;
    edtLkup: TEdit;
    Label5: TLabel;
    rgLookType: TRadioGroup;
    rgLookAccess: TRadioGroup;
    btnClose: TButton;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    btnCancel: TButton;
    btnApply: TButton;
    ComboBox1: TComboBox;
    OpenDialog1: TOpenDialog;
    btnOpen: TButton;
    procedure FormActivate(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure StringGrid1RowMoved(Sender: TObject; FromIndex,
      ToIndex: Integer);
    procedure btnCancelClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure ComboBox1Exit(Sender: TObject);
    procedure ComboBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnOpenClick(Sender: TObject);
  private
    procedure ShowTableStructure;
    procedure ShowValChecks;
    procedure DisplayStructure;
    procedure DisplayStatus(Row: Integer);
    function SetProperties: Boolean;
    function OpenTable: Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  BDE;

const
  NewFields: Integer = 1;

{$R *.DFM}

procedure TForm1.ShowTableStructure;
var
  i: Integer;

begin
  with StringGrid1, Restructure1 do
  begin
    RowCount := FieldCount + 1;
    for i := 1 to FieldCount do
    begin
      GetFieldDesc(i);
      Cells[0, i] := IntToStr(i);
      Cells[1, i] := Field.Name;
      Cells[2, i] := GetEnumName(TypeInfo(TdBasePxFieldType), Ord(Field.FieldType));
      Cells[3, i] := IntToStr(Field.Length);
      Cells[4, i] := IntToStr(Field.Precision);
    end;
  end;
end;

procedure TForm1.DisplayStructure;
begin
  ShowTableStructure;
  Restructure1.GetFieldDesc(StringGrid1.Row);
  ShowValChecks;
end;

procedure TForm1.DisplayStatus(Row: Integer);
begin
  StatusBar1.Panels[0].Text := IntToStr(Row) + '/' + IntToStr(Restructure1.FieldCount);
  StatusBar1.Panels[1].Text := Restructure1.TableName;
  StatusBar1.Panels[2].Text := Restructure1.TableType + ' ' + IntToStr(Restructure1.TableLevel);
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  if OpenTable then
  begin
    DisplayStructure;
    DisplayStatus(1);
  end
  else
    Close;
end;

procedure TForm1.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ShowValChecks;
begin
  with Restructure1 do
  begin
    cbReq.Checked := ValCheck.Required;
    edtMin.Text := ValCheck.MinimumValue;
    edtMax.Text := ValCheck.MaximumValue;
    edtDef.Text := ValCheck.DefaultValue;
    edtPic.Text := ValCheck.Picture;
    edtLkup.Text := ValCheck.LookupDatabaseName + ValCheck.LookupTableName;
    if ValCheck.LookupType = ltCurrentField then
      rgLookType.ItemIndex := 0
    else
      rgLookType.ItemIndex := 1;
    if ValCheck.LookupAccess = laFillNoHelp then
      rgLookAccess.ItemIndex := 0
    else
      rgLookAccess.ItemIndex := 1;
  end;
end;

function TForm1.SetProperties: Boolean;
begin
  Result := True;
  try
    with Restructure1 do
    begin
      Field.Name := StringGrid1.Cells[1, StringGrid1.Row];
      Field.FieldType := TdBasePxFieldType(GetEnumValue(TypeInfo(TdBasePxFieldType), StringGrid1.Cells[2, StringGrid1.Row]));
      try
        Field.Length := StrToInt(StringGrid1.Cells[3, StringGrid1.Row]);
      except
        Field.Length := 0;
      end;
      try
        Field.Precision := StrToInt(StringGrid1.Cells[4, StringGrid1.Row]);
      except
        Field.Precision := 0;
      end;
      ValCheck.Required := cbReq.Checked;
      ValCheck.MinimumValue := edtMin.Text;
      ValCheck.MaximumValue := edtMax.Text;
      ValCheck.DefaultValue := edtDef.Text;
      ValCheck.Picture := edtPic.Text;
      ValCheck.LookupDatabaseName := ExtractFilePath(edtLkup.Text);
      ValCheck.LookupTableName := ExtractFileName(edtLkup.Text);
      if rgLookType.ItemIndex = 0 then
        ValCheck.LookupType := ltCurrentField
      else
        ValCheck.LookupType := ltAllCorresponding;
      if rgLookAccess.ItemIndex = 0 then
        ValCheck.LookupAccess := laFillNoHelp
      else
        ValCheck.LookupAccess := laHelpAndFill;
    end;
  except
    Result := False;
  end;
end;

procedure TForm1.StringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
  var CanSelect: Boolean);
var
  R: TRect;
  i: Integer;

begin
  if ((Col = 2) and (Row <> 0)) then
  begin
    R := StringGrid1.CellRect(Col, Row);
    R.Left := R.Left + StringGrid1.Left;
    R.Right := R.Right + StringGrid1.Left;
    R.Top := R.Top + StringGrid1.Top;
    R.Bottom := R.Bottom + StringGrid1.Top;
    ComboBox1.Left := R.Left + 1;
    ComboBox1.Top := R.Top + 1;
    ComboBox1.Width := (R.Right + 1) - R.Left;
    ComboBox1.Height := (R.Bottom + 1) - R.Top;
    for i := 0 to ComboBox1.Items.Count - 1 do
      if ComboBox1.Items[i] = StringGrid1.Cells[Col, Row] then
      begin
        ComboBox1.ItemIndex := i;
        Break;
      end;
    ComboBox1.Visible := True;
    ComboBox1.SetFocus;
  end;
  CanSelect := True;
  if SetProperties then ;
    if StringGrid1.Row <= Restructure1.FieldCount then
      Restructure1.ChangeField(StringGrid1.Row, True);
  Restructure1.GetFieldDesc(Row);
  ShowValChecks;
  DisplayStatus(Row);
end;

procedure TForm1.StringGrid1RowMoved(Sender: TObject; FromIndex,
  ToIndex: Integer);
begin
  Restructure1.MoveField(FromIndex, ToIndex);
  Restructure1.GetFieldDesc(StringGrid1.Row);
  ShowValChecks;
  DisplayStatus(StringGrid1.Row);
end;

procedure TForm1.btnCancelClick(Sender: TObject);
begin
  Restructure1.Cancel;
  if StringGrid1.Row > Restructure1.FieldCount then
    StringGrid1.Row := Restructure1.FieldCount;
  DisplayStructure;
  StringGrid1.SetFocus;
end;

procedure TForm1.btnApplyClick(Sender: TObject);
begin
  if SetProperties then
    Restructure1.ChangeField(StringGrid1.Row, True);
  Restructure1.Apply;
  DisplayStructure;
  StringGrid1.SetFocus;
end;

procedure TForm1.ComboBox1Exit(Sender: TObject);
begin
  StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row] := ComboBox1.Items[ComboBox1.ItemIndex];
  ComboBox1.Visible := False;
  StringGrid1.SetFocus;
end;

procedure TForm1.ComboBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_LEFT) or (Key = VK_RIGHT) then
    StringGrid1.SetFocus;
end;

procedure TForm1.StringGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  i, j: Integer;
  
begin
  case Key of
    VK_DOWN:   if StringGrid1.Row = Restructure1.FieldCount then
                 with StringGrid1 do
                 begin
                   RowCount := Restructure1.FieldCount + 2;
                   Row := Row + 1;
                   Cells[0, Row] := IntToStr(Row);
                   Cells[1, Row] := 'NEWFIELD' + IntToStr(NewFields);
                   Inc(NewFields);
                   if Restructure1.TableType = szPARADOX then
                     Cells[2, Row] := 'pxAlpha'
                   else if Restructure1.TableType = szDBASE then
                     Cells[2, Row] := 'dbCharacter';
                   Cells[3, Row] := '10';
                   Cells[4, Row] := '0';
                   Repaint;
                   SetProperties;
                   Restructure1.AddField(True);
                 end;
    VK_DELETE: if ssCtrl in Shift then
               begin
                 Restructure1.DropField(StringGrid1.Row);
                 if StringGrid1.Row = StringGrid1.RowCount + 1 then
                 begin
                   StringGrid1.Row := StringGrid1.Row - 1;
                   StringGrid1.RowCount := StringGrid1.RowCount - 1;
                 end
                 else
                 begin
                   for i := StringGrid1.Row to StringGrid1.RowCount do
                     for j := 0 to 4 do
                       StringGrid1.Cells[j, i] := StringGrid1.Cells[j, i + 1];
                   StringGrid1.RowCount := StringGrid1.RowCount - 1;
                 end;
                 Restructure1.GetFieldDesc(StringGrid1.Row);
                 ShowValChecks;
                 DisplayStatus(StringGrid1.Row);
               end;
  end;
end;

function TForm1.OpenTable: Boolean;
begin
  if OpenDialog1.Execute then
  begin
    Restructure1.DatabaseName := ExtractFilePath(OpenDialog1.FileName);
    Restructure1.TableName := ExtractFileName(OpenDialog1.FileName);
    if UpperCase(ExtractFileExt(OpenDialog1.FileName)) = '.DBF' then
    begin
      cbReq.Enabled := False;
      edtMin.Enabled := False;
      edtMax.Enabled := False;
      edtDef.Enabled := False;
      edtPic.Enabled := False;
      edtLkup.Enabled := False;
      edtMin.Color := clBtnFace;
      edtMax.Color := clBtnFace;
      edtDef.Color := clBtnFace;
      edtPic.Color := clBtnFace;
      edtLkup.Color := clBtnFace;
      rgLookType.Enabled := False;
      rgLookAccess.Enabled := False;
      Label1.Enabled := False;
      Label2.Enabled := False;
      Label3.Enabled := False;
      Label4.Enabled := False;
      Label5.Enabled := False;
    end
    else
    begin
      cbReq.Enabled := True;
      edtMin.Enabled := True;
      edtMax.Enabled := True;
      edtDef.Enabled := True;
      edtPic.Enabled := True;
      edtLkup.Enabled := True;
      edtMin.Color := clWindow;
      edtMax.Color := clWindow;
      edtDef.Color := clWindow;
      edtPic.Color := clWindow;
      edtLkup.Color := clWindow;
      rgLookType.Enabled := True;
      rgLookAccess.Enabled := True;
      Label1.Enabled := True;
      Label2.Enabled := True;
      Label3.Enabled := True;
      Label4.Enabled := True;
      Label5.Enabled := True;
    end;
    with StringGrid1 do
    begin
      DefaultRowHeight := ComboBox1.Height;
      ColCount := 5;
      RowCount := Restructure1.FieldCount + 1;
      ColWidths[0] := 30;
      ColWidths[1] := 130;
      ColWidths[2] := 117;
      ColWidths[3] := 40;
      ColWidths[4] := 50;
      Cells[0, 0] := 'Fld.#';
      Cells[1, 0] := 'Name';
      Cells[2, 0] := 'Type';
      Cells[3, 0] := 'Length';
      Cells[4, 0] := 'Precision';
    end;
    Result := True;
  end
  else
    Result := False;
end;

procedure TForm1.btnOpenClick(Sender: TObject);
begin
  if OpenTable then
  begin
    DisplayStructure;
    DisplayStatus(1);
  end;
end;

end.
