unit Main;

interface

uses
  Confirm,
  Invisibles.ExceptionHandler,
  Options,
  System.Collections,
  System.Collections.T,
  System.ComponentModel,
  System.ComponentModel.T,
  System.Drawing,
  System.Drawing.T,
  System.IO,
  System.IO.T,
  System.Resources,
  System.Resources.T,
  System.T,
  System.Windows.Forms,
  System.Windows.Forms.T,
  TD.SandBar,
  Visibles.BorderExtender;

type
  TFormMain = class(System.Windows.Forms.Form)
  private
    {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ListFile: System.Windows.Forms.ListView;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    DialogOpenFile: System.Windows.Forms.OpenFileDialog;
    ExceptionHandler: Invisibles.ExceptionHandler.TExceptionHandler;
    Panel: System.Windows.Forms.Panel;
    TextFilters: System.Windows.Forms.TextBox;
    SandBarManager: TD.SandBar.SandBarManager;
    leftSandBarDock: TD.SandBar.ToolBarContainer;
    rightSandBarDock: TD.SandBar.ToolBarContainer;
    bottomSandBarDock: TD.SandBar.ToolBarContainer;
    topSandBarDock: TD.SandBar.ToolBarContainer;
    MenuBar: TD.SandBar.MenuBar;
    ItemFile: TD.SandBar.MenuBarItem;
    ItemMore: TD.SandBar.MenuBarItem;
    ItemOpenProject: TD.SandBar.MenuButtonItem;
    ItemOpenDirectory: TD.SandBar.MenuButtonItem;
    ItemReset: TD.SandBar.MenuButtonItem;
    ItemClear: TD.SandBar.MenuButtonItem;
    ItemExit: TD.SandBar.MenuButtonItem;
    StatusBar: System.Windows.Forms.StatusBar;
    ItemLoadOptions: TD.SandBar.MenuButtonItem;
    ItemAbout: TD.SandBar.MenuButtonItem;
    StatusBarPanelAppData: System.Windows.Forms.StatusBarPanel;
    StatusBarPanelFilters: System.Windows.Forms.StatusBarPanel;
    CheckAppDataClear: System.Windows.Forms.CheckBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ItemOpenProject_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemOpenDirectory_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemExit_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemClear_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemFile_BeforePopup(sender: System.Object; e: TD.SandBar.MenuPopupEventArgs);
    procedure ItemReset_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemAbout_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemLoadOptions_Activate(sender: System.Object; e: System.EventArgs);
    procedure CheckAppDataClear_Click(sender: System.Object; e: System.EventArgs);
    procedure ListFile_DragDrop(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
    procedure ListFile_DragEnter(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  strict private
    DialogFolder: TFolderBrowserDialog;
    FormConfirm: TFormConfirm;
    Options: TOptions;
    ApplicationSts: TApplicationSts;
    PathTable: THashTable;
    procedure IdleHandler(Sender: TObject; e: TEventArgs);
    procedure TryOpen(Path: string; AutoClean: Boolean = false);
    procedure OpenProject(ProjectPath: string);
    procedure OpenDirectory(Path: string);
    procedure DoClear;
    procedure GetProjectFiles(ProjectPath: string; out ProjectFiles: array of string);
    procedure GetProjectAppDataPaths(ProjectPath: string; out DataPaths: array of string);
    procedure AddDirectoriesToListFrom(Path: string; IsChecked: Boolean);
    procedure AddFilesToList(Path: string; IsChecked: Boolean);
    procedure AddFileToList(Path: string; IsChecked,IsMarked: Boolean);
    procedure AddDirectoryToList(Path: string; IsChecked,IsMarked: Boolean);
    procedure AddDirectoriesToList(Paths: array of string; IsChecked,IsMarked: Boolean);
    procedure AddKnownDirectoriesToList(Path: string; IsChecked: Boolean);
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFormMain))]

implementation

uses
  About,
  BorlandProjectSettings;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormMain.InitializeComponent;
type
  TArrayOfTD_SandBar_ToolbarItemBase = array of TD.SandBar.ToolbarItemBase;
  TArrayOfTD_SandBar_MenuButtonItem = array of TD.SandBar.MenuButtonItem;
  TArrayOfSystem_Windows_Forms_StatusBarPanel = array of System.Windows.Forms.StatusBarPanel;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TFormMain));
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.Panel := System.Windows.Forms.Panel.Create;
  Self.ListFile := System.Windows.Forms.ListView.Create;
  Self.TextFilters := System.Windows.Forms.TextBox.Create;
  Self.leftSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.SandBarManager := TD.SandBar.SandBarManager.Create;
  Self.bottomSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.rightSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.topSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.MenuBar := TD.SandBar.MenuBar.Create;
  Self.ItemFile := TD.SandBar.MenuBarItem.Create;
  Self.ItemOpenProject := TD.SandBar.MenuButtonItem.Create;
  Self.ItemOpenDirectory := TD.SandBar.MenuButtonItem.Create;
  Self.ItemReset := TD.SandBar.MenuButtonItem.Create;
  Self.ItemClear := TD.SandBar.MenuButtonItem.Create;
  Self.ItemExit := TD.SandBar.MenuButtonItem.Create;
  Self.ItemMore := TD.SandBar.MenuBarItem.Create;
  Self.ItemLoadOptions := TD.SandBar.MenuButtonItem.Create;
  Self.ItemAbout := TD.SandBar.MenuButtonItem.Create;
  Self.StatusBar := System.Windows.Forms.StatusBar.Create;
  Self.StatusBarPanelAppData := System.Windows.Forms.StatusBarPanel.Create;
  Self.StatusBarPanelFilters := System.Windows.Forms.StatusBarPanel.Create;
  Self.CheckAppDataClear := System.Windows.Forms.CheckBox.Create;
  Self.DialogOpenFile := System.Windows.Forms.OpenFileDialog.Create;
  Self.ExceptionHandler := Invisibles.ExceptionHandler.TExceptionHandler.Create;
  Self.Panel.SuspendLayout;
  Self.topSandBarDock.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarPanelAppData)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarPanelFilters)).BeginInit;
  Self.SuspendLayout;
  // 
  // Panel
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Panel, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.Panel.Controls.Add(Self.ListFile);
  Self.Panel.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel.Location := System.Drawing.Point.Create(0, 24);
  Self.Panel.Name := 'Panel';
  Self.Panel.Size := System.Drawing.Size.Create(488, 287);
  Self.Panel.TabIndex := 6;
  // 
  // ListFile
  // 
  Self.ListFile.AllowDrop := True;
  Self.ListFile.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListFile, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListFile.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListFile.CheckBoxes := True;
  Self.ListFile.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListFile.Location := System.Drawing.Point.Create(0, 0);
  Self.ListFile.Name := 'ListFile';
  Self.ListFile.Size := System.Drawing.Size.Create(488, 287);
  Self.ListFile.TabIndex := 0;
  Self.ListFile.View := System.Windows.Forms.View.List;
  Include(Self.ListFile.DragDrop, Self.ListFile_DragDrop);
  Include(Self.ListFile.DragEnter, Self.ListFile_DragEnter);
  // 
  // TextFilters
  // 
  Self.TextFilters.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextFilters.AutoSize := False;
  Self.BorderExtender.SetBorder3DStyle(Self.TextFilters, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextFilters.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextFilters.Location := System.Drawing.Point.Create(136, 314);
  Self.TextFilters.Name := 'TextFilters';
  Self.TextFilters.Size := System.Drawing.Size.Create(332, 18);
  Self.TextFilters.TabIndex := 12;
  Self.TextFilters.Text := '';
  // 
  // leftSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.leftSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.leftSandBarDock.Dock := System.Windows.Forms.DockStyle.Left;
  Self.leftSandBarDock.Location := System.Drawing.Point.Create(0, 24);
  Self.leftSandBarDock.Manager := Self.SandBarManager;
  Self.leftSandBarDock.Name := 'leftSandBarDock';
  Self.leftSandBarDock.Size := System.Drawing.Size.Create(0, 287);
  Self.leftSandBarDock.TabIndex := 13;
  // 
  // SandBarManager
  // 
  Self.SandBarManager.BottomContainer := Self.bottomSandBarDock;
  Self.SandBarManager.LeftContainer := Self.leftSandBarDock;
  Self.SandBarManager.OwnerForm := Self;
  Self.SandBarManager.Renderer := TD.SandBar.Office2002Renderer.Create;
  Self.SandBarManager.RightContainer := Self.rightSandBarDock;
  Self.SandBarManager.TopContainer := Self.topSandBarDock;
  // 
  // bottomSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.bottomSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.bottomSandBarDock.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.bottomSandBarDock.Location := System.Drawing.Point.Create(0, 311);
  Self.bottomSandBarDock.Manager := Self.SandBarManager;
  Self.bottomSandBarDock.Name := 'bottomSandBarDock';
  Self.bottomSandBarDock.Size := System.Drawing.Size.Create(488, 0);
  Self.bottomSandBarDock.TabIndex := 15;
  // 
  // rightSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.rightSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.rightSandBarDock.Dock := System.Windows.Forms.DockStyle.Right;
  Self.rightSandBarDock.Location := System.Drawing.Point.Create(488, 24);
  Self.rightSandBarDock.Manager := Self.SandBarManager;
  Self.rightSandBarDock.Name := 'rightSandBarDock';
  Self.rightSandBarDock.Size := System.Drawing.Size.Create(0, 287);
  Self.rightSandBarDock.TabIndex := 14;
  // 
  // topSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.topSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.topSandBarDock.Controls.Add(Self.MenuBar);
  Self.topSandBarDock.Dock := System.Windows.Forms.DockStyle.Top;
  Self.topSandBarDock.Location := System.Drawing.Point.Create(0, 0);
  Self.topSandBarDock.Manager := Self.SandBarManager;
  Self.topSandBarDock.Name := 'topSandBarDock';
  Self.topSandBarDock.Size := System.Drawing.Size.Create(488, 24);
  Self.topSandBarDock.TabIndex := 16;
  // 
  // MenuBar
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.MenuBar, System.Windows.Forms.Border3DStyle.Adjust);
  Self.MenuBar.Buttons.AddRange(TArrayOfTD_SandBar_ToolbarItemBase.Create(Self.ItemFile, 
          Self.ItemMore));
  Self.MenuBar.Guid := System.Guid.Create('af8dd691-d17b-4f58-9715-c0edd8143' +
    'ba0');
  Self.MenuBar.Location := System.Drawing.Point.Create(2, 0);
  Self.MenuBar.Movable := False;
  Self.MenuBar.Name := 'MenuBar';
  Self.MenuBar.Size := System.Drawing.Size.Create(486, 24);
  Self.MenuBar.TabIndex := 0;
  // 
  // ItemFile
  // 
  Self.ItemFile.MenuItems.AddRange(TArrayOfTD_SandBar_MenuButtonItem.Create(Self.ItemOpenProject, 
          Self.ItemOpenDirectory, Self.ItemReset, Self.ItemClear, Self.ItemExit));
  Self.ItemFile.Text := '&File';
  Include(Self.ItemFile.BeforePopup, Self.ItemFile_BeforePopup);
  // 
  // ItemOpenProject
  // 
  Self.ItemOpenProject.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temOpenProject.Image')));
  Self.ItemOpenProject.Text := '&Open BDS Project...';
  Include(Self.ItemOpenProject.Activate, Self.ItemOpenProject_Activate);
  // 
  // ItemOpenDirectory
  // 
  Self.ItemOpenDirectory.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temOpenDirectory.Image')));
  Self.ItemOpenDirectory.Text := 'Open &Directory...';
  Include(Self.ItemOpenDirectory.Activate, Self.ItemOpenDirectory_Activate);
  // 
  // ItemReset
  // 
  Self.ItemReset.Image := (System.Drawing.Image(resources.GetObject('ItemRes' +
    'et.Image')));
  Self.ItemReset.Text := '&Reset List';
  Include(Self.ItemReset.Activate, Self.ItemReset_Activate);
  // 
  // ItemClear
  // 
  Self.ItemClear.BeginGroup := True;
  Self.ItemClear.Image := (System.Drawing.Image(resources.GetObject('ItemCle' +
    'ar.Image')));
  Self.ItemClear.Text := '&Clear...';
  Include(Self.ItemClear.Activate, Self.ItemClear_Activate);
  // 
  // ItemExit
  // 
  Self.ItemExit.BeginGroup := True;
  Self.ItemExit.Image := (System.Drawing.Image(resources.GetObject('ItemExit' +
    '.Image')));
  Self.ItemExit.Text := '&Exit';
  Include(Self.ItemExit.Activate, Self.ItemExit_Activate);
  // 
  // ItemMore
  // 
  Self.ItemMore.MenuItems.AddRange(TArrayOfTD_SandBar_MenuButtonItem.Create(Self.ItemLoadOptions, 
          Self.ItemAbout));
  Self.ItemMore.Text := '&More';
  // 
  // ItemLoadOptions
  // 
  Self.ItemLoadOptions.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temLoadOptions.Image')));
  Self.ItemLoadOptions.Text := '&Reload Options';
  Include(Self.ItemLoadOptions.Activate, Self.ItemLoadOptions_Activate);
  // 
  // ItemAbout
  // 
  Self.ItemAbout.BeginGroup := True;
  Self.ItemAbout.Image := (System.Drawing.Image(resources.GetObject('ItemAbo' +
    'ut.Image')));
  Self.ItemAbout.Text := '&About...';
  Include(Self.ItemAbout.Activate, Self.ItemAbout_Activate);
  // 
  // StatusBar
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.StatusBar, System.Windows.Forms.Border3DStyle.Adjust);
  Self.StatusBar.Location := System.Drawing.Point.Create(0, 311);
  Self.StatusBar.Name := 'StatusBar';
  Self.StatusBar.Panels.AddRange(TArrayOfSystem_Windows_Forms_StatusBarPanel.Create(Self.StatusBarPanelAppData, 
          Self.StatusBarPanelFilters));
  Self.StatusBar.ShowPanels := True;
  Self.StatusBar.Size := System.Drawing.Size.Create(488, 22);
  Self.StatusBar.TabIndex := 17;
  Self.StatusBar.Text := 'Filters';
  // 
  // StatusBarPanelAppData
  // 
  Self.StatusBarPanelAppData.BorderStyle := System.Windows.Forms.StatusBarPanelBorderStyle.None;
  Self.StatusBarPanelAppData.Text := 'AppData Clear';
  // 
  // StatusBarPanelFilters
  // 
  Self.StatusBarPanelFilters.BorderStyle := System.Windows.Forms.StatusBarPanelBorderStyle.None;
  Self.StatusBarPanelFilters.Text := 'Filters';
  // 
  // CheckAppDataClear
  // 
  Self.CheckAppDataClear.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckAppDataClear, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckAppDataClear.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckAppDataClear.Location := System.Drawing.Point.Create(76, 318);
  Self.CheckAppDataClear.Name := 'CheckAppDataClear';
  Self.CheckAppDataClear.Size := System.Drawing.Size.Create(12, 12);
  Self.CheckAppDataClear.TabIndex := 18;
  Include(Self.CheckAppDataClear.Click, Self.CheckAppDataClear_Click);
  // 
  // DialogOpenFile
  // 
  Self.DialogOpenFile.AddExtension := False;
  // 
  // ExceptionHandler
  // 
  Self.ExceptionHandler.ExitOnError := False;
  Self.ExceptionHandler.SimpleMessageBox := False;
  // 
  // TFormMain
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(488, 333);
  Self.Controls.Add(Self.CheckAppDataClear);
  Self.Controls.Add(Self.TextFilters);
  Self.Controls.Add(Self.Panel);
  Self.Controls.Add(Self.leftSandBarDock);
  Self.Controls.Add(Self.rightSandBarDock);
  Self.Controls.Add(Self.bottomSandBarDock);
  Self.Controls.Add(Self.topSandBarDock);
  Self.Controls.Add(Self.StatusBar);
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.Name := 'TFormMain';
  Self.Panel.ResumeLayout(False);
  Self.topSandBarDock.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.StatusBarPanelAppData)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarPanelFilters)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormMain.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    Options.Filters := TextFilters.Text;
    Options.Store;
    ApplicationSts.MainFormSize := Size;
    ApplicationSts.Store;
    FormConfirm.Free;
    DialogFolder.Free;
    if Components <> nil then
      Components.Dispose;
  end;
  inherited Dispose(Disposing);
end;

constructor TFormMain.Create;
var
  Args: array of string;
begin
  inherited Create;
  InitializeComponent;
  Text := TApplication.ProductName;
  DockPadding.All := 0;
  TextFilters.BackColor := BorderExtender.TweakColor(TextFilters.BackColor,-20);
  ListFile.BackColor := BorderExtender.TweakColor(ListFile.BackColor,10);
  DialogFolder := TFolderBrowserDialog.Create;
  DialogFolder.SelectedPath := Environment.CurrentDirectory;
  DialogOpenFile.InitialDirectory := Environment.CurrentDirectory;
  FormConfirm := TFormConfirm.Create;
  PathTable := THashTable.Create;
  ApplicationSts := TApplicationSts.Load;
  Size := ApplicationSts.MainFormSize;
  Options := TOptions.Load;
  CheckAppDataClear.Enabled := Options.AppDataClear;
  TextFilters.Text := Options.Filters;
  Args := TEnvironment.GetCommandLineArgs;
  if (Length(Args) > 2) and (Args[2].CompareTo('/a') = 0) then begin
    TryOpen(Args[1],true);
    Include(TApplication.Idle,IdleHandler);
  end
  else if Length(Args) > 1 then
    TryOpen(Args[1]);
end;

procedure TFormMain.ListFile_DragEnter(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
begin
  e.Effect := TDragDropEffects.Copy;
end;

procedure TFormMain.ListFile_DragDrop(sender: System.Object; e: System.Windows.Forms.DragEventArgs);
var
  Drops: TStringArray;
begin
  try
    Drops := e.Data.GetData(TDataFormats.FileDrop) as TStringArray;
    if Length(Drops) > 0 then
      TryOpen(Drops[0]);
  except
    ;
  end;
end;

procedure TFormMain.ItemFile_BeforePopup(sender: System.Object; e: TD.SandBar.MenuPopupEventArgs);
begin
  ItemReset.Enabled := (ListFile.Items.Count > 0);
  ItemClear.Enabled := ItemReset.Enabled;
end;

procedure TFormMain.ItemOpenProject_Activate(sender: System.Object; e: System.EventArgs);
begin
  DialogOpenFile.Title := 'Open Project';
  DialogOpenFile.Filter := 'BDS Project File (*.bdsproj)|*.bdsproj|Any File (*.*)|*.*';
  if DialogOpenFile.ShowDialog = TDialogResult.OK then
    OpenProject(DialogOpenFile.FileName);
end;

procedure TFormMain.ItemOpenDirectory_Activate(sender: System.Object; e: System.EventArgs);
begin
  if DialogFolder.ShowDialog = TDialogResult.OK then
    OpenDirectory(DialogFolder.SelectedPath);
end;

procedure TFormMain.ItemReset_Activate(sender: System.Object; e: System.EventArgs);
begin
  ListFile.Items.Clear;
  PathTable.Clear;
end;

procedure TFormMain.ItemClear_Activate(sender: System.Object; e: System.EventArgs);
begin
  if FormConfirm.ShowDialog = TDialogResult.OK then
    DoClear;
end;

procedure TFormMain.ItemExit_Activate(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure TFormMain.ItemLoadOptions_Activate(sender: System.Object; e: System.EventArgs);
begin
  Options := TOptions.Load;
  CheckAppDataClear.Enabled := Options.AppDataClear;
  TextFilters.Text := Options.Filters;
end;

procedure TFormMain.ItemAbout_Activate(sender: System.Object; e: System.EventArgs);
begin
  with TFormAbout.Create do begin
    ShowDialog;
    Free;
  end;
end;

procedure TFormMain.CheckAppDataClear_Click(sender: System.Object; e: System.EventArgs);
var
  Item: TListViewItem;
begin
  for Item in ListFile.Items do
    if Assigned(Item.Tag) then
      Item.Checked := CheckAppDataClear.Checked;
end;

procedure TFormMain.IdleHandler(Sender: TObject; e: TEventArgs);
begin
  Close;
end;

procedure TFormMain.TryOpen(Path: string; AutoClean: Boolean = false);
begin
  if TFile.Exists(Path) and (TPath.GetExtension(Path).ToLower = '.bdsproj') then
    OpenProject(Path)
  else if TDirectory.Exists(Path) then
    OpenDirectory(Path)
  else if TDirectory.Exists(TPath.GetDirectoryName(Path)) then
    OpenDirectory(TPath.GetDirectoryName(Path));
  if AutoClean then
    DoClear;
end;

procedure TFormMain.OpenProject(ProjectPath: string);
var
  ProjectFiles: array of string;
  &File: string;
begin
  TCursor.Current := TCursors.WaitCursor;
  ListFile.BeginUpdate;
  try
    Options.Filters := TextFilters.Text;
    CheckAppDataClear.Checked := false;
    CheckAppDataClear_Click(nil,nil);
    AddFilesToList(TPath.GetDirectoryName(ProjectPath),true);
    AddDirectoriesToListFrom(TPath.GetDirectoryName(ProjectPath),true);
    AddKnownDirectoriesToList(TPath.GetDirectoryName(ProjectPath),true);
    GetProjectFiles(ProjectPath,ProjectFiles);
    for &File in ProjectFiles do begin
      AddFilesToList(TPath.GetDirectoryName(&File),true);
      AddKnownDirectoriesToList(TPath.GetDirectoryName(&File),true);
    end;
    if Options.AppDataClear then begin
      GetProjectAppDataPaths(ProjectPath,ProjectFiles);
      AddDirectoriesToList(ProjectFiles,CheckAppDataClear.Checked,true);
    end;
  finally
    ListFile.EndUpdate;
    TCursor.Current := TCursors.Default;
  end;
end;

procedure TFormMain.OpenDirectory(Path: string);
begin
  TCursor.Current := TCursors.WaitCursor;
  ListFile.BeginUpdate;
  try
    Options.Filters := TextFilters.Text;
    CheckAppDataClear.Checked := false;
    CheckAppDataClear_Click(nil,nil);
    AddFilesToList(Path,true);
    AddDirectoriesToListFrom(Path,true);
  finally
    ListFile.EndUpdate;
    TCursor.Current := TCursors.Default;
  end;
end;

procedure TFormMain.DoClear;
var
  I: Integer;
  Path: string;
begin
  TCursor.Current := TCursors.WaitCursor;
  ListFile.BeginUpdate;
  try
    for I := Pred(ListFile.Items.Count) downto 0 do
    begin
      if ListFile.Items[I].Checked then
      begin
        Path := ListFile.Items[I].Text;
        if Path.EndsWith(TPath.DirectorySeparatorChar + '*.*') then
        begin
          try
            TDirectory.Delete(Path.Substring(0, Path.Length - Length(TPath.DirectorySeparatorChar + '*.*')), true);
            PathTable.Remove(ListFile.Items[I].Text.ToUpper);
            ListFile.Items.RemoveAt(I);
          except
          end;
        end
        else
        begin
          try
            TFile.Delete(Path);
            PathTable.Remove(ListFile.Items[I].Text.ToUpper);
            ListFile.Items.RemoveAt(I);
          except
          end;
        end;
      end;
    end;
  finally
    ListFile.EndUpdate;
    TCursor.Current := TCursors.Default;
  end;
end;

procedure TFormMain.GetProjectFiles(ProjectPath: string; out ProjectFiles: array of string);
var
  Files: array of string;
  FileInfo: TFileInfo;
  Project: TBorlandProject;
  N: Integer;
begin
  Project := TBorlandProject.LoadFrom(ProjectPath) as TBorlandProject;
  ProjectPath := TPath.GetDirectoryName(ProjectPath) + TPath.DirectorySeparatorChar;
  SetLength(Files,Length(Project.DelphiDotNet.FileList));
  N := 0;
  for FileInfo in Project.DelphiDotNet.FileList do
    if (FileInfo.FileName <> '') and (FileInfo.ContainerId = '') then begin
      Files[N] := ProjectPath + FileInfo.FileName;
      Inc(N);
    end;
  SetLength(Files,N);
  ProjectFiles := Files;
end;

procedure TFormMain.GetProjectAppDataPaths(ProjectPath: string; out DataPaths: array of string);
var
  ProjectName: string;
  Paths: array of string;
  N: Integer;

  function ChopPathTails(S: string; TailN: integer): string;
  var
    I: Integer;
  begin
    Result := S;
    for I := 1 to TailN do
      Result := Result.Substring(0,Result.LastIndexOf(TPath.DirectorySeparatorChar));
  end;

  function GetDirectoryMatch(Path: string; Target: string): string;
  var
    Directories: array of string;
    Directory: string;
    Targets: array of string;
    CleanTargets: array of string;
    I: Integer;
  begin
    Result := '';
    Directories := TDirectory.GetDirectories(Path);
    for Directory in Directories do begin
      Targets := TDirectory.GetDirectories(Directory,Target + '*');
      if Length(Targets) > 0 then begin
        Result := Targets[0];
        Exit;
      end;
      Targets := TDirectory.GetDirectories(Directory);
      SetLength(CleanTargets,Length(Targets));
      for I := 0 to Pred(Length(Targets)) do
        CleanTargets[I] := Targets[I].Replace(' ','');
      for I := 0 to Pred(Length(Targets)) do
        if CleanTargets[I].LastIndexOf(Target,Directory.Length) >= 0 then begin
          Result := Targets[I];
          Exit;
        end;
    end;
  end;

begin
  ProjectName := TPath.GetFileNameWithoutExtension(ProjectPath);
  SetLength(Paths,2);
  N := 0;
  Paths[N] := GetDirectoryMatch(ChopPathTails(TApplication.LocalUserAppDataPath,3),ProjectName);
  if Paths[N] <> '' then
    Inc(N);
  Paths[N] := GetDirectoryMatch(ChopPathTails(TApplication.UserAppDataPath,3),ProjectName);
  if Paths[N] <> '' then
    Inc(N);
  SetLength(Paths,N);
  DataPaths := Paths;
end;

procedure TFormMain.AddDirectoriesToListFrom(Path: string; IsChecked: Boolean);
var
  Directories: array of string;
  Directory: string;
begin
  Directories := TDirectory.GetDirectories(Path);
  for Directory in Directories do begin
    if Options.IsKnowDirectory(Directory) then
      AddDirectoryToList(Directory,IsChecked,false)
    else begin
      AddFilesToList(Directory,IsChecked);
      AddDirectoriesToListFrom(Directory,IsChecked);
    end
  end;
end;

procedure TFormMain.AddFilesToList(Path: string; IsChecked: Boolean);
var
  Filter: string;
  Files: array of string;
  &File: string;
begin
  if Path <> '' then begin
    if Length(Options.FilterArray) > 0 then begin
      for Filter in Options.FilterArray do begin
        Files := TDirectory.GetFileSystemEntries(Path,Filter);
        for &File in Files do
          AddFileToList(&File,IsChecked,false);
      end;
    end
    else begin
      Files := TDirectory.GetFileSystemEntries(Path);
      for &File in Files do
        AddFileToList(&File,IsChecked,false);
    end;
  end;
end;

procedure TFormMain.AddFileToList(Path: string; IsChecked,IsMarked: Boolean);
begin
  if not PathTable.ContainsKey(Path.ToUpper) then begin
    PathTable.Add(Path.ToUpper,nil);
    with ListFile.Items.Add(Path) do begin
      Checked := IsChecked;
      if IsMarked then
        Tag := TObject(1);
    end;
  end;
end;

procedure TFormMain.AddDirectoryToList(Path: string; IsChecked,IsMarked: Boolean);
begin
  if TDirectory.Exists(Path) then
    AddFileToList(Path + TPath.DirectorySeparatorChar + '*.*',IsChecked,IsMarked);
end;

procedure TFormMain.AddDirectoriesToList(Paths: array of string; IsChecked: Boolean; IsMarked: Boolean);
var
  Directory: string;
begin
  for Directory in Paths do
    AddDirectoryToList(Directory,IsChecked,IsMarked);
end;

procedure TFormMain.AddKnownDirectoriesToList(Path: string; IsChecked: Boolean);
var
  Directory: string;
begin
  for Directory in Options.KnownDirectoryArray do
    AddDirectoryToList(Path + TPath.DirectorySeparatorChar + Directory, IsChecked, false);
end;


end.
