unit WinForm;

interface

uses
  System.Collections,
  System.ComponentModel,
  System.Data,
  System.Drawing,
  System.Threading,
  System.Windows.Forms;

type
  LoadTypeHashDelegate = procedure of object;
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    List: System.Windows.Forms.ListBox;
    Button1: System.Windows.Forms.Button;
    Button2: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  private
    D: LoadTypeHashDelegate;
    TypeHash: HashTable;
    LoadStatus: IAsyncResult;
    procedure LoadTypeHash;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses
  SetsDialog,
  System.IO;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.List := System.Windows.Forms.ListBox.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // List
  // 
  Self.List.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.List.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.List.IntegralHeight := False;
  Self.List.Location := System.Drawing.Point.Create(0, 0);
  Self.List.Name := 'List';
  Self.List.Size := System.Drawing.Size.Create(460, 305);
  Self.List.TabIndex := 0;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(344, 20);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 1;
  Self.Button1.Text := 'Button1';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(348, 52);
  Self.Button2.Name := 'Button2';
  Self.Button2.TabIndex := 2;
  Self.Button2.Text := 'Button2';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(460, 305);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.Button1);
  Self.Controls.Add(Self.List);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  InitializeComponent;
  D := LoadTypeHash;
  LoadStatus := D.BeginInvoke(nil,nil);
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
var
  AName: string;
begin
  AName := 'HashTable';
  with TNamespaces.Create do begin
    TypeName := AName;
    AName := TypeHash[AName.ToUpper] as string;
    Namespaces := AName;
    ShowDialog;
    Free;
  end;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  O: TObject;
begin
  if LoadStatus.IsCompleted then begin
    D.EndInvoke(LoadStatus);
    for O in TypeHash.Values do
      List.Items.Add(O as string);
  end;
end;

procedure TWinForm.LoadTypeHash;
var
  Files: array of string;
  NamespaceFile: string;

  procedure LoadANamespace(NamespaceFile: string);
  var
    Reader: StreamReader;
    TypeTokens: array of string;
    S: string;
    I: Integer;
    Found: Boolean;
  begin
    Reader := StreamReader.Create(NamespaceFile);
    NamespaceFile := Path.GetFileNameWithoutExtension(NamespaceFile);
    I := NamespaceFile.LastIndexOf('.');
    NamespaceFile := NamespaceFile.Substring(0,I);
    try
      Found := False;
      S := Reader.ReadLine;
      while Assigned(S) and not Found do begin
        Found := (S.Trim.ToUpper = 'TYPE');
        S := Reader.ReadLine;
      end;
      if Found then begin
        Found := False;
        while Assigned(S) and not Found do begin
          if S.Trim <> '' then begin
            if S.Trim.ToUpper = 'IMPLEMENTATION' then
              Found := true
            else begin
              TypeTokens := S.Split(['=']);
              TypeTokens[0] := TypeTokens[0].Trim.ToUpper;
              try
                TypeHash.Add(TypeTokens[0],NamespaceFile);
              except
                on System.ArgumentException do begin
                  S := TypeHash[TypeTokens[0]] as string;
                  if Assigned(S) then
                    TypeHash[TypeTokens[0]] := S + ',' + NamespaceFile
                  else
                    raise;
                end
                else
                  raise;
              end;
              TypeTokens[0] := TypeTokens[0].Substring(1);
              try
                TypeHash.Add(TypeTokens[0],NamespaceFile);
              except
                on System.ArgumentException do begin
                  S := TypeHash[TypeTokens[0]] as string;
                  if Assigned(S) then
                    TypeHash[TypeTokens[0]] := S + ',' + NamespaceFile
                  else
                    raise;
                end
                else
                  raise;
              end;
            end;
          end;
          S := Reader.ReadLine;
        end;
      end;
    finally
      Reader.Close;
    end;
  end;

begin
  TypeHash := HashTable.Create;
  Files := Directory.GetFiles('R:\.NET\Commons\T\');
  for NamespaceFile in Files do
    LoadANamespace(NamespaceFile);
end;

end.
