unit Options;

interface

uses
  Commons.Settings,
  System.Drawing,
  System.IO,
  System.Windows.Forms,
  System.Xml.Serialization;

type
  TOptions = class(TSettingsObject)
  public
    TypeListPath: string;
  public
    class function Load: TOptions;
    procedure Store;
    constructor Create; override;
  end;
  TApplicationSts = class(TSettingsObject)
  public
    MainFormSize: Size;
    Target: string;
    ErrorN: Integer;
    &Begin,&End: Boolean;
  public
    class function Load: TApplicationSts;
    procedure Store;
    constructor Create; override;
  end;

implementation

{ TOptions }

constructor TOptions.Create;
begin
  inherited Create;
end;

class function TOptions.Load: TOptions;
begin
  try
    Result := TOptions.LoadFrom(Path.ChangeExtension(Application.ExecutablePath,'.xml')) as TOptions;
  except
    Result := TOptions.Create;
  end;
end;

procedure TOptions.Store;
begin
  StoreTo(Path.ChangeExtension(Application.ExecutablePath,'.xml'));
end;

{ TApplicationSts }

constructor TApplicationSts.Create;
begin
  inherited Create;
  MainFormSize.Width := 530;
  MainFormSize.Height := 500;
end;

class function TApplicationSts.Load: TApplicationSts;
begin
  try
    Result := TApplicationSts.LoadFrom(Application.LocalUserAppDataPath + Path.DirectorySeparatorChar +
                                       Application.ProductName + '.xml') as TApplicationSts;
  except
    Result := TApplicationSts.Create;
  end;
end;

procedure TApplicationSts.Store;
begin
  StoreTo(Application.LocalUserAppDataPath + Path.DirectorySeparatorChar + Application.ProductName + '.xml');
end;

end.
