unit NamespaceSearchDialog;

interface

uses
  FrameList,
  Options,
  System.Collections,
  System.ComponentModel,
  System.Drawing,
  System.Windows.Forms,
  TypeList,
  Visibles.BorderExtender, System.Resources, Invisibles.ExceptionHandler;

type
  TNamespaceSearchDialog = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    PanelInput: System.Windows.Forms.Panel;
    PanelLists: System.Windows.Forms.Panel;
    TabControl: System.Windows.Forms.TabControl;
    TabPage0: System.Windows.Forms.TabPage;
    TextTarget: System.Windows.Forms.TextBox;
    UpDownErrorN: System.Windows.Forms.NumericUpDown;
    RadioBegin: System.Windows.Forms.RadioButton;
    RadioEnd: System.Windows.Forms.RadioButton;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    ColumnHeader1: System.Windows.Forms.ColumnHeader;
    ColumnHeader2: System.Windows.Forms.ColumnHeader;
    BtnSearch: System.Windows.Forms.Button;
    BtnRefine: System.Windows.Forms.Button;
    FrameList0: FrameList.TFrameList;
    ContextMenu: System.Windows.Forms.ContextMenu;
    ItemPageDelete: System.Windows.Forms.MenuItem;
    ItemDeleteLines: System.Windows.Forms.MenuItem;
    ItemDeleteNamespace: System.Windows.Forms.MenuItem;
    MenuItem1: System.Windows.Forms.MenuItem;
    MenuItem2: System.Windows.Forms.MenuItem;
    ItemCopyType: System.Windows.Forms.MenuItem;
    ItemCopyNamespace: System.Windows.Forms.MenuItem;
    ExceptionHandler: Invisibles.ExceptionHandler.TExceptionHandler;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure RadioBegin_Click(sender: System.Object; e: System.EventArgs);
    procedure RadioEnd_Click(sender: System.Object; e: System.EventArgs);
    procedure BtnSearch_Click(sender: System.Object; e: System.EventArgs);
    procedure BtnRefine_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemPageDelete_Click(sender: System.Object; e: System.EventArgs);
    procedure ContextMenu_Popup(sender: System.Object; e: System.EventArgs);
    procedure TextTarget_TextChanged(sender: System.Object; e: System.EventArgs);
    procedure ItemDeleteLines_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemDeleteNamespace_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemCopyNamespace_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemCopyType_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  strict private
    ApplicationSts: TApplicationSts;
    Options: TOptions;
    TypeList: TTypeList;
    TargetFilePath: string;
    function Run(ExeName,Pars: string): string;
    procedure Search(Target,TargetFilePath: string; ListResults: ListView);
    function AddPage(Target: string): TabPage;
    procedure RemovePage(Index: Integer);
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TNamespaceSearchDialog))]

implementation

uses
  System.IO,
  System.Diagnostics;

const
  ExeName = 'agrep.exe';
  BeginOfLineMeta = '^';
  EndOfLineMeta = '$';
  ParsFormat = '-ih{0} "{1}" {2}';

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TNamespaceSearchDialog.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_MenuItem = array of System.Windows.Forms.MenuItem;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TNamespaceSearchDialog));
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.PanelInput := System.Windows.Forms.Panel.Create;
  Self.BtnRefine := System.Windows.Forms.Button.Create;
  Self.BtnSearch := System.Windows.Forms.Button.Create;
  Self.TextTarget := System.Windows.Forms.TextBox.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.RadioEnd := System.Windows.Forms.RadioButton.Create;
  Self.RadioBegin := System.Windows.Forms.RadioButton.Create;
  Self.UpDownErrorN := System.Windows.Forms.NumericUpDown.Create;
  Self.PanelLists := System.Windows.Forms.Panel.Create;
  Self.TabControl := System.Windows.Forms.TabControl.Create;
  Self.ContextMenu := System.Windows.Forms.ContextMenu.Create;
  Self.ItemPageDelete := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem1 := System.Windows.Forms.MenuItem.Create;
  Self.ItemDeleteLines := System.Windows.Forms.MenuItem.Create;
  Self.ItemDeleteNamespace := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem2 := System.Windows.Forms.MenuItem.Create;
  Self.ItemCopyType := System.Windows.Forms.MenuItem.Create;
  Self.ItemCopyNamespace := System.Windows.Forms.MenuItem.Create;
  Self.TabPage0 := System.Windows.Forms.TabPage.Create;
  Self.FrameList0 := FrameList.TFrameList.Create;
  Self.ColumnHeader1 := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnHeader2 := System.Windows.Forms.ColumnHeader.Create;
  Self.ExceptionHandler := Invisibles.ExceptionHandler.TExceptionHandler.Create;
  Self.PanelInput.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.UpDownErrorN)).BeginInit;
  Self.PanelLists.SuspendLayout;
  Self.TabControl.SuspendLayout;
  Self.TabPage0.SuspendLayout;
  Self.SuspendLayout;
  // 
  // PanelInput
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.PanelInput, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelInput.Controls.Add(Self.BtnRefine);
  Self.PanelInput.Controls.Add(Self.BtnSearch);
  Self.PanelInput.Controls.Add(Self.TextTarget);
  Self.PanelInput.Controls.Add(Self.Label2);
  Self.PanelInput.Controls.Add(Self.Label1);
  Self.PanelInput.Controls.Add(Self.RadioEnd);
  Self.PanelInput.Controls.Add(Self.RadioBegin);
  Self.PanelInput.Controls.Add(Self.UpDownErrorN);
  Self.PanelInput.Dock := System.Windows.Forms.DockStyle.Top;
  Self.PanelInput.DockPadding.All := 1;
  Self.PanelInput.Location := System.Drawing.Point.Create(0, 0);
  Self.PanelInput.Name := 'PanelInput';
  Self.PanelInput.Size := System.Drawing.Size.Create(508, 50);
  Self.PanelInput.TabIndex := 0;
  // 
  // BtnRefine
  // 
  Self.BtnRefine.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnRefine.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnRefine, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnRefine.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnRefine.Location := System.Drawing.Point.Create(428, 26);
  Self.BtnRefine.Name := 'BtnRefine';
  Self.BtnRefine.Size := System.Drawing.Size.Create(75, 20);
  Self.BtnRefine.TabIndex := 7;
  Self.BtnRefine.Text := '&Refine';
  Include(Self.BtnRefine.Click, Self.BtnRefine_Click);
  // 
  // BtnSearch
  // 
  Self.BtnSearch.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnSearch.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnSearch, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnSearch.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnSearch.Location := System.Drawing.Point.Create(428, 4);
  Self.BtnSearch.Name := 'BtnSearch';
  Self.BtnSearch.Size := System.Drawing.Size.Create(75, 20);
  Self.BtnSearch.TabIndex := 6;
  Self.BtnSearch.Text := '&Search';
  Include(Self.BtnSearch.Click, Self.BtnSearch_Click);
  // 
  // TextTarget
  // 
  Self.TextTarget.AutoSize := False;
  Self.BorderExtender.SetBorder3DStyle(Self.TextTarget, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextTarget.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextTarget.Location := System.Drawing.Point.Create(4, 24);
  Self.TextTarget.Name := 'TextTarget';
  Self.TextTarget.Size := System.Drawing.Size.Create(188, 20);
  Self.TextTarget.TabIndex := 0;
  Self.TextTarget.Text := '';
  Include(Self.TextTarget.TextChanged, Self.TextTarget_TextChanged);
  // 
  // Label2
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Label2, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label2.Location := System.Drawing.Point.Create(170, 6);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(83, 16);
  Self.Label2.TabIndex := 3;
  Self.Label2.Text := 'Accept Error &#';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label1
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.Label1, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label1.Location := System.Drawing.Point.Create(5, 6);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(100, 16);
  Self.Label1.TabIndex := 1;
  Self.Label1.Text := 'Search &Target';
  // 
  // RadioEnd
  // 
  Self.RadioEnd.AutoCheck := False;
  Self.BorderExtender.SetBorder3DStyle(Self.RadioEnd, System.Windows.Forms.Border3DStyle.Adjust);
  Self.RadioEnd.CheckAlign := System.Drawing.ContentAlignment.BottomCenter;
  Self.RadioEnd.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.RadioEnd.Location := System.Drawing.Point.Create(310, 4);
  Self.RadioEnd.Name := 'RadioEnd';
  Self.RadioEnd.Size := System.Drawing.Size.Create(60, 32);
  Self.RadioEnd.TabIndex := 5;
  Self.RadioEnd.TabStop := True;
  Self.RadioEnd.Text := 'At &End';
  Self.RadioEnd.TextAlign := System.Drawing.ContentAlignment.TopLeft;
  Include(Self.RadioEnd.Click, Self.RadioEnd_Click);
  // 
  // RadioBegin
  // 
  Self.RadioBegin.AutoCheck := False;
  Self.BorderExtender.SetBorder3DStyle(Self.RadioBegin, System.Windows.Forms.Border3DStyle.Adjust);
  Self.RadioBegin.CheckAlign := System.Drawing.ContentAlignment.BottomCenter;
  Self.RadioBegin.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.RadioBegin.Location := System.Drawing.Point.Create(260, 4);
  Self.RadioBegin.Name := 'RadioBegin';
  Self.RadioBegin.Size := System.Drawing.Size.Create(76, 32);
  Self.RadioBegin.TabIndex := 4;
  Self.RadioBegin.TabStop := True;
  Self.RadioBegin.Text := 'At &Begin';
  Self.RadioBegin.TextAlign := System.Drawing.ContentAlignment.TopLeft;
  Include(Self.RadioBegin.Click, Self.RadioBegin_Click);
  // 
  // UpDownErrorN
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.UpDownErrorN, System.Windows.Forms.Border3DStyle.Adjust);
  Self.UpDownErrorN.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.UpDownErrorN.Location := System.Drawing.Point.Create(206, 24);
  Self.UpDownErrorN.Name := 'UpDownErrorN';
  Self.UpDownErrorN.Size := System.Drawing.Size.Create(48, 20);
  Self.UpDownErrorN.TabIndex := 2;
  // 
  // PanelLists
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.PanelLists, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelLists.Controls.Add(Self.TabControl);
  Self.PanelLists.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.PanelLists.Location := System.Drawing.Point.Create(0, 50);
  Self.PanelLists.Name := 'PanelLists';
  Self.PanelLists.Size := System.Drawing.Size.Create(508, 305);
  Self.PanelLists.TabIndex := 1;
  // 
  // TabControl
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.TabControl, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TabControl.ContextMenu := Self.ContextMenu;
  Self.TabControl.Controls.Add(Self.TabPage0);
  Self.TabControl.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.TabControl.Location := System.Drawing.Point.Create(0, 0);
  Self.TabControl.Name := 'TabControl';
  Self.TabControl.Padding := System.Drawing.Point.Create(3, 3);
  Self.TabControl.SelectedIndex := 0;
  Self.TabControl.Size := System.Drawing.Size.Create(508, 305);
  Self.TabControl.TabIndex := 0;
  Self.TabControl.TabStop := False;
  // 
  // ContextMenu
  // 
  Self.ContextMenu.MenuItems.AddRange(TArrayOfSystem_Windows_Forms_MenuItem.Create(Self.ItemPageDelete, 
          Self.MenuItem1, Self.ItemDeleteLines, Self.ItemDeleteNamespace, Self.MenuItem2, 
          Self.ItemCopyType, Self.ItemCopyNamespace));
  Include(Self.ContextMenu.Popup, Self.ContextMenu_Popup);
  // 
  // ItemPageDelete
  // 
  Self.ItemPageDelete.Index := 0;
  Self.ItemPageDelete.Text := '&Delete Page';
  Include(Self.ItemPageDelete.Click, Self.ItemPageDelete_Click);
  // 
  // MenuItem1
  // 
  Self.MenuItem1.Index := 1;
  Self.MenuItem1.Text := '-';
  // 
  // ItemDeleteLines
  // 
  Self.ItemDeleteLines.Index := 2;
  Self.ItemDeleteLines.Text := 'Delete Selected &Lines';
  Include(Self.ItemDeleteLines.Click, Self.ItemDeleteLines_Click);
  // 
  // ItemDeleteNamespace
  // 
  Self.ItemDeleteNamespace.Index := 3;
  Self.ItemDeleteNamespace.Text := 'Delete &Selected Namespace';
  Include(Self.ItemDeleteNamespace.Click, Self.ItemDeleteNamespace_Click);
  // 
  // MenuItem2
  // 
  Self.MenuItem2.Index := 4;
  Self.MenuItem2.Text := '-';
  // 
  // ItemCopyType
  // 
  Self.ItemCopyType.Index := 5;
  Self.ItemCopyType.Text := 'Copy &Type to Clipboard';
  Include(Self.ItemCopyType.Click, Self.ItemCopyType_Click);
  // 
  // ItemCopyNamespace
  // 
  Self.ItemCopyNamespace.Index := 6;
  Self.ItemCopyNamespace.Text := 'Copy &Namespace to Clipboard';
  Include(Self.ItemCopyNamespace.Click, Self.ItemCopyNamespace_Click);
  // 
  // TabPage0
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.TabPage0, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TabPage0.Controls.Add(Self.FrameList0);
  Self.TabPage0.DockPadding.All := 1;
  Self.TabPage0.Location := System.Drawing.Point.Create(4, 22);
  Self.TabPage0.Name := 'TabPage0';
  Self.TabPage0.Size := System.Drawing.Size.Create(500, 279);
  Self.TabPage0.TabIndex := 0;
  // 
  // FrameList0
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.FrameList0, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.FrameList0.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.FrameList0.Location := System.Drawing.Point.Create(1, 1);
  Self.FrameList0.Name := 'FrameList0';
  Self.FrameList0.Size := System.Drawing.Size.Create(498, 277);
  Self.FrameList0.TabIndex := 0;
  // 
  // ColumnHeader1
  // 
  Self.ColumnHeader1.Width := 250;
  // 
  // ColumnHeader2
  // 
  Self.ColumnHeader2.Width := 348;
  // 
  // ExceptionHandler
  // 
  Self.ExceptionHandler.ExitOnError := False;
  Self.ExceptionHandler.SimpleMessageBox := False;
  // 
  // TNamespaceSearchDialog
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(508, 355);
  Self.Controls.Add(Self.PanelLists);
  Self.Controls.Add(Self.PanelInput);
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.MinimumSize := System.Drawing.Size.Create(487, 300);
  Self.Name := 'TNamespaceSearchDialog';
  Self.PanelInput.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.UpDownErrorN)).EndInit;
  Self.PanelLists.ResumeLayout(False);
  Self.TabControl.ResumeLayout(False);
  Self.TabPage0.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TNamespaceSearchDialog.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    ApplicationSts.Target := TextTarget.Text;
    ApplicationSts.ErrorN := Decimal.ToUInt32(UpDownErrorN.Value);
    ApplicationSts.&Begin := RadioBegin.Checked;
    ApplicationSts.&End := RadioEnd.Checked;
    ApplicationSts.MainFormSize := Size;
    ApplicationSts.Store;
    &File.Delete(TargetFilePath);
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TNamespaceSearchDialog.Create;
var
  Writer: StreamWriter;
  TypeEntry: array of string;
  Value: TObject;
begin
  inherited Create;
  InitializeComponent;
  Text := Application.ProductName;
  ApplicationSts := TApplicationSts.Load;
  Size := ApplicationSts.MainFormSize;
  TextTarget.Text := ApplicationSts.Target;
  UpDownErrorN.Value := ApplicationSts.ErrorN;
  RadioBegin.Checked := ApplicationSts.&Begin;
  RadioEnd.Checked := ApplicationSts.&End;
  TypeEntry := Environment.GetCommandLineArgs;
  if Length(TypeEntry) > 1 then
    if TypeEntry[1] <> '' then
      TextTarget.Text := TypeEntry[1];
  Options := TOptions.Load;
  BtnSearch.Enabled := false;
  BtnRefine.Enabled := false;
  TypeList := TTypeList.Load(Options.TypeListPath);
  TargetFilePath := Path.GetTempFileName;
  Writer := StreamWriter.Create(TargetFilePath);
  try
    for Value in TypeList.KnownTypes do begin
      TypeEntry := System.string(Value).Split([',']);
      if TypeEntry[Pred(Length(TypeEntry))] <> '@' then
        Writer.WriteLine(TypeEntry[0]);
    end;
  finally
    Writer.Close;
    Writer.Free;
  end;
end;

function TNamespaceSearchDialog.AddPage(Target: string): TabPage;
var
  NewFrame: TFrameList;
begin
  Result := TabPage.Create;
  Result.Text := Target;
  NewFrame := TFrameList.Create;
  Result.Controls.Add(NewFrame);
  TabControl.TabPages.Add(Result);
  Result.DockPadding.All := 1;
  BorderExtender.SetBorder3DStyle(NewFrame, System.Windows.Forms.Border3DStyle.SunkenOuter);
  NewFrame.Dock := System.Windows.Forms.DockStyle.Fill;
  NewFrame.Location := System.Drawing.Point.Create(1, 1);
  TabControl.ResumeLayout(False);
  Result.ResumeLayout(False);
  ResumeLayout(False);
  Self.Size := System.Drawing.Size.Create(Self.Size.Width + 1,Self.Size.Height);
  TabControl.SelectedIndex := Pred(TabControl.TabPages.Count);
  Self.Size := System.Drawing.Size.Create(Self.Size.Width - 1,Self.Size.Height);
end;

procedure TNamespaceSearchDialog.RemovePage(Index: Integer);
var
  Page: TabPage;
begin
  Page := TabControl.TabPages[Index];
  TabControl.TabPages.RemoveAt(Index);
  Page.Free;
end;

function TNamespaceSearchDialog.Run(ExeName, Pars: string): string;
begin
  with Process.Create do try
    StartInfo.UseShellExecute := false;
    StartInfo.FileName := ExeName;
    StartInfo.Arguments := Pars;
    StartInfo.CreateNoWindow := true;
    StartInfo.RedirectStandardOutput := true;
    StartInfo.WindowStyle := ProcessWindowStyle.Hidden;
    Start;
    Result := StandardOutput.ReadToEnd;
    WaitForExit;
  finally
    Close;
    Free;
  end;
end;

procedure TNamespaceSearchDialog.Search(Target,TargetFilePath: string; ListResults: ListView);
var
  Reader: StringReader;
  ListItem: ListViewItem;
  S1,S2,Namespace: string;
  Namespaces: array of string;
begin
  if RadioBegin.Checked then
    Target := BeginOfLineMeta + Target
  else if RadioEnd.Checked then
    Target := Target + EndOfLineMeta;
  Reader := StringReader.Create(Run(ExeName,System.string.Format(ParsFormat,[UpDownErrorN.Value,Target,TargetFilePath])));
  S1 := Reader.ReadLine;
  while Assigned(S1) do begin
    S2:= Reader.ReadLine;
    if Assigned(S2) then begin
      Namespace := TypeList.KnownTypeHash[S1.ToUpper] as string;
      if Assigned(Namespace) then begin
        Namespaces := Namespace.Split([',']);
        for Namespace in Namespaces do begin
          ListItem := ListResults.Items.Add(S1);
          ListItem.Subitems.Add(Namespace);
        end;
      end;
    end;
    S1 := S2;
  end;
end;

procedure TNamespaceSearchDialog.RadioEnd_Click(sender: System.Object; e: System.EventArgs);
begin
  if RadioEnd.Checked then
    RadioEnd.Checked := false
  else begin
    RadioEnd.Checked := true;
    RadioBegin.Checked := false;
  end;
end;

procedure TNamespaceSearchDialog.RadioBegin_Click(sender: System.Object; e: System.EventArgs);
begin
  if RadioBegin.Checked then
    RadioBegin.Checked := false
  else begin
    RadioEnd.Checked := false;
    RadioBegin.Checked := true;
  end;
end;

procedure TNamespaceSearchDialog.ContextMenu_Popup(sender: System.Object; e: System.EventArgs);
var
  ListResults: ListView;
begin
  ListResults := (TabControl.SelectedTab.Controls.Item[0] as TFrameList).ListResults;
  ItemPageDelete.Enabled := (TabControl.SelectedIndex <> 0);
  ItemDeleteLines.Enabled := (ListResults.SelectedItems.Count > 0);
  ItemDeleteNamespace.Enabled := (ListResults.SelectedItems.Count = 1);
  ItemCopyType.Enabled := (ListResults.SelectedItems.Count = 1);
  ItemCopyNamespace.Enabled := (ListResults.SelectedItems.Count = 1);
end;

procedure TNamespaceSearchDialog.ItemPageDelete_Click(sender: System.Object; e: System.EventArgs);
begin
  RemovePage(TabControl.SelectedIndex);
end;

procedure TNamespaceSearchDialog.ItemDeleteLines_Click(sender: System.Object; e: System.EventArgs);
var
  ListResults: ListView;
  Item: ListViewItem;
begin
  ListResults := (TabControl.SelectedTab.Controls.Item[0] as TFrameList).ListResults;
  for Item in ListResults.SelectedItems do
    Item.Remove;
  TextTarget_TextChanged(nil,nil);
end;

procedure TNamespaceSearchDialog.ItemDeleteNamespace_Click(sender: System.Object; e: System.EventArgs);
var
  Namespace: string;
  ListResults: ListView;
  Item: ListViewItem;
begin
  ListResults := (TabControl.SelectedTab.Controls.Item[0] as TFrameList).ListResults;
  Namespace := ListResults.SelectedItems.Item[0].Subitems[1].Text;
  for Item in ListResults.Items do begin
    if System.String.Compare(Item.Subitems[1].Text,Namespace,true) = 0 then
      Item.Remove;
  end;
  TextTarget_TextChanged(nil,nil);
end;

procedure TNamespaceSearchDialog.ItemCopyType_Click(sender: System.Object; e: System.EventArgs);
var
  ListResults: ListView;
begin
  ListResults := (TabControl.SelectedTab.Controls.Item[0] as TFrameList).ListResults;
  Clipboard.SetDataObject(ListResults.SelectedItems.Item[0].Subitems[0].Text,true);
end;

procedure TNamespaceSearchDialog.ItemCopyNamespace_Click(sender: System.Object; e: System.EventArgs);
var
  ListResults: ListView;
begin
  ListResults := (TabControl.SelectedTab.Controls.Item[0] as TFrameList).ListResults;
  Clipboard.SetDataObject(ListResults.SelectedItems.Item[0].Subitems[1].Text,true);
end;

procedure TNamespaceSearchDialog.TextTarget_TextChanged(sender: System.Object; e: System.EventArgs);
begin
  BtnSearch.Enabled := (TextTarget.Text.Trim <> '');
  BtnRefine.Enabled := (TextTarget.Text.Trim <> '') and (FrameList0.ListResults.Items.Count > 0);
end;

procedure TNamespaceSearchDialog.BtnSearch_Click(sender: System.Object; e: System.EventArgs);
begin
  Cursor.Current := Cursors.WaitCursor;
  TabPage0.Text := TextTarget.Text.Trim;
  FrameList0.ListResults.Items.Clear;
  FrameList0.ListResults.BeginUpdate;
  try
    Search(TextTarget.Text.Trim,TargetFilePath,FrameList0.ListResults);
  finally
    FrameList0.ListResults.EndUpdate;
    Cursor.Current := Cursors.Default;
  end;
  TextTarget_TextChanged(nil,nil);
end;

procedure TNamespaceSearchDialog.BtnRefine_Click(sender: System.Object; e: System.EventArgs);
var
  TargetFilePath: string;
  Writer: StreamWriter;
  StartListResults, ListResults: ListView;
  Item: ListViewItem;
begin
  Cursor.Current := Cursors.WaitCursor;
  StartListResults := (TabControl.SelectedTab.Controls.Item[0] as TFrameList).ListResults;
  ListResults := (AddPage(TextTarget.Text.Trim).Controls.Item[0] as TFrameList).ListResults;
  TargetFilePath := Path.GetTempFileName;
  Writer := StreamWriter.Create(TargetFilePath);
  try
    for Item in StartListResults.SelectedItems do
      Writer.WriteLine(Item.Text);
  finally
    Writer.Close;
    Writer.Free;
  end;
  ListResults.BeginUpdate;
  try
    Search(TextTarget.Text.Trim,TargetFilePath,ListResults);
  finally
    &File.Delete(TargetFilePath);
    ListResults.EndUpdate;
    Cursor.Current := Cursors.Default;
  end;
end;


end.
