unit FrameList;

interface

uses
  System.Collections,
  System.ComponentModel,
  System.Drawing,
  System.Windows.Forms;

type
  TFrameList = class(System.Windows.Forms.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    ColumnTypes: System.Windows.Forms.ColumnHeader;
    ColumnNamespaces: System.Windows.Forms.ColumnHeader;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TFrameList_SizeChanged(sender: System.Object; e: System.EventArgs);
    procedure ListResults_ColumnClick(sender: System.Object; e: System.Windows.Forms.ColumnClickEventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  public
    ListResults: System.Windows.Forms.ListView;
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFrameList))]

implementation

type
  TListViewItemComparer = class(TObject,IComparer)
  strict private
    Column: Integer;
  public
    function Compare(X,Y: TObject): Integer;
    constructor Create; overload;
    constructor Create(Column: Integer); overload;
  end;

{ TListViewItemComparer }

constructor TListViewItemComparer.Create(Column: Integer);
begin
  inherited Create;
  Self.Column := Column;
end;

constructor TListViewItemComparer.Create;
begin
  inherited Create;
  Column := 0;
end;

function TListViewItemComparer.Compare(X, Y: TObject): Integer;
begin
  Result := System.string.Compare((ListViewItem(X)).SubItems[Column].Text, (ListViewItem(Y)).SubItems[Column].Text);
end;

{ TFrameList }

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrameList.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_ColumnHeader = array of System.Windows.Forms.ColumnHeader;
begin
  Self.ListResults := System.Windows.Forms.ListView.Create;
  Self.ColumnTypes := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnNamespaces := System.Windows.Forms.ColumnHeader.Create;
  Self.SuspendLayout;
  // 
  // ListResults
  // 
  Self.ListResults.AutoArrange := False;
  Self.ListResults.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListResults.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnTypes, 
          Self.ColumnNamespaces));
  Self.ListResults.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListResults.FullRowSelect := True;
  Self.ListResults.GridLines := True;
  Self.ListResults.HideSelection := False;
  Self.ListResults.LabelWrap := False;
  Self.ListResults.Location := System.Drawing.Point.Create(0, 0);
  Self.ListResults.Name := 'ListResults';
  Self.ListResults.Size := System.Drawing.Size.Create(496, 228);
  Self.ListResults.TabIndex := 0;
  Self.ListResults.View := System.Windows.Forms.View.Details;
  Include(Self.ListResults.ColumnClick, Self.ListResults_ColumnClick);
  // 
  // ColumnTypes
  // 
  Self.ColumnTypes.Text := 'Types';
  Self.ColumnTypes.Width := 220;
  // 
  // ColumnNamespaces
  // 
  Self.ColumnNamespaces.Text := 'Namespaces';
  Self.ColumnNamespaces.Width := 270;
  // 
  // TFrameList
  // 
  Self.Controls.Add(Self.ListResults);
  Self.Name := 'TFrameList';
  Self.Size := System.Drawing.Size.Create(496, 228);
  Include(Self.SizeChanged, Self.TFrameList_SizeChanged);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFrameList.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFrameList.Create;
begin
  inherited Create;
  InitializeComponent;
end;

procedure TFrameList.TFrameList_SizeChanged(sender: System.Object; e: System.EventArgs);
begin
  with ListResults do
    Columns[1].Width := Size.Width - Columns[0].Width;
end;

procedure TFrameList.ListResults_ColumnClick(sender: System.Object; e: System.Windows.Forms.ColumnClickEventArgs);
begin
  with Sender as ListView do begin
    BeginUpdate;
    ListViewItemSorter := TListViewItemComparer.Create(e.Column);
    ListViewItemSorter := nil;
    EndUpdate;
  end;
end;


end.
