unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, TrayAreaInjector;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    BtnStart: System.Windows.Forms.Button;
    BtnStop: System.Windows.Forms.Button;
    BtnShutdown: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure BtnStart_Click(sender: System.Object; e: System.EventArgs);
    procedure BtnStop_Click(sender: System.Object; e: System.EventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  private
    TrayArea: ITrayArea;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses
  System.Diagnostics,
  System.Runtime.InteropServices;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.BtnStart := System.Windows.Forms.Button.Create;
  Self.BtnStop := System.Windows.Forms.Button.Create;
  Self.BtnShutdown := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // BtnStart
  // 
  Self.BtnStart.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnStart.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.BtnStart.Location := System.Drawing.Point.Create(4, 4);
  Self.BtnStart.Name := 'BtnStart';
  Self.BtnStart.Size := System.Drawing.Size.Create(110, 23);
  Self.BtnStart.TabIndex := 0;
  Self.BtnStart.Text := 'Click to Start';
  Include(Self.BtnStart.Click, Self.BtnStart_Click);
  // 
  // BtnStop
  // 
  Self.BtnStop.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnStop.Enabled := False;
  Self.BtnStop.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.BtnStop.Location := System.Drawing.Point.Create(4, 31);
  Self.BtnStop.Name := 'BtnStop';
  Self.BtnStop.Size := System.Drawing.Size.Create(110, 23);
  Self.BtnStop.TabIndex := 1;
  Self.BtnStop.Text := 'Click to Stop';
  Include(Self.BtnStop.Click, Self.BtnStop_Click);
  // 
  // BtnShutdown
  // 
  Self.BtnShutdown.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnShutdown.Enabled := False;
  Self.BtnShutdown.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.BtnShutdown.Location := System.Drawing.Point.Create(4, 58);
  Self.BtnShutdown.Name := 'BtnShutdown';
  Self.BtnShutdown.Size := System.Drawing.Size.Create(110, 23);
  Self.BtnShutdown.TabIndex := 2;
  Self.BtnShutdown.Text := 'Click to Shutdown';
  Include(Self.BtnShutdown.Click, Self.Button1_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(118, 85);
  Self.Controls.Add(Self.BtnShutdown);
  Self.Controls.Add(Self.BtnStop);
  Self.Controls.Add(Self.BtnStart);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedDialog;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TWinForm';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  InitializeComponent;
end;

procedure TWinForm.BtnStart_Click(sender: System.Object; e: System.EventArgs);
begin
  BtnStart.Enabled := false;
  BtnStop.Enabled := true;
  BtnShutdown.Enabled := true;
  TrayArea := TrayAreaClass.Create;
  TrayArea.AttachTrayArea(Process.GetCurrentProcess.Id,'WindowsForms10.Window.8.app3');
  TrayArea.AddPanel('Panel1','Caption 1',1,0);
  TrayArea.AddPanel('Panel2','Caption 2',2,0);
end;

procedure TWinForm.BtnStop_Click(sender: System.Object; e: System.EventArgs);
begin
  BtnStart.Enabled := true;
  BtnStop.Enabled := false;
  BtnShutdown.Enabled := false;
  Marshal.ReleaseComObject(TrayArea);
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  Process.GetCurrentProcess.Kill;
end;


end.
