unit Unit1;

interface

uses
  Windows, Classes, Controls, Forms, TrayAreaInjector_TLB, Buttons, Graphics,
  ImgList;

type
  TForm1 = class(TForm)
    BtnStart: TSpeedButton;
    BtnStop: TSpeedButton;
    BtnShutdown: TSpeedButton;
    ImageList: TImageList;
    procedure BtnStartClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure BtnShutdownClick(Sender: TObject);
  private
    TrayArea: ITrayArea;
  end;

var
  Form1: TForm1;

implementation

uses
  Variants;

{$R *.dfm}

procedure TForm1.BtnStartClick(Sender: TObject);
type
  PPixelArray = ^TPixelArray;
  TPixelArray = array[0..0] of LongWord;
var
  Picture: Variant;
  PictureLine: Variant;
  PictureLineData: PPixelArray;
  PictureBitmap: TBitmap;
  ScanLine: PPixelArray;
  Row,Col: Integer;
  ImageI,PanelI: Integer;
begin
  BtnStart.Enabled := false;
  BtnStop.Enabled := true;
  BtnShutdown.Enabled := true;
  TrayArea := CoTrayArea.Create;
  TrayArea.AttachTrayArea(GetCurrentProcessID,'TForm1');
  PanelI := TrayArea.AddPanel('Panel1','Caption 1',1,0);
  PictureBitmap := TBitmap.Create;
  ImageList.GetBitmap(1,PictureBitmap);
  PictureBitmap.PixelFormat := pf32bit;
  Picture := VarArrayCreate([0, Pred(PictureBitmap.Height)], varVariant);
  for Row := 0 to Pred(PictureBitmap.Height) do begin
    ScanLine := PictureBitmap.ScanLine[Row];
    PictureLine := VarArrayCreate([0, Pred(PictureBitmap.Width)], varInteger);
    PictureLineData := VarArrayLock(PictureLine);
    try
      for Col := 0 to Pred(PictureBitmap.Width) do
        PictureLineData^[Col] := ScanLine^[Col];
    finally
      VarArrayUnlock(PictureLine);
    end;
    Picture[Row] := PictureLine;
  end;
  ImageI := TrayArea.AddPicture(Picture);
  if ImageI >= 0 then
    TrayArea.PanelImageIndex[PanelI] := ImageI;
end;

procedure TForm1.BtnStopClick(Sender: TObject);
begin
  BtnStart.Enabled := true;
  BtnStop.Enabled := false;
  BtnShutdown.Enabled := false;
  TrayArea := nil;
end;

procedure TForm1.BtnShutdownClick(Sender: TObject);
begin
  ExitProcess(0);
end;

end.

