unit CoClasses;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, TrayAreaInjector_TLB, Injected, StdVcl;

type
  TTrayArea = class(TAutoObject, ITrayArea)
  private
    AppTrayAreaPanel: ITrayArea;
  public
    procedure Initialize; override;
    procedure BeforeDestruction; override;
  protected
    function AddPanel(const ID, Text: WideString; ImageIndex, Width: Integer): Integer; safecall;
    procedure RemovePanel(Handle: Integer); safecall;
    function Get_PanelImageIndex(Handle: Integer): Integer; safecall;
    function Get_PanelText(Handle: Integer): WideString; safecall;
    procedure Set_PanelImageIndex(Handle, Value: Integer); safecall;
    procedure Set_PanelText(Handle: Integer; const Value: WideString); safecall;
    procedure AttachTrayArea(ProcessID: Integer; const WindowClass: WideString); safecall;
    function AddPicture(Picture: OleVariant): Integer; safecall;
  end;

implementation

uses
  ComServ;

function TTrayArea.AddPanel(const ID, Text: WideString; ImageIndex, Width: Integer): Integer;
begin
  Result := AppTrayAreaPanel.AddPanel(ID,Text,ImageIndex,Width);
end;

procedure TTrayArea.RemovePanel(Handle: Integer);
begin
  AppTrayAreaPanel.RemovePanel(Handle);
end;

function TTrayArea.Get_PanelText(Handle: Integer): WideString;
begin
  Result := AppTrayAreaPanel.PanelText[Handle];
end;

procedure TTrayArea.Set_PanelText(Handle: Integer; const Value: WideString);
begin
  AppTrayAreaPanel.PanelText[Handle] := Value;
end;

function TTrayArea.Get_PanelImageIndex(Handle: Integer): Integer;
begin
  Result := AppTrayAreaPanel.PanelImageIndex[Handle]
end;

procedure TTrayArea.Set_PanelImageIndex(Handle, Value: Integer);
begin
  AppTrayAreaPanel.PanelImageIndex[Handle] := Value;
end;

function TTrayArea.AddPicture(Picture: OleVariant): Integer;
begin
  Result := AppTrayAreaPanel.AddPicture(Picture);
end;

procedure TTrayArea.Initialize;
begin
  inherited Initialize;
  AppTrayAreaPanel := nil;
end;

procedure TTrayArea.BeforeDestruction;
begin
  AppTrayAreaPanel := nil;
  inherited BeforeDestruction;
end;

procedure TTrayArea.AttachTrayArea(ProcessID: Integer; const WindowClass: WideString);
begin
  AppTrayAreaPanel := TPanelInjected.Instanciate(ProcessID);
  AppTrayAreaPanel.AttachTrayArea(ProcessID,WindowClass);
end;

initialization
  TAutoObjectFactory.Create(ComServer, TTrayArea, Class_TrayArea, ciMultiInstance, tmApartment);
end.
