unit Options;

interface

uses
  Commons.Settings,
  System.Collections,
  System.Collections.T,
  System.ComponentModel,
  System.ComponentModel.T,
  System.Drawing,
  System.Drawing.T,
  System.T,
  System.Windows.Forms,
  System.Windows.Forms.T,
  System.Xml.Serialization,
  System.Xml.Serialization.T,
  Visibles.BorderExtender,
  Visibles.ButtonEx;

type
  [Serializable]
  TSystemExtraType = class (TObject)
  public
    DelphiName: string;
    Definition: string;
  end;
  [XmlInclude(typeof(TSystemExtraType))]
  [Serializable]
  TKnownType = class (TObject)
  public
    NETName: string;
    DelphiName: string;
    Exclude: Boolean;
  end;
  [XmlInclude(typeof(TKnownType))]
  [Serializable]
  TKnownNamespace = class (TObject)
  public
    Name: string;
    Prefix: string;
    Exclude: Boolean;
  end;
  [XmlInclude(typeof(TKnownNamespace))]
  TOptions = class(TSettingsObject)
  private
    class function Load: TOptions;
    procedure Store;
  public
    ClassPrefix: string;
    RecordPrefix: string;
    EnumeratedPrefix: string;
    ExceptionPrefix: string;
    RemoveExceptionPostfix: Boolean;
    RemoveClassPostfix: Boolean;
    DoNotRenameAttributes: Boolean;
    FullOptionsInUnits: Boolean;
    SystemExtraTypes: TArrayList;
    KnownTypes: TArrayList;
    KnownNamespaces: TArrayList;
    procedure SetKnownType(NETName,DelphiName: string; Exclude: Boolean);
    procedure SetKnownNamespace(Name,Prefix: string; Exclude: Boolean);
    function GetHashedKnownTypes: THashTable;
    function GetHashedKnownNamespaces: THashTable;
    constructor Create; override;
  end;
  TPanelHeights = record
    Assemblies: Integer;
    Namespaces: Integer;
  end;
  TApplicationSts = class(TSettingsObject)
  public
    MainFormSize: RSize;
    PanelHeights: TPanelHeights;
  public
    class function Load: TApplicationSts;
    procedure Store;
    constructor Create; override;
  end;
  TFormOptions = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    PanelNormal: System.Windows.Forms.Panel;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    BtnOk: Visibles.ButtonEx.TButtonEx;
    BtnCancel: Visibles.ButtonEx.TButtonEx;
    TextClassPrefix: System.Windows.Forms.TextBox;
    TextExceptionPrefix: System.Windows.Forms.TextBox;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    CheckException: System.Windows.Forms.CheckBox;
    CheckClass: System.Windows.Forms.CheckBox;
    Label3: System.Windows.Forms.Label;
    TextRecordPrefix: System.Windows.Forms.TextBox;
    BtnReload: Visibles.ButtonEx.TButtonEx;
    Label4: System.Windows.Forms.Label;
    TextEnumeratedPrefix: System.Windows.Forms.TextBox;
    ListNamespacePrefixes: System.Windows.Forms.CheckedListBox;
    LabelCustomNamePrefix: System.Windows.Forms.Label;
    TextCustomNamePrefix: System.Windows.Forms.TextBox;
    PanelCustom: System.Windows.Forms.Panel;
    CheckFullOptionsInUnits: System.Windows.Forms.CheckBox;
    CheckAttribute: System.Windows.Forms.CheckBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure BtnOk_Click(sender: System.Object; e: System.EventArgs);
    procedure BtnReload_Click(sender: System.Object; e: System.EventArgs);
    procedure ListNamespacePrefixes_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
    procedure TextCustomNamePrefix_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
  {$ENDREGION}
  strict private
    FOptions: TOptions;
    FRefreshRequired: Boolean;
    SelectedName: string;
    SelectedExclude: Boolean;
    procedure OptionsToControls(Options: TOptions);
    function ControlsToOptions(Options: TOptions): Boolean;
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  public
    function get_Options: TOptions;
    procedure set_Options(const Value: TOptions);
  public
    property Options: TOptions read get_Options write set_Options;
    property RefreshRequired: Boolean read FRefreshRequired;
    function ShowDialogNamespace(Namespace,CustomPrefix: string; Exclude_: Boolean): TDialogResult;
    function ShowDialogName(Name,CustomName: string; Exclude: Boolean): TDialogResult;
    function ShowDialog: TDialogResult;
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFormOptions))]

implementation

uses
  System.IO,
  System.IO.T,
  System.Text,
  System.Text.T;

{ TOptions }

constructor TOptions.Create;
begin
  inherited Create;
  SystemExtraTypes := TArrayList.Create;
  KnownTypes := TArrayList.Create;
  KnownNamespaces := TArrayList.Create;
  ClassPrefix := 'T';
  RecordPrefix := 'R';
  EnumeratedPrefix := 'T';
  ExceptionPrefix := 'E';
  RemoveExceptionPostfix := true;
  RemoveClassPostfix := true;
  DoNotRenameAttributes := true;
  FullOptionsInUnits := false;
end;

procedure TOptions.SetKnownType(NETName,DelphiName: string; Exclude: Boolean);
var
  I,J: Integer;
  KnownType: TKnownType;
begin
  I := -1;
  J := 0;
  while (I < 0) and (J < KnownTypes.Count) do
    if System.string.Compare((KnownTypes.Item[J] as TKnownType).NETName,NETName,true) = 0 then
      I := J
    else
      Inc(J);
  if (DelphiName <> '') or Exclude then begin
    KnownType := TKnownType.Create;
    KnownType.NETName := NETName;
    KnownType.DelphiName := DelphiName;
    KnownType.Exclude := Exclude;
  end;
  if I >= 0 then begin
    if (DelphiName <> '') or Exclude then
      KnownTypes.Item[I] := KnownType
    else
      KnownTypes.RemoveAt(I)
  end
  else if (DelphiName <> '') or Exclude then
    KnownTypes.Add(KnownType);
end;

procedure TOptions.SetKnownNamespace(Name,Prefix: string; Exclude: Boolean);
var
  I,J: Integer;
  KnownNamespace: TKnownNamespace;
begin
  I := -1;
  J := 0;
  while (I < 0) and (J < KnownNamespaces.Count) do
    if System.string.Compare((KnownNamespaces.Item[J] as TKnownNamespace).Name,Name,true) = 0 then
      I := J
    else
      Inc(J);
  if (Prefix <> '') or Exclude then begin
    KnownNamespace := TKnownNamespace.Create;
    KnownNamespace.Name := Name;
    KnownNamespace.Prefix := Prefix;
    KnownNamespace.Exclude := Exclude;
  end;
  if I >= 0 then begin
    if (Prefix <> '') or Exclude then
      KnownNamespaces.Item[I] := KnownNamespace
    else
      KnownNamespaces.RemoveAt(I)
  end
  else if (Prefix <> '') or Exclude then
    KnownNamespaces.Add(KnownNamespace);
end;

function TOptions.GetHashedKnownTypes: THashTable;
var
  I: Integer;
begin
  Result := THashTable.Create;
  for I := 0 to Pred(KnownTypes.Count) do
    Result.Add((KnownTypes[I] as TKnownType).NETName.ToUpper,KnownTypes[I]);
end;

function TOptions.GetHashedKnownNamespaces: THashTable;
var
  I: Integer;
begin
  Result := THashTable.Create;
  for I := 0 to Pred(KnownNamespaces.Count) do
    Result.Add((KnownNamespaces[I] as TKnownNamespace).Name.ToUpper,KnownNamespaces[I]);
end;

class function TOptions.Load: TOptions;
begin
  Result := TOptions.LoadFrom(TPath.ChangeExtension(TApplication.ExecutablePath,'.xml')) as TOptions;
end;

procedure TOptions.Store;
begin
  StoreTo(TPath.ChangeExtension(TApplication.ExecutablePath,'.xml'));
end;

{ TApplicationSts }

constructor TApplicationSts.Create;
begin
  inherited Create;
  MainFormSize.Width := 656;
  MainFormSize.Height := 557;
  PanelHeights.Assemblies := 56;
  PanelHeights.Namespaces := 124;
end;

class function TApplicationSts.Load: TApplicationSts;
begin
  try
    Result := TApplicationSts.LoadFrom(TApplication.LocalUserAppDataPath + TPath.DirectorySeparatorChar +
                                       TApplication.ProductName + '.xml') as TApplicationSts;
  except
    Result := TApplicationSts.Create;
  end;
end;

procedure TApplicationSts.Store;
begin
  StoreTo(TApplication.LocalUserAppDataPath + TPath.DirectorySeparatorChar + TApplication.ProductName + '.xml');
end;

{ TFormOption }

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormOptions.InitializeComponent;
begin
  Self.components := System.ComponentModel.Container.Create;
  Self.PanelNormal := System.Windows.Forms.Panel.Create;
  Self.CheckFullOptionsInUnits := System.Windows.Forms.CheckBox.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.TextEnumeratedPrefix := System.Windows.Forms.TextBox.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.TextRecordPrefix := System.Windows.Forms.TextBox.Create;
  Self.CheckClass := System.Windows.Forms.CheckBox.Create;
  Self.CheckException := System.Windows.Forms.CheckBox.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.TextExceptionPrefix := System.Windows.Forms.TextBox.Create;
  Self.TextClassPrefix := System.Windows.Forms.TextBox.Create;
  Self.TextCustomNamePrefix := System.Windows.Forms.TextBox.Create;
  Self.ListNamespacePrefixes := System.Windows.Forms.CheckedListBox.Create;
  Self.LabelCustomNamePrefix := System.Windows.Forms.Label.Create;
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.BtnOk := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.BtnCancel := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.BtnReload := Visibles.ButtonEx.TButtonEx.Create(Self.components);
  Self.PanelCustom := System.Windows.Forms.Panel.Create;
  Self.CheckAttribute := System.Windows.Forms.CheckBox.Create;
  Self.PanelNormal.SuspendLayout;
  Self.PanelCustom.SuspendLayout;
  Self.SuspendLayout;
  // 
  // PanelNormal
  // 
  Self.PanelNormal.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.PanelNormal, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelNormal.Controls.Add(Self.CheckAttribute);
  Self.PanelNormal.Controls.Add(Self.Label1);
  Self.PanelNormal.Controls.Add(Self.CheckException);
  Self.PanelNormal.Controls.Add(Self.CheckFullOptionsInUnits);
  Self.PanelNormal.Controls.Add(Self.Label4);
  Self.PanelNormal.Controls.Add(Self.TextEnumeratedPrefix);
  Self.PanelNormal.Controls.Add(Self.Label3);
  Self.PanelNormal.Controls.Add(Self.TextRecordPrefix);
  Self.PanelNormal.Controls.Add(Self.CheckClass);
  Self.PanelNormal.Controls.Add(Self.Label2);
  Self.PanelNormal.Controls.Add(Self.TextExceptionPrefix);
  Self.PanelNormal.Controls.Add(Self.TextClassPrefix);
  Self.PanelNormal.DockPadding.All := 1;
  Self.PanelNormal.Location := System.Drawing.Point.Create(0, 0);
  Self.PanelNormal.Name := 'PanelNormal';
  Self.PanelNormal.Size := System.Drawing.Size.Create(258, 177);
  Self.PanelNormal.TabIndex := 0;
  // 
  // CheckFullOptionsInUnits
  // 
  Self.CheckFullOptionsInUnits.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckFullOptionsInUnits, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckFullOptionsInUnits.CheckAlign := System.Drawing.ContentAlignment.TopLeft;
  Self.CheckFullOptionsInUnits.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckFullOptionsInUnits.Location := System.Drawing.Point.Create(12, 108);
  Self.CheckFullOptionsInUnits.Name := 'CheckFullOptionsInUnits';
  Self.CheckFullOptionsInUnits.Size := System.Drawing.Size.Create(92, 28);
  Self.CheckFullOptionsInUnits.TabIndex := 9;
  Self.CheckFullOptionsInUnits.Text := 'Full Options in Units';
  // 
  // Label4
  // 
  Self.Label4.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label4, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label4.Location := System.Drawing.Point.Create(72, 62);
  Self.Label4.Name := 'Label4';
  Self.Label4.Size := System.Drawing.Size.Create(100, 16);
  Self.Label4.TabIndex := 8;
  Self.Label4.Text := 'Enumerated Prefix';
  Self.Label4.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextEnumeratedPrefix
  // 
  Self.TextEnumeratedPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextEnumeratedPrefix.AutoSize := False;
  Self.TextEnumeratedPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextEnumeratedPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextEnumeratedPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextEnumeratedPrefix.Location := System.Drawing.Point.Create(180, 60);
  Self.TextEnumeratedPrefix.Name := 'TextEnumeratedPrefix';
  Self.TextEnumeratedPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextEnumeratedPrefix.TabIndex := 2;
  Self.TextEnumeratedPrefix.Text := 'T';
  Self.TextEnumeratedPrefix.WordWrap := False;
  // 
  // Label3
  // 
  Self.Label3.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label3, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label3.Location := System.Drawing.Point.Create(72, 38);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(100, 16);
  Self.Label3.TabIndex := 6;
  Self.Label3.Text := 'Record Prefix';
  Self.Label3.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextRecordPrefix
  // 
  Self.TextRecordPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextRecordPrefix.AutoSize := False;
  Self.TextRecordPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextRecordPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextRecordPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextRecordPrefix.Location := System.Drawing.Point.Create(180, 36);
  Self.TextRecordPrefix.Name := 'TextRecordPrefix';
  Self.TextRecordPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextRecordPrefix.TabIndex := 1;
  Self.TextRecordPrefix.Text := 'R';
  Self.TextRecordPrefix.WordWrap := False;
  // 
  // CheckClass
  // 
  Self.CheckClass.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckClass, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckClass.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckClass.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckClass.Location := System.Drawing.Point.Create(96, 128);
  Self.CheckClass.Name := 'CheckClass';
  Self.CheckClass.Size := System.Drawing.Size.Create(148, 16);
  Self.CheckClass.TabIndex := 5;
  Self.CheckClass.Text := 'No COM Class Postfix';
  Self.CheckClass.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // CheckException
  // 
  Self.CheckException.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckException, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckException.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckException.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckException.Location := System.Drawing.Point.Create(96, 108);
  Self.CheckException.Name := 'CheckException';
  Self.CheckException.Size := System.Drawing.Size.Create(148, 16);
  Self.CheckException.TabIndex := 4;
  Self.CheckException.Text := 'No Exception Postfix';
  Self.CheckException.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // Label2
  // 
  Self.Label2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label2, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label2.Location := System.Drawing.Point.Create(72, 85);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(100, 16);
  Self.Label2.TabIndex := 3;
  Self.Label2.Text := 'Exception Prefix';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label1
  // 
  Self.Label1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.Label1, System.Windows.Forms.Border3DStyle.Adjust);
  Self.Label1.Location := System.Drawing.Point.Create(72, 14);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(100, 16);
  Self.Label1.TabIndex := 2;
  Self.Label1.Text := 'Class Prefix';
  Self.Label1.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // TextExceptionPrefix
  // 
  Self.TextExceptionPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextExceptionPrefix.AutoSize := False;
  Self.TextExceptionPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextExceptionPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextExceptionPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextExceptionPrefix.Location := System.Drawing.Point.Create(180, 84);
  Self.TextExceptionPrefix.Name := 'TextExceptionPrefix';
  Self.TextExceptionPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextExceptionPrefix.TabIndex := 3;
  Self.TextExceptionPrefix.Text := 'E';
  Self.TextExceptionPrefix.WordWrap := False;
  // 
  // TextClassPrefix
  // 
  Self.TextClassPrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextClassPrefix.AutoSize := False;
  Self.TextClassPrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextClassPrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextClassPrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextClassPrefix.Location := System.Drawing.Point.Create(180, 12);
  Self.TextClassPrefix.Name := 'TextClassPrefix';
  Self.TextClassPrefix.Size := System.Drawing.Size.Create(64, 18);
  Self.TextClassPrefix.TabIndex := 0;
  Self.TextClassPrefix.Text := 'T';
  Self.TextClassPrefix.WordWrap := False;
  // 
  // TextCustomNamePrefix
  // 
  Self.TextCustomNamePrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextCustomNamePrefix.AutoSize := False;
  Self.TextCustomNamePrefix.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.TextCustomNamePrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.TextCustomNamePrefix.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.TextCustomNamePrefix.Location := System.Drawing.Point.Create(100, 116);
  Self.TextCustomNamePrefix.Name := 'TextCustomNamePrefix';
  Self.TextCustomNamePrefix.Size := System.Drawing.Size.Create(148, 18);
  Self.TextCustomNamePrefix.TabIndex := 11;
  Self.TextCustomNamePrefix.Text := '';
  Self.TextCustomNamePrefix.WordWrap := False;
  Include(Self.TextCustomNamePrefix.KeyDown, Self.TextCustomNamePrefix_KeyDown);
  // 
  // ListNamespacePrefixes
  // 
  Self.ListNamespacePrefixes.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ListNamespacePrefixes.BackColor := System.Drawing.SystemColors.Window;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNamespacePrefixes, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNamespacePrefixes.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.ListNamespacePrefixes.CheckOnClick := True;
  Self.ListNamespacePrefixes.IntegralHeight := False;
  Self.ListNamespacePrefixes.Location := System.Drawing.Point.Create(100, 28);
  Self.ListNamespacePrefixes.Name := 'ListNamespacePrefixes';
  Self.ListNamespacePrefixes.Size := System.Drawing.Size.Create(148, 84);
  Self.ListNamespacePrefixes.TabIndex := 9;
  Include(Self.ListNamespacePrefixes.ItemCheck, Self.ListNamespacePrefixes_ItemCheck);
  // 
  // LabelCustomNamePrefix
  // 
  Self.LabelCustomNamePrefix.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.LabelCustomNamePrefix, System.Windows.Forms.Border3DStyle.Adjust);
  Self.LabelCustomNamePrefix.Location := System.Drawing.Point.Create(100, 8);
  Self.LabelCustomNamePrefix.Name := 'LabelCustomNamePrefix';
  Self.LabelCustomNamePrefix.Size := System.Drawing.Size.Create(124, 16);
  Self.LabelCustomNamePrefix.TabIndex := 10;
  Self.LabelCustomNamePrefix.Text := 'Custom Name / Prefix';
  // 
  // BtnOk
  // 
  Self.BtnOk.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnOk.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnOk, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnOk.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnOk.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnOk.Location := System.Drawing.Point.Create(98, 184);
  Self.BtnOk.Name := 'BtnOk';
  Self.BtnOk.TabIndex := 1;
  Self.BtnOk.Text := '&Ok';
  Include(Self.BtnOk.Click, Self.BtnOk_Click);
  // 
  // BtnCancel
  // 
  Self.BtnCancel.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BtnCancel.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnCancel, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.BtnCancel.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnCancel.Location := System.Drawing.Point.Create(178, 184);
  Self.BtnCancel.Name := 'BtnCancel';
  Self.BtnCancel.TabIndex := 2;
  Self.BtnCancel.Text := '&Cancel';
  // 
  // BtnReload
  // 
  Self.BtnReload.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left)));
  Self.BtnReload.BackColor := System.Drawing.Color.LightSteelBlue;
  Self.BorderExtender.SetBorder3DStyle(Self.BtnReload, System.Windows.Forms.Border3DStyle.Adjust);
  Self.BtnReload.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnReload.FlatStyle := System.Windows.Forms.FlatStyle.Popup;
  Self.BtnReload.Location := System.Drawing.Point.Create(5, 184);
  Self.BtnReload.Name := 'BtnReload';
  Self.BtnReload.TabIndex := 3;
  Self.BtnReload.Text := '&Reload';
  Include(Self.BtnReload.Click, Self.BtnReload_Click);
  // 
  // PanelCustom
  // 
  Self.PanelCustom.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.PanelCustom, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelCustom.Controls.Add(Self.LabelCustomNamePrefix);
  Self.PanelCustom.Controls.Add(Self.ListNamespacePrefixes);
  Self.PanelCustom.Controls.Add(Self.TextCustomNamePrefix);
  Self.PanelCustom.DockPadding.All := 1;
  Self.PanelCustom.Location := System.Drawing.Point.Create(0, 0);
  Self.PanelCustom.Name := 'PanelCustom';
  Self.PanelCustom.Size := System.Drawing.Size.Create(258, 177);
  Self.PanelCustom.TabIndex := 4;
  // 
  // CheckAttribute
  // 
  Self.CheckAttribute.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.BorderExtender.SetBorder3DStyle(Self.CheckAttribute, System.Windows.Forms.Border3DStyle.Adjust);
  Self.CheckAttribute.CheckAlign := System.Drawing.ContentAlignment.MiddleRight;
  Self.CheckAttribute.FlatStyle := System.Windows.Forms.FlatStyle.Flat;
  Self.CheckAttribute.Location := System.Drawing.Point.Create(96, 148);
  Self.CheckAttribute.Name := 'CheckAttribute';
  Self.CheckAttribute.Size := System.Drawing.Size.Create(148, 16);
  Self.CheckAttribute.TabIndex := 10;
  Self.CheckAttribute.Text := 'Do not rename Attributes';
  Self.CheckAttribute.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // TFormOptions
  // 
  Self.AcceptButton := Self.BtnOk;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.BtnCancel;
  Self.ClientSize := System.Drawing.Size.Create(258, 213);
  Self.Controls.Add(Self.BtnReload);
  Self.Controls.Add(Self.BtnCancel);
  Self.Controls.Add(Self.BtnOk);
  Self.Controls.Add(Self.PanelNormal);
  Self.Controls.Add(Self.PanelCustom);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedDialog;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TFormOptions';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterParent;
  Self.PanelNormal.ResumeLayout(False);
  Self.PanelCustom.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormOptions.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    if Components <> nil then
      Components.Dispose;
  end;
  inherited Dispose(Disposing);
end;

constructor TFormOptions.Create;
begin
  inherited Create;
  InitializeComponent;
  Text := System.String.Format('{0} {1}',[TApplication.ProductName,'Options']);
  try
    FOptions := TOptions.Load;
  except
    FOptions := TOptions.Create;
  end;
  FRefreshRequired := false;
end;

procedure TFormOptions.BtnReload_Click(sender: TObject; e: TEventArgs);
begin
  try
    FOptions := TOptions.Load;
  except
    ;
  end;
end;

procedure TFormOptions.BtnOk_Click(sender: TObject; e: TEventArgs);
begin
  FRefreshRequired := FRefreshRequired or ControlsToOptions(FOptions);
  if ListNamespacePrefixes.Enabled then
    FOptions.SetKnownNamespace(SelectedName,TextCustomNamePrefix.Text.Trim,SelectedExclude)
  else if TextCustomNamePrefix.Enabled then
    FOptions.SetKnownType(SelectedName,TextCustomNamePrefix.Text.Trim,SelectedExclude);
  FOptions.Store;
end;

procedure TFormOptions.ListNamespacePrefixes_ItemCheck(sender: TObject; e: TItemCheckEventArgs);
var
  I: Integer;
  Prefix: TStringBuilder;
begin
  FRefreshRequired := true;
  Prefix := TStringBuilder.Create;
  for I := 0 to Pred(ListNamespacePrefixes.Items.Count) do
    if ListNamespacePrefixes.GetItemChecked(I) xor (I = e.Index) then begin
      Prefix.Append(string(ListNamespacePrefixes.Items[I]));
      Prefix.Append('.');
    end;
  Prefix.Length := TMath.Max(Prefix.Length - 1,0);
  TextCustomNamePrefix.Text := Prefix.ToString;
end;

procedure TFormOptions.TextCustomNamePrefix_KeyDown(sender: TObject; e: TKeyEventArgs);
var
  I: Integer;
begin
  FRefreshRequired := true;
  if ListNamespacePrefixes.Enabled then begin
    Exclude(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
    for I := 0 to Pred(ListNamespacePrefixes.Items.Count) do
      ListNamespacePrefixes.SetItemChecked(I,false);
    Include(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
  end;
end;

function TFormOptions.ControlsToOptions(Options: TOptions): Boolean;
begin
  Result := false;
  with Options do begin
    Result := Result or (ClassPrefix <> TextClassPrefix.Text.Trim);
    ClassPrefix := TextClassPrefix.Text.Trim;
    Result := Result or (RecordPrefix <> TextRecordPrefix.Text.Trim);
    RecordPrefix := TextRecordPrefix.Text.Trim;
    Result := Result or (EnumeratedPrefix <> TextEnumeratedPrefix.Text.Trim);
    EnumeratedPrefix := TextEnumeratedPrefix.Text.Trim;
    Result := Result or (ExceptionPrefix <> TextExceptionPrefix.Text.Trim);
    ExceptionPrefix := TextExceptionPrefix.Text.Trim;
    Result := Result or (RemoveExceptionPostfix <> CheckException.Checked);
    RemoveExceptionPostfix := CheckException.Checked;
    Result := Result or (RemoveClassPostfix <> CheckClass.Checked);
    RemoveClassPostfix := CheckClass.Checked;
    Result := Result or (DoNotRenameAttributes <> CheckAttribute.Checked);
    DoNotRenameAttributes := CheckAttribute.Checked;
    FullOptionsInUnits := CheckFullOptionsInUnits.Checked;
  end;
end;

procedure TFormOptions.OptionsToControls(Options: TOptions);
begin
  with Options do begin
    TextClassPrefix.Text := ClassPrefix;
    TextRecordPrefix.Text := RecordPrefix;
    TextEnumeratedPrefix.Text := EnumeratedPrefix;
    TextExceptionPrefix.Text := ExceptionPrefix;
    CheckException.Checked := RemoveExceptionPostfix;
    CheckClass.Checked := RemoveClassPostfix;
    CheckAttribute.Checked := DoNotRenameAttributes;
    CheckFullOptionsInUnits.Checked := FullOptionsInUnits;
  end;
end;

function TFormOptions.get_Options: TOptions;
begin
  Result := FOptions.Clone as TOptions;
end;

procedure TFormOptions.set_Options(const Value: TOptions);
begin
  FOptions := Value.Clone as TOptions;
  FOptions.Store;
end;

function TFormOptions.ShowDialog: TDialogResult;
begin
  FRefreshRequired := false;
  PanelCustom.Visible := false;
  PanelNormal.Visible := true;
  ListNamespacePrefixes.Enabled := false;
  TextCustomNamePrefix.Enabled := false;
  ListNamespacePrefixes.BackColor := BorderExtender.TweakColor(BackColor,10);
  TextCustomNamePrefix.BackColor := ListNamespacePrefixes.BackColor;
  SelectedName := '';
  SelectedExclude := false;
  ListNamespacePrefixes.Items.Clear;
  TextCustomNamePrefix.Text := '';
  OptionsToControls(FOptions);
  Result := inherited ShowDialog;
end;

function TFormOptions.ShowDialogNamespace(Namespace,CustomPrefix: string; Exclude_: Boolean): TDialogResult;
var
  Tokens: array of string;
  KnownNamespace: TKnownNamespace;
  I,J: Integer;
begin
  FRefreshRequired := false;
  PanelCustom.Visible := true;
  PanelNormal.Visible := false;
  ListNamespacePrefixes.Enabled := true;
  TextCustomNamePrefix.Enabled := true;
  ListNamespacePrefixes.BackColor := RColor.FromKnownColor(KnownColor.Window);
  TextCustomNamePrefix.BackColor := RColor.FromKnownColor(KnownColor.Window);
  SelectedName := Namespace;
  SelectedExclude := Exclude_;
  ListNamespacePrefixes.Items.Clear;
  TextCustomNamePrefix.Text := CustomPrefix;
  Exclude(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
  Tokens := Namespace.Split(['.']);
  for I := 0 to Pred(Length(Tokens)) do
    ListNamespacePrefixes.Items.Add(Tokens[I]);
  with FOptions.GetHashedKnownNamespaces do begin
    KnownNamespace := TKnownNamespace(Item[Namespace.ToUpper]);
    if Assigned(KnownNamespace) then
      if KnownNamespace.Prefix <> '' then begin
        Tokens := KnownNamespace.Prefix.Split(['.']);
        for I := 0 to Pred(Length(Tokens)) do begin
          J := ListNamespacePrefixes.Items.IndexOf(Tokens[I]);
          if J >= 0 then
            ListNamespacePrefixes.SetItemChecked(J,true);
        end;
      end;
  end;
  Include(ListNamespacePrefixes.ItemCheck,ListNamespacePrefixes_ItemCheck);
  OptionsToControls(FOptions);
  Result := inherited ShowDialog;
end;

function TFormOptions.ShowDialogName(Name,CustomName: string; Exclude: Boolean): TDialogResult;
begin
  FRefreshRequired := false;
  PanelCustom.Visible := true;
  PanelNormal.Visible := false;
  ListNamespacePrefixes.Enabled := false;
  TextCustomNamePrefix.Enabled := true;
  ListNamespacePrefixes.BackColor := BorderExtender.TweakColor(BackColor,10);
  TextCustomNamePrefix.BackColor := Color.FromKnownColor(KnownColor.Window);
  SelectedName := Name;
  SelectedExclude := Exclude;
  ListNamespacePrefixes.Items.Clear;
  TextCustomNamePrefix.Text := CustomName;
  OptionsToControls(FOptions);
  Result := inherited ShowDialog;
end;


end.
