unit Main;

interface

uses
  Invisibles.ExceptionHandler,
  Options,
  System.Collections,
  System.Collections.T,
  System.ComponentModel,
  System.ComponentModel.T,
  System.Drawing,
  System.Drawing.T,
  System.Reflection,
  System.Reflection.T,
  System.Resources,
  System.Resources.T,
  System.T,
  System.Text,
  System.Text.T,
  System.Windows.Forms,
  System.Windows.Forms.T,
  TD.SandBar,
  TD.SandBar.T,
  Visibles.BorderExtender;

type
  TFormMain = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    DialogLoad: System.Windows.Forms.OpenFileDialog;
    BorderExtender: Visibles.BorderExtender.TBorderExtender;
    ItemAssembly: TD.SandBar.MenuBarItem;
    ItemLoad: TD.SandBar.MenuButtonItem;
    ItemPrefixUnit: TD.SandBar.MenuBarItem;
    ItemGenerate: TD.SandBar.MenuButtonItem;
    ItemOptions: TD.SandBar.MenuButtonItem;
    ItemExit: TD.SandBar.MenuButtonItem;
    ExceptionHandler: Invisibles.ExceptionHandler.TExceptionHandler;
    ItemAbout: TD.SandBar.MenuButtonItem;
    ItemNamespacesUncheckAll: TD.SandBar.MenuButtonItem;
    ItemNamespacesCheckAll: TD.SandBar.MenuButtonItem;
    ContextMenuNames: TD.SandBar.ContextMenuBarItem;
    ItemNamesUncheckAll: TD.SandBar.MenuButtonItem;
    ItemNamesCheckAll: TD.SandBar.MenuButtonItem;
    ImageList: System.Windows.Forms.ImageList;
    PanelAssemblies: System.Windows.Forms.Panel;
    StatusBar: System.Windows.Forms.StatusBar;
    SplitterAssemblies: System.Windows.Forms.Splitter;
    PanelMore: System.Windows.Forms.Panel;
    PanelNamespaces: System.Windows.Forms.Panel;
    SplitterNamespaces: System.Windows.Forms.Splitter;
    PanelNames: System.Windows.Forms.Panel;
    ListNames: System.Windows.Forms.ListView;
    ColumnFCLName: System.Windows.Forms.ColumnHeader;
    ColumnTName: System.Windows.Forms.ColumnHeader;
    ListNamespaces: System.Windows.Forms.ListView;
    ColumnNamespaceName: System.Windows.Forms.ColumnHeader;
    ColumnNamespacePrefix: System.Windows.Forms.ColumnHeader;
    ListAssemblies: System.Windows.Forms.ListView;
    ColumnAssemblyName: System.Windows.Forms.ColumnHeader;
    ColumnAssemblyLocation: System.Windows.Forms.ColumnHeader;
    StatusBarAssemblies: System.Windows.Forms.StatusBarPanel;
    ItemClear: TD.SandBar.MenuButtonItem;
    ItemNamesSave: TD.SandBar.MenuButtonItem;
    ItemNamespacesSave: TD.SandBar.MenuButtonItem;
    ItemNamesTweak: TD.SandBar.MenuButtonItem;
    ItemNamespacesTweak: TD.SandBar.MenuButtonItem;
    SandBarManager: TD.SandBar.SandBarManager;
    leftSandBarDock: TD.SandBar.ToolBarContainer;
    rightSandBarDock: TD.SandBar.ToolBarContainer;
    bottomSandBarDock: TD.SandBar.ToolBarContainer;
    topSandBarDock: TD.SandBar.ToolBarContainer;
    MenuBar: TD.SandBar.MenuBar;
    ItemMerge: TD.SandBar.MenuButtonItem;
    ItemMergeAll: TD.SandBar.MenuButtonItem;
    ContextMenuNamespaces: TD.SandBar.ContextMenuBarItem;
    ItemGenerateTypeList: TD.SandBar.MenuButtonItem;
    ItemAppendToTypeList: TD.SandBar.MenuButtonItem;
    DialogSave: System.Windows.Forms.SaveFileDialog;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ItemLoad_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemGenerate_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemOptions_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemExit_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemAbout_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesCheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesCheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesUncheckAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemMerge_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemMergeAll_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemClear_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamesSave_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesSave_Click(sender: System.Object; e: System.EventArgs);
    procedure ListNamespaces_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
    procedure ListNames_ItemCheck(sender: System.Object; e: System.Windows.Forms.ItemCheckEventArgs);
    procedure ItemNamesTweak_Click(sender: System.Object; e: System.EventArgs);
    procedure ItemNamespacesTweak_Click(sender: System.Object; e: System.EventArgs);
    procedure ContextMenuNames_BeforePopup(sender: System.Object; e: TD.SandBar.MenuPopupEventArgs);
    procedure ContextMenuNamespaces_BeforePopup(sender: System.Object; e: TD.SandBar.MenuPopupEventArgs);
    procedure ItemPrefixUnit_BeforePopup(sender: System.Object; e: TD.SandBar.MenuPopupEventArgs);
    procedure ItemAssembly_BeforePopup(sender: System.Object; e: TD.SandBar.MenuPopupEventArgs);
    procedure ItemGenerateTypeList_Activate(sender: System.Object; e: System.EventArgs);
    procedure ItemAppendToTypeList_Activate(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    procedure Dispose(Disposing: Boolean); override;
  strict private
    DialogFolder: TFolderBrowserDialog;
    FormOptions: TFormOptions;
    Options: TOptions;
    ApplicationSts: TApplicationSts;
    INames,Names,Namespaces: THashTable;
    procedure AllCheckedTo(Value: Boolean; List: TListView);
    function GetSubitem(Subitems: TListViewItem.ListViewSubItemCollection; Index: Integer): TListViewItem.ListViewSubItem;
    procedure ReflectAssembly(AAssembly: TAssembly; ListIndex: Integer; Refresh: Boolean);
    procedure Generate(StoreFolderPath: string);
    procedure GenerateTypeList(StoreFolderPath: string; Append: Boolean);
  public
    constructor Create;
  end;

implementation

uses
  About,
  System.IO,
  System.IO.T,
  System.Runtime.InteropServices,
  System.Runtime.InteropServices.T,
  TypeList;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFormMain.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_StatusBarPanel = array of System.Windows.Forms.StatusBarPanel;
  TArrayOfSystem_Windows_Forms_ColumnHeader = array of System.Windows.Forms.ColumnHeader;
  TArrayOfTD_SandBar_ToolbarItemBase = array of TD.SandBar.ToolbarItemBase;
  TArrayOfTD_SandBar_MenuButtonItem = array of TD.SandBar.MenuButtonItem;
var
  resources: System.Resources.ResourceManager;
begin
  Self.components := System.ComponentModel.Container.Create;
  resources := System.Resources.ResourceManager.Create(TypeOf(TFormMain));
  Self.DialogLoad := System.Windows.Forms.OpenFileDialog.Create;
  Self.BorderExtender := Visibles.BorderExtender.TBorderExtender.Create;
  Self.StatusBar := System.Windows.Forms.StatusBar.Create;
  Self.StatusBarAssemblies := System.Windows.Forms.StatusBarPanel.Create;
  Self.PanelAssemblies := System.Windows.Forms.Panel.Create;
  Self.ListAssemblies := System.Windows.Forms.ListView.Create;
  Self.ColumnAssemblyName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnAssemblyLocation := System.Windows.Forms.ColumnHeader.Create;
  Self.ImageList := System.Windows.Forms.ImageList.Create(Self.components);
  Self.SplitterAssemblies := System.Windows.Forms.Splitter.Create;
  Self.PanelMore := System.Windows.Forms.Panel.Create;
  Self.PanelNames := System.Windows.Forms.Panel.Create;
  Self.ListNames := System.Windows.Forms.ListView.Create;
  Self.ColumnFCLName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnTName := System.Windows.Forms.ColumnHeader.Create;
  Self.SplitterNamespaces := System.Windows.Forms.Splitter.Create;
  Self.PanelNamespaces := System.Windows.Forms.Panel.Create;
  Self.ListNamespaces := System.Windows.Forms.ListView.Create;
  Self.ColumnNamespaceName := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnNamespacePrefix := System.Windows.Forms.ColumnHeader.Create;
  Self.leftSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.SandBarManager := TD.SandBar.SandBarManager.Create;
  Self.bottomSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.rightSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.topSandBarDock := TD.SandBar.ToolBarContainer.Create;
  Self.MenuBar := TD.SandBar.MenuBar.Create;
  Self.ContextMenuNames := TD.SandBar.ContextMenuBarItem.Create;
  Self.ItemNamesUncheckAll := TD.SandBar.MenuButtonItem.Create;
  Self.ItemNamesCheckAll := TD.SandBar.MenuButtonItem.Create;
  Self.ItemNamesTweak := TD.SandBar.MenuButtonItem.Create;
  Self.ItemNamesSave := TD.SandBar.MenuButtonItem.Create;
  Self.ContextMenuNamespaces := TD.SandBar.ContextMenuBarItem.Create;
  Self.ItemNamespacesUncheckAll := TD.SandBar.MenuButtonItem.Create;
  Self.ItemNamespacesCheckAll := TD.SandBar.MenuButtonItem.Create;
  Self.ItemNamespacesTweak := TD.SandBar.MenuButtonItem.Create;
  Self.ItemNamespacesSave := TD.SandBar.MenuButtonItem.Create;
  Self.ItemAssembly := TD.SandBar.MenuBarItem.Create;
  Self.ItemLoad := TD.SandBar.MenuButtonItem.Create;
  Self.ItemMerge := TD.SandBar.MenuButtonItem.Create;
  Self.ItemMergeAll := TD.SandBar.MenuButtonItem.Create;
  Self.ItemClear := TD.SandBar.MenuButtonItem.Create;
  Self.ItemExit := TD.SandBar.MenuButtonItem.Create;
  Self.ItemPrefixUnit := TD.SandBar.MenuBarItem.Create;
  Self.ItemGenerate := TD.SandBar.MenuButtonItem.Create;
  Self.ItemGenerateTypeList := TD.SandBar.MenuButtonItem.Create;
  Self.ItemAppendToTypeList := TD.SandBar.MenuButtonItem.Create;
  Self.ItemOptions := TD.SandBar.MenuButtonItem.Create;
  Self.ItemAbout := TD.SandBar.MenuButtonItem.Create;
  Self.ExceptionHandler := Invisibles.ExceptionHandler.TExceptionHandler.Create;
  Self.DialogSave := System.Windows.Forms.SaveFileDialog.Create;
  (System.ComponentModel.ISupportInitialize(Self.StatusBarAssemblies)).BeginInit;
  Self.PanelAssemblies.SuspendLayout;
  Self.PanelMore.SuspendLayout;
  Self.PanelNames.SuspendLayout;
  Self.PanelNamespaces.SuspendLayout;
  Self.topSandBarDock.SuspendLayout;
  Self.SuspendLayout;
  // 
  // DialogLoad
  // 
  Self.DialogLoad.DefaultExt := '*.dll';
  Self.DialogLoad.Filter := 'Libraries (*.dll)|*.dll|Apps (*.exe)|*.exe';
  Self.DialogLoad.InitialDirectory := '.';
  Self.DialogLoad.Title := 'Load Assembly';
  // 
  // StatusBar
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.StatusBar, System.Windows.Forms.Border3DStyle.Adjust);
  Self.StatusBar.Location := System.Drawing.Point.Create(1, 507);
  Self.StatusBar.Name := 'StatusBar';
  Self.StatusBar.Panels.AddRange(TArrayOfSystem_Windows_Forms_StatusBarPanel.Create(Self.StatusBarAssemblies));
  Self.StatusBar.ShowPanels := True;
  Self.StatusBar.Size := System.Drawing.Size.Create(646, 22);
  Self.StatusBar.TabIndex := 0;
  // 
  // StatusBarAssemblies
  // 
  Self.StatusBarAssemblies.AutoSize := System.Windows.Forms.StatusBarPanelAutoSize.Spring;
  Self.StatusBarAssemblies.Width := 630;
  // 
  // PanelAssemblies
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.PanelAssemblies, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelAssemblies.Controls.Add(Self.ListAssemblies);
  Self.PanelAssemblies.Dock := System.Windows.Forms.DockStyle.Top;
  Self.PanelAssemblies.Location := System.Drawing.Point.Create(1, 25);
  Self.PanelAssemblies.Name := 'PanelAssemblies';
  Self.PanelAssemblies.Size := System.Drawing.Size.Create(646, 56);
  Self.PanelAssemblies.TabIndex := 1;
  // 
  // ListAssemblies
  // 
  Self.ListAssemblies.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListAssemblies, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListAssemblies.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListAssemblies.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnAssemblyName, 
          Self.ColumnAssemblyLocation));
  Self.ListAssemblies.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListAssemblies.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListAssemblies.Location := System.Drawing.Point.Create(0, 0);
  Self.ListAssemblies.Name := 'ListAssemblies';
  Self.ListAssemblies.Size := System.Drawing.Size.Create(646, 56);
  Self.ListAssemblies.SmallImageList := Self.ImageList;
  Self.ListAssemblies.StateImageList := Self.ImageList;
  Self.ListAssemblies.TabIndex := 8;
  Self.ListAssemblies.View := System.Windows.Forms.View.Details;
  // 
  // ColumnAssemblyName
  // 
  Self.ColumnAssemblyName.Text := 'Assemblies';
  Self.ColumnAssemblyName.Width := 366;
  // 
  // ColumnAssemblyLocation
  // 
  Self.ColumnAssemblyLocation.Text := 'Locations';
  Self.ColumnAssemblyLocation.Width := 280;
  // 
  // ImageList
  // 
  Self.ImageList.ImageSize := System.Drawing.Size.Create(16, 16);
  Self.ImageList.ImageStream := (System.Windows.Forms.ImageListStreamer(resources.GetObject('I' +
    'mageList.ImageStream')));
  Self.ImageList.TransparentColor := System.Drawing.Color.Transparent;
  // 
  // SplitterAssemblies
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.SplitterAssemblies, System.Windows.Forms.Border3DStyle.RaisedInner);
  Self.SplitterAssemblies.Dock := System.Windows.Forms.DockStyle.Top;
  Self.SplitterAssemblies.Location := System.Drawing.Point.Create(1, 81);
  Self.SplitterAssemblies.MinExtra := 150;
  Self.SplitterAssemblies.MinSize := 50;
  Self.SplitterAssemblies.Name := 'SplitterAssemblies';
  Self.SplitterAssemblies.Size := System.Drawing.Size.Create(646, 3);
  Self.SplitterAssemblies.TabIndex := 2;
  Self.SplitterAssemblies.TabStop := False;
  // 
  // PanelMore
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.PanelMore, System.Windows.Forms.Border3DStyle.Adjust);
  Self.PanelMore.Controls.Add(Self.PanelNames);
  Self.PanelMore.Controls.Add(Self.SplitterNamespaces);
  Self.PanelMore.Controls.Add(Self.PanelNamespaces);
  Self.PanelMore.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.PanelMore.DockPadding.All := 1;
  Self.PanelMore.Location := System.Drawing.Point.Create(1, 84);
  Self.PanelMore.Name := 'PanelMore';
  Self.PanelMore.Size := System.Drawing.Size.Create(646, 423);
  Self.PanelMore.TabIndex := 3;
  // 
  // PanelNames
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.PanelNames, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelNames.Controls.Add(Self.ListNames);
  Self.PanelNames.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.PanelNames.Location := System.Drawing.Point.Create(1, 128);
  Self.PanelNames.Name := 'PanelNames';
  Self.PanelNames.Size := System.Drawing.Size.Create(644, 294);
  Self.PanelNames.TabIndex := 2;
  // 
  // ListNames
  // 
  Self.ListNames.AutoArrange := False;
  Self.ListNames.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNames, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNames.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListNames.CheckBoxes := True;
  Self.ListNames.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnFCLName, 
          Self.ColumnTName));
  Self.ListNames.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListNames.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListNames.HideSelection := False;
  Self.ListNames.Location := System.Drawing.Point.Create(0, 0);
  Self.ListNames.Name := 'ListNames';
  Self.MenuBar.SetSandBarMenu(Self.ListNames, Self.ContextMenuNames);
  Self.ListNames.Size := System.Drawing.Size.Create(644, 294);
  Self.ListNames.SmallImageList := Self.ImageList;
  Self.ListNames.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListNames.TabIndex := 5;
  Self.ListNames.View := System.Windows.Forms.View.Details;
  Include(Self.ListNames.ItemCheck, Self.ListNames_ItemCheck);
  // 
  // ColumnFCLName
  // 
  Self.ColumnFCLName.Text := '.NET Names';
  Self.ColumnFCLName.Width := 366;
  // 
  // ColumnTName
  // 
  Self.ColumnTName.Text := 'Delphi Names';
  Self.ColumnTName.Width := 280;
  // 
  // SplitterNamespaces
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.SplitterNamespaces, System.Windows.Forms.Border3DStyle.RaisedInner);
  Self.SplitterNamespaces.Dock := System.Windows.Forms.DockStyle.Top;
  Self.SplitterNamespaces.Location := System.Drawing.Point.Create(1, 125);
  Self.SplitterNamespaces.MinExtra := 150;
  Self.SplitterNamespaces.MinSize := 100;
  Self.SplitterNamespaces.Name := 'SplitterNamespaces';
  Self.SplitterNamespaces.Size := System.Drawing.Size.Create(644, 3);
  Self.SplitterNamespaces.TabIndex := 1;
  Self.SplitterNamespaces.TabStop := False;
  // 
  // PanelNamespaces
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.PanelNamespaces, System.Windows.Forms.Border3DStyle.SunkenOuter);
  Self.PanelNamespaces.Controls.Add(Self.ListNamespaces);
  Self.PanelNamespaces.Dock := System.Windows.Forms.DockStyle.Top;
  Self.PanelNamespaces.Location := System.Drawing.Point.Create(1, 1);
  Self.PanelNamespaces.Name := 'PanelNamespaces';
  Self.PanelNamespaces.Size := System.Drawing.Size.Create(644, 124);
  Self.PanelNamespaces.TabIndex := 0;
  // 
  // ListNamespaces
  // 
  Self.ListNamespaces.AutoArrange := False;
  Self.ListNamespaces.BackColor := System.Drawing.SystemColors.Control;
  Self.BorderExtender.SetBorder3DStyle(Self.ListNamespaces, System.Windows.Forms.Border3DStyle.Adjust);
  Self.ListNamespaces.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListNamespaces.CheckBoxes := True;
  Self.ListNamespaces.Columns.AddRange(TArrayOfSystem_Windows_Forms_ColumnHeader.Create(Self.ColumnNamespaceName, 
          Self.ColumnNamespacePrefix));
  Self.ListNamespaces.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListNamespaces.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListNamespaces.HideSelection := False;
  Self.ListNamespaces.Location := System.Drawing.Point.Create(0, 0);
  Self.ListNamespaces.Name := 'ListNamespaces';
  Self.MenuBar.SetSandBarMenu(Self.ListNamespaces, Self.ContextMenuNamespaces);
  Self.ListNamespaces.Size := System.Drawing.Size.Create(644, 124);
  Self.ListNamespaces.SmallImageList := Self.ImageList;
  Self.ListNamespaces.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListNamespaces.TabIndex := 7;
  Self.ListNamespaces.View := System.Windows.Forms.View.Details;
  Include(Self.ListNamespaces.ItemCheck, Self.ListNamespaces_ItemCheck);
  // 
  // ColumnNamespaceName
  // 
  Self.ColumnNamespaceName.Text := 'Namespaces';
  Self.ColumnNamespaceName.Width := 366;
  // 
  // ColumnNamespacePrefix
  // 
  Self.ColumnNamespacePrefix.Text := 'Prefixes';
  Self.ColumnNamespacePrefix.Width := 280;
  // 
  // leftSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.leftSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.leftSandBarDock.Dock := System.Windows.Forms.DockStyle.Left;
  Self.leftSandBarDock.Location := System.Drawing.Point.Create(1, 25);
  Self.leftSandBarDock.Manager := Self.SandBarManager;
  Self.leftSandBarDock.Name := 'leftSandBarDock';
  Self.leftSandBarDock.Size := System.Drawing.Size.Create(0, 504);
  Self.leftSandBarDock.TabIndex := 4;
  // 
  // SandBarManager
  // 
  Self.SandBarManager.BottomContainer := Self.bottomSandBarDock;
  Self.SandBarManager.LeftContainer := Self.leftSandBarDock;
  Self.SandBarManager.OwnerForm := Self;
  Self.SandBarManager.Renderer := TD.SandBar.Office2002Renderer.Create;
  Self.SandBarManager.RightContainer := Self.rightSandBarDock;
  Self.SandBarManager.TopContainer := Self.topSandBarDock;
  // 
  // bottomSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.bottomSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.bottomSandBarDock.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.bottomSandBarDock.Location := System.Drawing.Point.Create(1, 529);
  Self.bottomSandBarDock.Manager := Self.SandBarManager;
  Self.bottomSandBarDock.Name := 'bottomSandBarDock';
  Self.bottomSandBarDock.Size := System.Drawing.Size.Create(646, 0);
  Self.bottomSandBarDock.TabIndex := 6;
  // 
  // rightSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.rightSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.rightSandBarDock.Dock := System.Windows.Forms.DockStyle.Right;
  Self.rightSandBarDock.Location := System.Drawing.Point.Create(647, 25);
  Self.rightSandBarDock.Manager := Self.SandBarManager;
  Self.rightSandBarDock.Name := 'rightSandBarDock';
  Self.rightSandBarDock.Size := System.Drawing.Size.Create(0, 504);
  Self.rightSandBarDock.TabIndex := 5;
  // 
  // topSandBarDock
  // 
  Self.BorderExtender.SetBorder3DStyle(Self.topSandBarDock, System.Windows.Forms.Border3DStyle.Adjust);
  Self.topSandBarDock.Controls.Add(Self.MenuBar);
  Self.topSandBarDock.Dock := System.Windows.Forms.DockStyle.Top;
  Self.topSandBarDock.Location := System.Drawing.Point.Create(1, 1);
  Self.topSandBarDock.Manager := Self.SandBarManager;
  Self.topSandBarDock.Name := 'topSandBarDock';
  Self.topSandBarDock.Size := System.Drawing.Size.Create(646, 24);
  Self.topSandBarDock.TabIndex := 7;
  // 
  // MenuBar
  // 
  Self.MenuBar.AddRemoveButtonsVisible := False;
  Self.BorderExtender.SetBorder3DStyle(Self.MenuBar, System.Windows.Forms.Border3DStyle.Adjust);
  Self.MenuBar.Buttons.AddRange(TArrayOfTD_SandBar_ToolbarItemBase.Create(Self.ItemAssembly, 
          Self.ItemPrefixUnit, Self.ContextMenuNames, Self.ContextMenuNamespaces));
  Self.MenuBar.Guid := System.Guid.Create('2a41f0af-5f64-4fad-98db-b71d699fd' +
    'fe9');
  Self.MenuBar.Location := System.Drawing.Point.Create(2, 0);
  Self.MenuBar.Movable := False;
  Self.MenuBar.Name := 'MenuBar';
  Self.MenuBar.Size := System.Drawing.Size.Create(644, 24);
  Self.MenuBar.TabIndex := 0;
  Self.MenuBar.Tearable := False;
  Self.MenuBar.Text := '';
  // 
  // ContextMenuNames
  // 
  Self.ContextMenuNames.MenuItems.AddRange(TArrayOfTD_SandBar_MenuButtonItem.Create(Self.ItemNamesUncheckAll, 
          Self.ItemNamesCheckAll, Self.ItemNamesTweak, Self.ItemNamesSave));
  Self.ContextMenuNames.Text := '(ContextMenuNames)';
  Include(Self.ContextMenuNames.BeforePopup, Self.ContextMenuNames_BeforePopup);
  // 
  // ItemNamesUncheckAll
  // 
  Self.ItemNamesUncheckAll.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temNamesUncheckAll.Image')));
  Self.ItemNamesUncheckAll.Text := '&Uncheck All';
  Include(Self.ItemNamesUncheckAll.Activate, Self.ItemNamesUncheckAll_Click);
  // 
  // ItemNamesCheckAll
  // 
  Self.ItemNamesCheckAll.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temNamesCheckAll.Image')));
  Self.ItemNamesCheckAll.Text := '&Check All';
  Include(Self.ItemNamesCheckAll.Activate, Self.ItemNamesCheckAll_Click);
  // 
  // ItemNamesTweak
  // 
  Self.ItemNamesTweak.BeginGroup := True;
  Self.ItemNamesTweak.Image := (System.Drawing.Image(resources.GetObject('It' +
    'emNamesTweak.Image')));
  Self.ItemNamesTweak.Text := '&Tweak...';
  Include(Self.ItemNamesTweak.Activate, Self.ItemNamesTweak_Click);
  // 
  // ItemNamesSave
  // 
  Self.ItemNamesSave.BeginGroup := True;
  Self.ItemNamesSave.Image := (System.Drawing.Image(resources.GetObject('Ite' +
    'mNamesSave.Image')));
  Self.ItemNamesSave.Text := '&Save';
  Include(Self.ItemNamesSave.Activate, Self.ItemNamesSave_Click);
  // 
  // ContextMenuNamespaces
  // 
  Self.ContextMenuNamespaces.MenuItems.AddRange(TArrayOfTD_SandBar_MenuButtonItem.Create(Self.ItemNamespacesUncheckAll, 
          Self.ItemNamespacesCheckAll, Self.ItemNamespacesTweak, Self.ItemNamespacesSave));
  Self.ContextMenuNamespaces.Text := '(ContextMenuNamespaces)';
  Include(Self.ContextMenuNamespaces.BeforePopup, Self.ContextMenuNamespaces_BeforePopup);
  // 
  // ItemNamespacesUncheckAll
  // 
  Self.ItemNamespacesUncheckAll.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temNamespacesUncheckAll.Image')));
  Self.ItemNamespacesUncheckAll.Text := '&Uncheck All';
  Include(Self.ItemNamespacesUncheckAll.Activate, Self.ItemNamespacesUncheckAll_Click);
  // 
  // ItemNamespacesCheckAll
  // 
  Self.ItemNamespacesCheckAll.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temNamespacesCheckAll.Image')));
  Self.ItemNamespacesCheckAll.Text := '&Check All';
  Include(Self.ItemNamespacesCheckAll.Activate, Self.ItemNamespacesCheckAll_Click);
  // 
  // ItemNamespacesTweak
  // 
  Self.ItemNamespacesTweak.BeginGroup := True;
  Self.ItemNamespacesTweak.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temNamespacesTweak.Image')));
  Self.ItemNamespacesTweak.Text := '&Tweak...';
  Include(Self.ItemNamespacesTweak.Activate, Self.ItemNamespacesTweak_Click);
  // 
  // ItemNamespacesSave
  // 
  Self.ItemNamespacesSave.BeginGroup := True;
  Self.ItemNamespacesSave.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temNamespacesSave.Image')));
  Self.ItemNamespacesSave.Text := '&Save';
  Include(Self.ItemNamespacesSave.Activate, Self.ItemNamespacesSave_Click);
  // 
  // ItemAssembly
  // 
  Self.ItemAssembly.MenuItems.AddRange(TArrayOfTD_SandBar_MenuButtonItem.Create(Self.ItemLoad, 
          Self.ItemMerge, Self.ItemMergeAll, Self.ItemClear, Self.ItemExit));
  Self.ItemAssembly.Text := '&Assembly';
  Include(Self.ItemAssembly.BeforePopup, Self.ItemAssembly_BeforePopup);
  // 
  // ItemLoad
  // 
  Self.ItemLoad.Image := (System.Drawing.Image(resources.GetObject('ItemLoad' +
    '.Image')));
  Self.ItemLoad.Text := 'Load...';
  Include(Self.ItemLoad.Activate, Self.ItemLoad_Click);
  // 
  // ItemMerge
  // 
  Self.ItemMerge.Enabled := False;
  Self.ItemMerge.Image := (System.Drawing.Image(resources.GetObject('ItemMer' +
    'ge.Image')));
  Self.ItemMerge.Text := 'Merge...';
  Include(Self.ItemMerge.Activate, Self.ItemMerge_Click);
  // 
  // ItemMergeAll
  // 
  Self.ItemMergeAll.Image := (System.Drawing.Image(resources.GetObject('Item' +
    'MergeAll.Image')));
  Self.ItemMergeAll.Text := 'Merge &All...';
  Include(Self.ItemMergeAll.Activate, Self.ItemMergeAll_Click);
  // 
  // ItemClear
  // 
  Self.ItemClear.Enabled := False;
  Self.ItemClear.Image := (System.Drawing.Image(resources.GetObject('ItemCle' +
    'ar.Image')));
  Self.ItemClear.Text := '&Clear';
  Include(Self.ItemClear.Activate, Self.ItemClear_Click);
  // 
  // ItemExit
  // 
  Self.ItemExit.BeginGroup := True;
  Self.ItemExit.Image := (System.Drawing.Image(resources.GetObject('ItemExit' +
    '.Image')));
  Self.ItemExit.Text := '&Exit';
  Include(Self.ItemExit.Activate, Self.ItemExit_Click);
  // 
  // ItemPrefixUnit
  // 
  Self.ItemPrefixUnit.MenuItems.AddRange(TArrayOfTD_SandBar_MenuButtonItem.Create(Self.ItemGenerate, 
          Self.ItemGenerateTypeList, Self.ItemAppendToTypeList, Self.ItemOptions, 
          Self.ItemAbout));
  Self.ItemPrefixUnit.Text := '&Prefix Units';
  Include(Self.ItemPrefixUnit.BeforePopup, Self.ItemPrefixUnit_BeforePopup);
  // 
  // ItemGenerate
  // 
  Self.ItemGenerate.Image := (System.Drawing.Image(resources.GetObject('Item' +
    'Generate.Image')));
  Self.ItemGenerate.Text := 'Generate &Prefix Units...';
  Include(Self.ItemGenerate.Activate, Self.ItemGenerate_Click);
  // 
  // ItemGenerateTypeList
  // 
  Self.ItemGenerateTypeList.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temGenerateTypeList.Image')));
  Self.ItemGenerateTypeList.Text := 'Generate &Type List...';
  Include(Self.ItemGenerateTypeList.Activate, Self.ItemGenerateTypeList_Activate);
  // 
  // ItemAppendToTypeList
  // 
  Self.ItemAppendToTypeList.Image := (System.Drawing.Image(resources.GetObject('I' +
    'temAppendToTypeList.Image')));
  Self.ItemAppendToTypeList.Text := '&Append to Type List...';
  Include(Self.ItemAppendToTypeList.Activate, Self.ItemAppendToTypeList_Activate);
  // 
  // ItemOptions
  // 
  Self.ItemOptions.BeginGroup := True;
  Self.ItemOptions.Image := (System.Drawing.Image(resources.GetObject('ItemO' +
    'ptions.Image')));
  Self.ItemOptions.Text := '&Options...';
  Include(Self.ItemOptions.Activate, Self.ItemOptions_Click);
  // 
  // ItemAbout
  // 
  Self.ItemAbout.Image := (System.Drawing.Image(resources.GetObject('ItemAbo' +
    'ut.Image')));
  Self.ItemAbout.Text := 'About...';
  Include(Self.ItemAbout.Activate, Self.ItemAbout_Click);
  // 
  // ExceptionHandler
  // 
  Self.ExceptionHandler.ExitOnError := False;
  Self.ExceptionHandler.SimpleMessageBox := False;
  // 
  // DialogSave
  // 
  Self.DialogSave.DefaultExt := 'xml';
  Self.DialogSave.FileName := 'TypeList';
  Self.DialogSave.Filter := 'Xml files (*.xml)|*.xml|All files (*.*)|*.*';
  // 
  // TFormMain
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(648, 530);
  Self.Controls.Add(Self.PanelMore);
  Self.Controls.Add(Self.SplitterAssemblies);
  Self.Controls.Add(Self.PanelAssemblies);
  Self.Controls.Add(Self.StatusBar);
  Self.Controls.Add(Self.leftSandBarDock);
  Self.Controls.Add(Self.rightSandBarDock);
  Self.Controls.Add(Self.bottomSandBarDock);
  Self.Controls.Add(Self.topSandBarDock);
  Self.DockPadding.All := 1;
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.MinimumSize := System.Drawing.Size.Create(500, 300);
  Self.Name := 'TFormMain';
  (System.ComponentModel.ISupportInitialize(Self.StatusBarAssemblies)).EndInit;
  Self.PanelAssemblies.ResumeLayout(False);
  Self.PanelMore.ResumeLayout(False);
  Self.PanelNames.ResumeLayout(False);
  Self.PanelNamespaces.ResumeLayout(False);
  Self.topSandBarDock.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFormMain.Dispose(Disposing: Boolean);
begin
  if Disposing then begin
    ItemNamespacesSave_Click(nil,nil);
    ItemNamesSave_Click(nil,nil);
    ApplicationSts.PanelHeights.Assemblies := PanelAssemblies.Size.Height;
    ApplicationSts.PanelHeights.Namespaces := PanelNamespaces.Size.Height;
    ApplicationSts.MainFormSize := Size;
    ApplicationSts.Store;
    FormOptions.Free;
    DialogFolder.Free;
    if Components <> nil then
      Components.Dispose;
  end;
  inherited Dispose(Disposing);
end;

constructor TFormMain.Create;
begin
  inherited Create;
  InitializeComponent;
  Text := TApplication.ProductName;
  ListNamespaces.BackColor := BorderExtender.TweakColor(ListNamespaces.BackColor,10);
  ListNames.BackColor := ListNamespaces.BackColor;
  ListAssemblies.BackColor := ListNamespaces.BackColor;
  DockPadding.All := 0;
  PanelMore.DockPadding.All := 0;
  DialogFolder := TFolderBrowserDialog.Create;
  DialogFolder.SelectedPath := TEnvironment.CurrentDirectory;
  DialogLoad.InitialDirectory := TEnvironment.CurrentDirectory;
  DialogSave.InitialDirectory := TEnvironment.CurrentDirectory;
  FormOptions := TFormOptions.Create;
  Options := FormOptions.Options;
  ApplicationSts := TApplicationSts.Load;
  Size := ApplicationSts.MainFormSize;
  PanelAssemblies.Size := RSize.Create(PanelAssemblies.Size.Width,ApplicationSts.PanelHeights.Assemblies);
  PanelNamespaces.Size := RSize.Create(PanelNamespaces.Size.Width,ApplicationSts.PanelHeights.Namespaces);
  Names := THashTable.Create;
  INames := THashTable.Create;
  Namespaces := THashTable.Create;
  StatusBarAssemblies.Text := 'No assembly loaded';
  ItemNamespacesSave.Enabled := false;
  ItemNamesSave.Enabled := false;
end;

procedure TFormMain.ListNamespaces_ItemCheck(sender: TObject; e: TItemCheckEventArgs);
begin
  ItemNamespacesSave.Enabled := true;
end;

procedure TFormMain.ListNames_ItemCheck(sender: TObject; e: TItemCheckEventArgs);
begin
  ItemNamesSave.Enabled := true;
end;

procedure TFormMain.ItemAssembly_BeforePopup(sender: TObject; e: TMenuPopupEventArgs);
begin
  ItemMerge.Enabled := (ListNamespaces.Items.Count > 0);
  ItemClear.Enabled := ItemMerge.Enabled;
end;

procedure TFormMain.ItemPrefixUnit_BeforePopup(sender: TObject; e: TMenuPopupEventArgs);
var
  I: Integer;
begin
  if ListNames.Items.Count > 0 then
    for I := 0 to Pred(ListNamespaces.Items.Count) do
      if ListNamespaces.Items[I].Checked then begin
        ItemGenerate.Enabled := true;
        ItemGenerateTypeList.Enabled := true;
        ItemAppendToTypeList.Enabled := true;
        Exit;
      end;
  ItemGenerate.Enabled := false;
  ItemGenerateTypeList.Enabled := false;
  ItemAppendToTypeList.Enabled := false;
end;

procedure TFormMain.ContextMenuNamespaces_BeforePopup(sender: TObject; e: TMenuPopupEventArgs);
begin
  ItemNamespacesCheckAll.Enabled := (ListNamespaces.Items.Count > 0);
  ItemNamespacesUncheckAll.Enabled := ItemNamespacesCheckAll.Enabled;
  ItemNamespacesTweak.Enabled := ItemNamespacesCheckAll.Enabled and (ListNamespaces.SelectedItems.Count = 1);
end;

procedure TFormMain.ContextMenuNames_BeforePopup(sender: TObject; e: TMenuPopupEventArgs);
begin
  ItemNamesCheckAll.Enabled := (ListNames.Items.Count > 0);
  ItemNamesUncheckAll.Enabled := ItemNamesCheckAll.Enabled;
  ItemNamesTweak.Enabled := ItemNamesCheckAll.Enabled and (ListNames.SelectedItems.Count = 1);
end;

procedure TFormMain.ItemNamesUncheckAll_Click(sender: TObject; e: TEventArgs);
begin
  AllCheckedTo(false,ListNames);
end;

procedure TFormMain.ItemNamesCheckAll_Click(sender: TObject; e: TEventArgs);
begin
  AllCheckedTo(true,ListNames);
end;

procedure TFormMain.ItemNamesTweak_Click(sender: TObject; e: TEventArgs);
var
  DialogResult: TDialogResult;
  I: Integer;
begin
  if ListNames.SelectedItems.Item[0].ImageIndex = 1 then
    DialogResult := FormOptions.ShowDialogName(ListNames.SelectedItems.Item[0].Text,GetSubitem(ListNames.SelectedItems.Item[0].SubItems,1).Text,not ListNames.SelectedItems.Item[0].Checked)
  else
    DialogResult := FormOptions.ShowDialogName(ListNames.SelectedItems.Item[0].Text,'',not ListNames.SelectedItems.Item[0].Checked);
  if DialogResult = TDialogResult.OK then begin
    Options := FormOptions.Options;
    ItemNamesSave_Click(nil,nil);
    if ListAssemblies.Items.Count > 0 then begin
      Cursor.Current := TCursors.WaitCursor;
      Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
      Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      ListNames.BeginUpdate;
      ListNamespaces.BeginUpdate;
      try
        I := Integer(ListNames.SelectedItems.Item[0].Tag);
        ReflectAssembly(ListAssemblies.Items[I].Tag as TAssembly,I,true);
      finally
        ListNames.EndUpdate;
        ListNamespaces.EndUpdate;
        Include(ListNames.ItemCheck,ListNames_ItemCheck);
        Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
        Cursor.Current := TCursors.Default;
      end;
    end;
  end;
end;

procedure TFormMain.ItemNamesSave_Click(sender: TObject; e: TEventArgs);
var
  I: Integer;
begin
  for I := 0 to Pred(ListNames.Items.Count) do
    if (ListNames.Items[I].Checked and (GetSubItem(ListNames.Items[I].SubItems,2).Text = '0')) or
       (not ListNames.Items[I].Checked and (GetSubItem(ListNames.Items[I].SubItems,2).Text <> '0')) then begin
      if (ListNames.Items[I].ImageIndex = 1) then
        Options.SetKnownType(ListNames.Items[I].Text,GetSubitem(ListNames.Items[I].SubItems,1).Text,not ListNames.Items[I].Checked)
      else
        Options.SetKnownType(ListNames.Items[I].Text,'',not ListNames.Items[I].Checked);
      if ListNames.Items[I].Checked then
        GetSubItem(ListNames.Items[I].SubItems,2).Text := '1'
      else
        GetSubItem(ListNames.Items[I].SubItems,2).Text := '0';
    end;
  FormOptions.Options := Options;
  ItemNamesSave.Enabled := false;
end;

procedure TFormMain.ItemNamespacesUncheckAll_Click(sender: TObject; e: TEventArgs);
begin
  AllCheckedTo(false,ListNamespaces);
end;

procedure TFormMain.ItemNamespacesCheckAll_Click(sender: TObject; e: TEventArgs);
begin
  AllCheckedTo(true,ListNamespaces);
end;

procedure TFormMain.ItemNamespacesTweak_Click(sender: TObject; e: TEventArgs);
var
  I: Integer;
  Indexes: ArrayList;
begin
  if FormOptions.ShowDialogNamespace(ListNamespaces.SelectedItems.Item[0].Text,
                                     GetSubitem(ListNamespaces.SelectedItems.Item[0].SubItems,1).Text,
                                     not ListNamespaces.SelectedItems.Item[0].Checked) = TDialogResult.OK then begin
    Options := FormOptions.Options;
    ItemNamespacesSave_Click(nil,nil);
    if ListAssemblies.Items.Count > 0 then begin
      Cursor.Current := TCursors.WaitCursor;
      Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
      Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      ListNames.BeginUpdate;
      ListNamespaces.BeginUpdate;
      try
        Indexes := ListNamespaces.SelectedItems.Item[0].Tag as TArrayList;
        for I := 0 to Pred(Indexes.Count) do
          ReflectAssembly(ListAssemblies.Items[Integer(Indexes[I])].Tag as TAssembly,Integer(Indexes[I]),true);
      finally
        ListNames.EndUpdate;
        ListNamespaces.EndUpdate;
        Include(ListNames.ItemCheck,ListNames_ItemCheck);
        Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
        Cursor.Current := TCursors.Default;
      end;
    end;
  end;
end;

procedure TFormMain.ItemNamespacesSave_Click(sender: TObject; e: TEventArgs);
var
  I: Integer;
begin
  for I := 0 to Pred(ListNamespaces.Items.Count) do
    if (ListNamespaces.Items[I].Checked and (GetSubItem(ListNamespaces.Items[I].SubItems,2).Text = '0')) or
       (not ListNamespaces.Items[I].Checked and (GetSubItem(ListNamespaces.Items[I].SubItems,2).Text <> '0')) then begin
      Options.SetKnownNamespace(ListNamespaces.Items[I].Text,GetSubitem(ListNamespaces.Items[I].SubItems,1).Text,not ListNamespaces.Items[I].Checked);
      if ListNamespaces.Items[I].Checked then
        GetSubItem(ListNamespaces.Items[I].SubItems,2).Text := '1'
      else
        GetSubItem(ListNamespaces.Items[I].SubItems,2).Text := '0';
    end;
  FormOptions.Options := Options;
  ItemNamespacesSave.Enabled := false;
end;

procedure TFormMain.ItemAbout_Click(sender: TObject; e: TEventArgs);
begin
  with TFormAbout.Create do begin
    ShowDialog;
    Free;
  end;
end;

procedure TFormMain.ItemOptions_Click(sender: TObject; e: TEventArgs);
var
  I: Integer;
begin
  if FormOptions.ShowDialog = TDialogResult.OK then begin
    Options := FormOptions.Options;
    if (ListAssemblies.Items.Count > 0) and FormOptions.RefreshRequired then begin
      Cursor.Current := TCursors.WaitCursor;
      Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
      Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      ListNames.BeginUpdate;
      ListNamespaces.BeginUpdate;
      try
        for I := 0 to Pred(ListAssemblies.Items.Count) do
          ReflectAssembly(ListAssemblies.Items[I].Tag as TAssembly,I,true);
      finally
        ListNames.EndUpdate;
        ListNamespaces.EndUpdate;
        Include(ListNames.ItemCheck,ListNames_ItemCheck);
        Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
        Cursor.Current := TCursors.Default;
      end;
    end;
  end;
end;

procedure TFormMain.ItemGenerate_Click(sender: TObject; e: TEventArgs);
begin
  DialogFolder.Description := 'Prefix Units Store Folder';
  if DialogFolder.ShowDialog = TDialogResult.OK then begin
    Cursor.Current := TCursors.WaitCursor;
    try
      Generate(DialogFolder.SelectedPath);
    finally
      Cursor.Current := TCursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemAppendToTypeList_Activate(sender: System.Object; e: System.EventArgs);
begin
  DialogSave.OverwritePrompt := false;
  DialogSave.CheckFileExists := true;
  DialogSave.Title := 'Append to Type List';
  if DialogSave.ShowDialog = TDialogResult.OK then begin
    Cursor.Current := TCursors.WaitCursor;
    try
      GenerateTypeList(DialogSave.FileName,true);
    finally
      Cursor.Current := TCursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemGenerateTypeList_Activate(sender: System.Object; e: System.EventArgs);
begin
  DialogSave.OverwritePrompt := true;
  DialogSave.CheckFileExists := false;
  DialogSave.Title := 'Save Type List';
  if DialogSave.ShowDialog = TDialogResult.OK then begin
    Cursor.Current := TCursors.WaitCursor;
    try
      GenerateTypeList(DialogSave.FileName,false);
    finally
      Cursor.Current := TCursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemLoad_Click(sender: TObject; e: TEventArgs);
begin
  ItemClear_Click(nil,nil);
  TApplication.DoEvents;
  ItemMerge_Click(nil,nil);
end;

procedure TFormMain.ItemMerge_Click(sender: TObject; e: TEventArgs);
var
  AAssembly: TAssembly;
  ListItem: TListViewItem;
  I: Integer;
begin
  if (DialogLoad.ShowDialog = TDialogResult.OK) then begin
    Cursor.Current := TCursors.WaitCursor;
    Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
    Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
    ListNames.BeginUpdate;
    ListNamespaces.BeginUpdate;
    try
      AAssembly := TAssembly.LoadFrom(DialogLoad.FileName);
      for I := 0 to Pred(ListAssemblies.Items.Count) do
        if System.string.Compare((ListAssemblies.Items[I].Tag as TAssembly).FullName,AAssembly.FullName,true) = 0 then
          Exit;
      ListItem := ListAssemblies.Items.Add(AAssembly.FullName);
      ListItem.Tag := AAssembly;
      ListItem.SubItems.Add(AAssembly.Location);
      if ListAssemblies.Items.Count <= 1 then
        StatusBarAssemblies.Text := System.string.Format('Assebly: {0}',[AAssembly.GetName.Name])
      else
        StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                         [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
      ReflectAssembly(AAssembly,ListItem.Index,false);
      ListNames.Sort;
      ListNamespaces.Sort;
      if ListAssemblies.Items.Count <= 1 then
        StatusBarAssemblies.Text := System.string.Format('Assebly: {0}, {1} Namespaces, {2} Types',
                                                         [AAssembly.GetName.Name,ListNamespaces.Items.Count,ListNames.Items.Count])
      else
        StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                         [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
    finally
      ListNames.EndUpdate;
      ListNamespaces.EndUpdate;
      Include(ListNames.ItemCheck,ListNames_ItemCheck);
      Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      Cursor.Current := TCursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemClear_Click(sender: TObject; e: TEventArgs);
begin
  Names.Clear;
  INames.Clear;
  Namespaces.Clear;
  ListAssemblies.Items.Clear;
  ListNames.Items.Clear;
  ListNamespaces.Items.Clear;
  ItemNamespacesSave.Enabled := false;
  ItemNamesSave.Enabled := false;
  StatusBarAssemblies.Text := 'No assembly loaded';
end;

procedure TFormMain.ItemMergeAll_Click(sender: TObject; e: TEventArgs);
var
  AssemblyFiles: array of string;
  AAssembly: TAssembly;
  Duplicated: Boolean;
  ListItem: TListViewItem;
  I,J: Integer;
begin
  DialogFolder.Description := 'Assemblies Folder';
  if DialogFolder.ShowDialog = TDialogResult.OK then begin
    Cursor.Current := TCursors.WaitCursor;
    Exclude(ListNames.ItemCheck,ListNames_ItemCheck);
    Exclude(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
    ListNames.BeginUpdate;
    ListNamespaces.BeginUpdate;
    try
      AssemblyFiles := TDirectory.GetFileSystemEntries(DialogFolder.SelectedPath,'*.dll');
      for J := Low(AssemblyFiles) to High(AssemblyFiles) do begin
        try
          AAssembly := TAssembly.LoadFrom(AssemblyFiles[J]);
        except
          on EBadImageFormat do
            Continue;
          on EFileLoad do
            Continue;
          else
            raise;
        end;
        Duplicated := false;
        I := 0;
        while not Duplicated and (I < ListAssemblies.Items.Count) do begin
          Duplicated := (System.string.Compare((ListAssemblies.Items[I].Tag as TAssembly).FullName,AAssembly.FullName,true) = 0);
          Inc(I);
        end;
        if not Duplicated then begin
          ListItem := ListAssemblies.Items.Add(AAssembly.FullName);
          ListItem.Tag := AAssembly;
          ListItem.SubItems.Add(AAssembly.Location);
          StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                           [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
          Refresh;
          ReflectAssembly(AAssembly,ListItem.Index,false);
          StatusBarAssemblies.Text := System.string.Format('{0} Assemblies, {1} Namespaces, {2} Types',
                                                           [ListAssemblies.Items.Count,ListNamespaces.Items.Count,ListNames.Items.Count]);
          Refresh;
        end;
      end;
      ListNames.Sort;
      ListNamespaces.Sort;
    finally
      ListNames.EndUpdate;
      ListNamespaces.EndUpdate;
      Include(ListNames.ItemCheck,ListNames_ItemCheck);
      Include(ListNamespaces.ItemCheck,ListNamespaces_ItemCheck);
      Cursor.Current := TCursors.Default;
    end;
  end;
end;

procedure TFormMain.ItemExit_Click(sender: TObject; e: TEventArgs);
begin
  Close;
end;

procedure TFormMain.AllCheckedTo(Value: Boolean; List: TListView);
var
  I: Integer;
begin
  for I := 0 to Pred(List.Items.Count) do
    List.Items[I].Checked := Value and (GetSubItem(List.Items[I].SubItems,2).Text <> '0');
end;

function TFormMain.GetSubitem(Subitems: TListViewItem.ListViewSubItemCollection; Index: Integer): TListViewItem.ListViewSubItem;
begin
  while Subitems.Count <= Index do
    Subitems.Add('');
  Result := Subitems[Index];
end;

procedure TFormMain.ReflectAssembly(AAssembly: TAssembly; ListIndex: Integer; Refresh: Boolean);
var
  I,P: integer;
  NameItem,NamespaceItem: TListViewItem;
  Types: array of TType;
  FullName,Name,Namespace,ReplacementName,NamespacePrefix: string;
  KnownTypes,KnownNamespaces,NamespacePrefixes: THashTable;
  KnownType: TKnownType;
  KnownNamespace: TKnownNamespace;
begin
  KnownTypes := Options.GetHashedKnownTypes;
  KnownNamespaces := Options.GetHashedKnownNamespaces;
  NamespacePrefixes := THashTable.Create;
  Types := AAssembly.GetTypes;
  for I := Low(Types) to High(Types) do begin
    FullName := Types[I].ToString;
    P := FullName.LastIndexOf('.');
    if Types[I].IsInterface and not Types[I].IsPrimitive and
       (Types[I].IsPublic or Types[I].IsNestedPublic) and (P >= 0) and
       (FullName.IndexOfAny(['+','-','&','@']) < 0) then begin
      if not INames.Contains(FullName.ToUpper) then
        INames.Add(FullName.ToUpper,FullName);
    end
    else if not Types[I].IsInterface and not Types[I].IsPrimitive and
       (Types[I].IsPublic or Types[I].IsNestedPublic) and (P >= 0) and
       (FullName.IndexOfAny(['+','-','&','@']) < 0) then begin {Remove funny named types}
      Name := FullName.Substring(P + 1);
      Namespace := FullName.Remove(P,Length(FullName) - P);
      NamespaceItem := nil;
      NameItem := nil;
      if Refresh then begin
        NameItem := Names.Item[FullName.ToUpper] as TListViewItem;
        if not Assigned(NamespacePrefixes.Item[Namespace.ToUpper]) then
          NamespaceItem := Namespaces.Item[Namespace.ToUpper] as TListViewItem;
      end;
      if (Refresh and Assigned(NameItem)) or not Names.ContainsKey(FullName.ToUpper) then begin
        NamespacePrefix := '';
        ReplacementName := '';
        if not Refresh and not Namespaces.ContainsKey(Namespace.ToUpper) then begin
          NamespaceItem := ListNamespaces.Items.Add(Namespace);
          Namespaces.Add(Namespace.ToUpper,NamespaceItem);
        end;
        if Assigned(NamespaceItem) then with NamespaceItem do begin
          Checked := true;
          ImageIndex := 0;
          KnownNamespace := TKnownNamespace(KnownNamespaces.Item[Namespace.ToUpper]);
          if Assigned(KnownNamespace) then begin
            Checked := not KnownNamespace.Exclude;
            if KnownNamespace.Prefix <> '' then begin
              NamespacePrefix := KnownNamespace.Prefix.Replace('.','');
              GetSubitem(SubItems,1).Text := NamespacePrefix;
              ImageIndex := 2;
            end;
          end
          else
            GetSubitem(SubItems,1).Text := '';
          NamespacePrefixes.Add(Namespace.ToUpper,NamespacePrefix);
          if Checked then
            GetSubitem(SubItems,2).Text := '1'
          else
            GetSubitem(SubItems,2).Text := '0';
          if not Assigned(Tag) then
            Tag := TArrayList.Create;
          with Tag as TArrayList do begin
            if not Contains(TObject(ListIndex)) then
              Add(TObject(ListIndex));
          end;
        end
        else
          NamespacePrefix := string(NamespacePrefixes.Item[Namespace.ToUpper]);
        if not Refresh then begin
          NameItem := ListNames.Items.Add(FullName);
          Names.Add(FullName.ToUpper,NameItem);
        end;
        if Assigned(NameItem) then with NameItem do begin
          ImageIndex := 0;
          KnownType := TKnownType(KnownTypes[FullName.ToUpper]);
          if Assigned(KnownType) then begin
            Checked := not KnownType.Exclude;
            ReplacementName := KnownType.DelphiName;
            if ReplacementName <> '' then
              ImageIndex := 1
            else if NamespacePrefix <> '' then
              ImageIndex := 2;
          end
          else if Options.DoNotRenameAttributes and
                  Types[I].IsSubclassOf(TypeOf(System.Attribute)) then begin
            Checked := false;
            if NamespacePrefix <> '' then
              ImageIndex := 2;
          end
          else begin
            Checked := (Name.ToUpper <> 'UNIT'); {Uncheck Delphi phantom class}
            if NamespacePrefix <> '' then
              ImageIndex := 2;
          end;
          if Checked then
            GetSubitem(SubItems,2).Text := '1'
          else
            GetSubitem(SubItems,2).Text := '0';
          if ReplacementName <> '' then
            GetSubitem(SubItems,1).Text := ReplacementName
          else if Types[I].IsValueType then begin
            if Types[I].IsEnum then
              GetSubitem(SubItems,1).Text := Options.EnumeratedPrefix + NamespacePrefix + Name
            else
              GetSubitem(SubItems,1).Text := Options.RecordPrefix + NamespacePrefix + Name;
          end
          else if Types[I].IsSubclassOf(TypeOf(System.Exception)) then begin
            if Options.RemoveExceptionPostfix then begin
              P := Name.LastIndexOf('Exception');
              if P >= 0 then
                Name := Name.Remove(P,Length(Name) - P);
            end;
            GetSubitem(SubItems,1).Text := Options.ExceptionPrefix + NamespacePrefix + Name;
          end
          else if Options.RemoveClassPostfix and Types[I].IsCOMObject then begin
            P := Name.LastIndexOf('Class');
            if P >= 0 then
              Name := Name.Remove(P,Length(Name) - P);
            GetSubitem(SubItems,1).Text := Options.ClassPrefix + NamespacePrefix + Name;
          end
          else
            GetSubitem(SubItems,1).Text := Options.ClassPrefix + NamespacePrefix + Name;
          Tag := TObject(ListIndex);
        end;
      end;
    end;
  end;
end;

procedure TFormMain.Generate(StoreFolderPath: string);
var
  I: Integer;
  P,StatusBarSave: string;
  CumulativeAssemblies: THashTable;

  procedure UnitGenerate(UnitPath: string; UnitName: string; Namespace: string);
  var
    I,P: Integer;
    TypeToken: Boolean;
    S,E: string;
    TextFileStream: TFileStream;
    TextWriter: TStreamWriter;
    UsedAssembly: TAssembly;
    UsedAssemblies: THashTable;
  begin
    UsedAssemblies := THashTable.Create;
    TextFileStream := TFileStream.Create(UnitPath,FileMode.Create,FileAccess.Write);
    try
      TextWriter := TStreamWriter.Create(TextFileStream);
      try
        TextWriter.BaseStream.Seek(0,SeekOrigin.Begin);
        TextWriter.WriteLine(System.String.Format('unit {0};',[UnitName]));
        TextWriter.WriteLine('');
        TextWriter.WriteLine('interface');
        TextWriter.WriteLine('');
        TextWriter.WriteLine('{$region ''Info''} {');
        TextWriter.WriteLine(System.String.Format('This code has been generated by PrefixIt! V{0} - {1}',[Application.ProductVersion,DateTime.Now.ToString]));
        TextWriter.WriteLine('Assemblies:');
        for I := 0 to Pred(ListNames.Items.Count) do begin
          if ListNames.Items[I].Checked then begin
            S := ListNames.Items[I].Text;
            P := S.LastIndexOf('.');
            S := S.Remove(P,Length(S) - P);
            if System.String.Compare(S,Namespace,true) = 0 then
              UsedAssemblies.Item[ListNames.Items[I].Tag] := nil;
          end;
        end;
        for I := 0 to Pred(ListAssemblies.Items.Count) do
          if UsedAssemblies.Contains(TObject(I)) then begin
            UsedAssembly := ListAssemblies.Items[I].Tag as TAssembly;
            TextWriter.WriteLine(System.String.Format(' {0}, Location={1}',[UsedAssembly.FullName,UsedAssembly.Location]));
            if CumulativeAssemblies.Contains(UsedAssembly.Location) then
              CumulativeAssemblies[UsedAssembly.Location] := string(CumulativeAssemblies[UsedAssembly.Location]) + ',' + Namespace
            else
              CumulativeAssemblies[UsedAssembly.Location] := Namespace;
          end;
        with Options do begin
          TextWriter.WriteLine('Options:');
          TextWriter.WriteLine(System.String.Format(' ClassPrefix={0}',[ClassPrefix]));
          TextWriter.WriteLine(System.String.Format(' RecordPrefix={0}',[RecordPrefix]));
          TextWriter.WriteLine(System.String.Format(' EnumeratedPrefix={0}',[EnumeratedPrefix]));
          TextWriter.WriteLine(System.String.Format(' ExceptionPrefix={0}',[ExceptionPrefix]));
          TextWriter.WriteLine(System.String.Format(' RemoveExceptionPostfix={0}',[RemoveExceptionPostfix]));
          TextWriter.WriteLine(System.String.Format(' RemoveClassPostfix={0}',[RemoveClassPostfix]));
          TextWriter.WriteLine(System.String.Format(' DoNotRenameAttributes={0}',[DoNotRenameAttributes]));
          if FullOptionsInUnits then begin
            TextWriter.WriteLine(' Known Namespaces');
            for I := 0 to Pred(KnownNamespaces.Count) do with KnownNamespaces[I] as TKnownNamespace do begin
              E := 'x';
              if Exclude then
                E := ' ';
              TextWriter.WriteLine(System.String.Format(' {1}[{0}]={2} {3}',[I,E,Name,Prefix.Replace('.','')]));
            end;
            TextWriter.WriteLine(' Known Types');
            for I := 0 to Pred(KnownTypes.Count) do with KnownTypes[I] as TKnownType do begin
              E := 'x';
              if Exclude then
                E := ' ';
              TextWriter.WriteLine(System.String.Format(' {1}[{0}]={2} {3}',[I,E,NETName,DelphiName]));
            end;
          end;
        end;
        TextWriter.WriteLine('}{$endregion}');
        TextWriter.WriteLine('');
        TextWriter.WriteLine('{$weakpackageunit on}');
        TextWriter.WriteLine('{$importeddata off}');
        TextWriter.WriteLine('');
        if Namespace.ToUpper <> 'SYSTEM' then begin
          TextWriter.WriteLine('uses');
          TextWriter.WriteLine(System.String.Format('  {0};',[Namespace]));
          TextWriter.WriteLine('');
        end;
        TypeToken := false;
        for I := 0 to Pred(ListNames.Items.Count) do begin
          if ListNames.Items[I].Checked then begin
            S := ListNames.Items[I].Text;
            P := S.LastIndexOf('.');
            S := S.Remove(P,Length(S) - P);
            if System.String.Compare(S,Namespace,true) = 0 then begin
              if not TypeToken then begin
                TextWriter.WriteLine('type');
                TypeToken := true;
              end;
              if UsedAssemblies.Count > 1 then
                S := System.String.Format('  {0} = {1}; //Assembly: {2}',[ListNames.Items[I].SubItems[1].Text,
                                                                          ListNames.Items[I].Text,
                                                                          (ListAssemblies.Items[Integer(ListNames.Items[I].Tag)].Tag as TAssembly).GetName.Name])
              else
                S := System.String.Format('  {0} = {1};',[ListNames.Items[I].SubItems[1].Text,ListNames.Items[I].Text]);
              TextWriter.WriteLine(S);
            end;
          end;
        end;
        if Namespace.ToUpper = 'SYSTEM' then begin
          if Options.SystemExtraTypes.Count > 0 then begin
            if not TypeToken then begin
              TextWriter.WriteLine('type');
              TypeToken := true;
            end;
            TextWriter.WriteLine('  { Extra Types }');
          end;
          for I := 0 to Pred(Options.SystemExtraTypes.Count) do with Options.SystemExtraTypes[I] as TSystemExtraType do begin
            S := System.String.Format('  {0} = {1};',[DelphiName,Definition]);
            TextWriter.WriteLine(S);
          end;
        end;
        TextWriter.WriteLine('');
        TextWriter.WriteLine('implementation');
        TextWriter.WriteLine('');
        TextWriter.WriteLine('end.');
      finally
        TextWriter.Close;
      end;
    finally
      TextFileStream.Close;
    end;
  end;

  procedure AssemblyListGenerate(ListPath: string);
  var
    Key: TObject;
    TextFileStream: TFileStream;
    TextWriter: TStreamWriter;
    Namespaces: TStringArray;
    I: Integer;
  begin
    TextFileStream := TFileStream.Create(ListPath,FileMode.Create,FileAccess.Write);
    try
      TextWriter := TStreamWriter.Create(TextFileStream);
      try
        for Key in CumulativeAssemblies.Keys do begin
          Namespaces := System.string(CumulativeAssemblies[Key]).Split([',']);
          TextWriter.WriteLine(string(Key));
          for I := 0 to Pred(Length(Namespaces)) do
           TextWriter.WriteLine(System.String.Format('  //{0}',[Namespaces[I]]));
        end;
      finally
        TextWriter.Close;
      end;
    finally
      TextFileStream.Close;
    end;
  end;

begin
  if Options.ClassPrefix = '' then
    P := 'P'
  else
    P := Options.ClassPrefix;
  StatusBarSave := StatusBarAssemblies.Text;
  CumulativeAssemblies := THashTable.Create;
  try
    for I := 0 to Pred(ListNamespaces.Items.Count) do begin
      if ListNamespaces.Items[I].Checked then begin
        StatusBarAssemblies.Text := System.String.Format('Generating: {0}.{1}.pas',[ListNamespaces.Items[I].Text,P]);
        UnitGenerate(StoreFolderPath + TPath.DirectorySeparatorChar + ListNamespaces.Items[I].Text + '.' + P + '.pas',
                     ListNamespaces.Items[I].Text + '.' + P,
                     ListNamespaces.Items[I].Text);
        Refresh;
      end;
    end;
    StatusBarAssemblies.Text := 'Generating assembly list';
    AssemblyListGenerate(StoreFolderPath + TPath.DirectorySeparatorChar + 'Assemblies.txt');
    CumulativeAssemblies.Clear;
  finally
    StatusBarAssemblies.Text := StatusBarSave;
  end;
end;

procedure TFormMain.GenerateTypeList(StoreFolderPath: string; Append: Boolean);
var
  TypeList: TTypeList;
  I: Integer;
  StatusBarSave: string;

  procedure NamespaceAppend(Namespace: string);
  var
    I,P: Integer;
    S: string;
    Value: TObject;
  begin
    for I := 0 to Pred(ListNames.Items.Count) do begin
      S := ListNames.Items[I].Text;
      P := S.LastIndexOf('.');
      S := S.Remove(P,Length(S) - P);
      if System.String.Compare(S,Namespace,true) = 0 then begin
        if ListNames.Items[I].Checked then
          TypeList.AddType(ListNames.Items[I].SubItems[1].Text,Namespace,true);
        S := ListNames.Items[I].Text;
        TypeList.AddType(S.Substring(P + 1,S.Length - P - 1),Namespace,false);
      end;
    end;
    for Value in INames.Values do begin
      S := Value as string;
      P := S.LastIndexOf('.');
      S := S.Remove(P,Length(S) - P);
      if System.String.Compare(S,Namespace,true) = 0 then begin
        S := Value as string;
        TypeList.AddType(S.Substring(P + 1,S.Length - P - 1),Namespace,false);
      end;
    end;
    if Namespace.ToUpper = 'SYSTEM' then begin
      for I := 0 to Pred(Options.SystemExtraTypes.Count) do with Options.SystemExtraTypes[I] as TSystemExtraType do
        TypeList.AddType(DelphiName,Namespace,false);
    end;
  end;

begin
  if not Append then
    TypeList := TTypeList.Create
  else
    TypeList := TTypeList.Load(StoreFolderPath);
  StatusBarSave := StatusBarAssemblies.Text;
  try
    for I := 0 to Pred(ListNamespaces.Items.Count) do begin
      if ListNamespaces.Items[I].Checked then begin
        StatusBarAssemblies.Text := System.String.Format('Namespace: {0}',[ListNamespaces.Items[I].Text]);
        NamespaceAppend(ListNamespaces.Items[I].Text);
        Refresh;
      end;
    end;
    TypeList.StoreTo(StoreFolderPath);
  finally
    StatusBarAssemblies.Text := StatusBarSave;
  end;
end;


end.



