{-------------------------------------------------------
 STATE: THIS SOFTWARE IS FREEWARE AND IS PROVIDED AS IS
        AND COMES WITH NO WARRANTY OF ANY KIND, EITHER
        EXPRESSED OR IMPLIED. IN NO EVENT WILL THE
        AUTHOR(S) BE LIABLE FOR ANY DAMAGES RESULTING
        FROM THE USE OF THIS SOFTWARE.
--------------------------------------------------------}



{  Demo on how to unzip one or more files and display their contents.
   The unziped data is not written to a disk file but rather to
   a TStrinList and then they are displayed in a memo.

  CAUTION :  Don't forget to put the Info-Zip's Unzip32.dll in the
             same directory as this project, or somewhere else
             in the path and include (uses) the Zip32.pas
  Tested  : Delphi 2, 3, 4, 5   
  Author  : Theo Bebekis Email <bebekis@otenet.gr>
  }



unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UnZip32, StdCtrls, Spin, ComCtrls, Buttons, ExtCtrls;

type
  TfrmMain = class(TForm)
    Panel1: TPanel;
    Label6: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    edtFileToUnzip: TEdit;
    edtUnzipToDir: TEdit;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    lboContents: TListBox;
    btnContents: TSpeedButton;
    btnUnZipSelected: TSpeedButton;
    mmoMessages: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure AnyButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMDropFiles(var Msg: TMessage); message WM_DropFiles;
    procedure Get_Contents;
    procedure UnZip_SelectedFiles;
  public
    { Public declarations }
    ContentsList : TStringList;
    SelectedList : TStringList;
  end;




var
  frmMain: TfrmMain;
  UF   : TUserFunctions;
  Opt  : TDCL;
  bGetContents : boolean = False;
  bGetSelected : boolean = False;
  FNV          : array[0..999] of PChar;
  argc         : integer;





{ global routines }
procedure Set_UserFunctions(var Z: TUserFunctions);

{ user functions for use with the TUserFunctions structure }
function DllPrnt(Buffer: PChar; Size: ULONG): integer; stdcall;
function DllPassword(P: PChar; N: Integer; M, Name: PChar): integer; stdcall;
function DllService(CurFile: PChar; Size: ULONG): integer; stdcall;
function DllReplace(FileName: PChar): integer; stdcall;
procedure DllMessage(UnCompSize : ULONG;
                     CompSize   : ULONG;
                     Factor     : UINT;
                     Month      : UINT;
                     Day        : UINT;
                     Year       : UINT;
                     Hour       : UINT;
                     Minute     : UINT;
                     C          : Char;
                     FileName   : PChar;
                     MethBuf    : PChar;
                     CRC        : ULONG;
                     Crypt      : Char); stdcall;




                     
implementation

{$R *.DFM}




uses
  ShellApi;


const
  CONTENTS_CMD = 0;
  SELECTED_CMD = 1;













function GetWinTempDir: string;
var
  Buf: array[0..1023] of char;
begin
  SetString(Result, Buf, GetTempPath(SizeOf(Buf), Buf));
end;



{ global routines }

{ user functions for use with the TUserFunctions structure }
{----------------------------------------------------------------------------------}
function DllPrnt(Buffer: PChar; Size: ULONG): integer;
begin
  if bGetSelected then frmMain.mmoMessages.Lines.Add(Buffer);
  Result := Size;
end;
{----------------------------------------------------------------------------------}
function DllPassword(P: PChar; N: Integer; M, Name: PChar): integer;
begin
  Result := 1;
end;
{----------------------------------------------------------------------------------}
function DllService(CurFile: PChar; Size: ULONG): integer;
begin
  Result := 0;
end;
{----------------------------------------------------------------------------------}
function DllReplace(FileName: PChar): integer;
begin
  Result := 1;
end;
{----------------------------------------------------------------------------------}
procedure DllMessage(UnCompSize : ULONG;
                     CompSize   : ULONG;
                     Factor     : UINT;
                     Month      : UINT;
                     Day        : UINT;
                     Year       : UINT;
                     Hour       : UINT;
                     Minute     : UINT;
                     C          : Char;
                     FileName   : PChar;
                     MethBuf    : PChar;
                     CRC        : ULONG;
                     Crypt      : Char);
const
  sFormat = '%7u  %7u %4s  %02u-%02u-%02u  %02u:%02u  %s%s';
  cFactor = '%s%d%%';
  cFactor100 = '100%%';
var
  S       : string;
  sFactor : string;
  Sign    : Char;
begin

  if (CompSize > UnCompSize) then Sign := '-' else Sign := ' ';

  if (Factor = 100)
  then sFactor := cFactor100
  else sFactor := Format(cFactor, [Sign, Factor]);

  S := Format(sFormat, [UnCompSize, CompSize, sFactor, Month, Day, Year, Hour, Minute, C, FileName]);

 if bGetContents then
 with frmMain do
 begin
   lboContents.Items.Add(S);
   ContentsList.Add(FileName);
 end;

end;
{----------------------------------------------------------------------------------}
procedure Set_UserFunctions(var Z:TUserFunctions);
begin
  { prepare TUserFunctions structure }
  with Z do
  begin
    @Print                  := @DllPrnt;
    @Sound                  := nil;
    @Replace                := @DllReplace;
    @Password               := @DllPassword;
    @SendApplicationMessage := @DllMessage;
    @ServCallBk             := @DllService;
  end;      
end;








  { form's methods }

{----------------------------------------------------------------------------------
 Description    : this message handler allows us to drag n drop files from Explorer
 NOTE           : for more info about this handler check the Win32.hlp for the
                  WM_DROPFILES, DragQueryFile, DragAcceptFiles and DragFinish topics
-----------------------------------------------------------------------------------}
procedure TfrmMain.WMDropFiles(var Msg: TMessage);
var
  hDrop    : THandle;
  FileName : array[0..254] of Char;
begin

  btnContents.Tag := CONTENTS_CMD;
  btnUnZipSelected.Tag := SELECTED_CMD;

  hDrop  := Msg.WParam;
  DragQueryFile(hDrop, 0, FileName, 254);

  edtFileToUnzip.Text := '';
  if UpperCase(ExtractFileExt(FileName)) = UpperCase('.zip') then edtFileToUnzip.Text := FileName;

  DragFinish(hDrop);
end;
{----------------------------------------------------------------------------------}
procedure TfrmMain.Get_Contents;
begin
  { precautions }
  if Trim(edtFileToUnZip.Text) = '' then Exit;
  if Trim(edtUnZipToDir.Text) = '' then Exit;

  bGetContents := True;
  ContentsList.Clear;
  lboContents.Clear;

  with Opt do
  begin
    ExtractOnlyNewer  := Integer(False);  { true if you are to extract only newer }                    
    SpaceToUnderscore := Integer(False);  { true if convert space to underscore }                    
    PromptToOverwrite := Integer(False);  { true if prompt to overwrite is wanted }                    
    fQuiet            := 2;               { quiet flag. 1 = few messages, 2 = no messages, 0 = all messages }                    
    nCFlag            := Integer(False);  { write to stdout if true }                    
    nTFlag            := Integer(False);  { test zip file }                    
    nVFlag            := Integer(True);   { verbose listing }                    
    nUFlag            := Integer(True);   { "update" (extract only newer/new files) }                    
    nZFlag            := Integer(False);  { display zip file comment }                    
    nDFlag            := Integer(False);  { all args are files/dir to be extracted }                    
    nOFlag            := Integer(False);  { true if you are to always over-write files, false if not }                    
    nAFlag            := Integer(False);  { do end-of-line translation }                    
    nZIFlag           := Integer(False);  { get zip info if true }                    
    C_flag            := Integer(True);   { be case insensitive if TRUE }
    fPrivilege        := 1;               { 1 => restore Acl's, 2 => Use privileges }
    
    lpszExtractDir    := PChar(edtUnZipToDir.Text);  { zip file name }
    lpszZipFN         := PChar(edtFileToUnZip.Text); { Directory to extract to. NULL for the current directory }    
  end;

  { unzip }
  Wiz_SingleEntryUnzip(0,    { number of file names being passed }
                       nil,  { file names to be unarchived }
                       0,    { number of "file names to be excluded from processing" being  passed }
                       nil,  { file names to be excluded from the unarchiving process }
                       Opt,  { pointer to a structure with the flags for setting the  various options }
                       UF);  { pointer to a structure that contains pointers to user functions }



  bGetContents := False;
end;
{----------------------------------------------------------------------------------}
procedure TfrmMain.UnZip_SelectedFiles;
var
  i : integer;
begin
  { precautions }
  if Trim(edtFileToUnZip.Text) = '' then Exit;
  if Trim(edtUnZipToDir.Text) = '' then Exit;

  bGetSelected := True;
  SelectedList.Clear;
  mmoMessages.Clear;

  with Opt do
  begin
    ExtractOnlyNewer  := Integer(False);  { true if you are to extract only newer }                    
    SpaceToUnderscore := Integer(False);  { true if convert space to underscore }                    
    PromptToOverwrite := Integer(False);  { true if prompt to overwrite is wanted }                    
    fQuiet            := 2;               { quiet flag. 1 = few messages, 2 = no messages, 0 = all messages }                    
    nCFlag            := Integer(True);   { write to stdout if true }
    nTFlag            := Integer(False);  { test zip file }                    
    nVFlag            := Integer(False);  { verbose listing }
    nUFlag            := Integer(True);   { "update" (extract only newer/new files) }                    
    nZFlag            := Integer(False);  { display zip file comment }                    
    nDFlag            := Integer(False);  { all args are files/dir to be extracted }                    
    nOFlag            := Integer(False);  { true if you are to always over-write files, false if not }                    
    nAFlag            := Integer(True);   { do end-of-line translation }                    
    nZIFlag           := Integer(False);  { get zip info if true }                    
    C_flag            := Integer(True);   { be case insensitive if TRUE }
    fPrivilege        := 1;               { 1 => restore Acl's, 2 => Use privileges }
    
    lpszExtractDir    := PChar(edtUnZipToDir.Text);  { zip file name }
    lpszZipFN         := PChar(edtFileToUnZip.Text); { Directory to extract to. NULL for the current directory }    
  end;



  { get the selected files }
  for i := 0 to lboContents.Items.Count - 1 do
    if lboContents.Selected[i] then SelectedList.Add(ContentsList[i]);


  { if there are any selected files }
  if  SelectedList.Count > 0 then
  begin
  
    { copy the file names from SelectedList to FNV dynamic array }
    for i := 0 to SelectedList.Count - 1 do
    begin
      GetMem(FNV[i], Length(SelectedList[i]) + 1 );
      StrPCopy(FNV[i], SelectedList[i]);
    end;

    argc := SelectedList.Count;

    { unzip  }
    Wiz_SingleEntryUnzip(argc,             { number of file names being passed }
                         @FNV,             { file names to be unarchived }
                         0,                { number of "file names to be excluded from processing" being  passed }
                         nil,              { file names to be excluded from the unarchiving process }
                         Opt,              { pointer to a structure with the flags for setting the  various options }
                         UF);              { pointer to a structure that contains pointers to user functions }

    { release the memory }
    for i := (SelectedList.Count - 1) downto 0 do
      FreeMem(FNV[i], Length(SelectedList[i]) + 1 );

  end;
  
  bGetSelected := False;
end;



















{ enent handlers }


{----------------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);

begin
  { see WMDropFiles method comments }
  DragAcceptFiles(Handle, True);

  edtFileToUnzip.Text := '';
  edtUnzipToDir.Text := GetWinTempDir;

  ContentsList := TStringList.Create;
  SelectedList := TStringList.Create;

  { set user functions }
  Set_UserFunctions(UF);
end;
{----------------------------------------------------------------------------------}
procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ContentsList.Free;
  SelectedList.Free;
end;
{----------------------------------------------------------------------------------}
procedure TfrmMain.AnyButtonClick(Sender: TObject);
begin
  case TComponent(Sender).Tag of
    CONTENTS_CMD : Get_Contents;
    SELECTED_CMD : UnZip_SelectedFiles;
  end;
end;

end.








































 