{------------------------------------------------------------------------------------}
{  TreeView that can have bold nodes. You can Bold/Unbold nodes and check whether a  }
{  node is bold. Property Recursive controls changing node's childs state            }
{                                                                                    }
{  Freeware with source code. You may use it for any purposes, but you shall include }
{  the copyright notice below.                                                       }
{                                                                                    }
{  The component is released AS IS. The author helds no responsibility in any case   }
{                                                                                    }
{  (c) 1998 Alexander Rublinetsky (rublin@iname.com)                                 }
{------------------------------------------------------------------------------------}

unit ZTreeView;

interface

uses
  Windows, CommCtrl, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type
  TZTreeView = class(TTreeView)
  private
    FRecursive : Boolean;
  protected
    procedure SetNodeState(node : TTreeNode; State : Integer);
    function GetNodeState(node : TTreeNode): Integer;
  public
    procedure Bold(node : TTreeNode);
    procedure UnBold(node : TTreeNode);
    function IsBold(node : TTreeNode) : Boolean;
    procedure ToggleBold(node : TTreeNode);
  published
    property Recursive : boolean read FRecursive write FRecursive;
  end;

procedure Register;

implementation

procedure TZTreeView.Bold(node : TTreeNode);
var lev,i : Integer;
begin
    SetNodeState(node, TVIS_BOLD);
    if not FRecursive then Exit;
    lev := node.Level;
    i := node.AbsoluteIndex + 1;
    while (i < Items.Count) and (Items[i].Level > lev) do begin
       SetNodeState(Items[i], TVIS_BOLD);
       inc(i);
    end;
end;

procedure TZTreeView.UnBold(node : TTreeNode);
var lev,i : Integer;
begin
    SetNodeState(node, 0);
    if not FRecursive then Exit;
    lev := node.Level;
    i := node.AbsoluteIndex + 1;
    while (i < Items.Count) and (Items[i].Level > lev) do begin
       SetNodeState(Items[i], 0);
       inc(i);
    end;
end;

function TZTreeView.IsBold(node : TTreeNode) : Boolean;
var lev,i : Integer;
begin
    Result := ((GetNodeState(node) and TVIS_BOLD) <> 0);
    if not FRecursive then Exit;
    lev := node.Level;
    i := node.AbsoluteIndex + 1;
    while (i < Items.Count) and (Items[i].Level > lev) do begin
       if (GetNodeState(Items[i]) and TVIS_BOLD) <> 0
          then begin
             Result:=True;
             Exit;
          end;
       inc(i);
    end;
end;

procedure TZTreeView.ToggleBold(node : TTreeNode);
begin
   if IsBold(node)
      then UnBold(node)
      else Bold(node);
end;

procedure TZTreeView.SetNodeState(node : TTreeNode; State : Integer);
var
  tvi  : TTVItem;
begin
  FillChar(tvi, Sizeof(tvi), 0);
  tvi.hItem := node.ItemID;
  tvi.mask := TVIF_STATE;
  tvi.stateMask := TVIS_BOLD;
  tvi.state := State;
  TreeView_SetItem(node.Handle, tvi);
  OnChange(Self,Node);
end;

function TZTreeView.GetNodeState(node : TTreeNode): Integer;
var
  tvi  : TTVItem;
begin
  FillChar(tvi, Sizeof(tvi), 0);
  tvi.hItem := node.ItemID;
  tvi.mask := TVIF_STATE;
  tvi.stateMask := TVIS_BOLD;
  TreeView_GetItem(Handle, tvi);
  Result := tvi.state;
end;


procedure Register;
begin
  RegisterComponents('Samples', [TZTreeView]);
end;

end.
