unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ZLabelImage, StdCtrls, Spin, Buttons;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Panel1: TPanel;
    ZLabelImage1: TZLabelImage;
    Label1: TLabel;
    Edit1: TEdit;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    Label2: TLabel;
    Label3: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit2: TEdit;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    SpinEdit3: TSpinEdit;
    SpinEdit4: TSpinEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Button2: TButton;
    procedure Edit1Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
    procedure RadioGroup4Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Edit1Change(Sender: TObject);
begin
     ZLabelImage1.Caption := Edit1.Text;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
     If RadioGroup1.ItemIndex <> 0 then
     begin
          SpinEdit1.Enabled := False;
     end
     else
     begin
          SpinEdit1.Enabled := True;
     end;
     Case RadioGroup1.ItemIndex of
     0: ZLabelImage1.CaptionXAlignment := alXNone;
     1: ZLabelImage1.CaptionXAlignment := alXLeft;
     2: ZLabelImage1.CaptionXAlignment := alXRight;
     3: ZLabelImage1.CaptionXAlignment := alXCenter;
     end;

end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
     If RadioGroup2.ItemIndex <> 0 then
     begin
          SpinEdit2.Enabled := False;
     end
     else
     begin
          SpinEdit2.Enabled := True;
     end;
     Case RadioGroup2.ItemIndex of
     0: ZLabelImage1.CaptionYAlignment := alYNone;
     1: ZLabelImage1.CaptionYAlignment := alYTop;
     2: ZLabelImage1.CaptionYAlignment := alYBottom;
     3: ZLabelImage1.CaptionYAlignment := alYCenter;
     end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
     With OpenDialog1 do
     begin
          Execute;
          If FileName <> '' then
          begin
               Edit2.Text := FileName;
               ZLabelImage1.Picture.LoadFromFile(FileName);
               ZLabelImage1.Repaint;
          end;
     end;
end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
     If RadioGroup3.ItemIndex <> 0 then
     begin
          SpinEdit3.Enabled := False;
     end
     else
     begin
          SpinEdit3.Enabled := True;
     end;
     Case RadioGroup3.ItemIndex of
     0: ZLabelImage1.PictureXAlignment := alXNone;
     1: ZLabelImage1.PictureXAlignment := alXLeft;
     2: ZLabelImage1.PictureXAlignment := alXRight;
     3: ZLabelImage1.PictureXAlignment := alXCenter;
     end;
end;

procedure TForm1.RadioGroup4Click(Sender: TObject);
begin
     If RadioGroup4.ItemIndex <> 0 then
     begin
          SpinEdit4.Enabled := False;
     end
     else
     begin
          SpinEdit4.Enabled := True;
     end;
     Case RadioGroup4.ItemIndex of
     0: ZLabelImage1.PictureYAlignment := alYNone;
     1: ZLabelImage1.PictureYAlignment := alYTop;
     2: ZLabelImage1.PictureYAlignment := alYBottom;
     3: ZLabelImage1.PictureYAlignment := alYCenter;
     end;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
     ZLabelImage1.XCaption := SpinEdit1.Value;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
     ZLabelImage1.YCaption := SpinEdit2.Value;
end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
begin
     ZLabelImage1.XPicture := SpinEdit3.Value;
end;

procedure TForm1.SpinEdit4Change(Sender: TObject);
begin
     ZLabelImage1.YPicture := SpinEdit4.Value;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     ShowMessage('TLabelImage 0.1' + #13#10 +
                 'Delphi 2,3,4,5 component' + #13#10 +
                 'Freeware' + #13#10 + #13#10 +
                 'Author:' + #13#10 +
                 'Anthony ZANETTI' + #13#10 +
                 'ZWARE' + #13#10 +
                 'ZANETTI DEVELOPMENT' + #13#10 +
                 'email : a.zanetti@zware-soft.com' + #13#10 +#13#10 +
                 'Postal Address:' + #13#10 +
                 '7, Rue des msanges' + #13#10 +
                 '57690 CREHANGE' +#13#10 +
                 'FRANCE');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
     Close;
end;

end.
