unit Demo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, Buttons, ComCtrls, ExtCtrls,
  UnZIP, UnARJ, UnARC, UnSFX, Globals, ZipTV, UnLHA, UnZoo;

type
	TForm1 = class(TForm)
    	OpenDialog1	: TOpenDialog;
  	MainMenu1	: TMainMenu;
    	File1			: TMenuItem;
    	Open1			: TMenuItem;
    	Exit1			: TMenuItem;
    	Extract2		: TMenuItem;
    	All1			: TMenuItem;

    	PopupMenu1	: TPopupMenu;
    	Open2			: TMenuItem;
    	Exit2			: TMenuItem;
    	Extract1		: TMenuItem;

    	Memo1			: TMemo;
    	ListView1	: TListView;
    	ListView2	: TListView;
    	lblFileSpec	: TLabel;
    	Label1		: TLabel;
    	Label2		: TLabel;
    	Label3		: TLabel;

    	ZipTV1		: TZipTV;
    	UnZIP1		: TUnZIP;
    	UnSFX1		: TUnSFX;
    	UnARJ1		: TUnARJ;
    	UnARC1		: TUnARC;
    	UnLHA1		: TUnLHA;
    	UnZOO1		: TUnZOO;

		procedure DemoUnzip;
    	procedure Open1Click(Sender: TObject);
    	procedure Exit1Click(Sender: TObject);

     procedure ZipView1Read(Sender: TObject; FileNum: Integer);
		procedure ZipView1Totals (Sender: TObject; NumFiles: Integer);
     procedure UnZIP1FileExists(Sender: TObject; FN: string;
       var Accept: Boolean);
     procedure UnZIP1Begin(Sender: TObject; FN: string; RecNum: Integer;
       var Extract: Boolean);
     procedure UnZIP1End(Sender: TObject; FN: string);

     procedure All1Click(Sender: TObject);
    	procedure FormActivate(Sender: TObject);
     procedure ListView1Click(Sender: TObject);
    	procedure ListView1ColumnClick(Sender: TObject; Column: TListColumn);
  private
  public
  end;


var
	Form1: TForm1;


implementation


{$R *.DFM}

{ -------------------------------------------------------------- }
procedure TForm1.Open1Click(Sender: TObject);
begin
	if OpenDialog1.Execute then
 	begin
  	ListView1.items.Clear;
     Memo1.Text 		:= '';
     Form1.Caption 	:= OpenDialog1.FileName;
     ZipTV1.ArchiveFile  := OpenDialog1.FileName;
		ZipTV1.Activate;
  end;
end;
{ -------------------------------------------------------------- }
procedure TForm1.Exit1Click(Sender: TObject);
begin
	close;
end;
{ -------------------------------------------------------------- }
{ fill listbox with detailed compressed file info }
procedure TForm1.ZipView1Read(Sender: TObject; FileNum: Integer);
var
	NewItem : TListItem;
begin
  NewItem := ListView1.Items.Add;
  NewItem.Caption := ExtractFilename(ZipTV1.Filename);		  	  {filename}
  NewItem.SubItems.Add('');

  NewItem.SubItems.Add(FormatDateTime('mm-dd-yy',ZipTV1.Date)); {Date}
  NewItem.SubItems.Add(FormatDateTime('hh:mm',ZipTV1.Date));    {Time}
  NewItem.SubItems.Add(IntToStr(ZipTV1.PackedSize));            {PackedSize}
  NewItem.SubItems.Add(IntToStr(ZipTV1.UnpackedSize));          {UnpackedSize}
  NewItem.SubItems.Add(IntToStr(ZipTV1.Ratio) + '%');           {Ratio}
  NewItem.SubItems.Add(ZipTV1.sCompressionMethod);              {(string) method}
  if ZipTV1.ExternalAttr > 0 then
     NewItem.SubItems.Add(IntToStr(ZipTV1.ExternalAttr)) 		  {InternalAttr}
  else
     NewItem.SubItems.Add(' ---');
  {NewItem.SubItems.Add(IntToStr(ZipTV1.wCompressionMethod));}  {(word) method}
  NewItem.SubItems.Add(ExtractFileDir(ZipTV1.Filename));
  NewItem.SubItems.Add(ZipTV1.FileComment);							  {file comment}
end;
{ -------------------------------------------------------------- }
{ display the totals }
procedure TForm1.ZipView1Totals(Sender: TObject; NumFiles: Integer);
var
	NewItem : TListItem;
begin
	ListView2.items.Clear;
  NewItem := ListView2.Items.Add;
  NewItem.SubItems.Add(inttostr(ZipTV1.PackedSize));  	{PackedSize}
  NewItem.SubItems.Add(inttostr(ZipTV1.UnpackedSize));  {UnpackedSize}
  NewItem.SubItems.Add(IntToStr(ZipTV1.Ratio) + '%');   {ratio}
  Memo1.Text := ZipTV1.ZipComment;								{archive comment}
end;
{ ============================================================== }
{ click the lists headings }
procedure TForm1.ListView1ColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  MessageDlg(IntToStr(Column.Index), mtWarning, [mbOk], 0);
  case Column.Index of
     1:	;				{Filename}
  	2:	;				{Date}
     3: ;           {Time}
     4: ;           {UnCompressed}
     5: ;           {Compressed}
     6: ;           {Ratio}
     7: ;           {Method}
		8: ;				{Extract To (dir)}
     9: ;           {FileComment}
  end;
end;
{ -------------------------------------------------------------- }
procedure TForm1.FormActivate(Sender: TObject);
begin
	lblFileSpec.Caption := ZipTV1.FileSpec;
end;
{ -------------------------------------------------------------- }
procedure TForm1.ListView1Click(Sender: TObject);
begin
	if (ListView1.Items.Count = 0) or (ListView1.Selected = nil) then
		MessageDlg('Select a file to extract.',mtInformation,[mbOK],0)
	else begin
     case ZipTV1.ArcType of
        Arc, ArcExe:
           begin
              UnARC1.ArchiveFile := ZipTV1.ArchiveFile;
              UnARC1.FileSpec    := ListView1.Selected.Caption;
           end;
        Arj, ArjExe:
           begin
              UnARJ1.ArchiveFile := ZipTV1.ArchiveFile;
              UnARJ1.FileSpec    := ListView1.Selected.Caption;
           end;
        LZH:
           begin
              UnLHA1.ArchiveFile := ZipTV1.ArchiveFile;
              UnLHA1.FileSpec    := ListView1.Selected.Caption;
           end;
        Zip, ZipExe, Zip250, Zip250Exe:
           begin
              UnZIP1.ArchiveFile := ZipTV1.ArchiveFile;
              UnZIP1.FileSpec    := ListView1.Selected.Caption;
           end;
        Zoo:
        	begin
           	UnZoo1.ArchiveFile := ZipTV1.ArchiveFile;
              UnZoo1.FileSpec	 := ListView1.Selected.Caption;
           end;
     end;
  	DemoUnzip;
  end;
end;
{ -------------------------------------------------------------- }
procedure TForm1.UnZIP1FileExists(Sender: TObject; FN: string;
  var Accept: Boolean);
begin
	if MessageDlg(FN + ' already exists, overwrite?',mtInformation,[mbYes,mbNo],0) = mrNo then
  	Accept := false;
end;
{ -------------------------------------------------------------- }
procedure TForm1.All1Click(Sender: TObject);
begin
	if ZipTV1.ArchiveFile <> '' then
  begin
     case ZipTV1.ArcType of
        Arc, ArcExe:
           begin
              UnARC1.ArchiveFile := ZipTV1.ArchiveFile;
              UnARC1.FileSpec    := '*.*';
           end;
        Arj, ArjExe:
           begin
              UnARJ1.ArchiveFIle := ZipTV1.ArchiveFile;
              UnARJ1.FileSpec    := '*.*';
           end;
        LZH:
        	begin
              UnLHA1.ArchiveFIle := ZipTV1.ArchiveFile;
              UnLHA1.FileSpec    := '*.*';
           end;
        Zip, ZipExe:
           begin
              UnZIP1.ArchiveFile := ZipTV1.ArchiveFile;
              UnZIP1.FileSpec    := '*.*';
           end;
        Zoo:
        	begin
           	UnZoo1.ArchiveFile := ZipTV1.ArchiveFile;
              UnZoo1.FileSpec	 := '*.*';
           end;
     end;
  	DemoUnzip;
  end;
end;
{ -------------------------------------------------------------- }
procedure TForm1.UnZIP1Begin(Sender: TObject; FN: string; RecNum: Integer;
  var Extract: Boolean);
begin
	MessageDlg('Begin',mtInformation,[mbOk],0);
end;
{ -------------------------------------------------------------- }
procedure TForm1.UnZIP1End(Sender: TObject; FN: string);
begin
	MessageDlg('End',mtInformation,[mbOk],0);
end;
{ -------------------------------------------------------------- }
procedure TForm1.DemoUnzip;
begin
	case ZipTV1.ArcType of
  	Arc, ArcExe:
        begin
           UnARC1.ExtractDir  := 'c:\hold1';
           UnARC1.Extract;
        end;
     Arj, ArjExe:
        begin
           UnARJ1.ExtractDir  := 'c:\hold1';
           UnARJ1.Extract;
        end;
     LZH:
        begin
           UnLHA1.ExtractDir  := 'c:\hold1';
           UnLHA1.Extract;
        end;
     Zip, ZipExe:
     	begin
        	UnZIP1.ExtractDir  := 'c:\hold1';
           UnZIP1.Extract;
        end;
     Zoo:
     	begin
        	UnZOO1.ExtractDir  := 'c:\hold1';
           UnZOO1.Extract;
        end;
   	else
     	MessageDlg('Extraction of this file type is not supported.',mtInformation,[mbOK],0);
	end;

end;


end.

