unit XVOICE;

interface

uses Ole2, OleCtl, Classes, Graphics, OleCtrls, Windows;

type
  WideString = PWideChar;
  TDirectSSClickIn = procedure(Sender: TObject; x, y: Integer) of object;
  TDirectSSClickOut = procedure(Sender: TObject; x, y: Integer) of object;
  TDirectSSAudioStart = procedure(Sender: TObject; hi, lo: Integer) of object;
  TDirectSSAudioStop = procedure(Sender: TObject; hi, lo: Integer) of object;
  TDirectSSAttribChanged = procedure(Sender: TObject; which_attribute: Integer) of object;
  TDirectSSVisual = procedure(Sender: TObject; timehi: Integer; timelo: Integer; Phoneme: Smallint;
                                               EnginePhoneme: Smallint; hints: Integer;
                                               MouthHeight: Smallint; bMouthWidth: Smallint;
                                               bMouthUpturn: Smallint; bJawOpen: Smallint;
                                               TeethUpperVisible: Smallint;
                                               TeethLowerVisible: Smallint; TonguePosn: Smallint;
                                               LipTension: Smallint) of object;
  TDirectSSWordPosition = procedure(Sender: TObject; hi: Integer; lo: Integer; byteoffset: Integer) of object;
  TDirectSSBookMark = procedure(Sender: TObject; hi: Integer; lo: Integer; MarkNum: Integer) of object;
  TDirectSSTextDataStarted = procedure(Sender: TObject; hi: Integer; lo: Integer) of object;
  TDirectSSTextDataDone = procedure(Sender: TObject; hi: Integer; lo: Integer; Flags: Integer) of object;
  TDirectSSActiveVoiceStartup = procedure(Sender: TObject; init: Integer; init2: Integer) of object;
  TDirectSSError = procedure(Sender: TObject; warning: UINT; const Details: WideString;
                                              const Message: WideString) of object;
  TDirectSSwarning = procedure(Sender: TObject; warning: UINT; const Details: WideString;
                                                const Message: WideString) of object;
  TDirectSSVisualFuture = procedure(Sender: TObject; milliseconds: Integer; timehi: Integer;
                                                     timelo: Integer; Phoneme: Smallint;
                                                     EnginePhoneme: Smallint; hints: Integer;
                                                     MouthHeight: Smallint; bMouthWidth: Smallint;
                                                     bMouthUpturn: Smallint; bJawOpen: Smallint;
                                                     TeethUpperVisible: Smallint;
                                                     TeethLowerVisible: Smallint;
                                                     TonguePosn: Smallint; LipTension: Smallint) of object;

  TDirectSS = class(TOleControl)
  private
    FOnClickIn: TDirectSSClickIn;
    FOnClickOut: TDirectSSClickOut;
    FOnAudioStart: TDirectSSAudioStart;
    FOnAudioStop: TDirectSSAudioStop;
    FOnAttribChanged: TDirectSSAttribChanged;
    FOnVisual: TDirectSSVisual;
    FOnWordPosition: TDirectSSWordPosition;
    FOnBookMark: TDirectSSBookMark;
    FOnTextDataStarted: TDirectSSTextDataStarted;
    FOnTextDataDone: TDirectSSTextDataDone;
    FOnActiveVoiceStartup: TDirectSSActiveVoiceStartup;
    FOnDebugging: TNotifyEvent;
    FOnError: TDirectSSError;
    FOnwarning: TDirectSSwarning;
    FOnVisualFuture: TDirectSSVisualFuture;
    function Get_Attributes(Attrib: Integer): Integer; stdcall;
    procedure Set_Attributes(Attrib: Integer; Value: Integer); stdcall;
    function Get_AttributeString(Attrib: Integer): string; stdcall;
    procedure Set_AttributeString(Attrib: Integer; const Value: string); stdcall;
    function Get_AttributeMemory(Attrib: Integer; var size: Integer): Integer; stdcall;
    procedure Set_AttributeMemory(Attrib: Integer; var size: Integer; Value: Integer); stdcall;
  protected
    procedure InitControlData; override;
  public
    procedure Speak(const text: string); stdcall;
    procedure Select(index: Integer); stdcall;
    function EngineID(index: Integer): string; stdcall;
    function ModeName(index: Integer): string; stdcall;
    function MfgName(index: Integer): string; stdcall;
    function ProductName(index: Integer): string; stdcall;
    function ModeID(index: Integer): string; stdcall;
    function Speaker(index: Integer): string; stdcall;
    function Style(index: Integer): string; stdcall;
    function Gender(index: Integer): Integer; stdcall;
    function Age(index: Integer): Integer; stdcall;
    function Features(index: Integer): Integer; stdcall;
    function Interfaces(index: Integer): Integer; stdcall;
    function EngineFeatures(index: Integer): Integer; stdcall;
    function LanguageID(index: Integer): Integer; stdcall;
    function Dialect(index: Integer): string; stdcall;
    procedure AudioPause; stdcall;
    procedure AudioReset; stdcall;
    procedure AudioResume; stdcall;
    procedure Inject(const value: string); stdcall;
    function Phonemes(charset, Flags: Integer; const input: string): string; stdcall;
    procedure PosnGet(var hi, lo: Integer); stdcall;
    procedure TextData(characterset, Flags: Integer; const text: string); stdcall;
    procedure InitAudioDestMM(deviceid: Integer); stdcall;
    procedure AboutDlg(hWnd: Integer; const title: string); stdcall;
    procedure GeneralDlg(hWnd: Integer; const title: string); stdcall;
    procedure LexiconDlg(hWnd: Integer; const title: string); stdcall;
    procedure TranslateDlg(hWnd: Integer; const title: string); stdcall;
    function FindEngine(const EngineID, MfgName, ProductName, ModeID, ModeName: string; LanguageID: Integer; const Dialect, Speaker, Style: string; Gender, Age, Features, Interfaces, EngineFeatures, RankEngineID, RankMfgName, RankProductName, RankModeID, RankModeName, RankLanguage, RankDialect, RankSpeaker, RankStyle, RankGender, RankAge, RankFeatures, RankInterfaces, RankEngineFeatures: Integer): Integer; stdcall;
    procedure GetPronunciation(charset: Integer; const text: string; Sense: Integer; var Pronounce: string; var PartOfSpeech: Integer; var EngineInfo: string); stdcall;
    procedure InitAudioDestDirect(direct: Integer); stdcall;
    procedure InitAudioDestObject(object_: Integer); stdcall;
    function Find(const RankList: string): Integer; stdcall;
    procedure LexAddTo(lex, charset: Integer; const text, Pronounce: string; PartOfSpeech, EngineInfo, engineinfosize: Integer); stdcall;
    procedure LexGetFrom(lex, charset: Integer; const text: string; Sense: Integer; var Pronounce: string; var PartOfSpeech, EngineInfo, sizeofengineinfo: Integer); stdcall;
    procedure LexRemoveFrom(lex: Integer; const text: string; Sense: Integer); stdcall;
    procedure QueryLexicons(f: Integer; var pdw: Integer); stdcall;
    procedure ChangeSpelling(lex: Integer; const stringa, stringb: string); stdcall;
    property CountEngines: Integer index 18 read GetIntegerProp;
    property MaxRealTime: Integer index 33 read GetIntegerProp;
    property hWnd: Integer index 70 read GetIntegerProp;
    property AudioDest: Integer index 75 read GetIntegerProp;
    property Attributes[Attrib: Integer]: Integer read Get_Attributes write Set_Attributes;
    property AttributeString[Attrib: Integer]: string read Get_AttributeString write Set_AttributeString;
    property AttributeMemory[Attrib: Integer; var size: Integer]: Integer read Get_AttributeMemory write Set_AttributeMemory;
  published
    property TabStop;
    property DragCursor;
    property DragMode;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnStartDrag;
    property debug: Smallint index 1 read GetSmallintProp write SetSmallintProp stored False;
    property Initialized: Smallint index 2 read GetSmallintProp write SetSmallintProp stored False;
    property Pitch: Integer index 7 read GetIntegerProp write SetIntegerProp stored False;
    property MaxPitch: Integer index 8 read GetIntegerProp write SetIntegerProp stored False;
    property MinPitch: Integer index 9 read GetIntegerProp write SetIntegerProp stored False;
    property Speed: Integer index 10 read GetIntegerProp write SetIntegerProp stored False;
    property MaxSpeed: Integer index 11 read GetIntegerProp write SetIntegerProp stored False;
    property MinSpeed: Integer index 12 read GetIntegerProp write SetIntegerProp stored False;
    property VolumeRight: Integer index 13 read GetIntegerProp write SetIntegerProp stored False;
    property MinVolumeRight: Integer index 14 read GetIntegerProp write SetIntegerProp stored False;
    property MaxVolumeRight: Integer index 15 read GetIntegerProp write SetIntegerProp stored False;
    property RealTime: Integer index 32 read GetIntegerProp write SetIntegerProp stored False;
    property MinRealTime: Integer index 34 read GetIntegerProp write SetIntegerProp stored False;
    property Tagged: Integer index 39 read GetIntegerProp write SetIntegerProp stored False;
    property MouthHeight: Smallint index 49 read GetSmallintProp write SetSmallintProp stored False;
    property MouthWidth: Smallint index 50 read GetSmallintProp write SetSmallintProp stored False;
    property MouthUpturn: Smallint index 51 read GetSmallintProp write SetSmallintProp stored False;
    property JawOpen: Smallint index 52 read GetSmallintProp write SetSmallintProp stored False;
    property TeethUpperVisible: Smallint index 53 read GetSmallintProp write SetSmallintProp stored False;
    property TeethLowerVisible: Smallint index 54 read GetSmallintProp write SetSmallintProp stored False;
    property TonguePosn: Smallint index 55 read GetSmallintProp write SetSmallintProp stored False;
    property LipTension: Smallint index 56 read GetSmallintProp write SetSmallintProp stored False;
    property CallBacksEnabled: Smallint index 57 read GetSmallintProp write SetSmallintProp stored False;
    property MouthEnabled: Smallint index 58 read GetSmallintProp write SetSmallintProp stored False;
    property LastError: Integer index 59 read GetIntegerProp write SetIntegerProp stored False;
    property SuppressExceptions: Smallint index 60 read GetSmallintProp write SetSmallintProp stored False;
    property Speaking: Smallint index 61 read GetSmallintProp write SetSmallintProp stored False;
    property LastWordPosition: Integer index 62 read GetIntegerProp write SetIntegerProp stored False;
    property LipType: Smallint index 63 read GetSmallintProp write SetSmallintProp stored False;
    property Sayit: string index 66 read GetStringProp write SetStringProp stored False;
    property FileName: string index 68 read GetStringProp write SetStringProp stored False;
    property CurrentMode: Integer index 69 read GetIntegerProp write SetIntegerProp stored False;
    property VolumeLeft: Integer index 72 read GetIntegerProp write SetIntegerProp stored False;
    property MinVolumeLeft: Integer index 73 read GetIntegerProp write SetIntegerProp stored False;
    property MaxVolumeLeft: Integer index 74 read GetIntegerProp write SetIntegerProp stored False;
    property OnClickIn: TDirectSSClickIn read FOnClickIn write FOnClickIn;
    property OnClickOut: TDirectSSClickOut read FOnClickOut write FOnClickOut;
    property OnAudioStart: TDirectSSAudioStart read FOnAudioStart write FOnAudioStart;
    property OnAudioStop: TDirectSSAudioStop read FOnAudioStop write FOnAudioStop;
    property OnAttribChanged: TDirectSSAttribChanged read FOnAttribChanged write FOnAttribChanged;
    property OnVisual: TDirectSSVisual read FOnVisual write FOnVisual;
    property OnWordPosition: TDirectSSWordPosition read FOnWordPosition write FOnWordPosition;
    property OnBookMark: TDirectSSBookMark read FOnBookMark write FOnBookMark;
    property OnTextDataStarted: TDirectSSTextDataStarted read FOnTextDataStarted write FOnTextDataStarted;
    property OnTextDataDone: TDirectSSTextDataDone read FOnTextDataDone write FOnTextDataDone;
    property OnActiveVoiceStartup: TDirectSSActiveVoiceStartup read FOnActiveVoiceStartup write FOnActiveVoiceStartup;
    property OnDebugging: TNotifyEvent read FOnDebugging write FOnDebugging;
    property OnError: TDirectSSError read FOnError write FOnError;
    property Onwarning: TDirectSSwarning read FOnwarning write FOnwarning;
    property OnVisualFuture: TDirectSSVisualFuture read FOnVisualFuture write FOnVisualFuture;
  end;

procedure Register;

implementation

{$J+}

procedure TDirectSS.InitControlData;
const
  CEventDispIDs: array [0..14] of DWORD = (
    $00000001, $00000002, $00000003, $00000004, $00000005, $00000006,
    $00000007, $00000008, $00000009, $0000000A, $0000000B, $0000000C,
    $0000000D, $0000000E, $0000000F);
  CControlData: TControlData = (
    ClassID: (
      D1:$EEE78591;D2:$FE22;D3:$11D0;D4:($8B,$EF,$00,$60,$08,$18,$41,$DE));
    EventIID: (
      D1:$EEE78597;D2:$FE22;D3:$11D0;D4:($8B,$EF,$00,$60,$08,$18,$41,$DE));
    EventCount: 15;
    EventDispIDs: @CEventDispIDs;
    LicenseKey: nil;
    Flags: $00000000);
begin
  ControlData := @CControlData;
end;

procedure TDirectSS.Speak;
const
  DispInfo: array[0..8] of Byte = ($06,$00,$00,$00,$00,$01,$01,$00,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.Select;
const
  DispInfo: array[0..8] of Byte = ($10,$00,$00,$00,$00,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.EngineID;
const
  DispInfo: array[0..8] of Byte = ($11,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.ModeName;
const
  DispInfo: array[0..8] of Byte = ($13,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.MfgName;
const
  DispInfo: array[0..8] of Byte = ($14,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.ProductName;
const
  DispInfo: array[0..8] of Byte = ($15,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.ModeID;
const
  DispInfo: array[0..8] of Byte = ($16,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Speaker;
const
  DispInfo: array[0..8] of Byte = ($17,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Style;
const
  DispInfo: array[0..8] of Byte = ($18,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Gender;
const
  DispInfo: array[0..8] of Byte = ($19,$00,$00,$00,$03,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Age;
const
  DispInfo: array[0..8] of Byte = ($1A,$00,$00,$00,$03,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Features;
const
  DispInfo: array[0..8] of Byte = ($1B,$00,$00,$00,$03,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Interfaces;
const
  DispInfo: array[0..8] of Byte = ($1C,$00,$00,$00,$03,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.EngineFeatures;
const
  DispInfo: array[0..8] of Byte = ($1D,$00,$00,$00,$03,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.LanguageID;
const
  DispInfo: array[0..8] of Byte = ($1E,$00,$00,$00,$03,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

function TDirectSS.Dialect;
const
  DispInfo: array[0..8] of Byte = ($1F,$00,$00,$00,$08,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.AudioPause;
const
  DispInfo: array[0..7] of Byte = ($23,$00,$00,$00,$00,$01,$00,$00);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.AudioReset;
const
  DispInfo: array[0..7] of Byte = ($24,$00,$00,$00,$00,$01,$00,$00);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.AudioResume;
const
  DispInfo: array[0..7] of Byte = ($25,$00,$00,$00,$00,$01,$00,$00);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.Inject;
const
  DispInfo: array[0..8] of Byte = ($26,$00,$00,$00,$00,$01,$01,$00,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.Phonemes;
const
  DispInfo: array[0..10] of Byte = ($28,$00,$00,$00,$08,$01,$03,$00,$03,$03,$08);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.PosnGet;
const
  DispInfo: array[0..9] of Byte = ($29,$00,$00,$00,$00,$01,$02,$00,$83,$83);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.TextData;
const
  DispInfo: array[0..10] of Byte = ($2A,$00,$00,$00,$00,$01,$03,$00,$03,$03,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.InitAudioDestMM;
const
  DispInfo: array[0..8] of Byte = ($2B,$00,$00,$00,$00,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.AboutDlg;
const
  DispInfo: array[0..9] of Byte = ($2C,$00,$00,$00,$00,$01,$02,$00,$03,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.GeneralDlg;
const
  DispInfo: array[0..9] of Byte = ($2D,$00,$00,$00,$00,$01,$02,$00,$03,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.LexiconDlg;
const
  DispInfo: array[0..9] of Byte = ($2E,$00,$00,$00,$00,$01,$02,$00,$03,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.TranslateDlg;
const
  DispInfo: array[0..9] of Byte = ($2F,$00,$00,$00,$00,$01,$02,$00,$03,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.FindEngine;
const
  DispInfo: array[0..35] of Byte = ($30,$00,$00,$00,$03,$01,$1C,$00,$08,$08,$08,$08,$08,$03,$08,$08,$08,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.GetPronunciation;
const
  DispInfo: array[0..13] of Byte = ($40,$00,$00,$00,$00,$01,$06,$00,$03,$08,$03,$88,$83,$88);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.InitAudioDestDirect;
const
  DispInfo: array[0..8] of Byte = ($41,$00,$00,$00,$00,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.InitAudioDestObject;
const
  DispInfo: array[0..8] of Byte = ($43,$00,$00,$00,$00,$01,$01,$00,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.Find;
const
  DispInfo: array[0..8] of Byte = ($47,$00,$00,$00,$03,$01,$01,$00,$08);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.LexAddTo;
const
  DispInfo: array[0..14] of Byte = ($4F,$00,$00,$00,$00,$01,$07,$00,$03,$03,$08,$08,$03,$03,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.LexGetFrom;
const
  DispInfo: array[0..15] of Byte = ($50,$00,$00,$00,$00,$01,$08,$00,$03,$03,$08,$03,$88,$83,$83,$83);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.LexRemoveFrom;
const
  DispInfo: array[0..10] of Byte = ($51,$00,$00,$00,$00,$01,$03,$00,$03,$08,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.QueryLexicons;
const
  DispInfo: array[0..9] of Byte = ($52,$00,$00,$00,$00,$01,$02,$00,$03,$83);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure TDirectSS.ChangeSpelling;
const
  DispInfo: array[0..10] of Byte = ($53,$00,$00,$00,$00,$01,$03,$00,$03,$08,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.Get_Attributes;
const
  DispInfo: array[0..8] of Byte = ($4C,$00,$00,$00,$03,$02,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.Set_Attributes;
const
  DispInfo: array[0..9] of Byte = ($4C,$00,$00,$00,$00,$04,$02,$00,$03,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.Get_AttributeString;
const
  DispInfo: array[0..8] of Byte = ($4D,$00,$00,$00,$08,$02,$01,$00,$03);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.Set_AttributeString;
const
  DispInfo: array[0..9] of Byte = ($4D,$00,$00,$00,$00,$04,$02,$00,$03,$08);
begin
  InvokeMethod(DispInfo, nil);
end;

function TDirectSS.Get_AttributeMemory;
const
  DispInfo: array[0..9] of Byte = ($4E,$00,$00,$00,$03,$02,$02,$00,$03,$83);
begin
  InvokeMethod(DispInfo, @Result);
end;

procedure TDirectSS.Set_AttributeMemory;
const
  DispInfo: array[0..10] of Byte = ($4E,$00,$00,$00,$00,$04,$03,$00,$03,$83,$03);
begin
  InvokeMethod(DispInfo, nil);
end;

procedure Register;
begin
  RegisterComponents('OCX', [TDirectSS]);
end;

end.
