{$H+,B-,D-}
{XToolBar - release 2.75}


unit XToolBar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, ExtCtrls,
  Registry;

const
  MaxGroup = 32;  {Because I choosed static storing for some datas}
  MaxCtrlPerGroup = 32;
  MaxSizes = 128;

  TB_NO_DOCKED = #255#255#255;  {Delfault Dockarea name in registry loading}

type
//////////////////////////// TFloatBarPrent ////////////////////////////////////
  TFloatBarParent = Class(TWinControl)
  protected
    procedure CMVisibleChanged(var Message: TMessage); message CM_VISIBLECHANGED;
  end;
///////////////////////// TDockControl / Interface /////////////////////////////

  TDockControl = class(TCustomControl)
  private
    procedure SetXSpacing(aSpace : integer);
    procedure SetYSpacing(aSpace : integer);
    procedure SetCtrlH(aHeight : integer);
    procedure SetCtrlW(aWidth : integer);
    function GetXSpacing : integer;
    function GetYSpacing : integer;
    function GetCtrlH : integer;
    function GetCtrlW : integer;
  published
    property ControlHeight : integer read GetCtrlH write SetCtrlH default 22;
    property ControlWidth : integer read GetCtrlW write SetCtrlW default 22;
    property HorizontalSpacing : integer read GetXSpacing write SetXSpacing default 6;
    property VerticalSpacing : integer read GetYSpacing write SetYSpacing default 3;
  end;

//////////////////////////// TXToolBar / Interface //////////////////////////////
  TDocks = class;  // Forward
  {Events}
  TVDockEvent = procedure(Sender : TObject; Vertical : Boolean) of object;
  {Slave info}
  PSlaveInfo = ^TSlaveInfo;
  TSlaveInfo = record
    SlaveControl,MasterControl : TControl
  end;
  {Groups of controls}
  TGroupInfo = record
    Width,                 {Width in pixels}
    Count : integer;    {Number of controls in the group}
    Items : array[1..MaxCtrlPerGroup] of TControl;
  end;
  TGroupsInfo = array[0..MaxGroup-1] of TGroupInfo;
  {Sizes}
  TAcceptSize = record
    cx,cy : integer;
  end;
  TAcceptSizes = array[0..MaxSizes-1] of TAcceptSize;
  {TXToolBar}
  TToolbarDrawStyle = (csXToolbar, csWord7);
  TDockState = (dsDocked,dsFloat);
  TDockPos = (dpTop,dpBottom,dpLeft,dpRight); // Horizontal <=> x <= dpBottom
  TUsedPos = set of TDockPos;
  TXToolBar = class(TDockControl)
  private
    { Dclarations prives }
    {Evnements}
    FRegKey : string;
    FOnDockChanged,FOnVisibleChanged : TNotifyEvent;
    FOnVDock : TVDockEvent;
    {Autres}

    FDockForm : TForm;         // What form to dock on (MDI Parent form)
    FloatParent : TFloatBarParent;
    PrevBar,NextBar : TXToolBar;

    FDockedTo,FDockingTo,FDockBase : TDocks;

    FakeDocking,
    // If true, a docking will place the bar at the dockpos/dockline instead of dockpt.

    XLoaded,                    //True at the end of loaded method
    Ready2Load,									// True if the bar is ready to be loaded from the registry
    FAutoSave,								 // auto Save & Load position
    SlaveVertical,						 // <=> vertical controls are shown
    ShowActive,
    FMoving,                   // The move frame is drawn
    Docking,                   // Flag true when changing parent window
    FDown          : Boolean;  // Button down?

    OldRect,WinRect : TRect;

    ScrDC : HDC;               // Desktop DC; for move frame

    FUpdatingBounds: Boolean;
    FDockPt,
    FFloatPos,                 // absolute pos of floating win
    MovPos : TPoint;           // Form where the win is dragged - Bar relative
                               // Also used to give new pos to SetDock - absolute

    FSizing,
    CurSizeID,
    FFloatWidth,FFloatHeight,
                               // Size of floating window

    FHWidth,                   // Size when docked horz
    FVHeight,                  //                  vert

    NAcceptSizes,              // Nbr of possible sizes for the win

    NGroups : integer;         // Total nbr of btn groups
    GroupsInfo : TGroupsInfo;  // Info on groups
    AcceptSizes : TAcceptSizes;// Possible sizes of floating win
    FAllowDock : TUsedPos;     // Allowed directions of docking
    FDocks,                   // Possible dock places
    SlaveInfo : TList;

  	FSuppDockLine, FSuppDockPos : Integer; // for internal use, equivalent to FDockLine
	  FDockLine,FDockPos : integer;

    Old : Pointer;

    // Little procs
    procedure DrawMovRect;                   // Draw the move frame w/ oldrect
    procedure AutoResize;                    // Resizes the bar to fit controls
    procedure GetMinSize(var W,H : integer); //Get min clientsize
    procedure CheckMsg(var message : TMessage);
    procedure SetDockLine(Value: Integer);
    procedure SetDockPos(Value: Integer);
		procedure SetDockParams(LineTo, PosTo : integer);
    procedure SetAllowDock(aAllow : TUsedPos);
    procedure SwitchSlave;
    procedure UpdateSizes;
    procedure UpdateDockLine;
    procedure UpdateDockPos;
	  class function ControlInForm(Control,Form : TControl) : Boolean;
		Function SavedToRegistry : boolean; //True if saved
    procedure DrawControls;
  protected
    { Dclarations protges }
    procedure Loaded; override;
    // updates info; size the window & arrange ctrls

    procedure CreateParams(var params : TCreateParams); override;
    procedure SetParent(aParent : TWinControl); override;

		procedure AlignControls(AControl: TControl; var Rect: TRect); override;

    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;

    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    // Used when moving the win
    procedure WMNCHitTest(var Msg : TWMNCHitTest); message WM_NCHITTEST;
    procedure WMNCActivate(var Msg : TWMNCActivate); message WM_NCActivate;
    procedure WMActivate(var Msg : TWMActivate); message WM_ACTIVATE;
    procedure WMMouseActivate(var Msg : TWMMouseActivate); message WM_MOUSEACTIVATE;
    procedure WMClose(var Msg : TMessage); message WM_CLOSE;
    // Hides the win instead of closing & destroying it
    procedure WMSize(var Msg : TWMSize); message WM_SIZE;
    // Updates FloatSize & arrange ctrls
    procedure WMNCLButtonDown(var msg : TWMNCLButtonDown); message WM_NCLBUTTONDOWN;

    procedure CMVisibleChanged(var Message: TMessage); message CM_VISIBLECHANGED;
    // To set good showing attributes
    procedure CMShowingChanged(var Message: TMessage); message CM_ShowingChanged;
    // Calls inherited only when not undocking.
  public
    { Dclarations publiques }
    constructor Create(aOwner : TComponent); override;
    destructor Destroy; override;

		procedure RuntimeCreated;
    procedure NoticeVisibleChanged;
    procedure SetDock(aDock : TDocks);
    procedure UpdateInfo;
    procedure SlaveControl(Master,Slave : TControl);
    procedure LoadPosition;
    procedure SavePosition;
  published
    { Dclarations publies }
    property AllowedDock : TUsedPos read FAllowdock write SetAllowDock default [dpTop, dpLeft, dpRight, dpBottom];
    property AutoSavePosition : boolean read FAutoSave write FAutoSave default false;
    property Caption;
    property Color;
    property DockBase : TDocks read FDockBase write FDockBase;
    property DockedTo : TDocks read FDockedTo write SetDock stored False;
    property DockLine : Integer read FDockLine write SetDockLine;
    property DockPos : Integer read FDockPos write SetDockPos;
    property ParentColor;
    property ParentShowHint;
    property PopupMenu;
		property RegistryKey : string read FRegKey write FRegKey; 
    property Visible;
    property ShowHint;

    property OnDragOver;
    property OnDragDrop;
    property OnDockChanged : TNotifyEvent read FOnDockChanged write FOnDockChanged;
    property OnVerticalDock : TVDockEvent read FOnVDock write FOnVDock;
    property OnVisibleChanged : TNotifyEvent read FOnVisibleChanged write FOnVisibleChanged;
  end;

/////////////////////////////// TDocks / Interface /////////////////////////////

  TDocks = class(TDockControl)
  private
    // Events
    FOnInsertBar,FOnRemoveBar, FOnPaint,
    FOnVisibleChanged : TNotifyEvent;
    // Vars
    FAllowVisible,      //The user allows the dockarea to be visible
    FVisible : Boolean; //The dockarea is actually visible
    FTopAdd,FLeftAdd,FRightAdd,FBottomAdd : integer;

    FPosition : TDockPos;
    FOwnedBars : TList;
    FBoundLines : TUsedPos;

    FDockForm : TForm;         // What form to dock on

    BarLines : TList;
    DropRect : TRect;  // Rect where drop is accepted

    // Drawing style
    FDrawStyle : TToolbarDrawStyle;


    procedure SetPosition(aPos : TDockPos);
    procedure SetBoundLines(aBounds : TUsedPos);
    procedure UpdateSize;
    procedure UpdateDrop;
    procedure UpdateLines;
    function GetLine(const Pos : TPoint;var Line : TList) : integer;
    procedure BuildLine(wanted : integer); //Create as many needed lines until Wanted exist

    procedure RemoveBarFrom(aBar : TXToolBar);
    procedure MoveBarTo(aBar: TXToolBar; Line: TList; DckPos : integer);
    procedure PlaceBarTo(aBar: TXToolBar; Line: TList; DckPos : integer);

    procedure ArrangeBars;

    procedure InsertBar(aBar : TXToolBar; var Pos : TPoint);
    procedure RemoveBar(aBar : TXToolBar);
    procedure MoveBar(aBar : TXToolBar; var Pos : TPoint);

    procedure SetDrawStyle(Value: TToolbarDrawStyle);
    procedure SetVisible(aVisible : boolean);
  protected
    procedure Loaded; override;
    procedure Paint; override;

    procedure CreateParams(var params : TCreateParams); override;

    procedure WMSize(var Msg : TWMSize); message WM_SIZE;
    procedure WMMove(var Msg : TWMMove); message WM_MOVE;
    procedure CMControlListChange(var Msg : TCMControlListChange); message CM_CONTROLLISTCHANGE;
    // Updates if a control is added
  public
    constructor Create(aOwner : TComponent); override;
    destructor Destroy; override;

    property ActualVisible : boolean read FVisible;
    property Visible read FAllowVisible write SetVisible;
  published
    property AllowVisible : boolean read FAllowVisible write SetVisible default true;
    property BoundLines : TUsedPos read FBoundLines write SetBoundLines default [];
    property Canvas;
    property Color;
    property DrawStyle: TToolbarDrawStyle read FDrawStyle write SetDrawStyle;
    property ParentColor;
    property PopupMenu;
    property Position : TDockPos read FPosition write SetPosition nodefault;

    property OnInsertBar : TNotifyEvent read FOnInsertBar write FOnInsertBar;
    property OnPaint : TNotifyEvent read FOnPaint write FOnPaint;
    property OnRemoveBar : TNotifyEvent read FOnRemoveBar write FOnRemoveBar;
    property OnVisibleChanged : TNotifyEvent read FOnVisibleChanged write FOnVisibleChanged;
  end;

////////////////////////////////////////////////////////////////////////////////

procedure Register;

////////////////////////////////////////////////////////////////////////////////
implementation//////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//uses Dialogs;  //For debugging
////////////////////////////// Common Variables ////////////////////////////////

type
  PUsedWinInfo = ^TUsedWinInfo;
  TUsedWinInfo = record
    WinHnd : TWinControl;
    UseCount : integer;
    Old,New : Pointer;
  end;

var
  FXSpacing,FYSpacing,FControlWidth,FControlHeight,
  FBarWidth,FBarHeight,ClLeft,ClTop,NCWidth,NCHeight : integer;
  UsedWindows : TList;

///////////////////////////////// Routines /////////////////////////////////////

procedure UseWindow(win : TWinControl; proc : TWndMethod; var Old : pointer);
var
  InfoPtr : PUsedWinInfo;
  ProcPtr : Pointer;
  i : integer;
begin
  For i := 0 to UsedWindows.Count-1 do
    With PUsedWinInfo(UsedWindows[i])^ do
      if WinHnd = Win then
      begin
        inc(UseCount);
        exit;
      end;
  InfoPtr := new(PUsedWinInfo);
  InfoPtr^.WinHnd := Win;
  ProcPtr := MakeObjectInstance(Proc);
  InfoPtr^.New := ProcPtr;
  Old := Pointer(SetWindowLong(Win.handle, GWL_WNDPROC, Longint(ProcPtr)));
  InfoPtr^.Old := Old;
  InfoPtr^.UseCount := 1;
  UsedWindows.Add(InfoPtr);
end;

procedure StopUseWindow(win : TWinControl);
var
  i : integer;
begin
  For i := 0 to UsedWindows.Count-1 do
    With PUsedWinInfo(UsedWindows[i])^ do
      if WinHnd = Win then
      begin
        dec(UseCount);
        if UseCount = 0 then begin
          If Win.HandleAllocated then
            SetWindowLong(Win.Handle, GWL_WNDPROC, Longint(Old));
          FreeObjectInstance(New);
          Dispose(UsedWindows[i]);
          UsedWindows.Remove(UsedWindows[i]);
        end;
      end;
end;


//////////////////////////////// TXToolBar //////////////////////////////////////
{ TXToolBar ------------ Public }

constructor TXToolBar.Create;
var
  i : integer;
begin
  inherited Create(aOwner);

  // Builds the RegKey
  FRegKey := 'Software\MyCompany\MyApp\ToolBars';

  // Find the form where we should dock
  If not (Owner is TForm) then
    Raise Exception.Create(name+' XToolBar must be owned by a form');
  {if (csDesigning in ComponentState) or (Application.MainForm = NIL) then
    FDockForm := TForm(Owner)
  else
    FDockForm := Application.MainForm;
  {Should NOT be that!}

  FDockForm := TForm(Owner);

  ControlStyle := [csAcceptsControls, csCaptureMouse, csClickEvents,
    csSetCaption, csDoubleClicks];

  If not (csDesigning in ComponentState) then begin
    // Create Floating parent (if not already)
    For i := 0 to FDockForm.ControlCount-1 do begin
      If TControl(FDockForm.Controls[i]) is TFloatBarParent then begin
        FloatParent := TFloatBarParent(FDockForm.Controls[i]);
        break;
      end;
    end;
    If FloatParent = nil then begin
      FloatParent := TFloatBarParent.Create(FDockForm);
      FloatParent.Parent := FDockForm;
    end;
    // Update BarChain
    For i := 0 to FDockForm.ComponentCount-1 do begin
      If TComponent(FDockForm.Components[i]) is TXToolBar then begin
      	If TXToolBar(FDockForm.Components[i]) <> self then begin
	        PrevBar := TXToolBar(FDockForm.Components[i]);
  	      NextBar := PrevBar.NextBar;
    	    PrevBar.NextBar := Self;
      	  NextBar.PrevBar := Self;
        	break;   {Awful, but who cares?}
        end;
      end;
    end;
    If NextBar = nil then begin
      NextBar := Self;
      PrevBar := Self;
    end;
    // Subclass form proc.
    UseWindow(FDockForm,CheckMsg,Old);
  end;

  FDocks := TList.Create;
  SlaveInfo := TList.Create;
  Width := FBarWidth+NCWidth;
  Height := FBarWidth+NCHeight;
  FDockBase := nil;  { for safety, in case it hasn't been set}
  FAllowDock := [dpTop, dpLeft, dpRight, dpBottom]; {Its default value}

end;

destructor TXToolBar.Destroy;
var
  i : integer;
begin
  if Not (csDesigning in ComponentState) then begin
	  If FAutoSave then
  		SavePosition;
    // Don't destroy DockCtrl : it's owned by DockForm
    // Remove from Bar Chain
    PrevBar.NextBar := NextBar;
    NextBar.PrevBar := PrevBar;
    StopUseWindow(FDockForm);
  end;
  Fdocks.Free;
  FDocks := nil;
  i := SlaveInfo.Count;
  While I > 0 do begin
    Dispose(SlaveInfo[I-1]);
    SlaveInfo.delete(i-1);
    i := SlaveInfo.Count;
  end;
  SlaveInfo.Free;
  SlaveInfo := nil;
  inherited Destroy;
end;

procedure TXToolBar.SetDock;
begin
  Parent := aDock;
end;

function CompareControls(item1,item2 : pointer) : integer;
var
	HalfHeight : integer;
begin
  result := TControl(item1).Top-TControl(item2).Top;
  HalfHeight :=
  	(TControl(item1).Height+TControl(item2).height) div 4;
  if (result > -HalfHeight) and
  (result<HalfHeight) then
    result := TControl(item1).left-TControl(item2).Left;
end;

Procedure TXToolBar.UpdateSizes;
var
  i,j,Max,Min,W,H : integer;
  OldSlaveState : boolean;
begin
 DisableAlign;
  //Calc groups sizes
  For i := 0 to NGroups-1 do begin
    GroupsInfo[i].Width := 0;
    For j := 1 to GroupsInfo[i].Count do
    	With GroupsInfo[i] do
      	if Items[j].Visible then
		     inc(GroupsInfo[i].Width,Items[j].Width);
  end;
  OldSlaveState := SlaveVertical;

  If SlaveVertical then SwitchSlave;
  Min := 0;
  Max := 0;

  {Calculation of min-max width}
  For i := 0 to NGroups-1 do
  	For j := 1 to GroupsInfo[i].Count do
    	With GroupsInfo[i].Items[j] do
	    	If Visible then begin
			    if Min < Width then
      			Min := Width;
			    inc(Max,Width);
		    end;

  If Max = 0 then begin
    NAcceptSizes := 1; {No visible control}
    AcceptSizes[0].cx := FBarWidth+NCWidth;
    AcceptSizes[0].cy := FBarHeight+NCHeight;
  end else begin
    inc(min,FXSpacing*2); //Adds spacings
    inc(max,FXSpacing*NGroups+FXSpacing);
    //  Now calc best sizes
    W := min;
    GetMinSize(W,H);
    AcceptSizes[0].cx := W+NCWidth;
    AcceptSizes[0].cy := H+NCHeight;
    j := 0;
    For i := min+1 to max do begin
      W := i;
      GetMinSize(W,H);
      inc(H,NCHeight); // Client -> window
      inc(W,NCWidth);
      If H < AcceptSizes[j].cy-2 then begin //-2 to prevent too much resizings
        inc(j);
        AcceptSizes[j].cy := H;
        AcceptSizes[j].cx := W;
      end;
    end;
    NAcceptSizes := j+1;
  end;
  // Set docked sizes
  If not SlaveVertical then SwitchSlave;
  FVHeight := FYSpacing+Ngroups*FYSpacing;
  For i := 0 to NGroups-1 do
  	For j := 1 to GroupsInfo[i].Count do
    	With GroupsInfo[i].Items[j] do
      	If Visible then
			  	Inc(FVHeight,Height);
  FHWidth := AcceptSizes[NAcceptSizes-1].cx-NCWidth;
  If OldSlaveState xor SlaveVertical then
  	SwitchSlave;

  // Reset size
	AutoResize;
  EnableAlign;
end;

Procedure TXToolBar.UpdateInfo;

procedure GroupInfo;
var
  i,GrpI : integer;
  ChildControls : TList;
begin
  // Set GroupsInfo
  ChildControls := TList.Create;
  For i := 0 to ControlCount-1 do
  	ChildControls.Add(Controls[i]);
  ChildControls.Sort(CompareControls);
  GroupsInfo[0].Count := 1;
  GroupsInfo[0].Items[1] := ChildControls[0];
  i := 1;
  GrpI := 0;
  With CHildCOntrols do
    While i < Count do begin
      if
      ((TControl(Items[i]).Top = TControl(Items[i-1]).Top) and
      (TControl(Items[i]).Left <= TControl(Items[i-1]).Left + TControl(Items[i-1]).Width))
      or
      ((TControl(Items[i]).Left <= TControl(Items[i-1]).Left) and
      (TControl(Items[i]).Top <= TControl(Items[i-1]).Top + TControl(Items[i-1]).Height))

        then begin
        Inc(GroupsInfo[GrpI].Count);
        GroupsInfo[GrpI].Items[GroupsInfo[GrpI].Count] := TControl(CHildCOntrols.Items[i]);
      end else begin
        Inc(GrpI);
        GroupsInfo[GrpI].Items[1] := TControl(CHildCOntrols.Items[i]);
        GroupsInfo[GrpI].Count := 1;
      end;
      inc(i);
    end;
  NGroups := GrpI+1;
	ChildControls.Free;
end;

begin
  If ControlCount > 0 then begin
    GroupInfo;
  end else begin
    NGroups := 0;
  end;
  UpdateSizes;
end;

procedure TXToolBar.NoticeVisibleChanged;
begin
	UpdateSizes;
end;

procedure TXToolBar.RuntimeCreated;
// To be called after creation at runtime...
begin
	Loaded;              //Sets up many params
  Destroyhandle;       // Shows the bar - Prehaps this would cause problem w/ combo boxes
  UpdateControlState;
end;

{$WARNINGS OFF}

Function TXToolBar.SavedToRegistry : boolean;
var
	Reg : TRegIniFile;
begin
	try
  	Reg := TRegIniFile.Create(FRegKey);
    Result := Reg.ReadString(Name, 'DockedTo', TB_NO_DOCKED) <> TB_NO_DOCKED;
  finally
    Reg.Free; //Ok warning
  end;
end;

procedure TXToolBar.LoadPosition;
  function FindDock(sName: String): TDocks;
  var
    i: Integer;
  begin
    Result := NIL;
    if Assigned(FDockForm) then
      for i := 0 to FDockForm.ControlCount - 1 do
        if (TControl(FDockForm.Controls[i]) is TDocks) and
           (TDocks(FDockForm.Controls[i]).Name = sName) then
      		begin
          Result := TDocks(FDockForm.Controls[i]);
          break;
          end;
  end;

var
  Reg: TRegIniFile;
  nLeft, nTop, nWidth, nHeight: Integer;
  sDockedTo: String;
  Docks: TDocks;
begin
  if not (csDesigning in ComponentState) then
  	try
      Reg := TRegIniFile.Create(FRegKey);
      // The status was saved ?
      sDockedTo := Reg.ReadString(Name, 'DockedTo', TB_NO_DOCKED);
      if sDockedTo <> TB_NO_DOCKED then
        begin
        if sDockedTo <> '' then
          begin
          Docks := FindDock(sDockedTo);
          if Assigned(Docks) then
            begin
            FDockLine := Reg.ReadInteger(Name, 'DockLine', FDockLine);
            FDockPos  := Reg.ReadInteger(Name, 'DockPos', FDockPos);
						If Xloaded and (FDockLine >= Docks.BarLines.Count) then
							FDockLine := Docks.BarLines.Count;
            //Prevents to get empty barlines
            FakeDocking := True;
            DockedTo := Docks;
            FakeDocking := False;
            end;
          end
        else
          begin
          DockedTo := NIL;
          nLeft   := Reg.ReadInteger(Name, 'Left', Left);
          nTop    := Reg.ReadInteger(Name, 'Top', Top);
          nWidth  := Reg.ReadInteger(Name, 'Width', Width);
          nHeight := Reg.ReadInteger(Name, 'Height', Height);
          MoveWindow(Handle, nLeft, nTop, nWidth, nHeight, True);
          end;
        end;
    finally
      Reg.Free; //Ok warning
    end;
end;

procedure TXToolBar.SavePosition;
var
  Reg: TRegIniFile;
begin
  if not (csDesigning in ComponentState) then
    try
      Reg := TRegIniFile.Create(FRegKey);
      if Assigned(FDockedTo) then
        begin
        Reg.WriteString(Name, 'DockedTo', FDockedTo.Name);
        Reg.WriteInteger(Name, 'DockLine', FDockLine);
        Reg.WriteInteger(Name, 'DockPos', FDockPos);
        end
      else
        begin
        Reg.WriteString(Name, 'DockedTo', '');
        Reg.WriteInteger(Name, 'Left', Left);
        Reg.WriteInteger(Name, 'Top', Top);
        Reg.WriteInteger(Name, 'Width', Width);
        Reg.WriteInteger(Name, 'Height', Height);
        end;
    finally
      Reg.Free;  //Then again
    end;
end;

{$WARNINGS ON}

{ TXToolBar ------------ Protected }

procedure TXToolBar.AlignControls(aControl : TCOntrol; var Rect : TRect);
var
  cx,cy,i,j,k : integer;
  prec1line : boolean; {"carriage return" before?}
begin // Ignores the parameters is OK
	If (csDesigning in ComponentState) then
  	UpdateInfo;
  If NGroups = 0 then exit;
  cx := 0;
  cy := FYSpacing;
  Prec1Line := true;
  For i := 0 to NGroups-1 do begin
    if (Prec1line) and ((cx+GroupsInfo[i].Width+2*FXspacing <= Self.ClientWidth) or (cx<=FXspacing)) then
      inc(cx,FXSpacing)
    else begin
      cx := FXspacing;
      k := GroupsInfo[i-1].Count ;
      If (k > 0) and (i > 0) then
	      inc(cy,GroupsInfo[i-1].Items[k].Height+FYSpacing);
        {This supposes there is at least ONE visible control in the prec group}
    end;
    Prec1Line := true;
    k := 0;
    For j := 1 to GroupsInfo[i].Count do
      With GroupsInfo[i].Items[j] do
      	If Visible then begin
	        if Width+cx+FXspacing > Self.ClientWidth then begin
  	        cx := FXSpacing;
    	      //inc(cy,FControlHeight);
      	    if k > 0 then
	      	    inc(cy,GroupsInfo[i].Items[k].Height);
	          prec1line := false;
  	      end;
          k := j;
			    Left := cx;
      	  Top := cy;
        	inc(cx,width);
	      end;
  end;
end;

procedure TXToolBar.Loaded;
{
  Sets docks list
  Sets control list
  Set Groups contents
  >UpdateInfo
  >arrange ctrls
}

var
  p : TPoint;
  bar : txtoolbar;
begin
  SetAllowDock(FAllowDock); {Forces setting up FDocks}
  If FDockedTo <> nil then
		FFloatWidth := 300   { maximum Float Width at start}
  else
  	FFloatWidth := Width;

  DisableAlign;
  UpdateInfo;

  If FAutoSave and not (csDesigning in ComponentState) and SavedToRegistry then begin
  	//Load pos/size form registry
	  If not Ready2Load then begin
		  // Undock all autoloading bars
  		Bar := Self;
    	Repeat
	  		If Bar.FAutoSave then begin
  	  		Bar.DockedTo := nil;
    	  	Bar.Ready2Load := True;
	      end;
		  	Bar := Bar.NextBar
  		until self = bar;
	  end;
  	LoadPosition
  end
  else begin
  	// Recalc pos/size
	  If FDockedTo = nil then begin
  	  If not (csDesigning in ComponentState) then
    		SetBounds(Left+FDockForm.Left,Top+FDockForm.Top
      		,FFloatWidth,FFloatHeight);
	  end
  	else begin
    	If FDockedTo.Position <= dpBottom then
      	SetBounds(Left,Top,FHWidth,FBarHeight)
	    else
  	    SetBounds(Left,Top,FBarWidth,FVHeight);

	  end;

	  P.X := Left; P.Y := Top;
  	FFloatPos := Parent.ClientToScreen(P);
	  if FDockedTo <> nil then FDockBase := FDockedTo;
  end;
  SlaveVertical := not ( (FDockedTo = nil) or (FDockedTo.Position <= dpBottom));

  EnableAlign;

  XLoaded := True;
  UpdateDockLine;
  UpdateDockPos;
  inherited Loaded;
end;

{$WARNINGS OFF}

procedure TXToolBar.SetParent(AParent: TWinControl);
var
  ChVert : boolean;
  OldActive,DummyCtrl : TWinControl;
begin
  if (csDestroying in ComponentState) then begin
    inherited SetParent(aParent);
    exit;
  end;

  If (aParent = nil) or (not (aParent is TDocks)) then begin
    if csDesigning in ComponentState then
      aParent := FDockForm
    else
      aParent := FloatParent;
    FDockingTo := nil;
  end else
    FDockingTo := TDocks(aParent);

  if Parent = AParent then exit;

  DisableAlign;
  ChVert := ((FDockingTo  <> nil) and (FDockingTo.FPosition > dpBottom)) xor
    ((FDockedTo <> nil) and (FDockedTo.FPosition > dpBottom ));

  OldActive := FDockForm.ActiveControl;

  If (Parent = nil) or (OldActive = nil) or (OldActive = Self) or (not OldActive.Visible) then
  	OldActive := Nil;
  If OldActive <> nil then begin
  	DummyCtrl := TWinControl.Create(Self);
  	DummyCtrl.Parent := Self;
	  DummyCtrl.SetFocus;
  end;

  Docking := True; {Flag used in CMShowingChanged & AlignCtrls}

  If ChVert then
    SwitchSlave;// no need to call UpdateSizes

  inherited SetParent(AParent);
  If (fDockingTo = Nil) then {Go back to oldpos}
  	If (csDesigning in ComponentState) then begin
      If FDockBase <> nil then
      	SetBounds(FDockBase.Left+Left,FDockBase.Top+Top,FFloatWidth,FFloatHeight);
    end else
    	MoveWindow(Handle,FFloatPos.x,FFloatPos.y,FFloatWidth,FFloatHeight,True);

  Docking := False; {Flag back to normal}

  If ((FDockedTo = nil) xor (FDockingTo = nil)) or (csDesigning in
ComponentState) then
  begin
		If (FDockedTo <> nil) then
    	FDockBase := FDockedTo;  
    Destroyhandle;
  end;
  UpdateControlState;

  Perform(WM_NCACTIVATE,0,0); {Shows that beautiful activated caption!}

  If OldActive <> nil then begin
  	If OldActive.Visible then
	  	OldActive.SetFocus;
    DummyCtrl.Free; //Ok warn
  end; {Gives the focus to the control that might have just lost it due to a destroyhandle}

  EnableAlign;

  {Set fields and call events}
  FDockedTo := FDockingTo;
  If (FDockedTo <> nil) then
  	FDockBase := FDockedTo;  
  If assigned(FOnVDock) and ChVert then
    FOnVDock(Self,(FDockedTo  <> nil) and (FDockedTo.FPosition > dpBottom));
  if assigned(FOnDockChanged) then
    FOnDockChanged(Self);

end;

{$WARNINGS ON}

procedure TXToolBar.CreateParams;
begin
  inherited CreateParams(Params);
  with Params do
  begin
    WindowClass.style := WindowClass.Style or CS_DBLCLKS;

    if FDockingTo = nil then begin
 	    ExStyle := ExStyle or WS_EX_TOOLWINDOW; // Ignored by Windows if no caption
      if csDesigning in ComponentState then
         Style := (Style or WS_CAPTION or WS_SYSMENU)
      else begin
        Style := (Style or WS_POPUP or WS_SYSMENU or WS_CAPTION)
          and not (WS_CHILD or WS_GROUP or WS_TABSTOP);
        end;
    end else
    	ExStyle := ExStyle; // or WS_EX_TRANSPARENT; //bugged!! :(
  end;
end;

class function TXToolBar.ControlInForm(Control,Form : TControl) : Boolean;
begin
  if (Control = nil) then
  begin
    result := false;
    exit;
  end;
  While Control.Parent <> Nil do
    Control := Control.Parent;
  result := Control = Form;
end;

procedure TXToolBar.CheckMsg(var Message : TMessage);
function NotControlInToolBar(Control : TControl) : longBool;
begin
  if (Control = nil) then
  begin
    result := true;
    exit;
  end;
  While (Control.Parent <> Nil) and (not(Control is TXToolBar)) do
    Control := Control.Parent;
  result := Control is TForm;
end;

var
  NewActive : boolean;
  Bar : TXToolBar;

begin
  With Message do
    Case Msg of
      WM_ACTIVATE : begin // Show inactive title when other win isactivated.
        NewActive := (wParam <> WA_INACTIVE) or ControlInForm(FindControl(lParam),FDockForm);
        If ShowActive xor NewActive then begin
          Bar := Self;
          Repeat
            Bar.ShowActive := NewActive;
            PostMessage(Bar.Handle,WM_NCACTIVATE,0,0);
            Bar := Bar.NextBar;
          until Bar =Self
        end;
        if (wParam <> WA_INACTIVE) then
        	SendMessage(FDockForm.Handle,WM_NCACTIVATE,1,0)
        else
        	SendMessage(FDockForm.Handle,WM_NCACTIVATE,0,0);

        if (FDockForm.FormStyle=fsMDIForm) or
        NotControlInToolBar(FDockForm.ActiveControl) then
          result := CallWindowProc(Old,FdockForm.Handle,Msg,wParam,lParam);
        end;
      WM_SETFOCUS : begin      // Prevents re-focus of toolbar.
        if (FDockForm.FormStyle=fsMDIForm) or
        NotControlInToolBar(FDockForm.ActiveControl) then
          result := CallWindowProc(Old,FdockForm.Handle,Msg,wParam,lParam);
        end;
      WM_SHOWWINDOW : begin
        FloatParent.Visible := wParam <> 0;
        result := CallWindowProc(Old,FdockForm.Handle,Msg,wParam,lParam);
        end;
      WM_NCACTIVATE : begin  // Doesn't show inactive title if toolbar is activated
        wparam := Ord(ShowActive);
        result := CallWindowProc(Old,FdockForm.Handle,Msg,wParam,lParam);
        end;
      else
        result := CallWindowProc(Old,FdockForm.Handle,Msg,wParam,lParam);
    end;
end;

procedure TXToolBar.WMMouseActivate;
begin
  inherited;
  If not (csDesigning in ComponentState) then begin
    msg.Result := MA_NOACTIVATE;
    SetActiveWindow(FDockForm.Handle);
    SetWindowPos(Handle,HWND_TOP,0,0,0,0,
    SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE)
  end;
end;

procedure TXToolBar.WMNCActivate(var Msg : TWMNCActivate);
begin
  With msg do begin
    Active := ShowActive;
    inherited;
  end
end;

procedure TXToolBar.WMActivate;
var
  newactive : boolean;
  Bar : TXToolBar;
begin
  //If not (csDesigning in ComponentState) then
  begin
    With Msg do
      NewActive := (Active <> WA_INACTIVE) or ControlInForm(FindControl(ActiveWindow),FDockForm);
      If ShowActive xor NewActive then begin
        Bar := Self;
        Repeat
          Bar.ShowActive := NewActive;
          PostMessage(Bar.Handle,WM_NCACTIVATE,0,0);
          Bar := Bar.NextBar;
        until Bar=Self
      end;
    if (NewActive) then
    	PostMessage(FDockForm.Handle,WM_NCACTIVATE,1,0)
    else
    	PostMessage(FDockForm.Handle,WM_NCACTIVATE,0,0);
  end;
  inherited;
end;

procedure TXToolBar.CMVisibleChanged(var Message: TMessage);
begin
  inherited;
  If (DockedTo <> nil) and not (csDesigning in ComponentState) then begin
    if Visible then
      DockedTo.InsertBar(Self,FDockPt)
    else
      DockedTo.RemoveBar(Self);
  end;
  If Assigned(FOnVisibleChanged) then
    FOnVisibleChanged(Self);
end;

procedure TXToolBar.WMNCHitTest(var Msg : TWMNCHitTest);
begin
  inherited;
  if FDockedTo = nil then
    With msg do begin
      if Result = HTCAPTION then begin
        Result := HTCLIENT;
        exit;
      end;
      if Result = HTBORDER then begin
        If xPos < Left+5 then Result := HTLEFT else
        if xPos > Left+Width-5 then result := HTRIGHT else
        if ypos < Top+5 then result := HTTOP else
        //if ypos > Top+Height-5 then
          result := HTBOTTOM;
      end;
    end;
end;

procedure TXToolBar.CMShowingChanged(var Message: TMessage);
begin
  If (not Docking) or (FDockingTo <> nil) then
    inherited;
end;

procedure TXToolBar.WMClose;
begin
  msg.result := 0;
  Hide;
end;

procedure TXToolBar.WMSIZE;
begin
  Inherited;
  If (FDockingTo=nil) and (not Docking) then begin
    If csDesigning in ComponentState then begin
      UpdateInfo;
    end;
    FFloatHeight := Height;
    FFloatWidth := Width;
  end;
end;

procedure TXToolBar.WMNCLBUTTONDOWN;
begin
  Inherited;
  With msg do begin
    if (HitTest >= 10) and (HitTest <= 17) then begin
      FSizing := HitTest;
      FDown := True;
      SetCapture(Handle);
      WinRect := Rect(0,0,Width,Height);

      OldRect := WinRect;
      OffsetRect(Oldrect,Left,Top);
      ScrDC := GetDC(0);
      DrawMovRect;
      ReleaseDC(0,ScrDC);
    end;
  end;
end;


procedure TXToolBar.MouseDown;
begin
  if Button <> mbLeft then exit;
  if ssDouble in Shift then

  begin
    FDown := False;
    if FMoving = true then begin
      DrawMovRect;
      FMoving := False;
    end;
    if FDockedTo = nil
      then SetDock(FDockBase)    { this swaps FDockedTo and FDockBase }
      else SetDock(nil);
  end else

  begin   //Simple click
    If FDockedTo = nil then
      MovPos := Point(X+ClLeft,Y+ClTop)// Add Client origin in Windows coord.
    else
      MovPos := Point(X,Y);
    FDown := True;
    FMoving := True;
    GetWindowRect(Handle,WinRect);
    OffsetRect(WinRect,-x,-y);

  	ScrDC := GetDc(0);
    FMoving := True;
    OldRect := WinRect;
    OffsetRect(OldRect,X,Y);
    DrawMovRect;
    ReleaseDC(0,ScrDC);
  end;
end;

procedure TXToolBar.MouseMove;

procedure ReSize;
var
  L,i : integer;
begin
  if (FSizing = HTBOTTOM) or (FSizing = HTTOP) then begin
    Inc(Y,CLTop);
    With WinRect do
      If FSizing = HTTOP then
        L := Bottom-Y+3
      else
        L := Y+3;
    i := 0;
    While (i < NAcceptSizes-1) and (AcceptSizes[i].cy > L) do inc(i);

  end else begin
    Inc(X,ClLeft);
    With WinRect do
      If FSizing = HTLEFT then
        L := Right-X+3
      else
        L := X+3;
      i := NAcceptSizes-1;
    While (i > 0) and (AcceptSizes[i].cx > L) do dec(i);
  end;

  If i <> CurSizeID then begin

    With WinRect do begin
      if FSizing = HTTOP then
        Top := Bottom-AcceptSizes[i].cy
      else
        Bottom := AcceptSizes[i].cy;
      if FSizing = HTLEFT then
        Left := Right-AcceptSizes[i].cx
      else
        Right := AcceptSizes[i].cx;
    end;
    ShowCursor(False); // Reduce flicker
    ScrDC := GetDC(0);
    DrawMovRect;
    OldRect := WinRect;
    OffsetRect(OldRect,Left,Top);
    DrawMovRect;
    ReleaseDC(0,ScrDC);
    ShowCursor(True);
    CurSizeID := i;
  end;
end;

var
  NxtDock : TDocks;
  pt : TPoint;
  i : integer;
begin
  if not FDown then exit;
  If FSizing <> 0 then begin
    resize;
    exit;
  end;
  If FMoving then begin
    Pt := Point(x,y);        // Where is the cursor?
    Windows.ClientToScreen(Handle,Pt);
    Windows.ScreenToClient(FDockForm.Handle,Pt);
    NxtDock := nil;
    For i := 0 to FDocks.Count-1 do
      If PtInRect(TDocks(FDocks[i]).DropRect,Pt) then begin
        NxtDock := TDocks(FDocks[i]);
        break;
      end;

    if NxtDock <> FDockingTo then begin
      If NxtDock = nil then begin
        Winrect := Rect(-FFloatWidth div 2,-8,FFloatWidth div 2,FFloatHeight - 8);
        MovPos := Point(FFloatWidth div 2,8);
      end else
        If NxtDock.FPosition <= dpBottom then begin//Horz
          WinRect := Rect(-FHWidth div 2,-8,FHWidth div 2,FBarHeight - 8);
          Movpos := Point(FHWidth div 2,8);
        end else begin //Vert
          WinRect := Rect(-8,-FVHeight div 2,FBarWidth-8,FVHeight div 2);
          MovPos := point(8,FVHeight div 2);
        end;
        Windows.ClientToScreen(Handle,Winrect.TopLeft);
        Windows.ClientToScreen(Handle,WinRect.BottomRight);

    end;

    ShowCursor(False);       // Reduces Cur. flicker
    ScrDC := GetDC(0);
    DrawMovRect;             // Wipe old
    FDockingTo := NxtDock;   // Only now coz used by DrawMovRect
    OldRect := WinRect;
    OffsetRect(OldRect,X,Y);
    DrawMovRect;
    ReleaseDC(0,ScrDC);
    ShowCursor(True);
  end;
end;

procedure TXToolBar.MouseUp;
begin
  FDown := False;
  if FMoving then begin
    ScrDC := GetDC(0);
    DrawMovRect;
    ReleaseDC(0,ScrDC);
    MovPos := Point(x-movpos.x,y-movpos.y);
    Windows.ClientToScreen(Handle,MovPos);
    if FDockingTo = nil then
      FFloatPos := MovPos
    else begin
      FDockPt := MovPos;
      Windows.ScreenToClient(FDockingTo.Handle,FDockPt)
    end;
    If FDockingTo <> FDockedTo then
      SetDock(FDockingTo)
    else
      if FDockedTo = nil then
        MoveWindow(handle,MovPos.x,MovPos.y,FFloatWidth,FFloatHeight,true)
      else
        FDockedTo.MoveBar(Self,FDockPt);
    FMoving := False;
    exit;
  end;
  If FSizing <>0 then begin
    FSizing := 0;
    ReleaseCapture;
    ScrDC := GetDC(0);
    DrawMovRect;
    ReleaseDC(0,ScrDC);
    With OldRect do begin
      FFloatPos := TopLeft;
      MoveWindow(handle,Left,Top,Right-Left,Bottom-Top,true)
    end;
  end;
end;


procedure TXToolBar.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
var
   P: TPoint;
   Line: TList;
   Zone: Integer;
begin
  If (csDesigning in ComponentState) and (FDockedTo <> nil) and
  not (csLoading in ComponentState) and not FUpdatingBounds then
  	with FDockedTo do begin
      P := Point(ALeft+1, ATop+1);    //That allows to set the line visually
      Zone := GetLine(P, Line);
 	  	If FPosition <= dpBottom then begin
      	FHWidth := AWidth;
      	SetDockParams(Zone,ALeft-2)
      end
	    else begin
  	  	FVHeight := AHeight;
      	SetDockParams(Zone,ATop-2);
      end;
      ArrangeBars;
    end
  else
	  inherited SetBounds(ALeft, ATop, AWidth, AHeight);
end;

{TXToolBar -------- Private}

Procedure TXToolBar.SetAllowDock;
var
	i : integer;
begin
	FAllowDock := aAllow;
	// Sets Dockareas
	if not (csReading in ComponentState) then
		With FDockForm do
		  For i := 0 to ControlCount-1 do
    	  If Controls[i] is TDocks then
        	If TDocks(Controls[i]).position in FAllowDock then
	      		FDocks.Add(Controls[i]);
end;

procedure TXToolBar.SetDockLine(Value: Integer);
begin
  if (Value <> FSuppDockLine) then begin
     FSuppDockLine := Value;
     if not (csLoading in ComponentState) then
        UpdateDockLine;
  end;
end;

procedure TXToolbar.UpdateDockLine;
begin
   SetDockParams(FSuppDockLine,FDockPos);
end;

procedure TXToolBar.SetDockPos(Value: Integer);
begin
   if (Value <> FSuppDockPos) then begin
      FSuppDockPos := Value;
      if not (csLoading in ComponentState) then
         UpdateDockPos;
   end;
end;

procedure TXToolbar.UpdateDockPos;
begin
   SetDockParams(FDockLine,FSuppDockPos);
end;


Procedure TXToolBar.SetDockParams(LineTo, PosTo : integer);
var
   Line: TList;
begin
  If (FDockedTo <> nil) and ((PosTo <> FDockPos) or (LineTo <> FDockLine)) then
  	with FDockedTo do begin
      if LineTo > BarLines.Count-1 then begin
        Line := TList.Create;
        BarLines.Add(Line); end
      else
        Line := BarLines[LineTo];
  	  MoveBarTo(Self, Line, PosTo);
    end;
end;

procedure TXToolBar.DrawControls;
var
	i : integer;
begin
	For i := 0 to ControlCount -1 do
  	TControl(Controls[i]).Invalidate;
end;

procedure TXToolBar.AutoResize;
var
  w,h : integer;
begin
	If (FDockingTo <> FDockedTo) then exit;
  W := FFloatWidth;
  GetMinSize(W,H);
  Inc(W,NCWidth);
  Inc(H,NCHeight);
  FFloatWidth := W;
  FFloatHeight := H;
  CurSizeID := 0;
  While (CurSizeID < NAcceptSizes-1) and ((AcceptSizes[CursizeID].cx <> W) or (AcceptSizes[CurSizeID].cy <> H)) do
  	inc(CurSizeID);  // Suppose sizes OK
  Refresh;
  if (csDesigning in ComponentState) then exit;
  If FDockedTo <> nil then begin
  	FDockedTo.ArrangeBars;
  end else begin
  	SetBounds(Left,Top,W,H);
  end;
end;

procedure TXToolBar.SlaveControl;
var
	tmp : TControl;
  info : PSlaveInfo;
begin
	If SlaveVertical then begin
  	Tmp := Master; //We're vertical, so Master is in fact slave
  	Master := Slave;
    Slave := Tmp;
  end;

  New(Info);
  SlaveInfo.Add(Info);

  Slave.Hide;
  Info.SlaveControl := Slave;
  Info.MasterControl := Master;

  UpdateSizes;
end;

procedure TXToolBar.SwitchSlave;
var
  i : integer;
  Temp : TControl;
begin
  For i := 0 to SlaveInfo.Count -1 do
    With PSlaveInfo(SlaveInfo[i])^ do begin
      Temp := SlaveControl;
      SlaveControl := MasterControl;
      MasterControl := Temp;
      DisableAlign;
      SlaveControl.Hide;
      MasterControl.Show;
      EnableAlign;
    end;
  SlaveVertical := not SlaveVertical;
  //UpdateSizes; arg! call it if you wanna deadlock!
  // and there is no need to call it!
end;

procedure TXToolBar.DrawMovRect;
var
  R : TRect;
begin
  R := OldRect;
  DrawFocusRect(ScrDC,R);
  If FDockingTo = nil then begin
    inflateRect(R,-1,-1);
    DrawFocusRect(ScrDC,R);
    inflateRect(R,-1,-1);
    DrawFocusRect(ScrDC,R);
  end;
end;

{$WARNINGS OFF}

procedure TXToolBar.GetMinSize;
var
  mx,cx,cy,i,j,k : integer;
  prec1line : boolean;
begin
	If ControlCount = 0 then begin
  	W := FBarWidth;
    H := FBarHeight;
    exit;
  end;
  mx := 0;
  cx := 0;
  cy := FYspacing;
  Prec1Line := true;
  For i := 0 to NGroups-1 do begin
    if (Prec1line) and ((cx+GroupsInfo[i].Width+2*FXspacing <= W) or
(cx<=FXspacing)) then
      inc(cx,FXspacing)
    else begin
      cx := FXspacing;
      If ( i > 0 ) and(k>0) then //Ok warn
	      inc(cy,GroupsInfo[i-1].Items[k].Height+FYSpacing);
    end;
    Prec1Line := true;
    k :=0;
    For j := 1 to GroupsInfo[i].Count do
      With GroupsInfo[i].Items[j] do
      	If Visible then begin
	        if Width+cx+FXspacing > W then begin
	          cx := FXSpacing;
      	    if k > 0 then
	      	    inc(cy,GroupsInfo[i].Items[k].Height);
	          prec1line := false;
          end;
          k := j;
	        inc(cx,width);
  	      if mx<cx then mx := cx;
    	  end;
  end;
  W := Mx+FXspacing;
  H := Cy+FYSpacing+FcontrolHeight;
end;

{$WARNINGS ON}

///////////////////////// TDocks
///////////////////////////////////////////////

///////////////////////// TDocks / Public
//////////////////////////////////////
constructor TDocks.Create;
begin
  inherited Create(aOwner);
  If not (aOwner is TForm) then
    Raise Exception.Create('TDocks must be owned by a form');
  FDockForm := TForm(aOwner);
  ControlStyle := [csAcceptsControls, csSetCaption];
  if csDesigning in ComponentState then begin
    align := alTop;
    Height := FBarHeight;
  end;
  FAllowVisible := True;
  BarLines := Tlist.Create;
end;

destructor TDocks.Destroy;
begin
  While BarLines.Count > 0 do begin
    TList(BarLines[BarLines.Count-1]).Free;
    BarLines.Delete(BarLines.Count-1);
  end;
  BarLines.Free;
  Inherited Destroy;
end;

//////////////////////// TDocks / Protected
////////////////////////////////////

function ComparePos(Item1,Item2 : pointer) : integer;
begin
  result := TXToolBar(Item1).DockPos - TXToolBar(Item2).DockPos;
end;

procedure TDocks.ArrangeBars;

procedure HorzArrange;
var
  Line,i,lim : integer;
  BarLine : TList;
begin
  For Line := 0 to BarLines.Count - 1 do begin
    BarLine := BarLines[Line];
    lim := FLeftAdd-2;

    For i := 0 to BarLine.Count - 1 do
      With TXToolBar(BarLine[i]) do begin
        FUpdatingBounds := True;
        if FDockPos > self.Width - FHWidth-FRightAdd-2 then
          FDockPos := Self.Width - FHWidth-FRightAdd-2;
        if FDockPos < Lim then
          FDockPos := Lim;
        Lim := FDockPos + FHWidth + 2;
        SetBounds(FDockPos+2,FTopAdd+(FBarHeight+2)*Line,FHWidth,FBarHeight);
        FUpdatingBounds := False;
      end;
  end;
end;

procedure VertArrange;
var
  i,lim,Line : integer;
  BarLine : TList;
begin
  For Line := 0 to BarLines.Count - 1 do begin
    BarLine := BarLines[Line];
    lim := FTopAdd-2;

    For i := 0 to BarLine.Count - 1 do
      With TXToolBar(BarLine[i]) do begin
        FUpdatingBounds := True;
        if FDockPos + FVHeight > self.Height-FBottomAdd-2 then
          FDockPos := Self.Height - FVHeight-FBottomAdd-2;
        if FDockPos < Lim then
          FDockPos := Lim;
        Lim := FDockPos + FVHeight + 2;
        SetBounds(FLeftAdd+Line*(FBarWidth+2),FDockPos+2,FBarWidth,FVHeight);
        FUpdatingBounds := False;
    	end;
  end;
end;

begin
  If FPosition <= dpBottom then
    HorzArrange
  else
    VertArrange;
  Invalidate;
end;

procedure TDocks.Loaded;
begin
  inherited Loaded;
  ArrangeBars;
end;

procedure TDocks.UpdateLines;
var
  L,i : integer;
begin
  For L := 0 to BarLines.Count-1 do
    For i := 0 to TList(BarLines[L]).Count-1 do
      TXToolBar(TList(BarLines[l])[i]).FDockLine := L;
end;

Procedure TDocks.BuildLine(wanted : integer);
begin
	While BarLines.Count-1 < wanted do
  	BarLines.Add(TList.Create)
end;

function TDocks.GetLine(const Pos : TPoint;var Line : TList) : integer;
var
  inserting : Boolean;
begin
  if FPosition <= dpBottom then begin
    result := (2*(Pos.y-FTopAdd)+3*FBarHeight div 2) div FBarHeight;
  end else begin
    result := (2*(Pos.x-FLeftAdd)+3*FBarWidth div 2) div FBarWidth;
  end;

  Inserting := (result mod 2) = 0;
  result := result div 2;
  if result > BarLines.Count-1 then begin
    result := BarLines.Count;
    Line := TList.Create;
    BarLines.Add(Line);
  end else begin
    if Inserting then begin
      Line := TList.Create;
      BarLines.Insert(result,Line);
      UpdateLines;
    end else
      Line := BarLines[result];
  end;
end;

procedure TDocks.RemoveBarFrom(aBar : TXToolBar);
var
  Line : TList;
begin
  Line := BarLines[aBar.FDockLine];
  Line.Remove(aBar);
  if Line.Count = 0 then begin
    BarLines.Remove(Line);
    Line.Free;
    UpdateLines;
    UpdateSize;
  end;
end;

procedure TDocks.MoveBarTo(aBar: TXToolBar; Line: TList; DckPos : integer);
begin
  If BarLines.IndexOf(Line) <> aBar.FDockLine then begin
    RemoveBarFrom(aBar);
		PlaceBarTo(aBar,Line, DckPos);
  end else begin
	  aBar.FDockPos := DckPos;
		Line.Sort(ComparePos);
	  ArrangeBars;
  	UpdateSize;
  end;
end;

procedure TDocks.PlaceBarTo(aBar : TXToolBar; Line : TList; DckPos : integer);
begin
  Line.Add(aBar);
  aBar.FDockLine := BarLines.IndexOf(Line);
  aBar.FDockPos := DckPos;
	Line.Sort(ComparePos);
  ArrangeBars;
  UpdateSize;
end;

procedure TDocks.RemoveBar;
begin
  RemoveBarFrom(aBar);
  ArrangeBars;
  If assigned(FOnRemoveBar) then
    FOnRemoveBar(Self);
end;

procedure TDocks.MoveBar;
var
  Line : Tlist;
begin
  GetLine(Pos,Line);
  If FPosition <= dpBottom then
	  MoveBarTo(aBar, Line, Pos.x-2)
  else
	  MoveBarTo(aBar, Line, Pos.y-2);
end;

procedure TDocks.InsertBar(aBar : TXToolBar; var Pos : TPoint);
var
  Line : TList;
begin
  GetLine(Pos,Line);
  If FPosition <= dpBottom then
	  PlaceBarTo(aBar,Line,Pos.x-2)
  else
	  PlaceBarTo(aBar,Line,Pos.y-2);

  If assigned(FOnInsertBar) then
    FOnInsertBar(Self);
end;

procedure TDocks.SetDrawStyle(Value: TToolbarDrawStyle);
begin
   if (FDrawStyle <> Value) then begin
      FDrawStyle := Value;
      Invalidate;
   end;
end;

procedure TDocks.CMControlListChange(var Msg : TCMControlListChange);
begin
  With Msg do begin
    if (Control is TXToolBar) and Control.Visible then
      If Inserting then
      		With TXToolBar(Control) do
		      	If FakeDocking then begin
		          BuildLine(FDockLine);
 	        		PlaceBarTo(TXToolBar(Control),BarLines[FDockLine],FDockPos)
		        end
        else
	        InsertBar(TXToolBar(Control),TXToolBar(Control).FDockPt)
      else
        RemoveBar(TXToolBar(Control));
  end;
end;

procedure TDocks.WMMove;
begin
  UpdateDrop;
  msg.result := 0;
end;

procedure TDocks.WMSize;
begin
  ArrangeBars;
  UpdateDrop;
  msg.result := 0;
end;

procedure TDocks.Paint;

procedure HorzCarve(y, iStart, maxLen : integer);
var
   iWidth: Integer;
begin
  if (maxLen = -1) or ((iStart+maxLen) > ClientWidth) then iWidth := ClientWidth - iStart
  else iWidth := maxLen;
  With canvas do begin
    Pen.Color := clBtnShadow;
    MoveTo(iStart,y);
    LineTo(iStart+iWidth-1,y);
    Pen.Color := clBtnHighLight;
    inc(y);
    MoveTo(iStart+iWidth-2,y);
    LineTo(iStart,y);
  end;
end;

procedure VertCarve(x, iStart, maxLen : integer);
var
   iHeight: Integer;
begin
  if (maxLen = -1) or ((iStart+maxLen) > ClientHeight) then iHeight := ClientHeight - iStart
  else iHeight := maxLen;
  With canvas do begin
    Pen.Color := clBtnShadow;
    MoveTo(x,iStart);
    LineTo(x,iStart+iHeight-1);
    Pen.Color := clBtnHighLight;
    inc(x);
    MoveTo(x,iStart+iHeight-2);
    LineTo(x,iStart);
  end;
end;

Procedure HorzPaint;
var
  lim,i,l : integer;
  Line : TList;

procedure Separ(x : integer);
var
  y : integer;
begin
  With canvas do begin
    Pen.Color := clBtnShadow;
    y := l*(FBarHeight+2)+FTopAdd;
    MoveTo(x,y);
    inc(y,FBarHeight); //inc(y,FBarHeight+2);
    LineTo(x,y);
    Pen.Color := clBtnHighLight;
    inc(x);
    dec(y);
    MoveTo(x,y);
    dec(y,FBarHeight); //dec(y,FBarHeight+2);
    LineTo(x,y);
  end;
end;

begin
  For l := 0 to BarLines.Count - 1 do begin
    if (l > 0) and (FDrawStyle = csXToolbar) then
      HorzCarve(l*(FBarHeight+2)-2+FTopAdd, 0, -1);
    Line := BarLines[l];
    Lim := 2+FLeftAdd;
    For i := 0 to Line.Count - 1 do
      With TXToolBar(Line[i]) do
      begin
        If FDockPos > Lim then
          Separ(FDockPos);
        If FDockPos+Width+6 < self.Width then
          Separ(FDockPos+Width+2);
        lim := 4+FDockPos+Width;

        // Draw toolbar lines if style is csWord7
        if (FDrawStyle = csWord7) then begin
           // Draw bottom line
           if (l < Barlines.Count - 1) then HorzCarve((l+1)*(FBarHeight+2)-2+FTopAdd, FDockPos-1, Width+6);
           // Draw Top line
           if (l > 0) then HorzCarve(l*(FBarHeight+2)-2+FTopAdd, FDockPos-1, Width+6);
        end;
      end
  end
end;

Procedure VertPaint;
var
  l : integer;

procedure Separ(y : integer);
var
  x : integer;
begin
  With canvas do begin
    Pen.Color := clBtnShadow;
    x := l*(FBarWidth+2)+FLeftAdd;
    MoveTo(x,y);
    inc(x,FBarWidth); //inc(x,FBarWidth+2);
    LineTo(x,y);
    Pen.Color := clBtnHighLight;
    inc(y);
    dec(x);
    MoveTo(x,y);
    dec(x,FBarWidth); //dec(x,FBarWidth+2);
    LineTo(x,y)
  end
end;

var
  i,lim : integer;
  Line : TList;

begin
  For l := 0 to BarLines.Count - 1 do begin
    if (l > 0) and (FDrawStyle = csXToolbar) then
      VertCarve(l*(FBarWidth+2)-2+FLeftAdd, 0, -1);
    Line := BarLines[l];
    Lim := 2+FTopAdd;
    For i := 0 to Line.Count - 1 do
      With TXToolBar(Line[i]) do
      begin
        If FDockPos > Lim then
          Separ(DockPos);
        If FDockPos+Height+6 < self.Height then
          Separ(FDockPos+Height+2);
        lim := 4+FDockPos+Height;

        // Draw toolbar lines if style is csWord7
        if (FDrawStyle = csWord7) then begin
           // Draw bottom line
           if (l < BarLines.Count - 1) then VertCarve((l+1)*(FBarWidth+2)-2+FLeftAdd, FDockPos-1, Height+6);
           // Draw Top line
           if (l > 0) then VertCarve(l*(FBarWidth+2)-2+FLeftAdd, FDockPos-1, Height+6);
        end;
      end
  end
end;

Procedure DrawBound;
begin
  if dpTop in BoundLines then
    HorzCarve(0, 0, -1);
  if dpLeft in boundlines then
    VertCarve(0, 0, -1);
  if dpBottom in BoundLines then
    HorzCarve(ClientHeight-2, 0, -1);
  if dpRight in boundlines then
    VertCarve(ClientWidth-2, 0, -1);
end;

Procedure DrawToolBars;
var
  i,j : integer;
begin       // I'm NOT satisfued with it!
  For i := 0 to BarLines.Count-1 do
  	For j := 0 to TList(BarLines[i]).Count-1 do
    	With TXToolBar( TList(BarLines[i])[j]) do
      	DrawControls;
end;

begin
	If Assigned(OnPaint) then
  	OnPaint(Self);
//  DrawToolBars; //Redraw the toolbars if they have xparent style
  DrawBound;
  If FPosition <= dpBottom then
    HorzPaint
  else
    VertPaint
end;

procedure TDocks.CreateParams;
begin
  inherited CreateParams(Params);
  With Params do begin
    Style := Style or WS_CLIPCHILDREN;
    WindowClass.style := WindowClass.Style or CS_HREDRAW or CS_VREDRAW
  end
end;


//////////////////////// TDocks / Private //////////////////////////////////////

Procedure TDocks.SetVisible(aVisible : Boolean);
begin
	If aVisible <> FAllowVisible then begin
  	FAllowVisible := aVisible;
    UpdateSize;
  end;
end;

procedure TDocks.UpdateSize;

Function CalcSize : integer;
begin
  if FPosition <= dpBottom then
  	Result := (FBarHeight+2)*BarLines.Count-2+FTopAdd+FBottomAdd
  else
  	Result := (FBarWidth+2)*BarLines.Count-2+FLeftAdd+FRightAdd
end;

Function CalcEmptySize : integer;
begin
  if FPosition <= dpBottom then
    Result := 5+FTopAdd+FBottomAdd
  else
		Result := 5+FLeftAdd+FRightAdd
end;

Procedure SetSize(newSize : integer);
begin
  case FPosition of
    dpTop : SetBounds(Left,Top,Width,NewSize);
  	dpBottom : SetBounds(Left,Top-NewSize+Height,Width,NewSize);
    dpLeft : SetBounds(Left,Top,NewSize,Height);
    dpRight : SetBounds(Left-NewSize+Width,Top,NewSize,Height);
  end;
end;

var
  newSize : integer;
begin
	If csDesigning in ComponentState then
  	If BarLines.Count = 0 then
    	NewSize := CalcEmptySize
    else
    	NewSize := CalcSize
  else
  	If FAllowVisible and (BarLines.Count > 0) then
    	NewSize := CalcSize
    else
    	NewSize := 0;
  SetSize(NewSize);
  If FVisible xor (FAllowVisible and (BarLines.Count > 0)) then begin
    FVisible := not FVisible;
    if assigned(FOnVisibleChanged) then
      FOnVisibleChanged(Self)
  end
end;

procedure Tdocks.SetPosition;
begin
  FPosition := aPos;
  align := TAlign(Ord(aPos)+1);
  UpdateSize;
  ArrangeBars
end;

procedure TDocks.SetBoundLines;
begin
  FBoundLines := aBounds;
  FleftAdd := 2*Ord(dpLeft in FBoundLines);
  FTopAdd := 2*Ord(dpTop in FBoundLines);
  FRightAdd := 2*Ord(dpRight in FBoundLines);
  FBottomAdd := 2*Ord(dpBottom in FBoundLines);
  UpdateSize;
  ArrangeBars
end;

procedure TDocks.UpdateDrop;
begin
  DropRect := GetClientRect;
  OffsetRect(DropRect,Left,Top);
  if FPosition <= dpBottom then
    InflateRect(DropRect,10,20)
  else
    InflateRect(DropRect,20,10);
end;

///////////////////////////////// TFLoatBarParent //////////////////////////////

procedure TFloatBarParent.CMVisibleChanged;
var
  i : integer;
begin
  For i := 0 to ControlCount-1 do
    if TControl(Controls[i]) is TWinControl then
      with TWinControl(Controls[i]) do
        If Self.Visible then begin
          If Visible then begin
            Hide;  // Updates FShowing to false
            Show
          end
        end else
          ShowWindow(Handle,SW_HIDE)
end;

//////////////////////////// TDockControl //////////////////////////////////////

procedure TDockControl.SetXSpacing;
begin
  FXSpacing := aSpace;
  FBarWidth := 2*FXSpacing+FControlWidth;
end;

procedure TDockControl.SetYSpacing;
begin
  FYSpacing := aSpace;
  FBarHeight := 2*FYSpacing+FControlHeight;
end;

procedure TDockControl.SetCtrlW;
begin
  FControlWidth := aWidth;
  FBarWidth := 2*FXSpacing+FControlWidth;
end;

procedure TDockControl.SetCtrlH;
begin
  FControlHeight := aHeight;
  FBarHeight := 2*FYSpacing+FControlHeight;
end;

function TDockControl.GetXSpacing;
begin
  result := FXSpacing;
end;

function TDockControl.GetYSpacing;
begin
  result := FYSpacing;
end;

function TDockControl.GetCtrlW;
begin
  result := FControlWidth;
end;

function TDockControl.GetCtrlH;
begin
  result := FControlHeight;
end;
////////////////////////////////////////////////////////////////////////////////

procedure Register;
begin
  RegisterComponents('Supplment', [TXToolBar, TDocks]);
end;

initialization
	FXSpacing := 6;
  FYSpacing := 3;
  FControlHeight := 22;
  FControlWidth := 22;
  FBarHeight := 2*FYSpacing+FControlHeight;
  FBarWidth := 2*FXSpacing+FControlWidth;
  UsedWindows := Tlist.Create;

  { Gets non-client width & height}
  ClLeft := GetSystemMetrics(SM_CYDLGFRAME);
  ClTop := ClLeft + GetSystemMetrics(SM_CYSMCAPTION);
  NCWidth:= 2*ClLeft;
  NCHeight:= ClTop+ClLeft;

finalization
  UsedWindows.Free;
end.

