unit xPieReg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, xPie;

type
  TPieControlEditor = class(TForm)
    edText: TEdit;
    edValue: TEdit;
    edOutside: TEdit;
    ItemList: TListBox;
    pnlColor: TPanel;
    ColorDialog1: TColorDialog;
    btnApply: TButton;
    UpDown1: TUpDown;
    UpDown2: TUpDown;
    Preview: TxPie;
    Label5: TLabel;
    Label6: TLabel;
    edHeight: TEdit;
    UpDown3: TUpDown;
    Label7: TLabel;
    procedure NewButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
    procedure ItemListClick(Sender: TObject);
    procedure ItemEditChange(Sender: TObject);
    procedure ItemControlExit(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure pnlColorClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure ItemListDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ItemListDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure PreviewClick(Sender: TObject);
  private
    { Private-Deklarationen }
    fEdit  : Boolean;
    procedure ShowPreview;
  public
    { Public-Deklarationen }
    PieItems: TPieItems;
    OrginalPie : TxPie;
    procedure UpdateList;
  end;

procedure Register;

implementation

uses
  DsgnIntf, xProcs;

{$R *.DFM}

{ TPieItemsProperty }
type
  TPieItemsProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure TPieItemsProperty.Edit;
begin
  with TPieControlEditor.Create(Application) do
  try
    OrginalPie:=GetComponent(0) as TxPie;
    PieItems.Assign(OrginalPie.Items);
    UpdateList;
    if ShowModal=mrOk then
       OrginalPie.Items.Assign(PieItems);
  finally
    Free;
  end;
end;

function TPieItemsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paReadOnly];
end;


{ TPieControlEditor }

procedure TPieControlEditor.NewButtonClick(Sender: TObject);
begin
  PieItems.Add;
  UpdateList;
  ItemList.ItemIndex:=ItemList.Items.Count-1;
  edText.SetFocus;
end;

procedure TPieControlEditor.UpdateList;
var
  S: String;
  i: Integer;
begin
  ItemList.Items.Clear;
  for i:=0 to PieItems.Count-1 do
  begin
    S:='(untitled)';
    if PieItems.Items[i].Text<>'' then S:=PieItems.Items[i].Text;
    ItemList.Items.Add(IntToStr(i)+'-'+S);
  end;
  if PieItems.Count>0 then
  begin
    ItemList.ItemIndex:=0;
    ItemListClick(nil);  // !!!
  end;
  ShowPreview;
end;

procedure TPieControlEditor.FormCreate(Sender: TObject);
begin
  PieItems:=TPieItems.Create(nil);
end;

procedure TPieControlEditor.FormDestroy(Sender: TObject);
begin
  PieItems.Free;
end;

procedure TPieControlEditor.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TPieControlEditor.OkButtonClick(Sender: TObject);
begin
  ItemEditChange(Sender);
  ModalResult:=mrOk;
end;

procedure TPieControlEditor.btnApplyClick(Sender: TObject);
begin
  ItemEditChange(Sender);
  OrginalPie.Items.Assign(PieItems);
end;

procedure TPieControlEditor.ItemListClick(Sender: TObject);
var
  aItem: TPieItem;
begin
  FEdit:=True;
  try
    aItem:=PieItems.Items[ItemList.ItemIndex];
    edValue.Text:=IntToStr(aItem.Value);
    edOutside.Text:=IntToStr(aItem.Outside);
    edHeight.Text:=IntToStr(aItem.Height);
    edText.Text:=aItem.Text;
    pnlColor.Color:=aItem.Color;
  finally
    FEdit:=False;
  end;
end;

procedure TPieControlEditor.ItemEditChange(Sender: TObject);
var
  aItem: TPieItem;
  S: String;
  aOld: Integer;
begin
  if (ItemList.ItemIndex <> - 1) and not FEdit then
  begin
    aItem:=PieItems.Items[ItemList.ItemIndex];
    try
      aItem.Value:=StrToInt(edValue.Text);
    except
    end;
    try
      aItem.Height:=StrToInt(edHeight.Text);
    except
    end;
    try
      aItem.Outside:=StrToInt(edOutside.Text);
    except
    end;
    aItem.Text:=edText.Text;
    aItem.Color:=pnlColor.Color;

    S:='(untitled)';
    if aItem.Text<>'' then S:=aItem.Text;
    aOld:=ItemList.ItemIndex;
    ItemList.Items[aOld]:=IntToStr(aOld)+'-'+S;
    ItemList.ItemIndex:=aOld;

    ShowPreview;
  end;
end;

procedure TPieControlEditor.ShowPreview;
begin
  Preview.Items.Assign(PieItems);
end;

procedure TPieControlEditor.ItemControlExit(Sender: TObject);
begin
  ItemEditChange(Sender);
end;

procedure TPieControlEditor.DeleteButtonClick(Sender: TObject);
begin
  PieItems.Items[ItemList.ItemIndex].Free;
  UpdateList;
end;

procedure TPieControlEditor.pnlColorClick(Sender: TObject);
begin
  ColorDialog1.Color:=pnlColor.Color;
  if ColorDialog1.Execute then
  begin
    pnlColor.Color:=ColorDialog1.Color;
    ItemEditChange(Sender);
  end;
end;

procedure TPieControlEditor.ItemListDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
  i: Integer;
begin
  if (Source = ItemList) and (ItemList.ItemIndex <> - 1) then
  begin
    i:=ItemList.ItemAtPos(Point(X,Y),True);
    Accept := (i <> ItemList.ItemIndex) and (i<>-1);
  end else
    Accept := False;
end;

procedure TPieControlEditor.ItemListDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  i: Integer;
  aItem: TPieItem;
begin
  i:= ItemList.ItemAtPos(Point(x,y),True);
  if i <> -1 then
  begin
    aItem:=PieItems.Items[ItemList.ItemIndex];
    aItem.Index:=i;
    UpdateList;
    ItemList.ItemIndex:=i;
    ItemListClick(nil);
    ShowPreview;
  end;
end;

{ TxAboutEditor }
type
  TxAboutEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure TxAboutEditor.ExecuteVerb(Index: Integer);
begin if Index=0 then TxPie.About; end;

function TxAboutEditor.GetVerb(Index: Integer): string;
begin if Index=0 then Result:='About..'; end;

function TxAboutEditor.GetVerbCount: Integer;
begin Result := 1; end;


procedure Register;
begin
  RegisterComponents('xTool', [TxPie]);
  RegisterPropertyEditor(TypeInfo(TPieItems), nil, '', TPieItemsProperty);
  RegisterComponentEditor(TxPie, TxAboutEditor );
end;


procedure TPieControlEditor.PreviewClick(Sender: TObject);
begin
  if Preview.Selected <> - 1 then
  begin
    ItemList.ItemIndex:=Preview.Selected;
    ItemListClick(nil);
  end;
end;

end.

