{*******************************************************}
{                                                       }
{       xTool - Component Collection                    }
{                                                       }
{       Copyright (c) 1997 Fabula Software              }
{                                                       }
{*******************************************************}
unit xCursor;
  { general cursors needed by various components & controls }

interface

const
  crHand     = 17779;
  crMagnify  = 17780;
  crWait     = 17781;
  crHandMove = 17782;

procedure cursorWait;
procedure cursorDefault;

implementation

{$IFDEF Win32}
  {$R xCursor.r32 }
  {$R wait.res    }
{$ELSE}
  {$R xCursor.res }
{$ENDIF}

uses
  WinProcs, SysUtils, Controls, Forms;

const
  WAIT_CURSOR = 'wait.ani';

procedure cursorWait;
begin
  Screen.Cursor:=crWait;
end;

procedure cursorDefault;
begin
  Screen.Cursor:=crDefault;
end;                        

initialization

  Screen.Cursors[crHand]    :=LoadCursor(hInstance,'X_HAND');
  Screen.Cursors[crMagnify] :=LoadCursor(hInstance,'X_MAGNIFY');
  Screen.Cursors[crHandMove]:=LoadCursor(hInstance,'X_MOVE');

{$IFDEF Win32}
  Screen.Cursors[crWait]:=LoadCursor(hInstance,'X_WAIT');
{$ELSE}
  Screen.Cursors[crWait]:=Screen.Cursors[crHourGlass];
{$ENDIF}

end.
