{ eXtended Explorer Form
   Amedeo Lanza <amldc@tin.it>

  Demonstration for Delphi controls needs:

  TSplitter - a splitter control
   Cerny Robert <Robert.Cerny@neosys.xrs.si>

  TToolbar97 - an Office97-like toolbar
   Jordan Russell <jordanr7@aol.com>
  http://members.aol.com/jordanr7

  TDirTree - a Directory TreeView
   Markus Stephany <MirBir.St@T-Online.de>
  http://home.t-online.de/home/MirBir.St/

  TFileList - a File ListView component for Delphi 2
   Amedeo Lanza <amldc@tin.it>
  http://volftp.tin.it/IT/IT/COLLABORAZIONI/LANZA/index.htm

  TPathComboBox - a  File Path combobox component
   Angus Johnson <ajohnson@rpi.net.au>

description:
 This is a File Explorer sample using the Explorer's family of Delphi VCLs.
 You will need the above units to be installed in order to build this sample.
 You may find all these components on Delphi Super Page at
 http://SunSITE.icm.edu.pl/delphi/.

 Most features are based on TFileList since this program was born to test it.
 Others VCLs are used just because better than the Delphi 2 standard ones and
 are not shown in all their own potentialities.

usage:
 Install the required components into the Delphi palette and open the project.
 First of all you may jump to TXExplorer.FormCreate code and modify the columns'
 caption (default is in English, this example set italian texts).
 Then... run it and explore your file system !

copyright & license
 Free use and distribution for non commercial purposes. See documentation for
 license restrictions.

DISCLAIMER:
 I ASK NO FEE and I GIVE NO WARRANTY for this software, either expressed or
 implied. Use it AT YOUR OWN RISK.

suggestions, bug reports & comments to the author:
 Amedeo Lanza di Casalanza
 from: Torino, Italy
 mailto:amldc@tin.it
 http://volftp.tin.it/IT/IT/COLLABORAZIONI/LANZA/index.htm

WARNING FOR EMAIL ABUSE:
 *BORLAND DELPHI* related messages are WELCOME, any other use of the author's
 email address for unsolicited ADVERTISING is STRICTLY PROHIBITED.

Thanks to all who shared their knowledge ...and controls. Also thanks to
DSP and UNDU for their precious services.

Known bugs
 PathComboBox set to wrong path at startup 

history:

 09-oct-1997 V0.4 amldc@tin.it
  + intermediate release for beta tester

 25-sep-1997 V0.3 amldc@tin.it
  + Added CdUp button (stolen from PathComboBox example)
  + Added use of new OnFileAdd property from TFileView 2.0
  + Added support for File Drop from Explorer to the file view
  + Added simple search dialog to demonstrate use of directory and file spec
    lists

 13-sep-1997 V0.2 amldc@tin.it
  + Added use of PathComboBox instead of DriveComboBox
  + Updated for TFileView 1.1

 10-aug-1997 V0.1 amldc@tin.it
  + Just dropped some controls and played around...

}
unit XExplFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, SpeedBar, ComCtrls, StdCtrls, FileCtrl, Menus,
  TB97,Splitctl, DirTree,FileList, PathCombo, newstat, RXSplit;

type
  TXExplorer = class(TForm)
    PanelLeft: TPanel;
    PanelRight: TPanel;
    DirTree1: TDirTree;
    Dock971: TDock97;
    tbViewStyle: TToolbar97;
    BtnViewReport: TToolbarButton97;
    BtnViewList: TToolbarButton97;
    BtnViewSmallIcon: TToolbarButton97;
    BtnViewIcon: TToolbarButton97;
    cbDisplayDir: TCheckBox;
    PanelRightLabel: TPanel;
    LabelPanelRight: TLabel;
    Panel1: TPanel;
    LabelPanelLeft: TLabel;
    Toolbar971: TToolbar97;
    FilterComboBox1: TFilterComboBox;
    ToolbarSep971: TToolbarSep97;
    ToolbarSep972: TToolbarSep97;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    PathComboBox1: TPathComboBox;
    View1: TMenuItem;
    ItemViewIcon: TMenuItem;
    ItemViewSmallIcon: TMenuItem;
    ItemViewList: TMenuItem;
    ItemViewReport: TMenuItem;
    N2: TMenuItem;
    ItemSetAttributes: TMenuItem;
    ItemSetColumns: TMenuItem;
    BtnCdUp: TToolbarButton97;
    ToolbarSep973: TToolbarSep97;
    Tools1: TMenuItem;
    ItemSearchWindow: TMenuItem;
    Splitter1: TSplitter;
    FileList1: TFileList;
    StatusBar1: TStatusBar;
    N3: TMenuItem;
    ItemDisplayDirectory: TMenuItem;
    ItemDisplayParent: TMenuItem;
    cbDisplayParent: TCheckBox;
    ToolbarSep974: TToolbarSep97;
    procedure FormCreate(Sender: TObject);
    procedure DirTree1Change(Sender: TObject; Node: TTreeNode);
    procedure BtnViewIconClick(Sender: TObject);
    procedure BtnViewSmallIconClick(Sender: TObject);
    procedure BtnViewListClick(Sender: TObject);
    procedure BtnViewReportClick(Sender: TObject);
    procedure DisplayDirClick(Sender: TObject);
    procedure FilterComboBox1Change(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure PathComboBox1Change(Sender: TObject);
    procedure ItemSetAttributesClick(Sender: TObject);
    procedure ItemSetColumnsClick(Sender: TObject);
    procedure BtnCdUpClick(Sender: TObject);
    procedure FileList1FileAdd(Sender: TObject; Item: TListItem;
      Path: string; FindData: TWin32FindDataA);
    procedure ItemSearchWindowClick(Sender: TObject);
    procedure FileList1FileDrop(Files: TStrings; X, Y: Integer);
    procedure DisplayParentClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdatePanelLabels;
    procedure SetViewChecked;
    procedure ShowOptionDialog(Sender: TObject);
  public
    { Public declarations }
  protected
    procedure Loaded; override;
  end;

var
  XExplorer: TXExplorer;
(*  FileList1 :TFileList; *)

implementation
uses about, OptFrm, SeaFrm;

{$R *.DFM}

var
  FileCounter :integer;

//
// Update labels of left and right panel
//
procedure TXExplorer.UpdatePanelLabels;
begin
  with FileList1 do
    LabelPanelRight.Caption := format('[%s] ( %s )',
                      [AnsiLowerCase(Directory),Mask]);
  StatusBar1.Panels[0].Text := format ('%s  %3d file(s)',
    [FileList1.Directory,FileList1.Items.Count]);
end;

////////////////////////////////////////////////////////////////////////////////
// FORM CREATION / DELETION
////////////////////////////////////////////////////////////////////////////////
//
// this was used for TFileList development
// purposes, may be suppressed if not needed
//
procedure TXExplorer.FormCreate(Sender: TObject);
begin
(*
  // used for control development
  FileList1 := TFileList.Create(Self);
  with FileList1 do
  begin

    Parent    := PanelRight;
    Align     := alClient;
    ViewStyle := vsReport;
    DisplayDirectory := true;
    ViewColumns := [fiName,fiSize,fiType,fiModified,fiCreated,
                    fiLastAccess,fiDosName,fiAttributes{,fiPath}];
  end;
*)
inherited;
end;

//
// this was used for TFileList development
// purposes, may be suppressed if not needed
//
procedure TXExplorer.FormDestroy(Sender: TObject);
begin
(*  FileList1.Free; *)
inherited;
end;

////////////////////////////////////////////////////////////////////////////////
// FORM CREATION / DELETION
////////////////////////////////////////////////////////////////////////////////

// Sets up FileVie1 columns
//
// note that columns's caption and width will
// be affected only in runtime
//
procedure TXExplorer.Loaded;
var S :string;
begin
  with FileList1 do
  begin
    // set custom column headers
    SetColCaption(fiName,'Nome');
    SetColCaption(fiSize,'Dimensioni');
    SetColCaption(fiType,'Tipo');
    SetColCaption(fiModified,'Modificato');
    SetColCaption(fiCreated,'Creato');
    SetColCaption(fiLastAccess,'Ultimo accesso');
    SetColCaption(fiAttributes,'Attributi');
    SetColCaption(fiDosName,'Nome Dos');
    SetColCaption(fiPath,'Cartella');
    // SetColWidth (fiName,150); if you want to set column width
  end;
  // View Menu style setup
  SetViewChecked;
  GetDir (0,S);
  PathComboBox1.Path := S;
end;

// Set Check Mark for List View Style items and (View menu)
// Down property for List View Style buttons (View Style toolbar)
procedure TXExplorer.SetViewChecked;
begin
  ItemViewIcon.Checked      := (FileList1.ViewStyle = vsIcon);
  ItemViewList.Checked      :=  (FileList1.ViewStyle = vsList);
  ItemViewSmallIcon.Checked := (FileList1.ViewStyle = vsSmallIcon);
  ItemViewReport.Checked    := (FileList1.ViewStyle = vsReport);
  BtnViewIcon.Down      := (FileList1.ViewStyle = vsIcon);
  BtnViewList.Down      :=  (FileList1.ViewStyle = vsList);
  BtnViewSmallIcon.Down := (FileList1.ViewStyle = vsSmallIcon);
  BtnViewReport.Down    := (FileList1.ViewStyle = vsReport);
end;

////////////////////////////////////////////////////////////////////////////////
// Directory and Mask controls events (INTERFACE)
////////////////////////////////////////////////////////////////////////////////

// Selected new drive
// directory changed on DirTree
procedure TXExplorer.DirTree1Change(Sender: TObject; Node: TTreeNode);
begin
  FileCounter := 0;
  if PathCombobox1.Path <> DirTree1.Directory then
    PathCombobox1.Path := DirTree1.Directory;
  if FileList1.Directory <> DirTree1.Directory then
    FileList1.Directory := DirTree1.Directory;
  UpdatePanelLabels;
end;

// directory change in PathComboBox
procedure TXExplorer.PathComboBox1Change(Sender: TObject);
begin
  if DirTree1.Directory <> PathComboBox1.Path then
  DirTree1.Directory := PathComboBox1.Path;
  with PathComboBox1 do
    BtnCdUp.Enabled := ((itemindex <> -1) and
                        (length(items[itemindex]) > 3))
end;

// Selected new file mask
procedure TXExplorer.FilterComboBox1Change(Sender: TObject);
begin
  FileList1.Mask := FilterComboBox1.Mask;
  UpdatePanelLabels;
end;


////////////////////////////////////////////////////////////////////////////////
// Toolbar items (INTERFACE)
////////////////////////////////////////////////////////////////////////////////

// Select View Style
procedure TXExplorer.BtnViewIconClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsIcon;
  SetViewChecked;
end;
// Select View Style
procedure TXExplorer.BtnViewSmallIconClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsSmallIcon;
  SetViewChecked;
end;
// Select View Style
procedure TXExplorer.BtnViewListClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsList;
  SetViewChecked;
end;
// Select View Style
procedure TXExplorer.BtnViewReportClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsReport;
  SetViewChecked;
end;
// Go back one level in the directory
procedure TXExplorer.BtnCdUpClick(Sender: TObject);
begin
  // if not a root directory then change up one level
  with PathComboBox1 do begin
     if (itemindex <> -1) and (length(items[itemindex]) > 3) then
        // itemindex := itemindex-1 {DOES NOT WORK !?}
        Path := items[itemindex-1]
     else messagebeep(0);
  end;
end;
// Include/Exclude directory listing
procedure TXExplorer.DisplayDirClick(Sender: TObject);
begin
  FileList1.DisplayDirectory := cbDisplayDir.Checked;
end;
// Include/Exclude parent directory listing
procedure TXExplorer.DisplayParentClick(Sender: TObject);
begin
  FileList1.DisplayParentDir := cbDisplayParent.Checked;
end;



// Display About Box
procedure TXExplorer.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

////////////////////////////////////////////////////////////////////////////////
// OPTION DIALOG ROUTINES
////////////////////////////////////////////////////////////////////////////////

procedure TXExplorer.ShowOptionDialog(Sender: TObject);
var
  NewFileType :TFileTypes;
  NewCols :TFileInfos;
begin
  with OptionsDlg do
  begin
    // File Attributes
    cbArchive.Checked  := (ftArchive  in FileList1.FileTypes);
    cbReadonly.Checked := (ftReadonly in FileList1.FileTypes);
    cbHidden.Checked   := (ftHidden   in FileList1.FileTypes);
    cbSystem.Checked   := (ftSystem   in FileList1.FileTypes);
    cbAll.Checked      := (ftAll      in FileList1.FileTypes);
    // Columns
    cbName.Checked        := (fiName        in FileList1.ViewColumns);
    cbType.Checked        := (fiType        in FileList1.ViewColumns);
    cbSize.Checked        := (fiSize        in FileList1.ViewColumns);
    cbModified.Checked    := (fiModified    in FileList1.ViewColumns);
    cbCreated.Checked     := (fiCreated     in FileList1.ViewColumns);
    cbLastAccess.Checked  := (fiLastAccess  in FileList1.ViewColumns);
    cbAttributes.Checked  := (fiAttributes  in FileList1.ViewColumns);
    cbDosName.Checked     := (fiDosName     in FileList1.ViewColumns);
    cbDosExt.Checked      := (fiDosExt      in FileList1.ViewColumns);
    cbPath.Checked        := (fiPath        in FileList1.ViewColumns);
    cbAllColumns.Checked  := (fiAll         in FileList1.ViewColumns);

    if (ShowModal = mrOK) then
    begin
      // File Attributes
      NewFileType := [];
      if cbArchive.Checked  then NewFileType := NewFileType + [ftArchive];
      if cbReadonly.Checked then NewFileType := NewFileType + [ftReadonly];
      if cbHidden.Checked   then NewFileType := NewFileType + [ftHidden];
      if cbSystem.Checked   then NewFileType := NewFileType + [ftSystem];
      if cbAll.Checked      then NewFileType := NewFileType + [ftAll];
      FileList1.FileTypes := NewFileType;
      // Columns
      NewCols := [];
      if cbName.Checked        then NewCols := NewCols + [fiName];
      if cbType.Checked        then NewCols := NewCols + [fiType];
      if cbSize.Checked        then NewCols := NewCols + [fiSize];
      if cbModified.Checked    then NewCols := NewCols + [fiModified];
      if cbCreated.Checked     then NewCols := NewCols + [fiCreated];
      if cbLastAccess.Checked  then NewCols := NewCols + [fiLastAccess];
      if cbAttributes.Checked  then NewCols := NewCols + [fiAttributes];
      if cbDosName.Checked     then NewCols := NewCols + [fiDosName];
      if cbDosExt.Checked      then NewCols := NewCols + [fiDosExt];
      if cbPath.Checked        then NewCols := NewCols + [fiPath];
      if cbAllColumns.Checked  then NewCols := NewCols + [fiAll];
      FileList1.ViewColumns := NewCols;
    end;
  end;
end;
// Open Options dialog on File Attributes page
procedure TXExplorer.ItemSetAttributesClick(Sender: TObject);
begin
  OptionsDlg.ActivePage := 0;
  ShowOptionDialog(Sender);
end;

// Open Options dialog on Display Columns page
procedure TXExplorer.ItemSetColumnsClick(Sender: TObject);
begin
  OptionsDlg.ActivePage := 1;
  ShowOptionDialog(Sender);
end;
////////////////////////////////////////////////////////////////////////////////
// CALLBACK ROUTINES
////////////////////////////////////////////////////////////////////////////////
procedure TXExplorer.FileList1FileAdd(Sender: TObject; Item: TListItem;
  Path: string; FindData: TWin32FindDataA);
begin
  Inc(FileCounter);
  StatusBar1.Panels[0].Text := format ('(%3d) %s%s',
    [FileCounter,Path,FindData.cFileName]);
end;

// display the search dialog and scan for specified
// paths and specs
procedure TXExplorer.ItemSearchWindowClick(Sender: TObject);
begin
  with SearchForm do
  if (ShowModal = mrOK) then
  begin
    FileList1.Directory := ''; // clear file list
    FileList1.Mask := FilterComboBox1.Mask;
    FileList1.Directory := EditPath.Text;
    UpdatePanelLabels;
  end;
end;

procedure TXExplorer.FileList1FileDrop(Files: TStrings; X, Y: Integer);
var
  I :integer;
begin
    for I := 0 to Pred(Files.Count) do
    begin
      FileList1.AddFile(Files[I]);
      Application.ProcessMessages;
    end;
end;


end.
