{ eXtended Explorer Form
   Amedeo Lanza <amldc@tin.it>

  Demonstration for Delphi controls needs:

  TSplitter - a splitter control
   Cerny Robert <Robert.Cerny@neosys.xrs.si>

  TToolbar97 - an Office97-like toolbar
   Jordan Russell <jordanr7@aol.com>
  http://members.aol.com/jordanr7

  TDirTree - a Directory TreeView
   Markus Stephany <MirBir.St@T-Online.de>
  http://home.t-online.de/home/MirBir.St/

  TFileList - a File ListView component for Delphi 2
   Amedeo Lanza <amldc@tin.it>
  http://volftp.tin.it/IT/IT/COLLABORAZIONI/LANZA/index.htm

  TPathComboBox - a  File Path combobox component
   Angus Johnson <ajohnson@rpi.net.au>

description:
 This is a File Explorer sample using the Explorer's family of Delphi VCLs.
 You will need the above units to be installed in order to build this sample.
 You may find all these components on Delphi Super Page at
 http://SunSITE.icm.edu.pl/delphi/.

 I've included the dcu precompiled units for you convenience, but remember that
 full sources for all are available on DSP.

usage:
 Install the required components into the Delphi palette and open the project.
 First of all you may jump to TXExplorer.FormCreate code and modify the columns'
 caption (default is in English, this example set italian texts).
 Then... run it and explore your file system !


copyright & license
 Free use and distribution for non commercial purposes. See documentation for
 license restrictions.

DISCLAIMER:
 I ASK NO FEE and I GIVE NO WARRANTY for this software, either expressed or
 implied. Use it AT YOUR OWN RISK.

suggestions, bug reports & comments to the author:
 Amedeo Lanza di Casalanza
 from: Torino, Italy
 mailto:amldc@tin.it
 http://volftp.tin.it/IT/IT/COLLABORAZIONI/LANZA/index.htm

WARNING FOR EMAIL ABUSE:
 *BORLAND DELPHI* related messages are WELCOME, any other use of the author's
 email address for unsolicited ADVERTISING is STRICTLY PROHIBITED.

Thanks to all who shared their knowledge ...and controls. Also thanks to
DSP and UNDU for their precious services.

history:
 10-aug-1997 V0.1 amldc@tin.it
  + Just dropped some controls and played around...

 13-sep-1997 V0.2 amldc@tin.it
  + Added use of PathComboBox instead of DriveComboBox
  + Updated for TFileView 1.1
}
unit XExplFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, SpeedBar, ComCtrls, StdCtrls, FileCtrl, Menus,
  TB97,Splitctl, DirTree,FileList, PathCombo;

type
  TXExplorer = class(TForm)
    PanelLeft: TPanel;
    PanelRight: TPanel;
    StatusBar1: TStatusBar;
    DirTree1: TDirTree;
    Dock971: TDock97;
    tbViewStyle: TToolbar97;
    BtnViewReport: TToolbarButton97;
    BtnViewList: TToolbarButton97;
    BtnViewSmallIcon: TToolbarButton97;
    BtnViewIcon: TToolbarButton97;
    Splitter1: TSplitter;
    cbDisplayDir: TCheckBox;
    PanelRightLabel: TPanel;
    LabelPanelRight: TLabel;
    Panel1: TPanel;
    LabelPanelLeft: TLabel;
    Toolbar971: TToolbar97;
    FilterComboBox1: TFilterComboBox;
    ToolbarSep971: TToolbarSep97;
    ToolbarSep972: TToolbarSep97;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    PathComboBox1: TPathComboBox;
    View1: TMenuItem;
    ItemViewIcon: TMenuItem;
    ItemViewSmallIcon: TMenuItem;
    ItemViewList: TMenuItem;
    ItemViewReport: TMenuItem;
    N2: TMenuItem;
    ItemSetAttributes: TMenuItem;
    ItemSetColumns: TMenuItem;
    FileList1: TFileList;
    procedure FormCreate(Sender: TObject);
    procedure DirTree1Change(Sender: TObject; Node: TTreeNode);
    procedure BtnViewIconClick(Sender: TObject);
    procedure BtnViewSmallIconClick(Sender: TObject);
    procedure BtnViewListClick(Sender: TObject);
    procedure BtnViewReportClick(Sender: TObject);
    procedure cbDisplayDirClick(Sender: TObject);
    procedure FilterComboBox1Change(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure PathComboBox1Change(Sender: TObject);
    procedure ItemSetAttributesClick(Sender: TObject);
    procedure ItemSetColumnsClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdatePanelLabels;
    procedure SetViewChecked;
    procedure ShowOptionDialog(Sender: TObject);
  public
    { Public declarations }
  protected
    procedure Loaded; override;
  end;

var
  XExplorer: TXExplorer;
(*  FileList1 :TFileList; *)

implementation

uses about, dlgattr;

{$R *.DFM}

//
// Update labels of left and right panel
//
procedure TXExplorer.UpdatePanelLabels;
begin
  with FileList1 do
    LabelPanelRight.Caption := format('[%s] ( %s )',
                      [AnsiLowerCase(Directory),Mask]);
end;
// Selected new drive
// directory changed on Dir Tree
procedure TXExplorer.DirTree1Change(Sender: TObject; Node: TTreeNode);
begin
  PathCombobox1.Path := DirTree1.Directory;
  FileList1.Directory := DirTree1.Directory;
  UpdatePanelLabels;
end;
// Selected new file mask
procedure TXExplorer.FilterComboBox1Change(Sender: TObject);
begin
  FileList1.Mask := FilterComboBox1.Mask;
  UpdatePanelLabels;
end;

//
// this was used for TFileList development
// purposes, may be suppressed if not needed
//
procedure TXExplorer.FormCreate(Sender: TObject);
begin
(*
  // used for control development
  FileList1 := TFileList.Create(Self);
  with FileList1 do
  begin

    Parent    := PanelRight;
    Align     := alClient;
    ViewStyle := vsReport;
    DisplayDirectory := true;
    ViewColumns := [fiName,fiSize,fiType,fiModified,fiCreated,
                    fiLastAccess,fiDosName,fiAttributes{,fiPath}];
  end;
*)
inherited;
end;

// Sets up FileVie1 columns
//
// note that columns's caption and width will
// be affected only in runtime
//
procedure TXExplorer.Loaded;
begin
  with FileList1 do
  begin
    SetColCaption(fiName,'Nome');
    SetColCaption(fiSize,'Dimensioni');
    SetColCaption(fiType,'Tipo di file');
    SetColCaption(fiModified,'Modificato');
    SetColCaption(fiCreated,'Creato');
    SetColCaption(fiLastAccess,'Ultimo accesso');
    SetColCaption(fiAttributes,'Attributi');
    SetColCaption(fiDosName,'Nome Dos');
    SetColCaption(fiPath,'Cartella');
    SetColWidth (fiName,150);
  end;
  // View Menu style setup
  SetViewChecked;
end;

// Set Check Mark for List View Style items and (View menu)
// Down property for List View Style buttons (View Style toolbar)
procedure TXExplorer.SetViewChecked;
begin
  ItemViewIcon.Checked      := (FileList1.ViewStyle = vsIcon);
  ItemViewList.Checked      :=  (FileList1.ViewStyle = vsList);
  ItemViewSmallIcon.Checked := (FileList1.ViewStyle = vsSmallIcon);
  ItemViewReport.Checked    := (FileList1.ViewStyle = vsReport);
  BtnViewIcon.Down      := (FileList1.ViewStyle = vsIcon);
  BtnViewList.Down      :=  (FileList1.ViewStyle = vsList);
  BtnViewSmallIcon.Down := (FileList1.ViewStyle = vsSmallIcon);
  BtnViewReport.Down    := (FileList1.ViewStyle = vsReport);
end;


// Select View Style
procedure TXExplorer.BtnViewIconClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsIcon;
  SetViewChecked;
end;
// Select View Style
procedure TXExplorer.BtnViewSmallIconClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsSmallIcon;
  SetViewChecked;
end;
// Select View Style
procedure TXExplorer.BtnViewListClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsList;
  SetViewChecked;
end;
// Select View Style
procedure TXExplorer.BtnViewReportClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsReport;
  SetViewChecked;
end;

// Include/Exclude directory listing
procedure TXExplorer.cbDisplayDirClick(Sender: TObject);
begin
  FileList1.DisplayDirectory := cbDisplayDir.Checked;
end;
//
// this was used for TFileList development
// purposes, may be suppressed if not needed
//
procedure TXExplorer.FormDestroy(Sender: TObject);
begin
(*  FileList1.Free; *)
inherited;
end;

procedure TXExplorer.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TXExplorer.PathComboBox1Change(Sender: TObject);
begin
  DirTree1.Directory := PathComboBox1.Path;
end;

procedure TXExplorer.ShowOptionDialog(Sender: TObject);
var
  NewFileType :TFileTypes;
  NewCols :TFileInfos;
begin
  with DlgAttributes do
  begin
    // File Attributes
    cbArchive.Checked  := (ftArchive  in FileList1.FileTypes);
    cbReadonly.Checked := (ftReadonly in FileList1.FileTypes);
    cbHidden.Checked   := (ftHidden   in FileList1.FileTypes);
    cbSystem.Checked   := (ftSystem   in FileList1.FileTypes);
    cbAll.Checked      := (ftAll      in FileList1.FileTypes);
    // Columns
    cbName.Checked        := (fiName        in FileList1.ViewColumns);
    cbType.Checked        := (fiType        in FileList1.ViewColumns);
    cbSize.Checked        := (fiSize        in FileList1.ViewColumns);
    cbModified.Checked    := (fiModified    in FileList1.ViewColumns);
    cbCreated.Checked     := (fiCreated     in FileList1.ViewColumns);
    cbLastAccess.Checked  := (fiLastAccess  in FileList1.ViewColumns);
    cbAttributes.Checked  := (fiAttributes  in FileList1.ViewColumns);
    cbDosName.Checked     := (fiDosName     in FileList1.ViewColumns);
    cbDosExt.Checked      := (fiDosExt      in FileList1.ViewColumns);
    cbPath.Checked        := (fiPath        in FileList1.ViewColumns);
//    cbAllColumns.Checked  := (fiAll         in FileList1.ViewColumns);

    if (ShowModal = mrOK) then
    begin
      // File Attributes
      NewFileType := [];
      if cbArchive.Checked  then NewFileType := NewFileType + [ftArchive];
      if cbReadonly.Checked then NewFileType := NewFileType + [ftReadonly];
      if cbHidden.Checked   then NewFileType := NewFileType + [ftHidden];
      if cbSystem.Checked   then NewFileType := NewFileType + [ftSystem];
      if cbAll.Checked      then NewFileType := NewFileType + [ftAll];
      FileList1.FileTypes := NewFileType;
      // Columns
      NewCols := [];
      if cbName.Checked        then NewCols := NewCols + [fiName];
      if cbType.Checked        then NewCols := NewCols + [fiType];
      if cbSize.Checked        then NewCols := NewCols + [fiSize];
      if cbModified.Checked    then NewCols := NewCols + [fiModified];
      if cbCreated.Checked     then NewCols := NewCols + [fiCreated];
      if cbLastAccess.Checked  then NewCols := NewCols + [fiLastAccess];
      if cbAttributes.Checked  then NewCols := NewCols + [fiAttributes];
      if cbDosName.Checked     then NewCols := NewCols + [fiDosName];
      if cbDosExt.Checked      then NewCols := NewCols + [fiDosExt];
      if cbPath.Checked        then NewCols := NewCols + [fiPath];
//      if cbAllColumns.Checked  then NewCols := NewCols + [fiAll];
      FileList1.ViewColumns := NewCols;
    end;
  end;
end;

procedure TXExplorer.ItemSetAttributesClick(Sender: TObject);
begin
  DlgAttributes.ActivePage := 0;
  ShowOptionDialog(Sender);
end;

procedure TXExplorer.ItemSetColumnsClick(Sender: TObject);
begin
  DlgAttributes.ActivePage := 1;
  ShowOptionDialog(Sender);
end;

end.
