{ ****************************************************************
  Info               :  TRunOnce2000X 
                        Freeware

  Source File Name   :  X2000Ro.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 4.0 Client/Server, Service Pack 3
  Decription         :  This component let start only one copy of your application.

  PROPERTIES:                                                   
   Terminate: Boolean - Terminate second copy                  
   SwitchToPrevious: Boolean - Activate the previous instance  
                               if exist                        

**************************************************************** }
unit x2000ro;

interface

uses
  Windows, SysUtils, Classes, Controls, Forms, Messages, Dialogs, DsgnIntf;

type
   TAbout2000X=class(TPropertyEditor)
   public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
   end;

   TRunOnce2000X = class(TComponent)
   private
     FMessage          : String;
     FAbout            : TAbout2000X;
     FShowMessage      : Boolean;
     FTerminate        : Boolean;
     FSwitchToPrevious : Boolean;
     FAlreadyExist     : TNotifyEvent;
     Mutex             : hWnd;
     IsCreated         : Boolean;
   public
     procedure Loaded; override;
     constructor Create(aOwner: TComponent); override;
     destructor Destroy; override;
   published
     property About            : TAbout2000X  read FAbout            write FAbout;
     property SwitchToPrevious : Boolean      read FSwitchToPrevious write FSwitchToPrevious;
     property Terminate        : Boolean      read FTerminate        write FTerminate;
     property AlreadyExist     : TNotifyEvent read FAlreadyExist     write FAlreadyExist;
     property ShowMessage      : boolean      read FShowMessage      write FShowMessage;
     property MessageText      : string       read FMessage          write FMessage;
   end;

implementation

uses x2000about;

procedure TRunOnce2000X.Loaded;
var
  PrevInstHandle: THandle;
  AppTitle: Array[0..$100] of Char;
begin
  inherited Loaded;
  StrPCopy(AppTitle, Application.Title);
  IsCreated := False;

  Mutex := CreateMutex(nil, False, AppTitle);
  if (GetLastError = ERROR_ALREADY_EXISTS) or
     (Mutex = 0) then
  begin
   if Assigned(FAlreadyExist) then FAlreadyExist(Self);

   if FSwitchToPrevious then
    begin
     PrevInsthandle := FindWindow(nil, AppTitle);
     SetWindowText(PrevInsthandle, '');
     PrevInstHandle := FindWindow(nil, AppTitle);
     if PrevInstHandle <> 0 then
      if IsIconic(PrevInstHandle) then
       ShowWindow(PrevInstHandle, SW_RESTORE)
      else
       BringWindowToTop(PrevInstHandle);
    end;

   if FTerminate then
   begin
      if FShowMessage then begin
         MessageDlg(Messagetext,mtInformation,[mbOK],0);
      end;
      Application.Terminate;
   end;
  end;
  IsCreated := True;
end;

constructor TRunOnce2000X.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FTerminate := True;
  FSwitchToPrevious := True;
end;

destructor TRunOnce2000X.Destroy;
begin
  if IsCreated then
   CloseHandle(Mutex);
  inherited Destroy;
end;

procedure TAbout2000X.Edit;
begin
 with TX2000AboutForm.Create(Application) do begin
  try
    ShowModal;
  finally
    Free;
  end;
 end;
end;

function TAbout2000X.GetAttributes: TPropertyAttributes;
begin
    Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout2000X.GetValue: string;
begin
    Result := '(X2000)';
end;


end.
