{ ****************************************************************
  Info               :  TIconGrabber2000X
                        Freeware

  Source File Name   :  X2000IC.PAS
  Autho / Modified   :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 4.0 Client/Server, Service Pack 3
  Decription         :  Grabber Icons from a file

****************************************************************   }
unit x2000ic;

interface

uses
  Windows, Messages, Forms, Classes, Graphics, Controls, SysUtils, ShellAPI, Dialogs, DsgnIntf;

type

  TAbout2000X=class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TIconGrabber2000X = class(TCustomControl)
  private
    FAbout    : TAbout2000X;
    FIcon     : TIcon;
    FFileName : TFilename;
    FIconIndex: Integer;
    procedure SetIcon(Value: TIcon);
    procedure SetFileName(Value: TFilename);
    procedure SetIconIndex(Value: Integer);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    procedure Grab(aFileName: String; aIconIndex: Integer);
  published
    property About     : TAbout2000X read FAbout     write FAbout;
    property Icon      : TIcon       read FIcon      write SetIcon;
    property FileName  : TFilename   read FFileName  write SetFileName;
    property IconIndex : Integer     read FIconIndex write SetIconIndex;
    property Visible;
  end;

implementation

uses X2000about;

constructor TIconGrabber2000X.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FIcon := TIcon.Create;
  Width := 32;
  Height := 32;
end;

destructor TIconGrabber2000X.Destroy;
begin
  FIcon.Destroy;
  inherited Destroy;
end;

procedure TIconGrabber2000X.Paint;
begin
  inherited Paint;
  with Canvas do Draw(0, 0, FIcon);
end;

procedure TIconGrabber2000X.SetIcon(Value: TIcon);
begin
  FIcon.Assign(Value);
  Invalidate;
end;

procedure TIconGrabber2000X.SetFileName(Value: TFilename);
var af:string;
begin
  af:=uppercase(ExtractFileExt(value));
  if (af <> '.EXE') and (af <> '.DLL') then begin
    FFilename:='';
    Messagedlg('You can use only EXE or DLL files', mtwarning, [mbOK],0);
    exit;
  end;
  if FFileName <> Value then
   begin
    FFileName := Value;
    Grab(FFileName, FIconIndex);
   end;
end;

procedure TIconGrabber2000X.SetIconIndex(Value: Integer);
begin
  if FIconIndex <> Value then
   begin
    FIconIndex := Value;
    Grab(FFileName, FIconIndex);
   end;
end;

procedure TIconGrabber2000X.Grab(aFileName: String; aIconIndex: Integer);
var
  PC: Array[0..$FF] of Char;
begin
  FFileName := aFileName;
  FIconIndex := aIconIndex;
  StrPCopy(PC, aFileName);

  FIcon.Handle := ExtractIcon(0, PC, aIconIndex);
  Invalidate;
end;

procedure TAbout2000X.Edit;
begin
 with TX2000AboutForm.Create(Application) do begin
  try
    ShowModal;
  finally
    Free;
  end;
 end;
end;

function TAbout2000X.GetAttributes: TPropertyAttributes;
begin
    Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout2000X.GetValue: string;
begin
    Result := '(X2000)';
end;

end.
