{
****************************************************************************
*                                                                          *
*       Unit Globals.pas : Global variables, constants, types...           *
*                                                                          *
****************************************************************************
}
unit Globals;
interface
uses Errors;
function numb(i : integer):string;
function CheckSymbol(_Name : String): Integer;
function LookSymbol(_Name : String):Integer;

Const
  TAB = '      ';
  TAB_ =^I;
  CR  = ^M;
  LF  = ^J;
  HexCode   = '0123456789ABCDEF';

Type
  Str32     = String[32];
  Token     = (_Unknown,_string_constant,_numeric_constant,_name,
               _program,_Var,_Begin,_While,_do,_repeat,_Until,
               _Write,_WriteLn,_MessageBox,_Procedure,_Read,_ReadLn,_Color,
               _period,_comma,
               _plus,_minus,_mul,_div,_lparen,_rparen,_separator,
               _assign,_equal,_greater,_less,_less_eq,_greater_eq,_not_eq,
               _colon,_true,_false,
               _if,_then,_else,_for,_to,
               _end);

  ObjCode   = (_Clear,_LoadConst,_LoadVar,_Push,_PopAdd,_PopSub,
               _PopMul,_PopDiv,_Store,_Inc_Const,_PutLabel,
               _JumpTo,_IfJumpTo,_IfNotJumpTo,
               _ProgramInit,_ProgramExit,
               _Logical,_Logical_Not,
               Greater,Less,_PutBox, _PutRead, _IncludeProc, _CallMacro);
Const
  MaxToken  = Ord(_end);
  TokenName : Array[0..MaxToken] of Str32 =
              ('','','','',
               'PROGRAM','VAR','BEGIN','WHILE','DO','REPEAT','UNTIL',
               'WRITE','WRITELN','MESSAGEBOX','PROCEDURE','READ','READLN','COLOR',
               '.',',',
               '+','-','*','/','(',')',';',
               ':=','=','>','<','<=','>=','<>',':','TRUE','FALSE',
               'IF','THEN','ELSE','FOR','TO',
               'END');

Type
  NameStr   = string;
  LabelStr  = string;

Var
  Look           : Char;
  Current_String : String;
  Current_Token  : Token;
  Current_Number : Longint;

  Source,Dest,Inc_Proc : Text;
  Name           : String;
  LineCount      : Longint;
  ProgramName    : NameStr;
  Console_App, Gui_App    : boolean;
  IncProc, ProcB        : Boolean;

(*************************
     Symbol Table Stuff
 *************************)
Const
  _Integer = 0;
  _Byte    = 1;
  _Long    = 2;
Type
  TType    = Record
               Name  : String[32];
               Size  : Word;
             End;

  Symbol   = Record
               Name  : String[32];
               Kind  : Integer;
             End;

  Proc     = Record
               Name : String[32];
             End;
Const
  TypeInteger  : TType = (Name : '_INTEGER'; Size :2);
  TypeByte     : TType = (Name : '_BYTE';    Size :1);
  TypeLong     : TType = (Name : '_LONGINT'; Size :4);
  TypeBoolean  : TType = (Name : '_BOOLEAN'; Size :1);
  TypeString   : TType = (Name : '_STRING';  Size :256);
Var
  SymbolTable  : Array[0..512] of Symbol;
  SymbolCount  : Integer;

  TypeTable    : Array[0..512] of TType;
  TypeCount    : Integer;

  StringConst  : Array[0..63]  of String;
  StringCount  : Integer;

  ProcTable    : Array[0..200] of Proc;
  ProcCount    : integer;
implementation

function  numb(i : integer):string;
var
  s : string;
begin
  str(i,s);
  numb := s;
end;

Function CheckSymbol(_Name : String): Integer;
Var
  tmp : integer;
Begin
  tmp := LookSymbol(_Name);
  if tmp = -1 then
     begin
          Expected('identifier');
          Halt;
     end;
  CheckSymbol := tmp;
End;

Function LookSymbol(_Name : String):Integer;
{ True if _NAME is in table }
Var
  q,r : Integer;
Begin
  r := -1;
  For q := 0 to SymbolCount-1 do
    If SymbolTable[q].Name = _Name then
      r := q;
  If r <> -1 then
    LookSymbol := SymbolTable[r].Kind
  else
    LookSymbol := -1;
End;

begin
end.