unit dtWinVerLabel;

{$R-}

// 32 bit Windows version display label.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TdtWinVerLabel = class(TCustomLabel)
  private
    { Private declarations }
  protected
    function GetLabelText: string; override;
  public
    { Public declarations }
  published
    property Align;
    property Alignment;
    property AutoSize;
//    property Caption;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
//    property FocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
//    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

procedure Register;

implementation

function TdtWinVerLabel.GetLabelText: string;
var
  OSVersionInfo: TOSVersionInfo; // structure to hold ver info
  MajVerStr,                     // Major OS ver no
  MinVerStr,                     // Minor OS ver no
  BuildNoStr,                    // Build no
//  MajVerNoStr,                   // Major ver no
//  MinVerNoStr,                   // Minor ver no
  PlatFormStr,                   // Platform ID
  CSDVerStr: string;             // more build info ?
//  w: word;                       // work var
begin
  Result := '';

  OSVersionInfo.dwOSVersionInfoSize := SizeOf(OSVersionInfo);
  if not GetVersionEx (OSVersionInfo) then Exit;

  with OSVersionInfo do begin
    case dwPlatFormId of
      VER_PLATFORM_WIN32s:        PlatFormStr := 'Win32s';
      VER_PLATFORM_WIN32_WINDOWS: PlatFormStr := 'Windows 95';
      VER_PLATFORM_WIN32_NT:      PlatFormStr := 'Windows NT';
    end;

    MajVerStr   := IntToStr (dwMajorVersion);
    MinVerStr   := IntToStr (dwMinorVersion);
    BuildNoStr  := IntToStr (dwBuildNumber and $0000FFFF); // low order word
//    w := dwBuildNumber shr 16;               // move hi order to w
//    MajVerNoStr := IntToStr (w shr 8);       // Lo byte
//    MinVerNoStr := IntToStr (w and $00FF);   // Hi byte
    CSDVerStr   := StrPas (szCSDVersion);

  Result := PlatFormStr + ' ' +
            MajVerStr + '.' +
            MinVerStr + ' ' + '(Build ' +
            BuildNoStr + ':' +
            CSDVerStr + ')';// +
//            MajVerNoStr + ' ' +
//            MinVerNoStr;
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TdtWinVerLabel]);
end;

end.
